/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity;

import com.diquest.ir.common.database.entity.WebManagerProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;

public final class WebManagerProperties
implements Serializable {
    private static final long serialVersionUID = -3298080250541862876L;
    Properties prop;

    public WebManagerProperties() {
    }

    public WebManagerProperties(List rows) {
        this.prop = new Properties();
        Iterator iter = rows.iterator();
        while (iter.hasNext()) {
            WebManagerProperty p = (WebManagerProperty)iter.next();
            String key = p.getKey();
            String value = p.getValue();
            ArrayList<String> values = (ArrayList<String>)this.prop.get(key);
            if (values == null) {
                values = new ArrayList<String>(1);
                this.prop.put(key, values);
            }
            values.add(value);
        }
    }

    public final synchronized String getProperty(String key) {
        List values = (List)this.prop.get(key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.get(0);
    }

    public final synchronized List getProperties(String key) {
        ArrayList values = (ArrayList)this.prop.get(key);
        if (values == null) {
            values = new ArrayList(0);
            this.prop.put(key, values);
        }
        return values;
    }

    public synchronized void addValue(String key, String value) {
        List properties = this.getProperties(key);
        properties.add(value);
    }

    public synchronized void addValues(String key, List values) {
        List properties = this.getProperties(key);
        properties.addAll(values);
    }

    public synchronized void removeValue(String key, String value) {
        List properties = this.getProperties(key);
        properties.remove(value);
        this.purge();
    }

    public synchronized void removeValues(String key, List values) {
        List properties = this.getProperties(key);
        properties.removeAll(values);
        this.purge();
    }

    public synchronized List remove(String key) {
        List properties = this.getProperties(key);
        this.prop.remove(key);
        return properties;
    }

    public synchronized void setProperty(String key, String value) {
        List properties = this.getProperties(key);
        properties.clear();
        properties.add(value);
    }

    public synchronized void setProperty(String key, List values) {
        List properties = this.getProperties(key);
        properties.clear();
        properties.addAll(values);
        this.purge();
    }

    private synchronized void purge() {
        Set<Map.Entry<Object, Object>> entrySet = this.prop.entrySet();
        Iterator<Map.Entry<Object, Object>> iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            if (!((List)entry.getValue()).isEmpty()) continue;
            iter.remove();
        }
    }

    public synchronized Enumeration enumerate() {
        Set<Map.Entry<Object, Object>> entrySet = this.prop.entrySet();
        final Iterator<Map.Entry<Object, Object>> iter = entrySet.iterator();
        return new Enumeration(){
            Map.Entry next = null;
            Iterator valueIterator = null;

            public boolean hasMoreElements() {
                while (this.valueIterator == null || !this.valueIterator.hasNext()) {
                    if (iter.hasNext()) {
                        this.next = (Map.Entry)iter.next();
                        List list = (List)this.next.getValue();
                        this.valueIterator = list.iterator();
                        continue;
                    }
                    return false;
                }
                return this.valueIterator.hasNext();
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                return new WebManagerProperty((String)this.next.getKey(), (String)this.valueIterator.next());
            }
        };
    }
}

