/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity.factory;

import com.diquest.ir.common.database.entity.JobLog;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsBinaryStreamColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class JobLogFactory {
    private static final RdbmsProperties properties = RdbmsPropertiesFactory.load();
    static final boolean USE_CLOB;

    static {
        String property = properties.getProperty("ir.db.useclob");
        USE_CLOB = property == null ? false : Boolean.valueOf(property);
    }

    public static JobLog create(RdbmsColumnValue[] values) {
        if (values[0] == null) {
            return null;
        }
        byte[] request_message = null;
        int job_id = values[0].getInt();
        String job_desc = values[1].toString();
        char job_status = values[2].getChar();
        char enable = values[3].getChar();
        if (!USE_CLOB) {
            request_message = ((RdbmsBinaryStreamColumnValue)values[4]).getValue();
        } else {
            String sRequest_message = values[4].toString();
            request_message = ByteUtil.hexToByteArray((String)sRequest_message);
        }
        char response_code = values[5].getChar();
        String response_message = values[6].toString();
        Date created = new Date(values[7].getLong());
        Date last_updated = new Date(values[8].getLong());
        String executor = values[9].toString();
        return new JobLog(job_id, job_desc, job_status, enable, request_message, response_code, response_message, created, last_updated, executor);
    }

    public static JobLog createList(RdbmsColumnValue[] values) {
        if (values[0] == null) {
            return null;
        }
        int job_id = values[0].getInt();
        String job_desc = values[1].toString();
        char job_status = values[2].getChar();
        char enable = values[3].getChar();
        char response_code = values[4].getChar();
        Date created = new Date(values[5].getLong());
        Date last_updated = new Date(values[6].getLong());
        String executor = values[7].toString();
        return new JobLog(job_id, job_desc, job_status, enable, null, response_code, null, created, last_updated, executor);
    }

    public static List create(List list) {
        int size = list.size();
        ArrayList<JobLog> rows = new ArrayList<JobLog>(size);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            rows.add(JobLogFactory.createList((RdbmsColumnValue[])iterator.next()));
        }
        return rows;
    }
}

