/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity.factory;

import com.diquest.ir.common.database.entity.ServerLog;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ServerLogFactory {
    public static ServerLog create(RdbmsColumnValue[] values, boolean useServer, boolean useTime, boolean useRegistered) {
        if (values == null || values[0] == null) {
            return null;
        }
        ServerLog log = new ServerLog();
        int index = 0;
        if (useServer) {
            log.setServer(values[index++].toString());
        }
        index = ServerLogFactory.setAttributes(values, log, index);
        if (useTime) {
            log.setDay(values[index++].getInt());
            log.setHour(values[index++].getInt());
            log.setMinute(values[index++].getInt());
        }
        if (useRegistered) {
            log.setRegistered(values[index++].getLong());
        }
        if (index != values.length) {
            throw new IllegalArgumentException();
        }
        return log;
    }

    public static ServerLog create(RdbmsColumnValue[] values) {
        return ServerLogFactory.create(values, true, true, true);
    }

    private static int setAttributes(RdbmsColumnValue[] values, ServerLog log, int index) {
        log.setDenial(values[index++].getInt());
        log.setErrors(values[index++].getInt());
        log.setSpaceUsed(values[index++].getInt());
        log.setSpaceRemain(values[index++].getInt());
        log.setCpuUsage(values[index++].getInt());
        log.setMemoryUsed(values[index++].getInt());
        log.setSpaceUsedByIr(values[index++].getInt());
        log.setCpuUsageByIr(values[index++].getInt());
        log.setMemoryMaxByIr(values[index++].getInt());
        log.setMemoryTotalByIr(values[index++].getInt());
        log.setMemoryUsedByIr(values[index++].getInt());
        log.setConnection(values[index++].getInt());
        return index;
    }

    public static ServerLog createCalculatedTime(RdbmsColumnValue[] values) {
        return ServerLogFactory.create(values, false, false, true);
    }

    public static Iterator createCalculatedTime(final Iterator iter) {
        return new Iterator(){

            public boolean hasNext() {
                return iter.hasNext();
            }

            public Object next() {
                return ServerLogFactory.createCalculatedTime((RdbmsColumnValue[])iter.next());
            }

            public void remove() {
                iter.remove();
            }
        };
    }

    public static Iterator create(final Iterator iter) {
        return new Iterator(){

            public boolean hasNext() {
                return iter.hasNext();
            }

            public Object next() {
                return ServerLogFactory.create((RdbmsColumnValue[])iter.next());
            }

            public void remove() {
                iter.remove();
            }
        };
    }

    public static List createCalculatedTime(List list) {
        int size = list.size();
        ArrayList<ServerLog> rows = new ArrayList<ServerLog>(size);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            rows.add(ServerLogFactory.createCalculatedTime((RdbmsColumnValue[])iterator.next()));
        }
        return rows;
    }

    public static List create(List list) {
        int size = list.size();
        ArrayList<ServerLog> rows = new ArrayList<ServerLog>(size);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            rows.add(ServerLogFactory.create((RdbmsColumnValue[])iterator.next()));
        }
        return rows;
    }

    public static List max(Iterator select, String server, long from, long to, long unit) {
        return ServerLogFactory.merge(select, server, from, to, unit, 1);
    }

    public static List min(Iterator select, String server, long from, long to, long unit) {
        return ServerLogFactory.merge(select, server, from, to, unit, 0);
    }

    public static List mergeAuto(Iterator select, String server, long from, long to, long unit) {
        return ServerLogFactory.merge(select, server, from, to, unit, 3);
    }

    private static List merge(Iterator select, String server, long from, long to, long unit, int type) {
        int slots = (int)((to - from) / unit);
        List[] toMerge = ServerLogFactory.dissipate(select, from, unit, slots);
        ServerLog[] logs = new ServerLog[slots];
        int i = 0;
        while (i < slots) {
            ServerLog merged;
            switch (type) {
                case 0: {
                    merged = ServerLog.min(toMerge[i].toArray(new ServerLog[toMerge[i].size()]));
                    break;
                }
                case 1: {
                    merged = ServerLog.max(toMerge[i].toArray(new ServerLog[toMerge[i].size()]));
                    break;
                }
                default: {
                    merged = ServerLog.mergeAuto(toMerge[i].toArray(new ServerLog[toMerge[i].size()]));
                }
            }
            logs[i] = merged;
            logs[i].setServer(server);
            logs[i].setRegistered(from + (long)i * unit);
            ++i;
        }
        return new ArrayList<ServerLog>(Arrays.asList(logs));
    }

    public static List max(List select, String server, long from, long to, long unit) {
        return ServerLogFactory.merge(select, server, from, to, unit, 1);
    }

    public static List min(List select, String server, long from, long to, long unit) {
        return ServerLogFactory.merge(select, server, from, to, unit, 0);
    }

    public static List mergeAuto(List select, String server, long from, long to, long unit) {
        return ServerLogFactory.merge(select, server, from, to, unit, 3);
    }

    private static List merge(List select, String server, long from, long to, long unit, int type) {
        int slots = (int)((to - from) / unit);
        List[] toMerge = ServerLogFactory.dissipate(select, from, unit, slots);
        ServerLog[] logs = new ServerLog[slots];
        int i = 0;
        while (i < slots) {
            ServerLog merged;
            switch (type) {
                case 0: {
                    merged = ServerLog.min(toMerge[i].toArray(new ServerLog[toMerge[i].size()]));
                    break;
                }
                case 1: {
                    merged = ServerLog.max(toMerge[i].toArray(new ServerLog[toMerge[i].size()]));
                    break;
                }
                default: {
                    merged = ServerLog.mergeAuto(toMerge[i].toArray(new ServerLog[toMerge[i].size()]));
                }
            }
            logs[i] = merged;
            logs[i].setServer(server);
            logs[i].setRegistered(from + (long)i * unit);
            ++i;
        }
        return new ArrayList<ServerLog>(Arrays.asList(logs));
    }

    private static List[] dissipate(List select, long from, long unit, int slots) {
        List[] toMerge = new ArrayList[slots];
        int i = 0;
        while (i < slots) {
            toMerge[i] = new ArrayList();
            ++i;
        }
        Iterator iter = select.iterator();
        while (iter.hasNext()) {
            ServerLog log = (ServerLog)((Object)iter.next());
            int slot = (int)((log.getRegistered().getTime() - from) / unit);
            toMerge[slot].add(log);
        }
        return toMerge;
    }

    private static List[] dissipate(Iterator iter, long from, long unit, int slots) {
        List[] toMerge = new ArrayList[slots];
        int i = 0;
        while (i < slots) {
            toMerge[i] = new ArrayList();
            ++i;
        }
        while (iter.hasNext()) {
            ServerLog log = (ServerLog)((Object)iter.next());
            int slot = (int)((log.getRegistered().getTime() - from) / unit);
            toMerge[slot].add(log);
        }
        return toMerge;
    }
}

