/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity.factory;

import com.diquest.ir.common.database.entity.StatisticalQueryLog;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class StatisticalQueryLogFactory {
    public static List merge(List logs) {
        if (logs.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StatisticalQueryLog> merged = new ArrayList<StatisticalQueryLog>();
        Iterator iter = logs.iterator();
        while (iter.hasNext()) {
            StatisticalQueryLog log = (StatisticalQueryLog)iter.next();
            if (merged.isEmpty()) {
                merged.add(new StatisticalQueryLog(log));
                continue;
            }
            StatisticalQueryLog last = (StatisticalQueryLog)merged.get(merged.size() - 1);
            if (last.getRegistered() == log.getRegistered()) {
                last.merge(log);
                continue;
            }
            merged.add(new StatisticalQueryLog(log));
        }
        return merged;
    }

    public static List merge(List logs, long start, long end, long units) {
        StatisticalQueryLog log;
        if (units > Integer.MAX_VALUE || (end - start) % units != 0L) {
            throw new IllegalArgumentException();
        }
        int size = (int)((end - start) / units);
        StatisticalQueryLog[] merged = new StatisticalQueryLog[(int)((end - start) / units)];
        int i = 0;
        while (i < size) {
            log = new StatisticalQueryLog();
            log.setDuration((int)units);
            log.setRegistered(start + units * (long)i);
            merged[i] = log;
            ++i;
        }
        Iterator iter = logs.iterator();
        while (iter.hasNext()) {
            log = (StatisticalQueryLog)iter.next();
            long logRegistered = log.getRegistered();
            long logDuration = log.getDuration();
            long startSlot = start + units * ((logRegistered - start) / units);
            long endSlot = Math.min(end, start + units * StatisticalQueryLogFactory.xxx(logRegistered + logDuration - start, units));
            long interval = startSlot;
            while (interval < endSlot) {
                double portion = StatisticalQueryLogFactory.portion(logRegistered, logDuration, interval, units);
                merged[(int)((interval - start) / units)].merge(log, portion);
                interval += units;
            }
        }
        return new ArrayList<StatisticalQueryLog>(Arrays.asList(merged));
    }

    public static List merge(Iterator logs, long start, long end, long units) {
        if (units > Integer.MAX_VALUE || (end - start) % units != 0L) {
            throw new IllegalArgumentException();
        }
        int size = (int)((end - start) / units);
        StatisticalQueryLog[] merged = new StatisticalQueryLog[(int)((end - start) / units)];
        int i = 0;
        while (i < size) {
            StatisticalQueryLog log = new StatisticalQueryLog();
            log.setDuration((int)units);
            log.setRegistered(start + units * (long)i);
            merged[i] = log;
            ++i;
        }
        while (logs.hasNext()) {
            StatisticalQueryLog log = (StatisticalQueryLog)logs.next();
            long logRegistered = log.getRegistered();
            long logDuration = log.getDuration();
            long startSlot = start + units * ((logRegistered - start) / units);
            long endSlot = Math.min(end, start + units * StatisticalQueryLogFactory.xxx(logRegistered + logDuration - start, units));
            long interval = startSlot;
            while (interval < endSlot) {
                double portion = StatisticalQueryLogFactory.portion(logRegistered, logDuration, interval, units);
                merged[(int)((interval - start) / units)].merge(log, portion);
                interval += units;
            }
        }
        return new ArrayList<StatisticalQueryLog>(Arrays.asList(merged));
    }

    public static long xxx(long position, long units) {
        return position / units + (long)(position % units == 0L ? 0 : 1);
    }

    public static double portion(long srcFrom, long srcLength, long destFrom, long destLength) {
        if (srcLength <= 0L || destLength <= 0L) {
            return 0.0;
        }
        long srcEnd = srcFrom + srcLength;
        long destEnd = destFrom + destLength;
        if (destEnd <= srcFrom || srcEnd <= destFrom) {
            return 0.0;
        }
        long overStart = Math.max(srcFrom, destFrom);
        long overEnd = Math.min(srcEnd, destEnd);
        return (double)(overEnd - overStart) / (double)srcLength;
    }

    public static StatisticalQueryLog create(RdbmsColumnValue[] values) {
        if (values == null || values[0] == null) {
            return null;
        }
        int index = 0;
        StatisticalQueryLog slog = new StatisticalQueryLog();
        slog.setRequested(values[index++].getInt());
        slog.setResponseTime(values[index++].getDouble());
        slog.setResponseTime0(values[index++].getInt());
        slog.setResponseTime1(values[index++].getInt());
        slog.setResponseTime2(values[index++].getInt());
        slog.setResponseTime3(values[index++].getInt());
        slog.setResponseTime4(values[index++].getInt());
        slog.setResponseTime5(values[index++].getInt());
        slog.setResponseTime6(values[index++].getInt());
        slog.setResponseTime7(values[index++].getInt());
        slog.setResponseTime8(values[index++].getInt());
        slog.setResponseTime9(values[index++].getInt());
        slog.setResponseTime10(values[index++].getInt());
        slog.setCacheHit(values[index++].getInt());
        slog.setCacheRequested(values[index++].getInt());
        slog.setRegistered(values[index++].getLong());
        if (index < values.length) {
            slog.setDuration(values[index++].getInt());
        }
        return slog;
    }

    public static StatisticalQueryLog createSummed(RdbmsColumnValue[] values) {
        if (values == null || values[0] == null) {
            return null;
        }
        int index = 0;
        StatisticalQueryLog slog = new StatisticalQueryLog();
        slog.setRequested(values[index++].getInt());
        slog.setResponseTime((int)Math.round(values[index++].getDouble()));
        slog.setResponseTime0(values[index++].getInt());
        slog.setResponseTime1(values[index++].getInt());
        slog.setResponseTime2(values[index++].getInt());
        slog.setResponseTime3(values[index++].getInt());
        slog.setResponseTime4(values[index++].getInt());
        slog.setResponseTime5(values[index++].getInt());
        slog.setResponseTime6(values[index++].getInt());
        slog.setResponseTime7(values[index++].getInt());
        slog.setResponseTime8(values[index++].getInt());
        slog.setResponseTime9(values[index++].getInt());
        slog.setResponseTime10(values[index++].getInt());
        slog.setCacheHit(values[index++].getInt());
        slog.setCacheRequested(values[index++].getInt());
        slog.setRegistered(values[index++].getLong());
        if (index < values.length) {
            slog.setDuration(values[index++].getInt());
        }
        return slog;
    }

    public static List create(List list) {
        int size = list.size();
        ArrayList<StatisticalQueryLog> rows = new ArrayList<StatisticalQueryLog>(size);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            rows.add(StatisticalQueryLogFactory.create((RdbmsColumnValue[])iterator.next()));
        }
        return rows;
    }
}

