/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity.feedback.impl;

import com.diquest.ir.common.database.entity.feedback.FeedbackEntity;
import com.diquest.ir.util.common.DateUtil;
import java.util.Date;

public class ClickNavigationEntity {
    private String collectionID;
    private String profileID;
    private int clickCount;
    private long regDate;

    public ClickNavigationEntity(FeedbackEntity entity) {
        this.collectionID = entity.getCollectionID();
        this.profileID = entity.getProfileID();
        this.clickCount = entity.getIntParams()[0];
        this.regDate = entity.getRegDate();
    }

    public ClickNavigationEntity(String collectionID, String profileID, int clickCount, long regDate) {
        this.collectionID = collectionID;
        this.profileID = profileID;
        this.clickCount = clickCount;
        this.regDate = regDate;
    }

    public void merge(ClickNavigationEntity entity) {
        this.clickCount += entity.getClickCount();
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = collectionID;
    }

    public String getProfileID() {
        return this.profileID;
    }

    public void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public long getRegDate() {
        return this.regDate;
    }

    public void setRegDate(long regDate) {
        this.regDate = regDate;
    }

    public void trimDownRegDate() {
        this.regDate = DateUtil.getDayStart((long)this.regDate);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[CollectionID=" + this.getCollectionID());
        buf.append("][ProfileID=" + this.getProfileID());
        buf.append("][regDate=" + new Date(this.getRegDate()));
        buf.append("][clickCount=" + this.getClickCount() + "]");
        return buf.toString();
    }
}

