/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity.feedback.impl;

import com.diquest.ir.common.database.entity.feedback.FeedbackEntity;
import com.diquest.ir.util.common.DateUtil;
import java.util.Date;

public class QueryCountEntity {
    private String collectionID;
    private String profileID;
    private int queryCount;
    private long regDate;

    public QueryCountEntity(FeedbackEntity entity) {
        this.collectionID = entity.getCollectionID();
        this.profileID = entity.getProfileID();
        this.queryCount = entity.getIntParams()[0];
        this.regDate = entity.getRegDate();
    }

    public QueryCountEntity(String collectionID, String profileID, int queryCount, long regDate) {
        this.collectionID = collectionID;
        this.profileID = profileID;
        this.queryCount = queryCount;
        this.regDate = regDate;
    }

    public void merge(QueryCountEntity entity) {
        this.queryCount += entity.getQueryCount();
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = collectionID;
    }

    public String getProfileID() {
        return this.profileID;
    }

    public void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public long getRegDate() {
        return this.regDate;
    }

    public void setRegDate(long regDate) {
        this.regDate = regDate;
    }

    public void trimDownRegDate() {
        this.regDate = DateUtil.getDayStart((long)this.regDate);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[CollectionID=" + this.getCollectionID());
        buf.append("][ProfileID=" + this.getProfileID());
        buf.append("][regDate=" + new Date(this.getRegDate()));
        buf.append("][queryCount=" + this.getQueryCount() + "]");
        return buf.toString();
    }
}

