/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity.profile;

import com.diquest.ir.common.msg.protocol.query.Query;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsBinaryStreamColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;

public class TestQuery {
    private static final RdbmsProperties properties = RdbmsPropertiesFactory.load();
    static final boolean USE_CLOB;
    private String collectionID;
    private String queryID;
    private String title;
    private String summary;
    private String thumbNail;
    private boolean displayRemoved;
    private Query query;
    private long regDate;

    static {
        String property = properties.getProperty("ir.db.useclob");
        USE_CLOB = property == null ? false : Boolean.valueOf(property);
    }

    public TestQuery(String collectionID, String queryID, String title, String summary, String thumbNail, boolean displayRemoved, Query query, long regDate) {
        this.collectionID = collectionID;
        this.queryID = queryID;
        this.title = title;
        this.summary = summary;
        this.thumbNail = thumbNail;
        this.displayRemoved = displayRemoved;
        this.query = query;
        this.regDate = regDate;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = collectionID;
    }

    public String getQueryID() {
        return this.queryID;
    }

    public void setQueryID(String queryID) {
        this.queryID = queryID;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public long getRegDate() {
        return this.regDate;
    }

    public void setRegDate(long regDate) {
        this.regDate = regDate;
    }

    public static TestQuery create(RdbmsColumnValue[] native_row) throws IOException {
        boolean displayRemoved;
        if (native_row[0] == null) {
            return null;
        }
        byte[] queryBytes = null;
        String collectionID = native_row[0].toString();
        String queryID = native_row[1].toString();
        String title = native_row[2].toString();
        String summary = native_row[3].toString();
        String thumbNail = native_row[4].toString();
        boolean bl = displayRemoved = native_row[5].getInt() == 1;
        if (!USE_CLOB) {
            queryBytes = ((RdbmsBinaryStreamColumnValue)native_row[6]).getValue();
        } else {
            String sQuery = native_row[6].toString();
            queryBytes = ByteUtil.hexToByteArray((String)sQuery);
        }
        long regDate = native_row[7].getLong();
        Query q = new Query();
        ByteArrayInputStream bais = new ByteArrayInputStream(queryBytes);
        q.deserialize(bais);
        return new TestQuery(collectionID, queryID, title, summary, thumbNail, displayRemoved, q, regDate);
    }

    public static TestQuery[] create(List list) throws IOException {
        int size = list.size();
        TestQuery[] testQueries = new TestQuery[size];
        int i = 0;
        while (i < size) {
            RdbmsColumnValue[] rdbms_column_value = (RdbmsColumnValue[])list.get(i);
            testQueries[i] = TestQuery.create(rdbms_column_value);
            ++i;
        }
        return testQueries;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getThumbNail() {
        return this.thumbNail;
    }

    public void setThumbNail(String thumbNail) {
        this.thumbNail = thumbNail;
    }

    public boolean isDisplayRemoved() {
        return this.displayRemoved;
    }

    public void setDisplayRemoved(boolean displayRemoved) {
        this.displayRemoved = displayRemoved;
    }
}

