/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity.profile.rankingmodel;

import com.diquest.ir.common.database.entity.profile.rankingmodel.ModelingField;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import java.util.List;

public class RankingModel {
    private String collectionID;
    private String profileID;
    private ModelingField[] fields;

    public RankingModel(String collectionID, String profileID, ModelingField[] fields) {
        this.collectionID = collectionID;
        this.profileID = profileID;
        this.fields = fields;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[collectionID = " + this.collectionID + "]");
        buf.append("[profileID = " + this.profileID + "]");
        buf.append("[fields.length = " + this.fields.length + "]");
        int i = 0;
        while (i < this.fields.length) {
            buf.append(this.fields[i].toString()).append('\n');
            ++i;
        }
        return buf.toString();
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = collectionID;
    }

    public String getProfileID() {
        return this.profileID;
    }

    public void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    public ModelingField[] getFields() {
        return this.fields;
    }

    public void setFields(ModelingField[] fields) {
        this.fields = fields;
    }

    public static RankingModel create(String collectionID, String profileID, List native_rows) {
        int size = native_rows.size();
        ModelingField[] modelingFields = new ModelingField[size];
        int i = 0;
        while (i < size) {
            RdbmsColumnValue[] rdbms_column_value = (RdbmsColumnValue[])native_rows.get(i);
            modelingFields[i] = RankingModel.create(rdbms_column_value);
            ++i;
        }
        return new RankingModel(collectionID, profileID, modelingFields);
    }

    public static ModelingField create(RdbmsColumnValue[] native_row) {
        if (native_row[0] == null) {
            return null;
        }
        String fieldID = native_row[2].toString();
        byte fieldType = Byte.decode(native_row[3].toString());
        int weight = native_row[4].getInt();
        boolean use = native_row[5].getInt() == 1;
        return new ModelingField(fieldID, fieldType, weight, use);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RankingModel) {
            RankingModel t = (RankingModel)obj;
            if (!this.collectionID.equals(t.collectionID)) {
                return false;
            }
            if (!this.profileID.equals(t.profileID)) {
                return false;
            }
            if (this.fields.length != t.fields.length) {
                return false;
            }
            int i = 0;
            while (i < this.fields.length) {
                ModelingField field = this.fields[i];
                boolean found = false;
                int k = 0;
                while (k < this.fields.length) {
                    ModelingField tField = t.fields[k];
                    if (field.equals(tField)) {
                        found = true;
                        break;
                    }
                    ++k;
                }
                if (!found) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

