/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity.profile.recommend;

import com.diquest.ir.common.database.handler.dictionary.RecommendDB;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import java.io.Serializable;
import java.util.List;

public class Recommend
implements Serializable {
    private static final long serialVersionUID = -1948637838893280201L;
    private String collectionID;
    private String profileID;
    private String keyword;
    private int recommendCount;
    private String[] recommendList;
    private long regDate;
    private boolean apply;

    public Recommend(String collectionID, String profileID, String keyword, int recommendCount, String[] recommendList, long regDate, boolean apply) {
        this.collectionID = collectionID;
        this.profileID = profileID;
        this.keyword = keyword;
        this.recommendCount = recommendCount;
        this.recommendList = recommendList;
        this.regDate = regDate;
        this.apply = apply;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = collectionID;
    }

    public String getProfileID() {
        return this.profileID;
    }

    public void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public int getRecommendCount() {
        return this.recommendCount;
    }

    public void setRecommendCount(int recommendCount) {
        this.recommendCount = recommendCount;
    }

    public String[] getRecommendList() {
        return this.recommendList;
    }

    public void setRecommendList(String[] recommendList) {
        this.recommendList = recommendList;
    }

    public long getRegDate() {
        return this.regDate;
    }

    public void setRegDate(long regDate) {
        this.regDate = regDate;
    }

    public boolean isApply() {
        return this.apply;
    }

    public void setApply(boolean apply) {
        this.apply = apply;
    }

    public static Recommend create(RdbmsColumnValue[] native_row) {
        String recommendListString;
        String[] recommendList;
        if (native_row[0] == null) {
            return null;
        }
        String collectionID = native_row[0].toString();
        String profileID = native_row[1].toString();
        String keyword = native_row[2].toString();
        int recommendCount = native_row[3].getInt();
        if (recommendCount != (recommendList = RecommendDB.makeRecommendList(recommendListString = native_row[4].toString())).length) {
            throw new IllegalArgumentException("RecommendCount(" + recommendCount + ") does not match to recommendList.length(" + recommendList.length + ")");
        }
        long regDate = native_row[5].getLong();
        boolean apply = native_row[6].getInt() == 1;
        return new Recommend(collectionID, profileID, keyword, recommendCount, recommendList, regDate, apply);
    }

    public static Recommend[] create(List list) {
        int size = list.size();
        Recommend[] recommends = new Recommend[size];
        int i = 0;
        while (i < size) {
            RdbmsColumnValue[] rdbms_column_value = (RdbmsColumnValue[])list.get(i);
            recommends[i] = Recommend.create(rdbms_column_value);
            ++i;
        }
        return recommends;
    }
}

