/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity.profile.redirect;

import com.diquest.ir.util.common.StringUtil;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import java.util.List;

public class Redirect {
    private String collectionID;
    private String profileID;
    private String keywords;
    private String themeTitle;
    private String author;
    private long start;
    private long end;
    private String redirectURL;
    private long regDate;
    private boolean apply;

    public Redirect(String collectionID, String profileID, String keywords, String themeTitle, String author, long start, long end, String redirectURL, long regDate, boolean apply) {
        this.collectionID = collectionID;
        this.profileID = profileID;
        this.keywords = keywords;
        this.themeTitle = themeTitle;
        this.author = author;
        this.start = start;
        this.end = end;
        this.redirectURL = redirectURL;
        this.regDate = regDate;
        this.apply = apply;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = collectionID;
    }

    public String getProfileID() {
        return this.profileID;
    }

    public void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    public String getKeyword() {
        return this.keywords;
    }

    public void setKeyword(String keyword) {
        this.keywords = keyword;
    }

    public String getThemeTitle() {
        return this.themeTitle;
    }

    public void setThemeTitle(String themeTitle) {
        this.themeTitle = themeTitle;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public String getRedirectHtmlURL() {
        String htmlURL = StringUtil.simpleText2HTML((String)this.redirectURL);
        htmlURL = StringUtil.simpleText2HTMLApos((String)htmlURL);
        htmlURL = htmlURL.replaceAll("\r\n", "");
        return htmlURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public long getRegDate() {
        return this.regDate;
    }

    public void setRegDate(long regDate) {
        this.regDate = regDate;
    }

    public boolean isApply() {
        return this.apply;
    }

    public void setApply(boolean apply) {
        this.apply = apply;
    }

    public static Redirect create(RdbmsColumnValue[] native_row) {
        if (native_row[0] == null) {
            return null;
        }
        String collectionID = native_row[0].toString();
        String profileID = native_row[1].toString();
        String keyword = native_row[2].toString();
        String themeTitle = native_row[3].toString();
        String author = native_row[4].toString();
        long start = native_row[5].getLong();
        long end = native_row[6].getLong();
        String redirectURL = native_row[7].toString();
        long regDate = native_row[8].getLong();
        boolean apply = native_row[9].getInt() == 1;
        return new Redirect(collectionID, profileID, keyword, themeTitle, author, start, end, redirectURL, regDate, apply);
    }

    public static Redirect[] create(List list) {
        int size = list.size();
        Redirect[] redirects = new Redirect[size];
        int i = 0;
        while (i < size) {
            RdbmsColumnValue[] rdbms_column_value = (RdbmsColumnValue[])list.get(i);
            redirects[i] = Redirect.create(rdbms_column_value);
            ++i;
        }
        return redirects;
    }
}

