/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity.profile.thesaurus;

import com.diquest.ir.common.database.handler.dictionary.ThesaurusDB;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import java.io.Serializable;
import java.util.List;

public class Thesaurus
implements Serializable {
    private static final long serialVersionUID = -8560497026213189106L;
    private String collectionID;
    private String profileID;
    private byte thesaurusID;
    private String keyword;
    private int thesaurusCount;
    private String[] keywords;
    private long regDate;
    private boolean apply;

    public Thesaurus(String collectionID, String profileID, byte thesaurusID, String keyword, int thesaurusCount, String[] keywords, long regDate, boolean apply) {
        this.collectionID = collectionID;
        this.profileID = profileID;
        this.thesaurusID = thesaurusID;
        this.keyword = keyword;
        this.thesaurusCount = thesaurusCount;
        this.keywords = keywords;
        this.regDate = regDate;
        this.apply = apply;
        int cfr_ignored_0 = keywords.length;
    }

    public static Thesaurus create(RdbmsColumnValue[] native_row) {
        if (native_row[0] == null) {
            return null;
        }
        String collectionID = native_row[0].toString();
        String profileID = native_row[1].toString();
        byte thesaurusID = (byte)native_row[2].getInt();
        String keyword = native_row[3].toString();
        int thesaurusCount = native_row[4].getInt();
        String[] keywords = ThesaurusDB.makeThesaurusList(native_row[5].toString());
        long regDate = native_row[6].getLong();
        boolean apply = native_row[7].getInt() == 1;
        return new Thesaurus(collectionID, profileID, thesaurusID, keyword, thesaurusCount, keywords, regDate, apply);
    }

    public static Thesaurus[] create(List list) {
        int size = list.size();
        Thesaurus[] items = new Thesaurus[size];
        int i = 0;
        while (i < size) {
            RdbmsColumnValue[] rdbms_column_value = (RdbmsColumnValue[])list.get(i);
            items[i] = Thesaurus.create(rdbms_column_value);
            ++i;
        }
        return items;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void setCollectionID(String collectionID) {
        this.collectionID = collectionID;
    }

    public String getProfileID() {
        return this.profileID;
    }

    public void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    public byte getThesaurusID() {
        return this.thesaurusID;
    }

    public void setThesaurusID(byte thesaurusID) {
        this.thesaurusID = thesaurusID;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    public long getRegDate() {
        return this.regDate;
    }

    public void setRegDate(long regDate) {
        this.regDate = regDate;
    }

    public boolean isApply() {
        return this.apply;
    }

    public void setApply(boolean apply) {
        this.apply = apply;
    }

    public int getThesaurusCount() {
        return this.thesaurusCount;
    }

    public void setThesaurusCount(int thesaurusCount) {
        this.thesaurusCount = thesaurusCount;
    }
}

