/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.entity.trends;

import com.diquest.commons.type.ArrayUtil;
import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.TrendsKeyword;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TrendsKeywordList
extends Transmitable
implements Serializable {
    private static final long serialVersionUID = 4841066676224635758L;
    private String name;
    private int capacity;
    private long modCount;
    private List list;

    public TrendsKeywordList() {
    }

    public TrendsKeywordList(String name, int capacity, long modCount, List trendsKeywordList) {
        this.name = name;
        this.capacity = capacity;
        this.modCount = modCount;
        this.list = trendsKeywordList;
    }

    public TrendsKeywordList(String name, long modCount, List trendsKeywordList) {
        this(name, Integer.MAX_VALUE, modCount, trendsKeywordList);
    }

    public synchronized boolean add(TrendsKeyword keyword) {
        int rank = keyword.getRank();
        if (!this.name.equals(keyword.getName())) {
            throw new IllegalArgumentException("Illegal name attribute.");
        }
        if (rank <= 0 || rank > this.size() + 1) {
            throw new IllegalArgumentException("Illegal rank attribute");
        }
        if (this.getRankOf(keyword.getKeyword()) != -1) {
            throw new IllegalArgumentException("The keyword " + keyword.getName() + " is already existing.");
        }
        if (rank == this.size() + 1) {
            if (this.size() == this.capacity) {
                return false;
            }
            this.list.add(keyword);
        } else {
            this.list.add(rank - 1, keyword);
            this.rerank(rank, this.size());
        }
        int size = this.size();
        while (size > this.capacity) {
            this.list.remove(--size);
        }
        return true;
    }

    public synchronized void deserialize(InputStream in) throws IOException {
        this.setName(ByteUtil.readString((InputStream)in));
        this.setCapacity(ByteUtil.readInt((InputStream)in));
        this.setModCount(ByteUtil.readLong((InputStream)in));
        int size = ByteUtil.readInt((InputStream)in);
        ArrayList<TrendsKeyword> list = new ArrayList<TrendsKeyword>(size);
        while (size-- > 0) {
            TrendsKeyword keyword = new TrendsKeyword();
            keyword.deserialize(in);
            list.add(keyword);
        }
        this.setTrendsKeywordList(list);
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TrendsKeywordList)) {
            return false;
        }
        TrendsKeywordList other = (TrendsKeywordList)obj;
        if (this.capacity != other.capacity) {
            return false;
        }
        if (this.list == null ? other.list != null : !this.list.equals(other.list)) {
            return false;
        }
        if (this.modCount != other.modCount) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public final synchronized int getCapacity() {
        return this.capacity;
    }

    public Transmitable getInstance() {
        return new TrendsKeywordList();
    }

    public final synchronized long getModCount() {
        return this.modCount;
    }

    public final synchronized String getName() {
        return this.name;
    }

    public final synchronized List getTrendsKeywordList() {
        return Collections.unmodifiableList(this.list);
    }

    public final synchronized List getTrendsKeywordList(String keyword) {
        return this.getTrendsKeywordList(keyword, true);
    }

    public final synchronized List getTrendsKeywordList(String keyword, boolean caseSensitive) {
        if (keyword == null || keyword.length() == 0) {
            return Collections.unmodifiableList(this.list);
        }
        String lower = null;
        String upper = null;
        if (!caseSensitive) {
            upper = keyword.toUpperCase();
            lower = keyword.toLowerCase();
        }
        ArrayList<TrendsKeyword> view = new ArrayList<TrendsKeyword>();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            TrendsKeyword tk = (TrendsKeyword)iterator.next();
            if (!(caseSensitive ? tk.getKeyword().indexOf(keyword) >= 0 : tk.getKeyword().toUpperCase().indexOf(upper) >= 0 || tk.getKeyword().toLowerCase().indexOf(lower) >= 0)) continue;
            view.add(tk);
        }
        return view;
    }

    public synchronized int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.capacity;
        result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
        result = 31 * result + (int)(this.modCount ^ this.modCount >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public synchronized boolean isNull() {
        return false;
    }

    public synchronized boolean move(int rank, int length, int move) {
        if (rank < 1 || length < 0 || rank + length - 1 > this.size()) {
            throw new IllegalArgumentException("Illegal range.");
        }
        if (move < 0) {
            if (rank + move < 1) {
                throw new IllegalArgumentException("Cannot move.");
            }
            ArrayList swapped = new ArrayList(this.list.subList(rank - 1 + move, rank - 1));
            ArrayList body = new ArrayList(this.list.subList(rank - 1, rank - 1 + length));
            int at = rank - 1 + move;
            Iterator it = body.iterator();
            while (it.hasNext()) {
                this.list.set(at++, it.next());
            }
            it = swapped.iterator();
            while (it.hasNext()) {
                this.list.set(at++, it.next());
            }
            this.rerank(rank - 1 + move);
        } else if (move > 0) {
            if (rank + length - 1 + move > this.size()) {
                throw new IllegalArgumentException("Cannot move");
            }
            ArrayList body = new ArrayList(this.list.subList(rank - 1, rank - 1 + length));
            ArrayList swapped = new ArrayList(this.list.subList(rank - 1 + length, rank - 1 + length + move));
            int at = rank - 1;
            Iterator it = swapped.iterator();
            while (it.hasNext()) {
                this.list.set(at++, it.next());
            }
            it = body.iterator();
            while (it.hasNext()) {
                this.list.set(at++, it.next());
            }
            this.rerank(rank - 1);
        } else {
            return false;
        }
        return true;
    }

    public synchronized boolean remove(int rank) {
        int index = rank - 1;
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("Illegal rank attribute.");
        }
        this.list.remove(index);
        this.rerank(index);
        return true;
    }

    public synchronized boolean remove(int[] ranks) {
        int size = this.size();
        int i = 0;
        while (i < ranks.length) {
            if (ranks[i] < 1 || ranks[i] > size) {
                throw new IllegalArgumentException("Illegal range");
            }
            ++i;
        }
        int[] sorted = ArrayUtil.copyOf((int[])ranks, (int)ranks.length);
        Arrays.sort(sorted);
        int i2 = sorted.length - 1;
        while (i2 >= 0) {
            this.list.remove(sorted[i2] - 1);
            --i2;
        }
        if (sorted.length > 0) {
            this.rerank(sorted[0]);
            return true;
        }
        return false;
    }

    public synchronized void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.getName());
        ByteUtil.writeInt((OutputStream)out, (int)this.getCapacity());
        ByteUtil.writeLong((OutputStream)out, (long)this.getModCount());
        ByteUtil.writeInt((OutputStream)out, (int)this.list.size());
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            ((TrendsKeyword)it.next()).serialize(out);
        }
    }

    public final synchronized void setModCount(long modCount) {
        this.modCount = modCount;
    }

    public final synchronized void setName(String name) {
        this.name = name;
    }

    public final synchronized void setTrendsKeywordList(List trendsKeywordList) {
        this.list = trendsKeywordList;
    }

    public final synchronized int size() {
        return this.list.size();
    }

    public synchronized String toString() {
        String TAB = ", ";
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append("name=").append(this.name).append(", ");
        buf.append("capacity=").append(this.capacity).append(", ");
        buf.append("modCount=").append(this.modCount).append(", ");
        buf.append("list=").append((Object)this.list);
        buf.append("]");
        return buf.toString();
    }

    public synchronized int getRankOf(String search) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            TrendsKeyword keyword = (TrendsKeyword)iterator.next();
            if (!keyword.getKeyword().equals(search)) continue;
            return keyword.getRank();
        }
        return -1;
    }

    private void rerank(int index) {
        this.rerank(index, this.size());
    }

    private void rerank(int from, int to) {
        int index = from;
        while (index < to) {
            TrendsKeyword pp = (TrendsKeyword)this.list.get(index);
            pp.setRank(index + 1);
            ++index;
        }
    }

    public final void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public synchronized boolean isFixed(int rank) {
        int index = rank - 1;
        if (this.list.size() <= index || index < 0) {
            throw new IllegalArgumentException();
        }
        return ((TrendsKeyword)this.list.get(index)).isFixed();
    }

    public synchronized void setFixed(int rank, boolean fixed) {
        int index = rank - 1;
        if (this.list.size() <= index || index < 0) {
            throw new IllegalArgumentException();
        }
        ((TrendsKeyword)this.list.get(index)).setFixed(fixed);
    }

    public synchronized boolean toggleFixed(int rank) {
        this.setFixed(rank, !this.isFixed(rank));
        return this.isFixed(rank);
    }
}

