/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.explorer;

import com.diquest.ir.common.database.explorer.IQuery;
import com.diquest.ir.common.database.explorer.MetaQueryGenerator;
import com.diquest.ir.common.database.explorer.QueryComparatorResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Query
implements IQuery {
    private Connection conn;
    private String query;
    public String tableName;
    public List columnNames;
    public List columnTypeNames;
    public List columnLabels;
    public int numColumns;

    public Query(Connection conn, String query) {
        this.conn = conn;
        this.query = query;
    }

    public List executeQuery() throws SQLException {
        ArrayList result = new ArrayList();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery(this.query);
            this.columnNames = new ArrayList();
            ResultSetMetaData rsmd = rs.getMetaData();
            int numColumns = rsmd.getColumnCount();
            int i = 1;
            while (i < numColumns + 1) {
                String columnName = rsmd.getColumnName(i);
                this.tableName = rsmd.getTableName(i);
                this.columnNames.add(columnName);
                ++i;
            }
            while (rs.next()) {
                HashMap row = new HashMap();
                int i2 = 0;
                while (i2 < this.columnNames.size()) {
                    row.put(this.columnNames.get(i2), rs.getString((String)this.columnNames.get(i2)));
                    ++i2;
                }
                result.add(row);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            this.release();
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public void getQueryMetaData() throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String metaQuery = null;
        try {
            try {
                stmt = this.conn.createStatement();
                metaQuery = this.getMetaQuery(this.conn);
                rs = stmt.executeQuery(metaQuery);
                this.columnNames = new ArrayList();
                ResultSetMetaData rsmd = rs.getMetaData();
                this.numColumns = rsmd.getColumnCount();
                this.columnNames = new ArrayList();
                this.columnLabels = new ArrayList();
                this.columnTypeNames = new ArrayList();
                int i = 1;
                while (i < this.numColumns + 1) {
                    this.columnNames.add(rsmd.getColumnName(i));
                    this.columnLabels.add(rsmd.getColumnLabel(i));
                    this.columnTypeNames.add(rsmd.getCatalogName(i));
                    ++i;
                }
            }
            catch (SQLException e) {
                this.release();
                throw e;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public String getMetaQuery(Connection conn) throws SQLException {
        return MetaQueryGenerator.generate(conn, this.query);
    }

    public void release() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    public List getColumnName() {
        return this.columnNames;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String toString() {
        return this.query;
    }

    public QueryComparatorResult include(Query compare) throws SQLException {
        int compareColCnt = compare.getColumnCount();
        List compareColTypes = compare.getColumnLabelList();
        List compareColNames = compare.getColumnTypeNameList();
        int i = 1;
        while (i < compareColCnt) {
            String compareColType = (String)compareColTypes.get(i);
            String compareColName = (String)compareColNames.get(i);
            QueryComparatorResult result = this.includeCompareMeta(compareColName, compareColType);
            if (!result.isSuccess()) {
                return result;
            }
            ++i;
        }
        return new QueryComparatorResult(true, String.valueOf(this.query) + " contains  " + compare.query + " meta information.");
    }

    private QueryComparatorResult includeCompareMeta(String columnLabel, String columnType) throws SQLException {
        int colCnt = this.getColumnCount();
        List colLabels = this.getColumnLabelList();
        List colTypes = this.getColumnTypeNameList();
        int j = 1;
        while (j < colCnt) {
            String compareLabel = (String)colLabels.get(j);
            String compareType = (String)colTypes.get(j);
            if (columnLabel.equals(compareLabel) && columnType.equals(compareType)) {
                return new QueryComparatorResult(true, "column label : " + columnLabel + " column type : " + columnType + " meta data is contained.");
            }
            ++j;
        }
        return new QueryComparatorResult(true, "column label : " + columnLabel + " column type : " + columnType + " meta data is not contained.");
    }

    private boolean hasAlreadyGet() {
        return this.columnNames != null || this.columnLabels != null || this.columnTypeNames != null;
    }

    public int getColumnCount() throws SQLException {
        if (!this.hasAlreadyGet()) {
            this.getQueryMetaData();
        }
        return this.numColumns;
    }

    public List getColumnNameList() throws SQLException {
        if (!this.hasAlreadyGet()) {
            this.getQueryMetaData();
        }
        return this.columnNames;
    }

    public List getColumnLabelList() throws SQLException {
        if (!this.hasAlreadyGet()) {
            this.getQueryMetaData();
        }
        return this.columnLabels;
    }

    public List getColumnTypeNameList() throws SQLException {
        if (!this.hasAlreadyGet()) {
            this.getQueryMetaData();
        }
        return this.columnTypeNames;
    }
}

