/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.explorer;

import com.diquest.ir.common.database.explorer.Query;
import com.diquest.ir.common.database.explorer.QueryComparatorResult;
import com.diquest.ir.common.exception.IRException;
import java.sql.SQLException;
import java.util.List;

public class QueryComparator {
    private final Query q1;
    private final Query q2;

    public QueryComparator(Query target, Query compare) {
        this.q1 = target;
        this.q2 = compare;
    }

    public QueryComparatorResult compare() throws IRException {
        try {
            int colCnt1 = this.q1.getColumnCount();
            int colCnt2 = this.q2.getColumnCount();
            List colLabels1 = this.q1.getColumnLabelList();
            if (colCnt1 != colCnt2) {
                throw new IRException(2, "Compare SQL queires : Meta data is not equal " + this.q1 + " and " + this.q2);
            }
            int i = 0;
            while (i < colCnt1) {
                QueryComparatorResult result = this.compareMeta((String)colLabels1.get(i));
                if (!result.isSuccess()) {
                    return result;
                }
                ++i;
            }
            return new QueryComparatorResult(true, "Meta data is equal " + this.q1 + " and " + this.q2);
        }
        catch (SQLException e) {
            throw new IRException(2, "Cannot compare SQL queires : " + this.q1 + " and " + this.q2, (Throwable)e);
        }
    }

    private QueryComparatorResult compareMeta(String columnLabel) throws SQLException {
        int colCnt = this.q2.getColumnCount();
        List colLabels = this.q2.getColumnLabelList();
        int j = 0;
        while (j < colCnt) {
            String compareLabel = (String)colLabels.get(j);
            if (columnLabel.equalsIgnoreCase(compareLabel)) {
                return new QueryComparatorResult(true, "Meta data of column lable(" + columnLabel + ") are contained in SQL query");
            }
            ++j;
        }
        return new QueryComparatorResult(false, "Meta data of column lable(" + columnLabel + ") are not contained in SQL query");
    }
}

