/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.handler.AbstractDB;
import com.diquest.ir.common.database.handler.Pageable;
import com.diquest.ir.common.database.handler.Sortable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractGeneralDB
extends AbstractDB
implements Sortable,
Pageable {
    static final int DISABLED = -1;
    private int offset = -1;
    private int limit = -1;
    private String orderColumn = null;
    private boolean orderDirection = true;

    public void deserialize(InputStream in) throws IOException {
        this.offset = ByteUtil.readInt((InputStream)in);
        this.limit = ByteUtil.readInt((InputStream)in);
        this.orderColumn = ByteUtil.readString((InputStream)in);
        this.orderDirection = ByteUtil.readBoolean((InputStream)in);
    }

    public final void disablePaging() {
        this.setOffset(-1);
        this.setLimit(-1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof AbstractGeneralDB) {
            return this.offset == ((AbstractGeneralDB)o).offset && this.limit == ((AbstractGeneralDB)o).limit && StringUtil.equals((String)this.orderColumn, (String)((AbstractGeneralDB)o).orderColumn) && this.orderDirection == ((AbstractGeneralDB)o).orderDirection;
        }
        return false;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final String getOrderColumn() {
        return this.orderColumn;
    }

    public final boolean getOrderDirection() {
        return this.orderDirection;
    }

    public int hashCode() {
        return this.offset ^ this.limit ^ StringUtil.hashCode((String)this.orderColumn) ^ (this.orderDirection ? 0 : -1);
    }

    public final boolean isPageable() {
        return this.offset >= 0 && this.limit >= 0;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeInt((OutputStream)out, (int)this.offset);
        ByteUtil.writeInt((OutputStream)out, (int)this.limit);
        ByteUtil.writeString((OutputStream)out, (String)this.orderColumn);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.orderDirection);
    }

    public final void setLimit(int limit) {
        this.limit = limit;
    }

    public final void setOffset(int offset) {
        this.offset = offset;
    }

    public void setOrderColumn(String orderColumn) {
        this.orderColumn = orderColumn;
    }

    public void setOrderDirection(boolean orderDirection) {
        this.orderDirection = orderDirection;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[offset=");
        b.append(this.offset);
        b.append(", limit=");
        b.append(this.limit);
        b.append(", orderColumn=");
        b.append(this.orderColumn);
        b.append(", orderDirection=");
        b.append(this.orderDirection);
        b.append("]");
        return b.toString();
    }
}

