/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.db.SqlUtil;
import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.StringArrayUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.AbstractKeywordCountQueryLog;
import com.diquest.ir.common.database.handler.AbstractQueryLogDB;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractKeywordCountQueryLogDB
extends AbstractQueryLogDB {
    public static final String COLLECTION = "COLLECTION_ID";
    public static final String PROFILE = "PROFILE";
    public static final String KEYWORDS = "KEYWORDS";
    public static final String REQUESTED = "REQUESTED";
    public static final String REGISTERED = "REGISTERED";
    public static final String DURATION = "DURATION";
    public static final String SUMMED = "SUMMED";
    public static final String SUMMED_COLUMN = "sum(REQUESTED) as SUMMED";
    public static final String[] ALL_COLUMNS = new String[]{"COLLECTION_ID", "PROFILE", "KEYWORDS", "REQUESTED", "REGISTERED", "DURATION"};
    public static final String[] CALC_COLUMNS = new String[]{"KEYWORDS", "sum(REQUESTED) as SUMMED"};
    public static final String[] CALC_LABELS = new String[]{"KEYWORDS", "SUMMED"};
    protected final String INSERT = SqlUtil.generateInsertSql((String)this.getTableName(), (String[])ALL_COLUMNS);
    protected String orderColumn = "SUMMED";
    protected boolean orderDirection = false;

    public final boolean isSupportServer() {
        return false;
    }

    public final String getOrderColumn() {
        return this.orderColumn;
    }

    public final void setOrderColumn(String orderColumn) {
        if (!this.isPossibleOrderColumn(orderColumn)) {
            throw new IllegalArgumentException(orderColumn);
        }
        this.orderColumn = orderColumn;
    }

    protected boolean isPossibleOrderColumn(String orderColumn) {
        return StringArrayUtil.indexOfIgnoreCase((String[])CALC_LABELS, (String)orderColumn) != -1;
    }

    public final boolean isOrderDirection() {
        return this.orderDirection;
    }

    public final void setOrderDirection(boolean orderDirection) {
        this.orderDirection = orderDirection;
    }

    public int insert(Enumeration logs) throws SQLException {
        Connection conn = ConnectionFactory.getConnection();
        try {
            int n = this.insert(conn, logs);
            return n;
        }
        finally {
            conn.close();
        }
    }

    /*
     * Exception decompiling
     */
    public int insert(Connection conn, Enumeration logs) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void conditioning(StringBuffer psql, List paramList, String keyword, String[] collections, String[][] profiles, long from, long to) {
        boolean collectionWithProfile;
        int parameterIndex = paramList.size() + 1;
        boolean used = parameterIndex > 1;
        boolean bl = collectionWithProfile = collections != null && collections.length > 0 && profiles != null && profiles.length > 0;
        if (collectionWithProfile) {
            used = this.ensureAnd(psql, used);
            psql.append(" ( ");
            this.addCollectionCondition(psql, collections.length);
            int i = 0;
            while (i < collections.length) {
                paramList.add(new RdbmsStringColumnParameter(COLLECTION, parameterIndex++, collections[i]));
                ++i;
            }
            psql.append(" or ");
            this.addCollectionAndProfileCondition(psql, profiles);
            i = 0;
            while (i < profiles.length) {
                if (profiles[i].length == 1) {
                    paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                } else if (profiles[i].length == 2) {
                    paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                    paramList.add(new RdbmsStringColumnParameter(this.getProfileColumnName(), parameterIndex++, profiles[i][1]));
                } else {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            psql.append(" ) ");
        } else {
            int i;
            if (collections != null && collections.length > 0) {
                used = this.ensureAnd(psql, used);
                this.addCollectionCondition(psql, collections.length);
                i = 0;
                while (i < collections.length) {
                    paramList.add(new RdbmsStringColumnParameter(COLLECTION, parameterIndex++, collections[i]));
                    ++i;
                }
            }
            if (profiles != null && profiles.length > 0) {
                used = this.ensureAnd(psql, used);
                this.addCollectionAndProfileCondition(psql, profiles);
                i = 0;
                while (i < profiles.length) {
                    if (profiles[i].length == 1) {
                        paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                    } else if (profiles[i].length == 2) {
                        paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                        paramList.add(new RdbmsStringColumnParameter(this.getProfileColumnName(), parameterIndex++, profiles[i][1]));
                    } else {
                        throw new IllegalArgumentException();
                    }
                    ++i;
                }
            }
        }
        if (keyword != null && keyword.length() > 0) {
            used = this.ensureAnd(psql, used);
            SqlUtil.appendStringLike((StringBuffer)psql, (String)KEYWORDS);
            paramList.add(new RdbmsStringColumnParameter(KEYWORDS, parameterIndex++, "%" + keyword + "%"));
        }
        if (from >= 0L && to >= 0L) {
            used = this.ensureAnd(psql, used);
            this.addBoundCondition(psql);
            paramList.add(new RdbmsDateColumnParameter(REGISTERED, parameterIndex++, from));
            paramList.add(new RdbmsDateColumnParameter(REGISTERED, parameterIndex++, to));
        }
    }

    public final int delete(Connection conn, String keyword, String[] collections, String[][] profiles, long from, long to) throws SQLException {
        ArrayList paramList = new ArrayList();
        StringBuffer psql = this.getDeleteSqlWithWhere();
        this.conditioning(psql, paramList, keyword, collections, profiles, from, to);
        return AbstractKeywordCountQueryLogDB.executeUpdate(conn, psql.toString(), this.paramList2Array(paramList));
    }

    public final int delete(Connection conn, String collection, String profile, String keyword, long registered) throws SQLException {
        StringBuffer psql = this.getDeleteSqlWithWhere();
        SqlUtil.appendStringEquals((StringBuffer)psql, (String)COLLECTION);
        psql.append(" AND ");
        SqlUtil.appendStringEquals((StringBuffer)psql, (String)PROFILE);
        psql.append(" AND ");
        SqlUtil.appendStringEquals((StringBuffer)psql, (String)KEYWORDS);
        psql.append(" AND ");
        SqlUtil.appendStringEquals((StringBuffer)psql, (String)REGISTERED);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(COLLECTION, 1, collection), new RdbmsStringColumnParameter(PROFILE, 2, profile), new RdbmsStringColumnParameter(KEYWORDS, 3, keyword), new RdbmsDateColumnParameter(REGISTERED, 4, registered)};
        return AbstractKeywordCountQueryLogDB.executeUpdate(conn, psql.toString(), parameters);
    }

    public int count(Connection conn, String keyword, String[] collections, String[][] profiles, long from, long to) throws SQLException {
        StringBuffer psql = new StringBuffer(this.getCountSql());
        int position = psql.length();
        ArrayList paramList = new ArrayList();
        this.conditioning(psql, paramList, keyword, collections, profiles, from, to);
        if (!paramList.isEmpty()) {
            psql.insert(position, " where ");
        }
        psql.append(" group by KEYWORDS ");
        RdbmsColumnParameter[] parameters = this.paramList2Array(paramList);
        return this.getCount(conn, psql.toString(), parameters);
    }

    public int getRequested(Connection conn, String keyword, String[] collections, String[][] profiles, long from, long to) throws SQLException {
        List select = this.select(conn, keyword, collections, profiles, from, to);
        return AbstractKeywordCountQueryLogDB.sumRequested(select);
    }

    public static int sumRequested(List select) {
        int summed = 0;
        Iterator iter = select.iterator();
        while (iter.hasNext()) {
            AbstractKeywordCountQueryLog entry = (AbstractKeywordCountQueryLog)iter.next();
            summed += entry.getRequested();
        }
        return summed;
    }

    private List searchWithPaging(List list, String keyword) {
        int skip = 0;
        int remain = Integer.MAX_VALUE;
        if (this.isPageable()) {
            skip = this.getOffset() - 1;
            remain = this.getLimit();
        }
        ArrayList<AbstractKeywordCountQueryLog> searched = new ArrayList<AbstractKeywordCountQueryLog>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            AbstractKeywordCountQueryLog log = (AbstractKeywordCountQueryLog)iter.next();
            if (StringUtil.indexOf((String)log.getKeywords(), (String)keyword) < 0) continue;
            if (skip > 0) {
                --skip;
                continue;
            }
            if (remain > 0) {
                searched.add(log);
                --remain;
            }
            if (remain <= 0) break;
        }
        return searched;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List select(Connection conn, String keyword, String[] collections, String[][] profiles, long from, long to, int referenceLimit) throws SQLException {
        if (keyword == null) {
            return this.select(conn, keyword, collections, profiles, from, to);
        }
        AbstractKeywordCountQueryLogDB db = (AbstractKeywordCountQueryLogDB)this.getInstance();
        db.setOffset(1);
        db.setLimit(referenceLimit);
        List reference = db.select(conn, null, collections, profiles, from, to);
        List searched = null;
        if (this.isPageable()) {
            searched = this.searchWithPaging(reference, keyword);
            if (searched.size() >= this.getLimit()) return searched;
            searched = this.select(conn, keyword, collections, profiles, from, to);
        } else {
            searched = this.select(conn, keyword, collections, profiles, from, to);
        }
        AbstractKeywordCountQueryLog.referRankFrom(searched, reference);
        return searched;
    }

    public List select(Connection conn, String keyword, String[] collections, String[][] profiles, long from, long to) throws SQLException {
        List list = null;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        if (this.isPageable()) {
            ArrayList paramList = new ArrayList();
            StringBuffer where = new StringBuffer();
            this.conditioning(where, paramList, keyword, collections, profiles, from, to);
            if (!paramList.isEmpty()) {
                where.insert(0, "where ");
            }
            RdbmsPagingQuery pagingQuery = null;
            pagingQuery = new RdbmsPagingQuery(KEYWORDS, this.getOffset(), this.getLimit(), CALC_COLUMNS, "from " + this.getTableName(), where.toString(), "group by KEYWORDS", this.getOrderBy(), this.paramList2Array(paramList));
            list = supporter.fetchCriteria(conn, pagingQuery);
        } else {
            StringBuffer psql = new StringBuffer(this.getSelectCalcColumns());
            int position = psql.length();
            ArrayList paramList = new ArrayList();
            this.conditioning(psql, paramList, keyword, collections, profiles, from, to);
            if (!paramList.isEmpty()) {
                psql.insert(position, " where ");
            }
            psql.append(" group by KEYWORDS ");
            psql.append(this.getOrderBy());
            list = supporter.fetchItems(conn, new RdbmsGeneralQuery(psql.toString(), this.paramList2Array(paramList)));
        }
        List ret = this.create(list);
        int rank = this.isPageable() ? this.getOffset() : 1;
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            ((AbstractKeywordCountQueryLog)it.next()).setRank(rank++);
        }
        return ret;
    }

    protected abstract List create(List var1);

    protected String getOrderBy() {
        if (!StringUtil.isEmpty((String)this.orderColumn)) {
            StringBuffer buf = new StringBuffer(32);
            buf.append("order by ");
            buf.append(this.orderColumn);
            buf.append(' ');
            buf.append(SqlUtil.Order.toString((boolean)this.orderDirection));
            int used = StringArrayUtil.indexOfIgnoreCase((String[])CALC_LABELS, (String)this.orderColumn);
            int i = 0;
            while (i < CALC_LABELS.length) {
                if (i != used) {
                    buf.append(", ");
                    buf.append(CALC_LABELS[i]);
                    buf.append(' ');
                    buf.append(SqlUtil.Order.toString((boolean)true));
                }
                ++i;
            }
            return buf.toString();
        }
        return "";
    }

    protected abstract String getSelectCalcColumns();

    public abstract Transmitable getInstance();

    public void deserialize(InputStream in) throws IOException {
        super.deserialize(in);
        this.orderColumn = ByteUtil.readString((InputStream)in);
        this.orderDirection = ByteUtil.readBoolean((InputStream)in);
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        ByteUtil.writeString((OutputStream)out, (String)this.orderColumn);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.orderDirection);
    }

    public boolean equals(Object o) {
        boolean superEquals = super.equals(o);
        if (superEquals && o instanceof AbstractKeywordCountQueryLogDB) {
            return StringUtil.equals((String)this.orderColumn, (String)((AbstractKeywordCountQueryLogDB)o).orderColumn) && this.orderDirection == ((AbstractKeywordCountQueryLogDB)o).orderDirection;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ (this.orderColumn != null ? this.orderColumn.hashCode() : 0) ^ (this.orderDirection ? -1 : 0);
    }

    public String toString() {
        return "[" + super.toString() + ", orderColumn=" + this.orderColumn + ", orderDirection=" + this.orderDirection + "]";
    }

    public Inserter getInserter() {
        return new Inserter();
    }

    public class Inserter {
        protected PreparedStatement pstmt;

        Inserter() {
        }

        public void open(Connection conn) throws SQLException {
            this.close();
            this.pstmt = conn.prepareStatement(AbstractKeywordCountQueryLogDB.this.INSERT);
        }

        public synchronized void push(AbstractKeywordCountQueryLog log) throws SQLException {
            int idx = 0;
            this.pstmt.setString(++idx, log.getCollection());
            this.pstmt.setString(++idx, log.getProfile());
            this.pstmt.setString(++idx, PROPERTIES.encode(log.getKeywords()));
            this.pstmt.setInt(++idx, log.getRequested());
            this.pstmt.setTimestamp(++idx, new Timestamp(log.getRegistered()));
            this.pstmt.setLong(++idx, log.getDuration());
            this.pstmt.executeUpdate();
        }

        public synchronized void push(String collection, String profile, String keywords, int requested, long registered, long duration) throws SQLException {
            int idx = 0;
            this.pstmt.setString(++idx, collection);
            this.pstmt.setString(++idx, profile);
            this.pstmt.setString(++idx, PROPERTIES.encode(keywords));
            this.pstmt.setInt(++idx, requested);
            this.pstmt.setTimestamp(++idx, new Timestamp(registered));
            this.pstmt.setLong(++idx, duration);
            this.pstmt.executeUpdate();
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        public void close() {
            ConnectionFactory.release((PreparedStatement)this.pstmt);
            this.pstmt = null;
        }
    }
}

