/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.db.SqlUtil;
import com.diquest.commons.type.ArrayUtil;
import com.diquest.ir.common.database.handler.TimeLimited;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractLogDB
extends Transmitable
implements TimeLimited {
    public static final long LIMITLESS = -1L;
    private static final String PROFILE_COLUMN_NAME = "PROFILE";
    private static final String COLLECTION_COLUMN_NAME = "COLLECTION_ID";
    private static final String SERVER_COLUMN_NAME = "SERVER";
    private static final String REGISTERED_COLUMN_NAME = "REGISTERED";
    protected static final RdbmsProperties PROPERTIES = RdbmsPropertiesFactory.load();

    protected static final int executeUpdate(Connection conn, String psql, RdbmsColumnParameter[] parameters) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(psql, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public final int delete() throws SQLException {
        Connection conn = ConnectionFactory.getConnection();
        try {
            int n = this.delete(conn);
            return n;
        }
        finally {
            conn.close();
        }
    }

    public final int delete(Connection conn) throws SQLException {
        return this.delete(conn, null, null, null, -1L, -1L);
    }

    public synchronized int delete(Connection conn, String[] collections, String[][] profiles, String[] servers, long from, long to) throws SQLException {
        int i;
        boolean used;
        ArrayList<Object> paramList = new ArrayList<Object>();
        int parameterIndex = 1;
        StringBuffer psql = this.getDeleteSqlWithWhere();
        boolean bl = used = parameterIndex > 1;
        if (collections != null && collections.length > 0) {
            if (!this.isSupportCollection()) {
                throw new SQLException("Collection field is not available.");
            }
            used = this.ensureAnd(psql, used);
            this.addCollectionCondition(psql, collections.length);
            i = 0;
            while (i < collections.length) {
                paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, collections[i]));
                ++i;
            }
        }
        if (profiles != null && profiles.length > 0) {
            if (!this.isSupportCollection() || !this.isSupportProfile()) {
                throw new SQLException("Collection or Profile field is not available.");
            }
            used = this.ensureAnd(psql, used);
            this.addCollectionAndProfileCondition(psql, profiles);
            i = 0;
            while (i < profiles.length) {
                if (profiles[i].length == 1) {
                    paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                } else if (profiles[i].length == 2) {
                    paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                    paramList.add(new RdbmsStringColumnParameter(this.getProfileColumnName(), parameterIndex++, profiles[i][1]));
                } else {
                    throw new IllegalArgumentException("Incorrect profile information: " + ArrayUtil.toString((Object[])profiles[i]));
                }
                ++i;
            }
        }
        if (servers != null && servers.length > 0) {
            if (!this.isSupportServer()) {
                throw new SQLException("Server field is not available.");
            }
            used = this.ensureAnd(psql, used);
            this.addServerCondition(psql, servers.length);
            i = 0;
            while (i < servers.length) {
                paramList.add(new RdbmsStringColumnParameter(this.getServerColumnName(), parameterIndex++, servers[i]));
                ++i;
            }
        }
        if (from >= 0L && to >= 0L) {
            used = this.ensureAnd(psql, used);
            this.addBoundCondition(psql);
            paramList.add(new RdbmsDateColumnParameter(this.getRegisteredColumnName(), parameterIndex++, from));
            paramList.add(new RdbmsDateColumnParameter(this.getRegisteredColumnName(), parameterIndex++, to));
        } else if (from >= 0L) {
            used = this.ensureAnd(psql, used);
            SqlUtil.appendOperation((StringBuffer)psql, (String)this.getRegisteredColumnName(), (String)" >= ");
            paramList.add(new RdbmsDateColumnParameter(this.getRegisteredColumnName(), parameterIndex++, from));
        } else if (to >= 0L) {
            used = this.ensureAnd(psql, used);
            SqlUtil.appendOperation((StringBuffer)psql, (String)this.getRegisteredColumnName(), (String)" < ");
            paramList.add(new RdbmsDateColumnParameter(this.getRegisteredColumnName(), parameterIndex++, to));
        }
        return AbstractLogDB.executeUpdate(conn, psql.toString(), this.paramList2Array(paramList));
    }

    public final int deleteBetween(Connection conn, long from, long to) throws SQLException {
        return this.delete(conn, null, null, null, from, to);
    }

    public final int deleteBefore(Connection conn, long to) throws SQLException {
        return this.delete(conn, null, null, null, -1L, to);
    }

    public final int deleteAfter(Connection conn, long from) throws SQLException {
        return this.delete(conn, null, null, null, from, -1L);
    }

    public final int deleteCollection(Connection conn, String collection) throws SQLException {
        return this.deleteCollections(conn, new String[]{collection});
    }

    public final int deleteCollections(Connection conn, String[] collections) throws SQLException {
        return this.delete(conn, collections, null, null, -1L, -1L);
    }

    public final int deleteServer(Connection conn, String server) throws SQLException {
        return this.deleteServers(conn, new String[]{server});
    }

    public final int deleteServers(Connection conn, String[] servers) throws SQLException {
        return this.delete(conn, null, null, servers, -1L, -1L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return o instanceof AbstractLogDB;
    }

    public String getCollectionColumnName() {
        return COLLECTION_COLUMN_NAME;
    }

    public String getProfileColumnName() {
        return PROFILE_COLUMN_NAME;
    }

    public String getRegisteredColumnName() {
        return REGISTERED_COLUMN_NAME;
    }

    public String getServerColumnName() {
        return SERVER_COLUMN_NAME;
    }

    public abstract String getTableName();

    public abstract int hashCode();

    public final boolean isNull() {
        return false;
    }

    public abstract boolean isSupportCollection();

    public abstract boolean isSupportProfile();

    public abstract boolean isSupportServer();

    public abstract String toString();

    private String getDeleteSql() {
        return "delete from " + this.getTableName();
    }

    protected final void addBoundCondition(StringBuffer psql) {
        SqlUtil.appendInclusiveExclusiveBetween((StringBuffer)psql, (String)this.getRegisteredColumnName());
    }

    protected final void addCollectionAndProfileCondition(StringBuffer psql, String[][] profiles) {
        String collectionColumnName = this.getCollectionColumnName();
        String profileColumnName = this.getProfileColumnName();
        String[] collAndProf = new String[]{collectionColumnName, profileColumnName};
        int i = 0;
        while (i < profiles.length) {
            if (i != 0) {
                psql.append(" and ");
            }
            if (profiles[i].length == 1) {
                SqlUtil.appendStringEquals((StringBuffer)psql, (String)collectionColumnName);
            } else if (profiles[i].length == 2) {
                SqlUtil.appendStringEquals((StringBuffer)psql, (String[])collAndProf, (boolean)true);
            } else {
                throw new IllegalArgumentException();
            }
            ++i;
        }
    }

    protected final void addCollectionCondition(StringBuffer psql, int count) {
        this.addCondition(psql, this.getCollectionColumnName(), count);
    }

    protected final void addCondition(StringBuffer psql, String column, int count) {
        SqlUtil.appendStringEquals((StringBuffer)psql, (String)column, (int)count, (boolean)false);
    }

    protected final void addProfileCondition(StringBuffer psql, int count) {
        this.addCondition(psql, this.getProfileColumnName(), count);
    }

    protected final void addServerCondition(StringBuffer psql, int count) {
        this.addCondition(psql, this.getServerColumnName(), count);
    }

    protected final boolean ensureAnd(StringBuffer psql, boolean used) {
        if (!used) {
            used = true;
        } else {
            psql.append(" and ");
        }
        return used;
    }

    protected final int getCount(Connection conn, String psql, RdbmsColumnParameter[] parameters) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnValue[] fetchItem = supporter.fetchItem(conn, new RdbmsGeneralQuery(psql, parameters));
        if (fetchItem != null && fetchItem.length > 0 && fetchItem[0] != null) {
            return fetchItem[0].getInt();
        }
        return 0;
    }

    protected final String getCountSql() {
        return "select count(*) from " + this.getTableName();
    }

    protected final StringBuffer getDeleteSqlWithWhere() {
        StringBuffer psql = new StringBuffer();
        psql.append(this.getDeleteSql());
        psql.append(" where ");
        return psql;
    }

    protected final RdbmsColumnParameter[] paramList2Array(List paramList) {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[paramList.size()];
        paramList.toArray(parameters);
        return parameters;
    }

    public class NoSuchValueException
    extends Exception {
        private static final long serialVersionUID = -8720094742250993789L;
    }
}

