/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.common.database.handler.AbstractLogDB;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;

abstract class AbstractQueryLogDB
extends AbstractLogDB
implements CollectionObservable {
    private static final int DISABLED = -1;
    private int offset = -1;
    private int limit = -1;

    AbstractQueryLogDB() {
    }

    public void deserialize(InputStream in) throws IOException {
        this.offset = ByteUtil.readInt((InputStream)in);
        this.limit = ByteUtil.readInt((InputStream)in);
    }

    public abstract Transmitable getInstance();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof AbstractQueryLogDB) {
            return this.offset == ((AbstractQueryLogDB)o).offset && this.limit == ((AbstractQueryLogDB)o).limit;
        }
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeInt((OutputStream)out, (int)this.offset);
        ByteUtil.writeInt((OutputStream)out, (int)this.limit);
    }

    public int hashCode() {
        return this.offset ^ this.limit;
    }

    public String toString() {
        return "[offset=" + this.offset + ", limit=" + this.limit + "]";
    }

    public final void disablePaging() {
        this.setOffset(-1);
        this.setLimit(-1);
    }

    public final int getLimit() {
        return this.limit;
    }

    public final int getOffset() {
        return this.offset;
    }

    public abstract String getTableName();

    public final String getTimeColumnName() {
        return this.getRegisteredColumnName();
    }

    public final boolean isPageable() {
        return this.offset >= 0 && this.limit >= 0;
    }

    public final boolean isSupportCollection() {
        return true;
    }

    public final boolean isSupportProfile() {
        return true;
    }

    public abstract boolean isSupportServer();

    public final void setLimit(int limit) {
        this.limit = limit;
    }

    public final void setOffset(int offset) {
        this.offset = offset;
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                this.deleteCollection(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }
}

