/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.ir.common.database.entity.Client;
import com.diquest.ir.common.database.entity.CollectionAuthoritySet;
import com.diquest.ir.common.database.entity.Member;
import com.diquest.ir.common.database.entity.factory.ClientFactory;
import com.diquest.ir.common.database.entity.factory.MemberFactory;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.encode.SHA2Encoder;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsBinaryStreamColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsBinaryStreamColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsCharStreamColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class AuthorityDB {
    public static final int BUSINESS_COLLECTION_MNG = 1;
    public static final int BUSINESS_INDEX_DB_MNG = 2;
    public static final int BUSINESS_KNOWLEDGE_MNG = 3;
    public static final int BUSINESS_SERVER_SETTING_MNG = 4;
    public static final int BUSINESS_SYSTEM_MNG = 5;
    public static final int BUSINESS_LOG_MNG = 6;
    public static final int BUSINESS_ERRORTRACKING_MNG = 7;
    public static final int BUSINESS_ADMIN_MNG = 8;
    public static final int BUSINESS_JOBLIST_MNG = 9;
    public static final int BUSINESS_DBWATCHER_MNG = 10;
    public static final char AUTH_LEVEL_READ = 'R';
    public static final char AUTH_LEVEL_WRITE = 'W';
    public static final char AUTH_LEVEL_NONE = 'N';
    public static final char AUTH_LEVEL_FALSE = 'D';
    public static final char AUTH_LEVEL_NOT_DEFINED = 'K';
    public static final char AUTH_LEVEL_REPORT_READ_ALL_COLLECTION = 'A';
    public static final char AUTH_LEVEL_JOBLOG_READ_ALL_JOB = 'A';
    public static final char AUTH_LEVEL_ERRORREPORT_READ_ENABLE_TEST = 'E';
    public static final int MEMBER_SESSION_TIME = 60;
    public static final char IS_CONNECTED = 'A';
    public static final char IS_NOT_CONNECTED = 'B';
    public static final String DEFAULT_PROFILE = "Default";
    public static final String ADMIN_ID = "super";
    static final RdbmsProperties properties = RdbmsPropertiesFactory.load();
    static final boolean USE_CLOB;
    public static final int VALIDATE_MEMBER_SUCCESS = 0;
    public static final int VALIDATE_MEMBER_NOT_FOUND = -1;
    public static final int VALIDATE_MEMBER_PASSWORD_NOT_EQUAL = -2;
    static final String SQL_VALIDATE_MEMBER;
    static final String SQL_PUSH_MEMBER;
    private static final String SQL_GET_ALL_MEMBER;
    private static final String SQL_GET_MEMBER;
    static final String SQL_UPDATE_MEMBER;
    static final String SQL_UPDATE_MEMBER_EXCLUDE_PASSWORD;
    static final String SQL_REMOVE_MEMBER;
    static final String SQL_GET_COLLECTION_AUTH;
    static final String SQL_UPDATE_COLLECTION_AUTH;
    static final String SQL_SET_MEMBER_CONNECTED;
    static final String SQL_ACCEPT_CONNECT;
    static final String SQL_PUSH_TRUSTED_CLIENT;
    public static final String SQL_GET_ALL_CLIENT;
    public static final String SQL_GET_CLIENT;
    static final String SQL_UPDATE_TRUSTED_CLIENT;
    static final String SQL_REMOVE_TRUSTED_CLIENT;
    static final String SQL_REMOVE_ALL_CLIENT;

    static {
        String property = properties.getProperty("ir.db.useclob");
        USE_CLOB = property == null ? false : Boolean.valueOf(property);
        SQL_VALIDATE_MEMBER = "SELECT * FROM " + properties.getPrefix() + "_MEMBER WHERE USER_ID=? ";
        SQL_PUSH_MEMBER = " INSERT INTO " + properties.getPrefix() + "_MEMBER (USER_ID, PASSWORD, NAME, AUTH_REPORT_MNG, " + " AUTH_INDEX_MNG, AUTH_SEARCHPROFILE_MNG, AUTH_THESAURUSDIC_MNG, AUTH_STOPWORDDIC_MNG, AUTH_USERDIC_MNG, AUTH_USERCNDIC_MNG, " + " AUTH_BANNEDWORDDIC_MNG, AUTH_REDIRECTDIC_MNG, AUTH_RECOMMENDDIC_MNG, AUTH_CATEGORYRANKDIC_MNG, " + " AUTH_DOCUMENTRANKDIC_MNG, AUTH_KEYWORDPROFILEDIC_MNG, AUTH_INDEXLOG_MNG, AUTH_ERRORLOG_MNG, AUTH_SEARCHLOG_MNG, AUTH_JOBLOG_MNG, " + " AUTH_COLLECTION_MNG, AUTH_SERVER_MNG, AUTH_LOGSETTING_MNG, AUTH_ERRORREPORT_MNG, AUTH_JOBLIST_MNG, " + " AUTH_POPKEYWORD_MNG, AUTH_ACCOUNT_MNG, AUTH_CONNECT_MNG, AUTH_MANAGERTOOL_MNG, COLLECTION_AUTHORITY, " + " DESCRIPTION, CREATED, UPDATED, IS_CONNECTED) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
        SQL_GET_ALL_MEMBER = " SELECT * FROM " + properties.getPrefix() + "_MEMBER " + " ORDER BY UPDATED DESC";
        SQL_GET_MEMBER = "SELECT * from " + properties.getPrefix() + "_MEMBER WHERE USER_ID = ? ";
        SQL_UPDATE_MEMBER = " UPDATE " + properties.getPrefix() + "_MEMBER SET USER_ID=?, PASSWORD=?, NAME=?,  AUTH_REPORT_MNG=?, " + " AUTH_INDEX_MNG=?, AUTH_SEARCHPROFILE_MNG=?, AUTH_THESAURUSDIC_MNG=?, AUTH_STOPWORDDIC_MNG=?, AUTH_USERDIC_MNG=?, " + " AUTH_USERCNDIC_MNG=?, AUTH_BANNEDWORDDIC_MNG=?, AUTH_REDIRECTDIC_MNG=?, AUTH_RECOMMENDDIC_MNG=?, AUTH_CATEGORYRANKDIC_MNG=?, " + " AUTH_DOCUMENTRANKDIC_MNG=?, AUTH_KEYWORDPROFILEDIC_MNG=?, AUTH_INDEXLOG_MNG=?, AUTH_ERRORLOG_MNG=?, AUTH_SEARCHLOG_MNG=?, AUTH_JOBLOG_MNG=?, " + " AUTH_COLLECTION_MNG=?, AUTH_SERVER_MNG=?, AUTH_LOGSETTING_MNG=?, AUTH_ERRORREPORT_MNG=?, AUTH_JOBLIST_MNG=?, " + " AUTH_POPKEYWORD_MNG=?, AUTH_ACCOUNT_MNG=?, AUTH_CONNECT_MNG=?, AUTH_MANAGERTOOL_MNG=?, COLLECTION_AUTHORITY=?, DESCRIPTION=?, " + " UPDATED=? " + " WHERE USER_ID=? ";
        SQL_UPDATE_MEMBER_EXCLUDE_PASSWORD = " UPDATE " + properties.getPrefix() + "_MEMBER SET USER_ID=?, NAME=?,  AUTH_REPORT_MNG=?, " + " AUTH_INDEX_MNG=?, AUTH_SEARCHPROFILE_MNG=?, AUTH_THESAURUSDIC_MNG=?, AUTH_STOPWORDDIC_MNG=?, AUTH_USERDIC_MNG=?, " + " AUTH_USERCNDIC_MNG=?, AUTH_BANNEDWORDDIC_MNG=?, AUTH_REDIRECTDIC_MNG=?, AUTH_RECOMMENDDIC_MNG=?, AUTH_CATEGORYRANKDIC_MNG=?, " + " AUTH_DOCUMENTRANKDIC_MNG=?, AUTH_KEYWORDPROFILEDIC_MNG=?, AUTH_INDEXLOG_MNG=?, AUTH_ERRORLOG_MNG=?, AUTH_SEARCHLOG_MNG=?, AUTH_JOBLOG_MNG=?, " + " AUTH_COLLECTION_MNG=?, AUTH_SERVER_MNG=?, AUTH_LOGSETTING_MNG=?, AUTH_ERRORREPORT_MNG=?, AUTH_JOBLIST_MNG=?, " + " AUTH_POPKEYWORD_MNG=?, AUTH_ACCOUNT_MNG=?, AUTH_CONNECT_MNG=?, AUTH_MANAGERTOOL_MNG=?," + " COLLECTION_AUTHORITY=?, DESCRIPTION=?, UPDATED=? " + " WHERE USER_ID=? ";
        SQL_REMOVE_MEMBER = " DELETE FROM " + properties.getPrefix() + "_MEMBER " + " WHERE USER_ID=? ";
        SQL_GET_COLLECTION_AUTH = " SELECT COLLECTION_AUTHORITY FROM " + properties.getPrefix() + "_MEMBER " + " WHERE USER_ID = ?";
        SQL_UPDATE_COLLECTION_AUTH = " UPDATE " + properties.getPrefix() + "_MEMBER " + " SET COLLECTION_AUTHORITY=? " + " WHERE USER_ID=? ";
        SQL_SET_MEMBER_CONNECTED = " UPDATE " + properties.getPrefix() + "_MEMBER " + " SET   IS_CONNECTED=? " + " WHERE USER_ID=? ";
        SQL_ACCEPT_CONNECT = " SELECT IS_CONNECTED  FROM " + properties.getPrefix() + "_MEMBER WHERE USER_ID=? ";
        SQL_PUSH_TRUSTED_CLIENT = " INSERT INTO " + properties.getPrefix() + "_CLIENT (IP, DESCRIPTION,CREATED,CREATOR,LAST_UPDATED,LAST_UPDATOR)" + " VALUES (?,?,?,?,?,?)";
        SQL_GET_ALL_CLIENT = " SELECT * FROM " + properties.getPrefix() + "_CLIENT ORDER BY LAST_UPDATED DESC";
        SQL_GET_CLIENT = " SELECT *  FROM " + properties.getPrefix() + "_CLIENT " + " WHERE IP=? ";
        SQL_UPDATE_TRUSTED_CLIENT = " UPDATE " + properties.getPrefix() + "_CLIENT SET DESCRIPTION=?, LAST_UPDATED=?, LAST_UPDATOR=? " + " WHERE IP=? ";
        SQL_REMOVE_TRUSTED_CLIENT = " DELETE FROM " + properties.getPrefix() + "_CLIENT " + " WHERE IP=? ";
        SQL_REMOVE_ALL_CLIENT = " DELETE FROM " + properties.getPrefix() + "_CLIENT ";
    }

    public boolean hasPrivilege(Connection conn, Member member, String pageURL) throws SQLException {
        return true;
    }

    public int validateMember(String userID, String password, Member comparator) {
        return this.validateMember(password, comparator, properties.getUseEncryption());
    }

    public int validateMember(String userID, String password, Member comparator, boolean useEncryption) {
        return this.validateMember(password, comparator, useEncryption);
    }

    public int validateMember(String password, Member comparator) {
        return this.validateMember(password, comparator, properties.getUseEncryption());
    }

    public int validateMember(String password, Member comparator, boolean useEncryption) {
        if (comparator == null) {
            return -1;
        }
        if (useEncryption) {
            if (!(password = SHA2Encoder.encrypt((String)password)).equals(comparator.getPassword())) {
                return -2;
            }
            return 0;
        }
        if (!password.equals(comparator.getPassword())) {
            return -2;
        }
        return 0;
    }

    public int validateMember(Connection conn, String userID, String password) throws SQLException, IOException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("USER_ID", 1, userID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_VALIDATE_MEMBER, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnValue[] member_column_values = supporter.fetchItem(conn, query);
        Member member = MemberFactory.create(member_column_values);
        return this.validateMember(password, member);
    }

    public Member pushMember(Connection conn, String userID, String name, String password, char authReportMng, char authIndexMng, char authSearchProfileMng, char authThesaurusDicMng, char authStopwordDicMng, char authUserDicMng, char authUserCnDicMng, char authBannedwordDicMng, char authRedirectDicMng, char authRecommendDicMng, char authCategoryRankDicMng, char authDocumentRankDicMng, char authKeywordProfileDicMng, char authIndexLogMng, char authErrorLogMng, char authSearchLogMng, char authJobLogMng, char authCollectionMng, char authServerMng, char authLogSettingMng, char authErrorReportMng, char authJobListMng, char authPopKeywordMng, char authAccountMng, char authConnectMng, char authManagetToolMng, CollectionAuthoritySet collectionAuth, String description, long created, long updated) throws SQLException, IOException {
        RdbmsColumnParameter[] parameters = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        collectionAuth.serialize(baos);
        int idx = 1;
        if (!USE_CLOB) {
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("USER_ID", idx++, userID), new RdbmsStringColumnParameter("PASSWORD", idx++, properties.getUseEncryption() ? SHA2Encoder.encrypt((String)password) : password), new RdbmsStringColumnParameter("NAME", idx++, name), new RdbmsStringColumnParameter("AUTH_REPORT_MNG", idx++, authReportMng), new RdbmsStringColumnParameter("AUTH_INDEX_MNG", idx++, authIndexMng), new RdbmsStringColumnParameter("AUTH_SEARCHPROFILE_MNG", idx++, authSearchProfileMng), new RdbmsStringColumnParameter("AUTH_THESAURUSDIC_MNG", idx++, authThesaurusDicMng), new RdbmsStringColumnParameter("AUTH_STOPWORDDIC_MNG", idx++, authStopwordDicMng), new RdbmsStringColumnParameter("AUTH_USERDIC_MNG", idx++, authUserDicMng), new RdbmsStringColumnParameter("AUTH_USERCNDIC_MNG", idx++, authUserCnDicMng), new RdbmsStringColumnParameter("AUTH_BANNEDWORDDIC_MNG", idx++, authBannedwordDicMng), new RdbmsStringColumnParameter("AUTH_REDIRECTDIC_MNG", idx++, authRedirectDicMng), new RdbmsStringColumnParameter("AUTH_RECOMMENDDIC_MNG", idx++, authRecommendDicMng), new RdbmsStringColumnParameter("AUTH_CATEGORYRANKDIC_MNG", idx++, authCategoryRankDicMng), new RdbmsStringColumnParameter("AUTH_DOCUMENTRANKDIC_MNG", idx++, authDocumentRankDicMng), new RdbmsStringColumnParameter("AUTH_KEYWORDPROFILEDIC_MNG", idx++, authKeywordProfileDicMng), new RdbmsStringColumnParameter("AUTH_INDEXLOG_MNG", idx++, authIndexLogMng), new RdbmsStringColumnParameter("AUTH_ERRORLOG_MNG", idx++, authErrorLogMng), new RdbmsStringColumnParameter("AUTH_SEARCHLOG_MNG", idx++, authSearchLogMng), new RdbmsStringColumnParameter("AUTH_JOBLOG_MNG", idx++, authJobLogMng), new RdbmsStringColumnParameter("AUTH_COLLECTION_MNG", idx++, authCollectionMng), new RdbmsStringColumnParameter("AUTH_SERVER_MNG", idx++, authServerMng), new RdbmsStringColumnParameter("AUTH_LOGSETTING_MNG", idx++, authLogSettingMng), new RdbmsStringColumnParameter("AUTH_ERRORREPORT_MNG", idx++, authErrorReportMng), new RdbmsStringColumnParameter("AUTH_JOBLIST_MNG", idx++, authJobListMng), new RdbmsStringColumnParameter("AUTH_POPKEYWORD_MNG", idx++, authPopKeywordMng), new RdbmsStringColumnParameter("AUTH_ACCOUNT_MNG", idx++, authAccountMng), new RdbmsStringColumnParameter("AUTH_CONNECT_MNG", idx++, authConnectMng), new RdbmsStringColumnParameter("AUTH_MANAGERTOOL_MNG", idx++, authManagetToolMng), new RdbmsBinaryStreamColumnParameter("COLLECTION_AUTHORITY", idx++, baos.toByteArray()), new RdbmsStringColumnParameter("DESCRIPTION", idx++, description), new RdbmsDateColumnParameter("CREATED", idx++, new Timestamp(created)), new RdbmsDateColumnParameter("UPDATED", idx++, new Timestamp(updated)), new RdbmsStringColumnParameter("IS_CONNECTED", idx++, 'B')};
        } else {
            byte[] b = baos.toByteArray();
            String sCollectionAuth = ByteUtil.byteArrayToHex((byte[])b);
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("USER_ID", idx++, userID), new RdbmsStringColumnParameter("PASSWORD", idx++, properties.getUseEncryption() ? SHA2Encoder.encrypt((String)password) : password), new RdbmsStringColumnParameter("NAME", idx++, name), new RdbmsStringColumnParameter("AUTH_REPORT_MNG", idx++, authReportMng), new RdbmsStringColumnParameter("AUTH_INDEX_MNG", idx++, authIndexMng), new RdbmsStringColumnParameter("AUTH_SEARCHPROFILE_MNG", idx++, authSearchProfileMng), new RdbmsStringColumnParameter("AUTH_THESAURUSDIC_MNG", idx++, authThesaurusDicMng), new RdbmsStringColumnParameter("AUTH_STOPWORDDIC_MNG", idx++, authStopwordDicMng), new RdbmsStringColumnParameter("AUTH_USERDIC_MNG", idx++, authUserDicMng), new RdbmsStringColumnParameter("AUTH_USERCNDIC_MNG", idx++, authUserCnDicMng), new RdbmsStringColumnParameter("AUTH_BANNEDWORDDIC_MNG", idx++, authBannedwordDicMng), new RdbmsStringColumnParameter("AUTH_REDIRECTDIC_MNG", idx++, authRedirectDicMng), new RdbmsStringColumnParameter("AUTH_RECOMMENDDIC_MNG", idx++, authRecommendDicMng), new RdbmsStringColumnParameter("AUTH_CATEGORYRANKDIC_MNG", idx++, authCategoryRankDicMng), new RdbmsStringColumnParameter("AUTH_DOCUMENTRANKDIC_MNG", idx++, authDocumentRankDicMng), new RdbmsStringColumnParameter("AUTH_KEYWORDPROFILEDIC_MNG", idx++, authKeywordProfileDicMng), new RdbmsStringColumnParameter("AUTH_INDEXLOG_MNG", idx++, authIndexLogMng), new RdbmsStringColumnParameter("AUTH_ERRORLOG_MNG", idx++, authErrorLogMng), new RdbmsStringColumnParameter("AUTH_SEARCHLOG_MNG", idx++, authSearchLogMng), new RdbmsStringColumnParameter("AUTH_JOBLOG_MNG", idx++, authJobLogMng), new RdbmsStringColumnParameter("AUTH_COLLECTION_MNG", idx++, authCollectionMng), new RdbmsStringColumnParameter("AUTH_SERVER_MNG", idx++, authServerMng), new RdbmsStringColumnParameter("AUTH_LOGSETTING_MNG", idx++, authLogSettingMng), new RdbmsStringColumnParameter("AUTH_ERRORREPORT_MNG", idx++, authErrorReportMng), new RdbmsStringColumnParameter("AUTH_JOBLIST_MNG", idx++, authJobListMng), new RdbmsStringColumnParameter("AUTH_POPKEYWORD_MNG", idx++, authPopKeywordMng), new RdbmsStringColumnParameter("AUTH_ACCOUNT_MNG", idx++, authAccountMng), new RdbmsStringColumnParameter("AUTH_CONNECT_MNG", idx++, authConnectMng), new RdbmsStringColumnParameter("AUTH_MANAGERTOOL_MNG", idx++, authManagetToolMng), new RdbmsCharStreamColumnParameter("COLLECTION_AUTHORITY", idx++, sCollectionAuth.toCharArray()), new RdbmsStringColumnParameter("DESCRIPTION", idx++, description), new RdbmsDateColumnParameter("CREATED", idx++, new Timestamp(created)), new RdbmsDateColumnParameter("UPDATED", idx++, new Timestamp(updated)), new RdbmsStringColumnParameter("IS_CONNECTED", idx++, 'B')};
        }
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_PUSH_MEMBER, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        supporter.executeUpdate(conn, query);
        Member member = this.getMember(conn, userID);
        return member;
    }

    public List getAllMember(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET_ALL_MEMBER, null);
        return supporter.fetchItems(conn, query);
    }

    public String[] getAllMemberID(Connection conn) throws SQLException {
        List allMember = this.getAllMember(conn);
        String[] idList = new String[allMember.size()];
        int i = 0;
        while (i < allMember.size()) {
            RdbmsColumnValue[] member_column_values = (RdbmsColumnValue[])allMember.get(i);
            idList[i] = member_column_values[0].toString();
            ++i;
        }
        return idList;
    }

    public Member getMember(Connection conn, String userID) throws SQLException, IOException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("USER_ID", 1, userID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET_MEMBER, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnValue[] member_column_values = supporter.fetchItem(conn, query);
        Member member = MemberFactory.create(member_column_values);
        return member;
    }

    public int updateMember(Connection conn, String userID, String name, String password, char authReportMng, char authIndexMng, char authSearchProfileMng, char authThesaurusDicMng, char authStopwordDicMng, char authUserDicMng, char authUserCnDicMng, char authBannedwordDicMng, char authRedirectDicMng, char authRecommendDicMng, char authCategoryRankDicMng, char authDocumentRankDicMng, char authKeywordProfileDicMng, char authIndexLogMng, char authErrorLogMng, char authSearchLogMng, char authJobLogMng, char authCollectionMng, char authServerMng, char authLogSettingMng, char authErrorReportMng, char authJobListMng, char authPopKeywordMng, char authAccountMng, char authConnectMng, char authManagetToolMng, CollectionAuthoritySet collectionAuth, String description, long created, long updated) throws SQLException, IOException {
        RdbmsColumnParameter[] parameters = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        collectionAuth.serialize(baos);
        int idx = 1;
        if (!USE_CLOB) {
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("USER_ID", idx++, userID), new RdbmsStringColumnParameter("PASSWORD", idx++, properties.getUseEncryption() ? SHA2Encoder.encrypt((String)password) : password), new RdbmsStringColumnParameter("NAME", idx++, name), new RdbmsStringColumnParameter("AUTH_REPORT_MNG", idx++, authReportMng), new RdbmsStringColumnParameter("AUTH_INDEX_MNG", idx++, authIndexMng), new RdbmsStringColumnParameter("AUTH_SEARCHPROFILE_MNG", idx++, authSearchProfileMng), new RdbmsStringColumnParameter("AUTH_THESAURUSDIC_MNG", idx++, authThesaurusDicMng), new RdbmsStringColumnParameter("AUTH_STOPWORDDIC_MNG", idx++, authStopwordDicMng), new RdbmsStringColumnParameter("AUTH_USERDIC_MNG", idx++, authUserDicMng), new RdbmsStringColumnParameter("AUTH_USERCNDIC_MNG", idx++, authUserCnDicMng), new RdbmsStringColumnParameter("AUTH_BANNEDWORDDIC_MNG", idx++, authBannedwordDicMng), new RdbmsStringColumnParameter("AUTH_REDIRECTDIC_MNG", idx++, authRedirectDicMng), new RdbmsStringColumnParameter("AUTH_RECOMMENDDIC_MNG", idx++, authRecommendDicMng), new RdbmsStringColumnParameter("AUTH_CATEGORYRANKDIC_MNG", idx++, authCategoryRankDicMng), new RdbmsStringColumnParameter("AUTH_DOCUMENTRANKDIC_MNG", idx++, authDocumentRankDicMng), new RdbmsStringColumnParameter("AUTH_KEYWORDPROFILEDIC_MNG", idx++, authKeywordProfileDicMng), new RdbmsStringColumnParameter("AUTH_INDEXLOG_MNG", idx++, authIndexLogMng), new RdbmsStringColumnParameter("AUTH_ERRORLOG_MNG", idx++, authErrorLogMng), new RdbmsStringColumnParameter("AUTH_SEARCHLOG_MNG", idx++, authSearchLogMng), new RdbmsStringColumnParameter("AUTH_JOBLOG_MNG", idx++, authJobLogMng), new RdbmsStringColumnParameter("AUTH_COLLECTION_MNG", idx++, authCollectionMng), new RdbmsStringColumnParameter("AUTH_SERVER_MNG", idx++, authServerMng), new RdbmsStringColumnParameter("AUTH_LOGSETTING_MNG", idx++, authLogSettingMng), new RdbmsStringColumnParameter("AUTH_ERRORREPORT_MNG", idx++, authErrorReportMng), new RdbmsStringColumnParameter("AUTH_JOBLIST_MNG", idx++, authJobListMng), new RdbmsStringColumnParameter("AUTH_POPKEYWORD_MNG", idx++, authPopKeywordMng), new RdbmsStringColumnParameter("AUTH_ACCOUNT_MNG", idx++, authAccountMng), new RdbmsStringColumnParameter("AUTH_CONNECT_MNG", idx++, authConnectMng), new RdbmsStringColumnParameter("AUTH_MANAGERTOOL_MNG", idx++, authManagetToolMng), new RdbmsBinaryStreamColumnParameter("COLLECTION_AUTHORITY", idx++, baos.toByteArray()), new RdbmsStringColumnParameter("DESCRIPTION", idx++, description), new RdbmsDateColumnParameter("UPDATED", idx++, new Timestamp(updated)), new RdbmsStringColumnParameter("USER_ID", idx++, userID)};
        } else {
            byte[] b = baos.toByteArray();
            String sCollectionAuth = ByteUtil.byteArrayToHex((byte[])b);
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("USER_ID", idx++, userID), new RdbmsStringColumnParameter("PASSWORD", idx++, properties.getUseEncryption() ? SHA2Encoder.encrypt((String)password) : password), new RdbmsStringColumnParameter("NAME", idx++, name), new RdbmsStringColumnParameter("AUTH_REPORT_MNG", idx++, authReportMng), new RdbmsStringColumnParameter("AUTH_INDEX_MNG", idx++, authIndexMng), new RdbmsStringColumnParameter("AUTH_SEARCHPROFILE_MNG", idx++, authSearchProfileMng), new RdbmsStringColumnParameter("AUTH_THESAURUSDIC_MNG", idx++, authThesaurusDicMng), new RdbmsStringColumnParameter("AUTH_STOPWORDDIC_MNG", idx++, authStopwordDicMng), new RdbmsStringColumnParameter("AUTH_USERDIC_MNG", idx++, authUserDicMng), new RdbmsStringColumnParameter("AUTH_USERCNDIC_MNG", idx++, authUserCnDicMng), new RdbmsStringColumnParameter("AUTH_BANNEDWORDDIC_MNG", idx++, authBannedwordDicMng), new RdbmsStringColumnParameter("AUTH_REDIRECTDIC_MNG", idx++, authRedirectDicMng), new RdbmsStringColumnParameter("AUTH_RECOMMENDDIC_MNG", idx++, authRecommendDicMng), new RdbmsStringColumnParameter("AUTH_CATEGORYRANKDIC_MNG", idx++, authCategoryRankDicMng), new RdbmsStringColumnParameter("AUTH_DOCUMENTRANKDIC_MNG", idx++, authDocumentRankDicMng), new RdbmsStringColumnParameter("AUTH_KEYWORDPROFILEDIC_MNG", idx++, authKeywordProfileDicMng), new RdbmsStringColumnParameter("AUTH_INDEXLOG_MNG", idx++, authIndexLogMng), new RdbmsStringColumnParameter("AUTH_ERRORLOG_MNG", idx++, authErrorLogMng), new RdbmsStringColumnParameter("AUTH_SEARCHLOG_MNG", idx++, authSearchLogMng), new RdbmsStringColumnParameter("AUTH_JOBLOG_MNG", idx++, authJobLogMng), new RdbmsStringColumnParameter("AUTH_COLLECTION_MNG", idx++, authCollectionMng), new RdbmsStringColumnParameter("AUTH_SERVER_MNG", idx++, authServerMng), new RdbmsStringColumnParameter("AUTH_LOGSETTING_MNG", idx++, authLogSettingMng), new RdbmsStringColumnParameter("AUTH_ERRORREPORT_MNG", idx++, authErrorReportMng), new RdbmsStringColumnParameter("AUTH_JOBLIST_MNG", idx++, authJobListMng), new RdbmsStringColumnParameter("AUTH_POPKEYWORD_MNG", idx++, authPopKeywordMng), new RdbmsStringColumnParameter("AUTH_ACCOUNT_MNG", idx++, authAccountMng), new RdbmsStringColumnParameter("AUTH_CONNECT_MNG", idx++, authConnectMng), new RdbmsStringColumnParameter("AUTH_MANAGERTOOL_MNG", idx++, authManagetToolMng), new RdbmsCharStreamColumnParameter("COLLECTION_AUTHORITY", idx++, sCollectionAuth.toCharArray()), new RdbmsStringColumnParameter("DESCRIPTION", idx++, description), new RdbmsDateColumnParameter("UPDATED", idx++, new Timestamp(updated)), new RdbmsStringColumnParameter("USER_ID", idx++, userID)};
        }
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_MEMBER, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, query);
    }

    public int updateMemberExcludePassword(Connection conn, String userID, String name, char authReportMng, char authIndexMng, char authSearchProfileMng, char authThesaurusDicMng, char authStopwordDicMng, char authUserDicMng, char authUserCnDicMng, char authBannedwordDicMng, char authRedirectDicMng, char authRecommendDicMng, char authCategoryRankDicMng, char authDocumentRankDicMng, char authKeywordProfileDicMng, char authIndexLogMng, char authErrorLogMng, char authSearchLogMng, char authJobLogMng, char authCollectionMng, char authServerMng, char authLogSettingMng, char authErrorReportMng, char authJobListMng, char authPopKeywordMng, char authAccountMng, char authConnectMng, char authManagetToolMng, CollectionAuthoritySet collectionAuth, String description, long created, long updated) throws SQLException, IOException {
        RdbmsColumnParameter[] parameters = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        collectionAuth.serialize(baos);
        int idx = 1;
        if (!USE_CLOB) {
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("USER_ID", idx++, userID), new RdbmsStringColumnParameter("NAME", idx++, name), new RdbmsStringColumnParameter("AUTH_REPORT_MNG", idx++, authReportMng), new RdbmsStringColumnParameter("AUTH_INDEX_MNG", idx++, authIndexMng), new RdbmsStringColumnParameter("AUTH_SEARCHPROFILE_MNG", idx++, authSearchProfileMng), new RdbmsStringColumnParameter("AUTH_THESAURUSDIC_MNG", idx++, authThesaurusDicMng), new RdbmsStringColumnParameter("AUTH_STOPWORDDIC_MNG", idx++, authStopwordDicMng), new RdbmsStringColumnParameter("AUTH_USERDIC_MNG", idx++, authUserDicMng), new RdbmsStringColumnParameter("AUTH_USERCNDIC_MNG", idx++, authUserCnDicMng), new RdbmsStringColumnParameter("AUTH_BANNEDWORDDIC_MNG", idx++, authBannedwordDicMng), new RdbmsStringColumnParameter("AUTH_REDIRECTDIC_MNG", idx++, authRedirectDicMng), new RdbmsStringColumnParameter("AUTH_RECOMMENDDIC_MNG", idx++, authRecommendDicMng), new RdbmsStringColumnParameter("AUTH_CATEGORYRANKDIC_MNG", idx++, authCategoryRankDicMng), new RdbmsStringColumnParameter("AUTH_DOCUMENTRANKDIC_MNG", idx++, authDocumentRankDicMng), new RdbmsStringColumnParameter("AUTH_KEYWORDPROFILEDIC_MNG", idx++, authKeywordProfileDicMng), new RdbmsStringColumnParameter("AUTH_INDEXLOG_MNG", idx++, authIndexLogMng), new RdbmsStringColumnParameter("AUTH_ERRORLOG_MNG", idx++, authErrorLogMng), new RdbmsStringColumnParameter("AUTH_SEARCHLOG_MNG", idx++, authSearchLogMng), new RdbmsStringColumnParameter("AUTH_JOBLOG_MNG", idx++, authJobLogMng), new RdbmsStringColumnParameter("AUTH_COLLECTION_MNG", idx++, authCollectionMng), new RdbmsStringColumnParameter("AUTH_SERVER_MNG", idx++, authServerMng), new RdbmsStringColumnParameter("AUTH_LOGSETTING_MNG", idx++, authLogSettingMng), new RdbmsStringColumnParameter("AUTH_ERRORREPORT_MNG", idx++, authErrorReportMng), new RdbmsStringColumnParameter("AUTH_JOBLIST_MNG", idx++, authJobListMng), new RdbmsStringColumnParameter("AUTH_POPKEYWORD_MNG", idx++, authPopKeywordMng), new RdbmsStringColumnParameter("AUTH_ACCOUNT_MNG", idx++, authAccountMng), new RdbmsStringColumnParameter("AUTH_CONNECT_MNG", idx++, authConnectMng), new RdbmsStringColumnParameter("AUTH_MANAGERTOOL_MNG", idx++, authManagetToolMng), new RdbmsBinaryStreamColumnParameter("COLLECTION_AUTHORITY", idx++, baos.toByteArray()), new RdbmsStringColumnParameter("DESCRIPTION", idx++, description), new RdbmsDateColumnParameter("UPDATED", idx++, new Timestamp(updated)), new RdbmsStringColumnParameter("USER_ID", idx++, userID)};
        } else {
            byte[] b = baos.toByteArray();
            String sCollectionAuth = ByteUtil.byteArrayToHex((byte[])b);
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("USER_ID", idx++, userID), new RdbmsStringColumnParameter("NAME", idx++, name), new RdbmsStringColumnParameter("AUTH_REPORT_MNG", idx++, authReportMng), new RdbmsStringColumnParameter("AUTH_INDEX_MNG", idx++, authIndexMng), new RdbmsStringColumnParameter("AUTH_SEARCHPROFILE_MNG", idx++, authSearchProfileMng), new RdbmsStringColumnParameter("AUTH_THESAURUSDIC_MNG", idx++, authThesaurusDicMng), new RdbmsStringColumnParameter("AUTH_STOPWORDDIC_MNG", idx++, authStopwordDicMng), new RdbmsStringColumnParameter("AUTH_USERDIC_MNG", idx++, authUserDicMng), new RdbmsStringColumnParameter("AUTH_USERCNDIC_MNG", idx++, authUserCnDicMng), new RdbmsStringColumnParameter("AUTH_BANNEDWORDDIC_MNG", idx++, authBannedwordDicMng), new RdbmsStringColumnParameter("AUTH_REDIRECTDIC_MNG", idx++, authRedirectDicMng), new RdbmsStringColumnParameter("AUTH_RECOMMENDDIC_MNG", idx++, authRecommendDicMng), new RdbmsStringColumnParameter("AUTH_CATEGORYRANKDIC_MNG", idx++, authCategoryRankDicMng), new RdbmsStringColumnParameter("AUTH_DOCUMENTRANKDIC_MNG", idx++, authDocumentRankDicMng), new RdbmsStringColumnParameter("AUTH_KEYWORDPROFILEDIC_MNG", idx++, authKeywordProfileDicMng), new RdbmsStringColumnParameter("AUTH_INDEXLOG_MNG", idx++, authIndexLogMng), new RdbmsStringColumnParameter("AUTH_ERRORLOG_MNG", idx++, authErrorLogMng), new RdbmsStringColumnParameter("AUTH_SEARCHLOG_MNG", idx++, authSearchLogMng), new RdbmsStringColumnParameter("AUTH_JOBLOG_MNG", idx++, authJobLogMng), new RdbmsStringColumnParameter("AUTH_COLLECTION_MNG", idx++, authCollectionMng), new RdbmsStringColumnParameter("AUTH_SERVER_MNG", idx++, authServerMng), new RdbmsStringColumnParameter("AUTH_LOGSETTING_MNG", idx++, authLogSettingMng), new RdbmsStringColumnParameter("AUTH_ERRORREPORT_MNG", idx++, authErrorReportMng), new RdbmsStringColumnParameter("AUTH_JOBLIST_MNG", idx++, authJobListMng), new RdbmsStringColumnParameter("AUTH_POPKEYWORD_MNG", idx++, authPopKeywordMng), new RdbmsStringColumnParameter("AUTH_ACCOUNT_MNG", idx++, authAccountMng), new RdbmsStringColumnParameter("AUTH_CONNECT_MNG", idx++, authConnectMng), new RdbmsStringColumnParameter("AUTH_MANAGERTOOL_MNG", idx++, authManagetToolMng), new RdbmsCharStreamColumnParameter("COLLECTION_AUTHORITY", idx++, sCollectionAuth.toCharArray()), new RdbmsStringColumnParameter("DESCRIPTION", idx++, description), new RdbmsDateColumnParameter("UPDATED", idx++, new Timestamp(updated)), new RdbmsStringColumnParameter("USER_ID", idx++, userID)};
        }
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_MEMBER_EXCLUDE_PASSWORD, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, query);
    }

    public int removeMember(Connection conn, String userID) throws SQLException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("USER_ID", 1, userID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_REMOVE_MEMBER, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, query);
    }

    public CollectionAuthoritySet getCollectionAuthority(Connection conn, String userID) throws SQLException, IOException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("USER_ID", 1, userID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET_COLLECTION_AUTH, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnValue[] cAuth_column_value = supporter.fetchItem(conn, query);
        byte[] collectionAuthBytes = null;
        if (!USE_CLOB) {
            collectionAuthBytes = ((RdbmsBinaryStreamColumnValue)cAuth_column_value[0]).getValue();
        } else {
            String sCollectionAuth = cAuth_column_value[0].toString();
            collectionAuthBytes = ByteUtil.hexToByteArray((String)sCollectionAuth);
        }
        CollectionAuthoritySet cAuthSet = new CollectionAuthoritySet();
        ByteArrayInputStream bais = new ByteArrayInputStream(collectionAuthBytes);
        cAuthSet.deserialize(bais);
        return cAuthSet;
    }

    public int updateCollectionAuth(Connection conn, String userID, CollectionAuthoritySet collectionAuth) throws IOException, SQLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        collectionAuth.serialize(baos);
        RdbmsColumnParameter[] parameters = null;
        if (!USE_CLOB) {
            parameters = new RdbmsColumnParameter[]{new RdbmsBinaryStreamColumnParameter("COLLECTION_AUTHORITY", 1, baos.toByteArray()), new RdbmsStringColumnParameter("USER_ID", 2, userID)};
        } else {
            byte[] b = baos.toByteArray();
            String sCollectionAuth = ByteUtil.byteArrayToHex((byte[])b);
            parameters = new RdbmsColumnParameter[]{new RdbmsCharStreamColumnParameter("COLLECTION_AUTHORITY", 1, sCollectionAuth.toCharArray()), new RdbmsStringColumnParameter("USER_ID", 2, userID)};
        }
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_COLLECTION_AUTH, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, query);
    }

    public int setMemberConnected(Connection conn, String userID) throws SQLException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("IS_CONNECTED", 1, 'A'), new RdbmsStringColumnParameter("USER_ID", 2, userID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SET_MEMBER_CONNECTED, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, query);
    }

    public boolean acceptConnect(Connection conn, String user_id) throws SQLException, IOException {
        Member member = this.getMember(conn, user_id);
        char connected = member.getConnected();
        return 'B' == connected;
    }

    public Client pushTrustedClient(Connection conn, String ip, String description, String userID, long created) throws SQLException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("IP", 1, ip), new RdbmsStringColumnParameter("DESCRIPTION", 2, description), new RdbmsDateColumnParameter("CREATED", 3, created), new RdbmsStringColumnParameter("CREATOR", 4, userID), new RdbmsDateColumnParameter("LAST_UPDATED", 5, created), new RdbmsStringColumnParameter("LAST_UPDATOR", 6, userID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_PUSH_TRUSTED_CLIENT, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        supporter.executeUpdate(conn, query);
        return this.getTrustedClient(conn, ip);
    }

    public List getAllTrustedClient(Connection conn) throws SQLException {
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET_ALL_CLIENT, null);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return ClientFactory.create(supporter.fetchItems(conn, query));
    }

    public Client getTrustedClient(Connection conn, String ip) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("IP", 1, ip)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET_CLIENT, parameters);
        RdbmsColumnValue[] client_column_values = supporter.fetchItem(conn, query);
        return ClientFactory.create(client_column_values);
    }

    public Client updateTrustedClient(Connection conn, String ip, String description, String updator, long updated) throws SQLException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("DESCRIPTION", 1, description), new RdbmsDateColumnParameter("LAST_UPDATED", 2, new Timestamp(updated)), new RdbmsStringColumnParameter("LAST_UPDATOR", 3, updator), new RdbmsStringColumnParameter("IP", 4, ip)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_TRUSTED_CLIENT, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        supporter.executeUpdate(conn, query);
        return this.getTrustedClient(conn, ip);
    }

    public int removeTrustedClient(Connection conn, String ip) throws SQLException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("IP", 1, ip)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_REMOVE_TRUSTED_CLIENT, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, query);
    }

    public int removeAllClient(Connection conn) throws SQLException {
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_REMOVE_ALL_CLIENT);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, query);
    }
}

