/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.db.SqlUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.CategoryUpdateSetting;
import com.diquest.ir.common.database.entity.factory.CategoryUpdateSettingFactory;
import com.diquest.ir.common.database.handler.AbstractGeneralDB;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsLongColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class CategoryUpdateSettingDB
extends AbstractGeneralDB {
    private static final RdbmsProperties PROPERTIES = RdbmsPropertiesFactory.load();
    private static final String CATEGORY_UPDATE_SETTING = "CATEGORY_UPDATE_SETTING";
    private static final String TABLE = String.valueOf(PROPERTIES.getPrefix()) + "_" + "CATEGORY_UPDATE_SETTING";
    private static final String NAME = "CATUPDATE_ID";
    private static final String COLLECTION_ID = "COLLECTION_ID";
    private static final String FIELD = "FIELD";
    private static final String START_DATE = "START_DATE";
    private static final String END_DATE = "END_DATE";
    private static final String PERIOD = "PERIOD";
    private static final String ENABLE = "ENABLE";
    private static final String[] ALL = new String[]{"CATUPDATE_ID", "COLLECTION_ID", "FIELD", "START_DATE", "END_DATE", "PERIOD", "ENABLE"};
    private static final String[] ALL_BUT_PRIMARY = new String[]{"START_DATE", "END_DATE", "PERIOD", "ENABLE"};
    private static final String[] PRIMARY = new String[]{"CATUPDATE_ID", "COLLECTION_ID", "FIELD"};
    private static final String SELECT_SQL = SqlUtil.generateSelectSql((String)TABLE, (String[])ALL);
    private static final String SELECT_NAME_SQL = String.valueOf(SqlUtil.generateSelectSql((String)TABLE, (String[])ALL)) + " WHERE " + "CATUPDATE_ID" + "= ? ";
    private static final String SELECT_COLLECTION_SQL = String.valueOf(SqlUtil.generateSelectSql((String)TABLE, (String[])ALL)) + " WHERE " + "COLLECTION_ID" + "= ? ";
    private static final String SELECT_FIELD_SQL = String.valueOf(SqlUtil.generateSelectSql((String)TABLE, (String[])ALL)) + " WHERE " + "COLLECTION_ID" + "= ? AND " + "FIELD" + " = ?";
    private static final String DELETE_SQL = "DELETE FROM " + TABLE + " WHERE " + "CATUPDATE_ID" + "=? ";
    private static final String DELETE_COLLECTION_SQL = "DELETE FROM " + TABLE + " WHERE " + "COLLECTION_ID" + "=? ";
    private static final String DELETE_FIELD_SQL = "DELETE FROM " + TABLE + " WHERE " + "COLLECTION_ID" + "=? AND " + "FIELD" + " = ?";
    private static final String INSERT_SQL = SqlUtil.generateInsertSql((String)TABLE, (String[])ALL);
    private static final String UPDATE_SQL = SqlUtil.generateUpdateSql((String)TABLE, (String[])ALL_BUT_PRIMARY, (String[])PRIMARY);

    public Transmitable getInstance() {
        return new CategoryUpdateSettingDB();
    }

    public boolean isNull() {
        return false;
    }

    public List list(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String sql = String.valueOf(SELECT_SQL) + this.getOrderBy();
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql);
        return CategoryUpdateSettingFactory.create(supporter.fetchItems(conn, rdbmsGeneralQuery));
    }

    public CategoryUpdateSetting selectName(Connection conn, String name) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String sql = SELECT_NAME_SQL;
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)});
        return CategoryUpdateSettingFactory.create(supporter.fetchItem(conn, rdbmsGeneralQuery));
    }

    public CategoryUpdateSetting selectCollection(Connection conn, String collectionID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String sql = SELECT_COLLECTION_SQL;
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(COLLECTION_ID, 1, collectionID)});
        return CategoryUpdateSettingFactory.create(supporter.fetchItem(conn, rdbmsGeneralQuery));
    }

    public CategoryUpdateSetting selectField(Connection conn, String collectionID, String field) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String sql = SELECT_FIELD_SQL;
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(COLLECTION_ID, 1, collectionID), new RdbmsStringColumnParameter(FIELD, 2, field)});
        return CategoryUpdateSettingFactory.create(supporter.fetchItem(conn, rdbmsGeneralQuery));
    }

    public int delete(Connection conn, String name) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(DELETE_SQL, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)});
        return supporter.executeUpdate(conn, rdbmsGeneralQuery);
    }

    public int deleteCollection(Connection conn, String collectionID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(DELETE_COLLECTION_SQL, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(COLLECTION_ID, 1, collectionID)});
        return supporter.executeUpdate(conn, rdbmsGeneralQuery);
    }

    public int deleteField(Connection conn, String collectionID, String field) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(DELETE_FIELD_SQL, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(COLLECTION_ID, 1, collectionID), new RdbmsStringColumnParameter(FIELD, 2, field)});
        return supporter.executeUpdate(conn, rdbmsGeneralQuery);
    }

    public int insert(Connection conn, CategoryUpdateSetting setting) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        int index = 1;
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, index++, setting.getName()), new RdbmsStringColumnParameter(COLLECTION_ID, index++, setting.getCollectionID()), new RdbmsStringColumnParameter(FIELD, index++, setting.getField()), new RdbmsDateColumnParameter(START_DATE, index++, new Timestamp(setting.getStartDate().getTime())), new RdbmsDateColumnParameter(END_DATE, index++, new Timestamp(setting.getEndDate().getTime())), new RdbmsLongColumnParameter(PERIOD, index++, setting.getPeriod()), new RdbmsStringColumnParameter(ENABLE, index++, setting.isEnable() ? "Y" : "N")};
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(INSERT_SQL, parameters);
        return supporter.executeUpdate(conn, rdbmsGeneralQuery);
    }

    public int update(Connection conn, CategoryUpdateSetting setting) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        int index = 1;
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsDateColumnParameter(START_DATE, index++, new Timestamp(setting.getStartDate().getTime())), new RdbmsDateColumnParameter(END_DATE, index++, new Timestamp(setting.getEndDate().getTime())), new RdbmsLongColumnParameter(PERIOD, index++, setting.getPeriod()), new RdbmsStringColumnParameter(ENABLE, index++, setting.isEnable() ? "Y" : "N"), new RdbmsStringColumnParameter(NAME, index++, setting.getName()), new RdbmsStringColumnParameter(COLLECTION_ID, index++, setting.getCollectionID()), new RdbmsStringColumnParameter(FIELD, index++, setting.getField())};
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(UPDATE_SQL, parameters);
        return supporter.executeUpdate(conn, rdbmsGeneralQuery);
    }

    private String getOrderBy() {
        if (!StringUtil.isEmpty((String)this.getOrderColumn())) {
            StringBuilder buf = new StringBuilder(32);
            buf.append(" ORDER BY ");
            buf.append(this.getOrderColumn());
            buf.append(!this.getOrderDirection() ? " DESC " : " ASC ");
            return buf.toString();
        }
        return "";
    }
}

