/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.profile.categoryranking.CollectionCategory;
import com.diquest.ir.common.database.handler.dictionary.DBHandler;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class CollectionCategoryDB
extends DBHandler
implements CollectionObservable {
    static final String TABLE = String.valueOf(PREFIX) + "_COLLECTION_CATEGORY";
    static final String FIELD_TABLE = String.valueOf(PREFIX) + "_COLLECTION_CATEGORYFIELD";
    static final String SQL_INSERT_CATEGORY = " INSERT INTO " + TABLE + " (COLLECTION_ID, FIELD, CATEGORY) VALUES (?, ?, ?)";
    static final String SQL_INSERT_CATEGORY_FIELD = " INSERT INTO " + FIELD_TABLE + " (COLLECTION_ID, FIELD) VALUES (?, ?)";
    static final String SQL_SELECT_COLLECTION_CATEGORIES = "SELECT COLLECTION_ID, FIELD, CATEGORY FROM " + TABLE + " WHERE COLLECTION_ID = ? ";
    static final String SQL_SELECT_FIELD_CATEGORIES = "SELECT COLLECTION_ID, FIELD, CATEGORY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND FIELD = ? ";
    static final String SQL_SELECT_FIELD = "SELECT FIELD FROM " + FIELD_TABLE + " WHERE COLLECTION_ID = ? ORDER BY FIELD ASC";
    static final String SQL_SELECT_COUNT = "SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? ";
    static final String SQL_DELETE_COLLECTION_CATEGORIES = "DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? ";
    static final String SQL_DELETE_FIELD_CATEGORIES = "DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND FIELD = ? ";
    static final String SQL_DELETE_ALL = "DELETE FROM " + TABLE;
    static final String SQL_DELETE_COLLECTION_FIELDS = "DELETE FROM " + FIELD_TABLE + " WHERE COLLECTION_ID = ? ";
    static final String SQL_DELETE_FIELDS_ALL = "DELETE FROM " + FIELD_TABLE;

    public static void put(Connection conn, String collectionID, String field, String category) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("collectionID is null.");
        }
        if (StringUtil.isEmpty((String)field)) {
            throw new SQLException("field is null.");
        }
        if (StringUtil.isEmpty((String)category)) {
            throw new SQLException("category is null.");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("FIELD", 2, field), new RdbmsStringColumnParameter("CATEGORY", 3, category)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_CATEGORY, parameters);
        supporter.executeUpdate(conn, query);
    }

    public static void putField(Connection conn, String collectionID, String field) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("collectionID is null.");
        }
        if (StringUtil.isEmpty((String)field)) {
            throw new SQLException("field is null.");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("FIELD", 2, field)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_CATEGORY_FIELD, parameters);
        supporter.executeUpdate(conn, query);
    }

    public static CollectionCategory[] getListPage(Connection conn, String collectionID, String field, int start, int scale) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("collectionID is null");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "FIELD", "CATEGORY"};
        String[] froms = new String[]{TABLE};
        String[] orders = new String[]{"CATEGORY ASC"};
        RdbmsColumnParameter[] parameter = field == null || field.length() == 0 ? new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)} : new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("FIELD", 2, field)};
        RdbmsPagingQuery query = new RdbmsPagingQuery("CATEGORY", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return CollectionCategory.create(list);
    }

    public static String[] getListField(Connection conn, String collectionID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("collectionID is null");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_FIELD, parameters);
        List list = supporter.fetchItems(conn, query);
        String[] fields = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            RdbmsColumnValue[] rdbms_column_value = (RdbmsColumnValue[])list.get(i);
            fields[i] = rdbms_column_value[0].toString();
            ++i;
        }
        return fields;
    }

    public static CollectionCategory[] getListSearchPage(Connection conn, String collectionID, String field, String keyword, int start, int scale) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("collectionID is null");
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "FIELD", "CATEGORY"};
        String[] froms = new String[]{TABLE};
        String[] orders = new String[]{"CATEGORY ASC"};
        RdbmsColumnParameter[] parameter = field == null || field.length() == 0 ? new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("CATEGORY LIKE", 2, "%" + keyword + "%")} : new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("FIELD", 2, field), new RdbmsStringColumnParameter("CATEGORY LIKE", 3, "%" + keyword + "%")};
        RdbmsPagingQuery query = new RdbmsPagingQuery("CATEGORY", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return CollectionCategory.create(list);
    }

    public static int getCount(Connection conn, String collectionID, String field) throws SQLException {
        RdbmsColumnParameter[] parameters;
        String SQL_QUERY;
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("collectionID is null");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        if (StringUtil.isEmpty((String)field)) {
            SQL_QUERY = SQL_SELECT_COUNT;
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        } else {
            SQL_QUERY = String.valueOf(SQL_SELECT_COUNT) + " AND FIELD = ? ";
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("FIELD", 2, field)};
        }
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_QUERY, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountSearchKeyword(Connection conn, String collectionID, String field, String keyword) throws SQLException {
        RdbmsColumnParameter[] parameters;
        String SQL_QUERY;
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("collectionID is null");
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        if (StringUtil.isEmpty((String)field)) {
            SQL_QUERY = String.valueOf(SQL_SELECT_COUNT) + " AND CATEGORY LIKE ? ";
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("KEYWORD", 2, "%" + keyword + "%")};
        } else {
            SQL_QUERY = String.valueOf(SQL_SELECT_COUNT) + " AND FIELD = ? AND CATEGORY LIKE  ? ";
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("FIELD", 2, field), new RdbmsStringColumnParameter("KEYWORD", 3, "%" + keyword + "%")};
        }
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_QUERY, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static void deleteAll(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL, null);
        supporter.executeUpdate(conn, query);
    }

    public static void deleteAllField(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_FIELDS_ALL);
        supporter.executeUpdate(conn, query);
    }

    public static void deleteCollection(Connection conn, String collectionID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("collectionID is null.");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_COLLECTION_CATEGORIES, parameters);
        supporter.executeUpdate(conn, query);
    }

    public static void deleteCollectionFields(Connection conn, String collectionID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("collectionID is null.");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_COLLECTION_FIELDS, parameters);
        supporter.executeUpdate(conn, query);
    }

    public static void deleteField(Connection conn, String collectionID, String field) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("collectionID is null.");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("FIELD", 2, field)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_FIELD_CATEGORIES, parameters);
        supporter.executeUpdate(conn, query);
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                CollectionCategoryDB.deleteCollection(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }
}

