/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.handler.CollectionCategoryDB;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class CollectionCategoryDBApp {
    public static void main(String[] args) throws SQLException, IOException {
        String collectionID = "wine";
        String documentFile = "H:\\testbed\\sts\\wine\\wine_f.0000.UTF-8";
        String[] fieldNames = new String[]{"VINTAGE", "COUNTRY", "LOCATION", "APPELLATION", "TYPE", "IMPORT", "IS_SALES"};
        HashMap map = CollectionCategoryDBApp.getFields(documentFile, fieldNames);
        Connection conn = ConnectionFactory.getConnection();
        try {
            int i = 0;
            while (i < fieldNames.length) {
                CollectionCategoryDB.putField(conn, collectionID, fieldNames[i]);
                ++i;
            }
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String fieldName = (String)iterator.next();
                HashSet set = (HashSet)map.get(fieldName);
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    String category = (String)iter.next();
                    System.out.println(String.valueOf(fieldName) + "\t" + category);
                    if (StringUtil.isEmpty((String)category)) continue;
                    category = category.toUpperCase();
                    CollectionCategoryDB.put(conn, collectionID, fieldName, category);
                }
            }
        }
        finally {
            conn.close();
        }
    }

    public static HashMap getFields(String file, String[] fieldNames) throws IOException {
        HashSet[] sets = new HashSet[fieldNames.length];
        HashMap<String, Integer> fieldNameIndex = new HashMap<String, Integer>();
        int i = 0;
        while (i < fieldNames.length) {
            fieldNameIndex.put(fieldNames[i], new Integer(i));
            sets[i] = new HashSet();
            ++i;
        }
        String ext = FileUtil.getUpperExtension((File)new File(file));
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ext));
        String line = reader.readLine();
        int ii = 0;
        while (line != null) {
            if (line.startsWith("(")) {
                String field = line.substring(1);
                line = reader.readLine();
                Integer index = (Integer)fieldNameIndex.get(field);
                if (index == null) continue;
                StringBuffer buf = new StringBuffer();
                while (!line.equalsIgnoreCase(")" + field)) {
                    buf.append(line).append('\n');
                    line = reader.readLine();
                }
                String value = buf.toString().trim();
                value = value.toUpperCase();
                sets[index].add(value);
                if (++ii % 1000 == 0) {
                    System.out.println(ii);
                }
            }
            line = reader.readLine();
        }
        reader.close();
        HashMap<String, HashSet> map = new HashMap<String, HashSet>();
        int i2 = 0;
        while (i2 < fieldNames.length) {
            map.put(fieldNames[i2], sets[i2]);
            ++i2;
        }
        return map;
    }
}

