/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.ir.common.database.entity.CollectionMonitor;
import com.diquest.ir.common.database.entity.factory.CollectionMonitorFactory;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ProfileKey;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class CollectionMonitorDB {
    static RdbmsProperties properties = RdbmsPropertiesFactory.load();
    public static final char STATE_ADDCOMPLETE = 'C';
    public static final char STATE_MODIFYING = 'M';
    public static final char STATE_OPERATING = 'O';
    public static final char STATE_OPERMODI = 'H';
    static final String SQL_INSERT = "INSERT INTO " + properties.getPrefix() + "_COLLECTION_MONITOR" + " (\n" + "  COLLECTION_ID,\n" + "  COLLECTION_STATUS,\n" + "  COLLECTION_STATUS_PRE,\n" + "  LAST_MODIFIED_DATE\n" + " )\n" + " VALUES(?,?,?,?)";
    static final String SQL_SELECT_ALL = "  SELECT \n  COLLECTION_ID,\n  COLLECTION_STATUS,\n  COLLECTION_STATUS_PRE,\n  LAST_MODIFIED_DATE\n  FROM " + properties.getPrefix() + "_COLLECTION_MONITOR";
    static final String SQL_SELECT = "  SELECT \n  COLLECTION_ID,\n  COLLECTION_STATUS,\n  COLLECTION_STATUS_PRE,\n  LAST_MODIFIED_DATE\n  FROM " + properties.getPrefix() + "_COLLECTION_MONITOR\n" + "  WHERE " + "  COLLECTION_ID=? ";
    static final String SQL_SELECT_CURRENT_STATUS = "  SELECT \n  COLLECTION_STATUS\n  FROM " + properties.getPrefix() + "_COLLECTION_MONITOR\n" + "  WHERE " + "  COLLECTION_ID=? ";
    static final String SQL_SELECT_PRE_STATUS = "  SELECT \n  COLLECTION_STATUS_PRE\n  FROM " + properties.getPrefix() + "_COLLECTION_MONITOR\n" + "  WHERE " + "  COLLECTION_ID=? ";
    static final String SQL_DELETE = "  DELETE FROM " + properties.getPrefix() + "_COLLECTION_MONITOR\n" + " WHERE COLLECTION_ID=? ";
    static final String SQL_UPDATE = "  UPDATE " + properties.getPrefix() + "_COLLECTION_MONITOR\n" + "  SET\n" + "  COLLECTION_STATUS=?,\n" + "  COLLECTION_STATUS_PRE=?,\n" + "  LAST_MODIFIED_DATE=?\n" + "  WHERE " + "  COLLECTION_ID=? ";
    static final String SQL_UPDATE_MODIFIED_DATE = "  UPDATE " + properties.getPrefix() + "_COLLECTION_MONITOR\n" + "  SET\n" + "  LAST_MODIFIED_DATE=?\n" + "  WHERE " + "  COLLECTION_ID=? ";

    public int insert(Connection conn, String collectionID, char collectionStatus, char collectionStatusPre) throws SQLException {
        CollectionMonitor collectionMonitor = new CollectionMonitor(collectionID, collectionStatus, collectionStatusPre, System.currentTimeMillis());
        return this.insert(conn, collectionMonitor);
    }

    public int insert(Connection conn, String collectionID, char collectionStatus, char collectionStatusPre, long lastModifiedDate) throws SQLException {
        CollectionMonitor collectionMonitor = new CollectionMonitor(collectionID, collectionStatus, collectionStatusPre, lastModifiedDate);
        return this.insert(conn, collectionMonitor);
    }

    public int insert(Connection conn, CollectionMonitor status) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, status.getCollectionID()), new RdbmsStringColumnParameter("COLLECTION_STATUS", 2, String.valueOf(status.getCollectionStatus())), new RdbmsStringColumnParameter("COLLECTION_STATUS_PRE", 3, String.valueOf(status.getCollectionStatusPrevious())), new RdbmsDateColumnParameter("LAST_MODIFIED_DATE", 4, new Timestamp(status.getLastModifiedDate()))};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public List get(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_ALL);
        return CollectionMonitorFactory.create(supporter.fetchItems(conn, query));
    }

    public CollectionMonitor getStatus(Connection conn, String collectionID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT, parameters);
        RdbmsColumnValue[] values = supporter.fetchItem(conn, query);
        return CollectionMonitorFactory.create(values);
    }

    public CollectionMonitor getStatus(String collectionID) throws SQLException {
        Connection conn = ConnectionFactory.getConnection();
        try {
            CollectionMonitor collectionMonitor = this.getStatus(conn, collectionID);
            return collectionMonitor;
        }
        finally {
            conn.close();
        }
    }

    public char getStatusCurrent(Connection conn, String collectionID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_CURRENT_STATUS, parameters);
        RdbmsColumnValue[] values = supporter.fetchItem(conn, query);
        String value = values[0].getString();
        return value.charAt(0);
    }

    public char getStatusCurrent(String collectionID) throws SQLException {
        Connection conn = ConnectionFactory.getConnection();
        try {
            char c = this.getStatusCurrent(conn, collectionID);
            return c;
        }
        finally {
            conn.close();
        }
    }

    public char getStatusPre(Connection conn, String collectionID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_PRE_STATUS, parameters);
        RdbmsColumnValue[] values = supporter.fetchItem(conn, query);
        String value = values[0].getString();
        return value.charAt(0);
    }

    public int delete(Connection conn, String collectionID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE, parameters);
        int updated = supporter.executeUpdate(conn, query);
        return updated;
    }

    public int delete(String collectionID) throws IRException {
        Connection conn = null;
        try {
            int updated;
            conn = ConnectionFactory.getConnection();
            int n = updated = this.delete(conn, collectionID);
            return n;
        }
        catch (SQLException e) {
            throw new IRException(2, "Cannot delete rows for collection.", ProfileKey.getKey(collectionID), (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public int updateModifiedDate(Connection conn, String collectionID, long lastModifiedDate) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsDateColumnParameter("LAST_MODIFIED_DATE", 1, new Timestamp(lastModifiedDate)), new RdbmsStringColumnParameter("COLLECTION_ID", 2, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_MODIFIED_DATE, parameters);
        int updated = supporter.executeUpdate(conn, query);
        return updated;
    }

    public int updateStatus(Connection conn, String collectionID, char statusToUpdate) throws SQLException {
        char statusCurrent = this.getStatusCurrent(conn, collectionID);
        return this.update(conn, collectionID, statusToUpdate, statusCurrent);
    }

    public int update(Connection conn, String collectionID, char collectionStatus, char collectionStatusPre) throws SQLException {
        CollectionMonitor collectionMonitor = new CollectionMonitor(collectionID, collectionStatus, collectionStatusPre, System.currentTimeMillis());
        return this.update(conn, collectionMonitor);
    }

    public int update(Connection conn, String collectionID, char collectionStatus, char collectionStatusPre, long lastModifiedDate) throws SQLException {
        CollectionMonitor collectionMonitor = new CollectionMonitor(collectionID, collectionStatus, collectionStatusPre, lastModifiedDate);
        return this.update(conn, collectionMonitor);
    }

    public int update(Connection conn, CollectionMonitor status) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_STATUS", 1, String.valueOf(status.getCollectionStatus())), new RdbmsStringColumnParameter("COLLECTION_STATUS_PRE", 2, String.valueOf(status.getCollectionStatusPrevious())), new RdbmsDateColumnParameter("LAST_MODIFIED_DATE", 3, new Timestamp(status.getLastModifiedDate())), new RdbmsStringColumnParameter("COLLECTION_ID", 4, status.getCollectionID())};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE, parameters);
        int updated = supporter.executeUpdate(conn, query);
        return updated;
    }

    public int update(CollectionMonitor status) throws IRException {
        Connection conn = null;
        try {
            int updated;
            conn = ConnectionFactory.getConnection();
            int n = updated = this.modify(conn, status);
            return n;
        }
        catch (SQLException e) {
            throw new IRException(2, "Cannot update collection monitor rows for collection", ProfileKey.getKey(status.getCollectionID()), (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public int modify(Connection conn, CollectionMonitor status) throws SQLException {
        int updated = -1;
        CollectionMonitor exist_status = this.getStatus(conn, status.getCollectionID());
        if (exist_status == null) {
            this.insert(conn, status);
        } else {
            updated = this.update(conn, status);
        }
        return updated;
    }

    public int insertSafely(Connection conn, CollectionMonitor status) throws SQLException {
        CollectionMonitor select = this.getStatus(conn, status.getCollectionID());
        if (select == null) {
            return this.insert(conn, status);
        }
        return this.update(conn, status);
    }
}

