/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.ir.common.database.entity.CollectionStatus;
import com.diquest.ir.common.database.entity.factory.CollectionStatusFactory;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ProfileKey;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsLongColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;

public class CollectionStatusDB {
    static RdbmsProperties properties = RdbmsPropertiesFactory.load();
    public static final char INDEX_ALL = 'F';
    public static final char INDEX_ADD = 'I';
    public static final char FIELD_UPDATE = 'U';
    public static final char DOCUMENT_ADD = 'A';
    public static final char DOCUMENT_DEL = 'D';
    public static final char TYPE_AUTO = 'A';
    public static final char TYPE_MANUAL = 'M';
    public static final char STATE_COMPLETE = 'C';
    public static final char STATE_PROCESSING = 'P';
    public static final char STATE_REPOSITORY = 'R';
    public static final char STATE_INDEXING = 'I';
    public static final char STATE_FAIL = 'F';
    static final String SQL_INSERT = "INSERT INTO " + properties.getPrefix() + "_COLLECTION_STATUS" + " (\n" + "  COLLECTION_ID,\n" + "  INDEX_TYPE,\n" + "  AM_TYPE,\n" + "  STATE,\n" + "  INSERT_SIZE,\n" + "  UPDATE_SIZE,\n" + "  DELETE_SIZE,\n" + "  TOTAL_SIZE,\n" + "  TOTAL_DELETE_SIZE,\n" + "  START_TIME,\n" + "  END_TIME,\n" + "  COLLECTION_ELIPSE_TIME,\n" + "  REPOSITORY_ELIPSE_TIME,\n" + "  INDEX_ELIPSE_TIME\n" + " )\n" + " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    static final String SELECT_SQL = "  SELECT \n  COLLECTION_ID,\n  INDEX_TYPE,\n  AM_TYPE,\n  STATE,\n  INSERT_SIZE,\n  UPDATE_SIZE,\n  DELETE_SIZE,\n  TOTAL_SIZE,\n  TOTAL_DELETE_SIZE,\n  START_TIME,\n  END_TIME,\n  COLLECTION_ELIPSE_TIME,\n  REPOSITORY_ELIPSE_TIME,\n  INDEX_ELIPSE_TIME\n  FROM " + properties.getPrefix() + "_COLLECTION_STATUS\n" + "  WHERE " + "  COLLECTION_ID=? " + "  AND " + "  INDEX_TYPE=? ";
    static final String SELECT_MAX_TOTAL_SIZE_SQL = " SELECT TOTAL_SIZE AS TOTAL_SIZE \t  \n FROM " + properties.getPrefix() + "_COLLECTION_STATUS \t\t  \n" + " WHERE COLLECTION_ID = ?    \t\t  \n" + " AND END_TIME = ? \t\t\t\t\t\t";
    static final String SQL_GET_MAX_ENDTIME_BY_COLLECTION = " \t SELECT MAX(END_TIME)\t\t\t  \n \t FROM " + properties.getPrefix() + "_COLLECTION_STATUS \t\t  \n" + " \t WHERE COLLECTION_ID = ?   \t\t  \n" + " \t AND TOTAL_SIZE != -1 \t\t\t\t";
    static final String UPDATE_SQL = "  UPDATE " + properties.getPrefix() + "_COLLECTION_STATUS\n" + "  SET\n" + "  AM_TYPE=?,\n" + "  STATE=?,\n" + "  INSERT_SIZE=?,\n" + "  UPDATE_SIZE=?,\n" + "  DELETE_SIZE=?,\n" + "  TOTAL_SIZE=?,\n" + "  TOTAL_DELETE_SIZE=?,\n" + "  START_TIME=?,\n" + "  END_TIME=?,\n" + "  COLLECTION_ELIPSE_TIME=?,\n" + "  REPOSITORY_ELIPSE_TIME=?,\n" + "  INDEX_ELIPSE_TIME=?\n" + "  WHERE " + "  COLLECTION_ID=? " + "  AND " + "  INDEX_TYPE=? ";
    static final String DELETE_SQL = "  DELETE FROM " + properties.getPrefix() + "_COLLECTION_STATUS\n" + " WHERE COLLECTION_ID=? ";
    public static final String SQL_GET_REMAIN_JOB = "  UPDATE " + properties.getPrefix() + "_COLLECTION_STATUS\n" + "  SET\n" + "  STATE = '" + 'F' + "'\n" + "  WHERE " + "  STATE = '" + 'I' + "' or " + "  STATE = '" + 'R' + "' or " + "  STATE = '" + 'P' + "'";

    public int insert(Connection conn, CollectionStatus status) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, status.getCollection()), new RdbmsStringColumnParameter("INDEX_TYPE", 2, String.valueOf(status.getIndexingType())), new RdbmsStringColumnParameter("AM_TYPE", 3, String.valueOf(status.getExecutionType())), new RdbmsStringColumnParameter("STATE", 4, String.valueOf(status.getStatus())), new RdbmsIntColumnParameter("INSERT_SIZE", 5, status.getInserted()), new RdbmsIntColumnParameter("UPDATE_SIZE", 6, status.getUpdated()), new RdbmsIntColumnParameter("DELETE_SIZE", 7, status.getDeleted()), new RdbmsIntColumnParameter("TOTAL_SIZE", 8, status.getTotalIndexed()), new RdbmsIntColumnParameter("TOTAL_DELETE_SIZE", 9, status.getTotalDeleteSize()), new RdbmsStringColumnParameter("START_TIME", 10, String.valueOf(status.getStarted())), new RdbmsStringColumnParameter("END_TIME", 11, String.valueOf(status.getEnded())), new RdbmsLongColumnParameter("COLLECTION_ELIPSE_TIME", 12, status.getCollectElapsedTime()), new RdbmsLongColumnParameter("REPOSITORY_ELIPSE_TIME", 13, status.getRepositoryElapsedTime()), new RdbmsLongColumnParameter("INDEX_ELIPSE_TIME", 14, status.getIndexElapsedTime())};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public CollectionStatus getStatus(Connection conn, String collectionID, char indexType) throws SQLException {
        RdbmsSupporter rdbmsSupporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("INDEX_TYPE", 2, String.valueOf(indexType))};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SELECT_SQL, parameters);
        RdbmsColumnValue[] tuple = rdbmsSupporter.fetchItem(conn, query);
        return CollectionStatusFactory.create(tuple);
    }

    public int getMaxTotalSize(Connection conn, String collectionID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET_MAX_ENDTIME_BY_COLLECTION, parameters);
        RdbmsColumnValue[] tuple = supporter.fetchItem(conn, query);
        RdbmsColumnValue max_end_time = tuple[0];
        if (!"".equals(tuple[0].toString())) {
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("END_TIME", 2, max_end_time.toString())};
            query = new RdbmsGeneralQuery(SELECT_MAX_TOTAL_SIZE_SQL, parameters);
            tuple = supporter.fetchItem(conn, query);
            return Integer.parseInt(tuple[0].toString());
        }
        return 0;
    }

    public int update(Connection conn, CollectionStatus status) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("AM_TYPE", 1, String.valueOf(status.getExecutionType())), new RdbmsStringColumnParameter("STATE", 2, String.valueOf(status.getStatus())), new RdbmsIntColumnParameter("INSERT_SIZE", 3, status.getInserted()), new RdbmsIntColumnParameter("UPDATE_SIZE", 4, status.getUpdated()), new RdbmsIntColumnParameter("DELETE_SIZE", 5, status.getDeleted()), new RdbmsIntColumnParameter("TOTAL_SIZE", 6, status.getTotalIndexed()), new RdbmsIntColumnParameter("TOTAL_DELETE_SIZE", 7, status.getTotalDeleteSize()), new RdbmsStringColumnParameter("START_TIME", 8, String.valueOf(status.getStarted())), new RdbmsStringColumnParameter("END_TIME", 9, String.valueOf(status.getEnded())), new RdbmsLongColumnParameter("COLLECTION_ELIPSE_TIME", 10, status.getCollectElapsedTime()), new RdbmsLongColumnParameter("REPOSITORY_ELIPSE_TIME", 11, status.getRepositoryElapsedTime()), new RdbmsLongColumnParameter("INDEX_ELIPSE_TIME", 12, status.getIndexElapsedTime()), new RdbmsStringColumnParameter("COLLECTION_ID", 13, status.getCollection()), new RdbmsStringColumnParameter("INDEX_TYPE", 14, String.valueOf(status.getIndexingType()))};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(UPDATE_SQL, parameters);
        int updated = supporter.executeUpdate(conn, query);
        return updated;
    }

    public int delete(Connection conn, String collectionID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(DELETE_SQL, parameters);
        int updated = supporter.executeUpdate(conn, query);
        return updated;
    }

    public int delete(String collectionID) throws IRException {
        Connection conn = null;
        try {
            conn = ConnectionFactory.getConnection();
            conn.setAutoCommit(false);
            int updated = this.delete(conn, collectionID);
            conn.commit();
            int n = updated;
            return n;
        }
        catch (SQLException e) {
            throw new IRException(2, "Cannot delete collection status.", ProfileKey.getKey(collectionID), (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public int update(CollectionStatus status) throws IRException {
        Connection conn = null;
        try {
            conn = ConnectionFactory.getConnection();
            conn.setAutoCommit(false);
            int updated = this.modify(conn, status);
            conn.commit();
            int n = updated;
            return n;
        }
        catch (SQLException e) {
            throw new IRException(2, "Cannot update collectionStatus.", ProfileKey.getKey(status.getCollection()), (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public int modify(Connection conn, CollectionStatus status) throws SQLException {
        int updated = -1;
        CollectionStatus exist_status = this.getStatus(conn, status.getCollection(), status.getIndexingType());
        if (exist_status == null) {
            this.insert(conn, status);
        } else {
            updated = this.update(conn, status);
        }
        return updated;
    }

    public int failAllStatus(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, SQL_GET_REMAIN_JOB);
    }
}

