/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.db.SqlUtil;
import com.diquest.commons.type.ArrayUtil;
import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.ErrorLog;
import com.diquest.ir.common.database.entity.factory.ErrorLogFactory;
import com.diquest.ir.common.database.handler.AbstractLogDB;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ErrorLogDB
extends AbstractLogDB {
    private static final int LIMIT_ERROR_MESSAGE = 4000;
    private static final int LIMIT_SERVICE_STACK = 4000;
    private static final int LIMIT_RAW_STACK = 4000;
    public static final char VERTIFY_OK = '1';
    public static final char VERTIFY_NO = '2';
    public static final char VERTIFY_ING = '3';
    private static final RdbmsProperties PROPERTIES = RdbmsPropertiesFactory.load();
    private static final Object SYNCH_INSERT = new Object();
    private static final String SQL_GET_NEXT_ID = "SELECT MAX(ERROR_ID)+1 as ERROR_ID from " + PROPERTIES.getPrefix() + "_ERROR_LOG";
    private static final String SQL_INSERT = " INSERT INTO " + PROPERTIES.getPrefix() + "_ERROR_LOG " + " ( ERROR_ID ,SERVER_GROUP ,SERVER_ID, SERVER_NAME, SERVER_IP," + " \tREPORTED_TIME , ERROR_LEVEL, ERROR_MESSAGE, SERVICE_STACK, RAW_STACK )" + " VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
    private static final String SQL_GET_ALL_ERROR_LOG_COUNT = "\tSELECT COUNT(*)\t\tFROM " + PROPERTIES.getPrefix() + "_ERROR_LOG";
    private static final String SQL_DELETE_ALL = "DELETE FROM " + PROPERTIES.getPrefix() + "_ERROR_LOG";
    private static final String SQL_DELETE = " DELETE FROM " + PROPERTIES.getPrefix() + "_ERROR_LOG " + " WHERE ERROR_ID = ? ";
    private static final String TABLE_NAME = String.valueOf(PROPERTIES.getPrefix()) + "_ERROR_LOG";
    public static final String ERROR_ID = "ERROR_ID";
    public static final String SERVER_GROUP = "SERVER_GROUP";
    public static final String SERVER_ID = "SERVER_ID";
    public static final String SERVER_NAME = "SERVER_NAME";
    public static final String SERVER_IP = "SERVER_IP";
    public static final String REPORTED_TIME = "REPORTED_TIME";
    public static final String ERROR_LEVEL = "ERROR_LEVEL";
    public static final String ERROR_MESSAGE = "ERROR_MESSAGE";
    public static final String SERVICE_STACK = "SERVICE_STACK";
    public static final String RAW_STACK = "RAW_STACK";
    private static final String[] ALL_COLUMNS = new String[]{"ERROR_ID", "SERVER_GROUP", "SERVER_ID", "SERVER_NAME", "SERVER_IP", "REPORTED_TIME", "ERROR_LEVEL", "ERROR_MESSAGE", "SERVICE_STACK", "RAW_STACK"};
    private static final String[] LIST_COLUMNS = new String[]{"ERROR_ID", "SERVER_NAME", "REPORTED_TIME", "ERROR_MESSAGE"};
    private static final String SELECT_ALL_COLUMNS = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])ALL_COLUMNS);
    private static final String SELECT_LIST_COLUMNS = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])LIST_COLUMNS);
    private static final int DISABLED = -1;
    private int offset = -1;
    private int limit = -1;
    private String orderColumn = "REPORTED_TIME";
    private boolean orderDirection = false;

    public void delete(Connection conn, int errorId) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter(ERROR_ID, 1, errorId)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE, parameters);
        supporter.executeUpdate(conn, query);
    }

    public int delete(Connection conn, int[] errorIds) throws SQLException {
        int count = 0;
        PreparedStatement pstmt = conn.prepareStatement(SQL_DELETE);
        try {
            int i = 0;
            while (i < errorIds.length) {
                pstmt.setInt(1, errorIds[i]);
                count += pstmt.executeUpdate();
                ++i;
            }
            int n = count;
            return n;
        }
        finally {
            ConnectionFactory.release((PreparedStatement)pstmt);
        }
    }

    public int delete(Connection conn, String[] servers, String errorMsg, long from, long to) throws SQLException {
        if (conn == null) {
            throw new NullPointerException();
        }
        if (ArrayUtil.isNullExist((Object[])servers)) {
            throw new NullPointerException();
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        WP wp = this.conditioning(servers, errorMsg, from, to);
        RdbmsColumnParameter[] parameters = this.paramList2Array(wp.getParameterList());
        String sql = String.valueOf(SQL_DELETE_ALL) + wp.getWhere().toString();
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public void deleteAll(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL);
        supporter.executeUpdate(conn, query);
    }

    public void deserialize(InputStream in) throws IOException {
        this.offset = ByteUtil.readInt((InputStream)in);
        this.limit = ByteUtil.readInt((InputStream)in);
        this.orderColumn = ByteUtil.readString((InputStream)in);
        this.orderDirection = ByteUtil.readBoolean((InputStream)in);
    }

    public final void disablePaging() {
        this.setOffset(-1);
        this.setLimit(-1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ErrorLogDB) {
            return this.offset == ((ErrorLogDB)o).offset && this.limit == ((ErrorLogDB)o).limit && StringUtil.equals((String)this.orderColumn, (String)((ErrorLogDB)o).orderColumn) && this.orderDirection == ((ErrorLogDB)o).orderDirection;
        }
        return false;
    }

    public int getAllErrorTrackingCount(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET_ALL_ERROR_LOG_COUNT);
        RdbmsColumnValue[] errorCnt = supporter.fetchItem(conn, query);
        return Integer.parseInt(errorCnt[0].toString());
    }

    public List getAllErrorTrackingList(Connection conn) throws SQLException {
        throw new SQLException("Deprecated method");
    }

    public int getCount(Connection conn, String[] servers, String errorMsg, long from, long to) throws SQLException {
        if (conn == null) {
            throw new NullPointerException();
        }
        if (ArrayUtil.isNullExist((Object[])servers)) {
            throw new NullPointerException();
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        WP wp = this.conditioning(servers, errorMsg, from, to);
        RdbmsColumnParameter[] parameters = this.paramList2Array(wp.getParameterList());
        RdbmsGeneralQuery query = new RdbmsGeneralQuery("SELECT count(*) from " + TABLE_NAME + " " + wp.getWhere().toString(), parameters);
        RdbmsColumnValue[] fetchItem = supporter.fetchItem(conn, query);
        if (fetchItem == null || fetchItem.length == 0 || fetchItem[0] == null) {
            return 0;
        }
        return fetchItem[0].getInt();
    }

    public int getCount(Connection conn, String[] servers, int[] levels, String errorMsg, long from, long to) throws SQLException {
        if (conn == null) {
            throw new NullPointerException();
        }
        if (ArrayUtil.isNullExist((Object[])servers)) {
            throw new NullPointerException();
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        WP wp = this.conditioning(servers, levels, errorMsg, from, to);
        RdbmsColumnParameter[] parameters = this.paramList2Array(wp.getParameterList());
        RdbmsGeneralQuery query = new RdbmsGeneralQuery("SELECT count(*) from " + TABLE_NAME + " " + wp.getWhere().toString(), parameters);
        RdbmsColumnValue[] fetchItem = supporter.fetchItem(conn, query);
        if (fetchItem == null || fetchItem.length == 0 || fetchItem[0] == null) {
            return 0;
        }
        return fetchItem[0].getInt();
    }

    public ErrorLog getErrorLog(Connection conn, int errorId) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter(ERROR_ID, 1, errorId)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SELECT_ALL_COLUMNS) + " where " + ERROR_ID + "=?", parameters);
        RdbmsColumnValue[] item = supporter.fetchItem(conn, query);
        return ErrorLogFactory.create(item);
    }

    public List getErrorLogs(Connection conn, String[] servers, String errorMsg, long from, long to) throws SQLException {
        if (conn == null) {
            throw new NullPointerException();
        }
        if (ArrayUtil.isNullExist((Object[])servers)) {
            throw new NullPointerException();
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        WP wp = this.conditioning(servers, errorMsg, from, to);
        RdbmsColumnParameter[] parameters = this.paramList2Array(wp.getParameterList());
        if (this.isPageable()) {
            RdbmsPagingQuery query = new RdbmsPagingQuery(ERROR_ID, this.getOffset(), this.getLimit(), LIST_COLUMNS, "FROM " + TABLE_NAME, wp.getWhere().toString(), null, this.getOrderBy(), parameters);
            return ErrorLogFactory.create(supporter.fetchCriteria(conn, query));
        }
        String sql = String.valueOf(SELECT_LIST_COLUMNS) + wp.getWhere().toString() + this.getOrderBy();
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, parameters);
        return ErrorLogFactory.create(supporter.fetchItems(conn, query));
    }

    public List getErrorLogs(Connection conn, String[] servers, int[] levels, String errorMsg, long from, long to) throws SQLException {
        if (conn == null) {
            throw new NullPointerException();
        }
        if (ArrayUtil.isNullExist((Object[])servers)) {
            throw new NullPointerException();
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        WP wp = this.conditioning(servers, levels, errorMsg, from, to);
        RdbmsColumnParameter[] parameters = this.paramList2Array(wp.getParameterList());
        if (this.isPageable()) {
            RdbmsPagingQuery query = new RdbmsPagingQuery(ERROR_ID, this.getOffset(), this.getLimit(), LIST_COLUMNS, "FROM " + TABLE_NAME, wp.getWhere().toString(), null, this.getOrderBy(), parameters);
            return ErrorLogFactory.create(supporter.fetchCriteria(conn, query));
        }
        String sql = String.valueOf(SELECT_LIST_COLUMNS) + wp.getWhere().toString() + this.getOrderBy();
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, parameters);
        return ErrorLogFactory.create(supporter.fetchItems(conn, query));
    }

    public ErrorLog getErrorTracking(Connection conn, int error_id) throws SQLException {
        throw new SQLException("Deprecated method");
    }

    public List getErrorTrackingList(Connection conn, int start, int scale, String column_name, String order_type) throws SQLException {
        throw new SQLException("Deprecated method");
    }

    public List getErrorTrackingListByConfirmCode(Connection conn, char confirm_code) throws SQLException {
        throw new SQLException("Deprecated method");
    }

    public Transmitable getInstance() {
        return new ErrorLogDB();
    }

    public final int getLimit() {
        return this.limit;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final String getOrderColumn() {
        return this.orderColumn;
    }

    public final boolean getOrderDirection() {
        return this.orderDirection;
    }

    public String getRegisteredColumnName() {
        return REPORTED_TIME;
    }

    public String getServerColumnName() {
        return SERVER_NAME;
    }

    public String getTableName() {
        return String.valueOf(PROPERTIES.getPrefix()) + "_ERROR_LOG";
    }

    public String getTimeColumnName() {
        return REPORTED_TIME;
    }

    public int hashCode() {
        return this.offset ^ this.limit ^ StringUtil.hashCode((String)this.orderColumn) ^ (this.orderDirection ? 0 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(Connection conn, int serverGroup, int serverID, String serverName, String serverIP, long reportedTime, int level, String errorMessage, String serviceStack, String rawStack) throws SQLException {
        Object object = SYNCH_INSERT;
        synchronized (object) {
            RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
            int next_id = this.getNextID(conn);
            RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter(ERROR_ID, 1, next_id), new RdbmsIntColumnParameter(SERVER_GROUP, 2, serverGroup), new RdbmsIntColumnParameter(SERVER_ID, 3, serverID), new RdbmsStringColumnParameter(SERVER_NAME, 4, serverName), new RdbmsStringColumnParameter(SERVER_IP, 5, serverIP), new RdbmsDateColumnParameter(REPORTED_TIME, 6, new Timestamp(reportedTime)), new RdbmsIntColumnParameter(ERROR_LEVEL, 7, level), new RdbmsStringColumnParameter(ERROR_MESSAGE, 8, StringUtil.limit((String)errorMessage, (int)4000, (String)"...")), new RdbmsStringColumnParameter(SERVICE_STACK, 9, StringUtil.limit((String)serviceStack, (int)4000, (String)"...")), new RdbmsStringColumnParameter(RAW_STACK, 10, StringUtil.limit((String)rawStack, (int)4000, (String)"..."))};
            RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT, parameters);
            return supporter.executeUpdate(conn, query);
        }
    }

    public final boolean isPageable() {
        return this.offset >= 0 && this.limit >= 0;
    }

    public boolean isSupportCollection() {
        return false;
    }

    public boolean isSupportProfile() {
        return false;
    }

    public boolean isSupportServer() {
        return true;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeInt((OutputStream)out, (int)this.offset);
        ByteUtil.writeInt((OutputStream)out, (int)this.limit);
        ByteUtil.writeString((OutputStream)out, (String)this.orderColumn);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.orderDirection);
    }

    public final void setLimit(int limit) {
        this.limit = limit;
    }

    public final void setOffset(int offset) {
        this.offset = offset;
    }

    public final void setOrderColumn(String orderColumn) {
        this.orderColumn = orderColumn;
    }

    public final void setOrderDirection(boolean orderDirection) {
        this.orderDirection = orderDirection;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[offset=");
        b.append(this.offset);
        b.append(", limit=");
        b.append(this.limit);
        b.append(", orderColumn=");
        b.append(this.orderColumn);
        b.append(", orderDirection=");
        b.append(this.orderDirection);
        b.append("]");
        return b.toString();
    }

    public int updateConfirmCode(Connection conn, int error_id, char confirm_code) throws SQLException {
        throw new SQLException("Deprecated method");
    }

    private WP conditioning(String[] servers, String errorMsg, long from, long to) {
        StringBuffer where = new StringBuffer();
        ArrayList<Object> parameterList = new ArrayList<Object>();
        if (servers != null && servers.length > 0) {
            SqlUtil.appendStringEquals((StringBuffer)where, (String)SERVER_NAME, (int)servers.length, (boolean)false);
            int i = 0;
            while (i < servers.length) {
                parameterList.add(new RdbmsStringColumnParameter(SERVER_NAME, parameterList.size() + 1, servers[i]));
                ++i;
            }
        }
        if (errorMsg != null && errorMsg.length() > 0) {
            if (where.length() > 0) {
                where.append(" ").append(SqlUtil.Connectives.toString((boolean)true)).append(" ");
            }
            SqlUtil.appendStringLike((StringBuffer)where, (String)ERROR_MESSAGE);
            parameterList.add(new RdbmsStringColumnParameter(ERROR_MESSAGE, parameterList.size() + 1, "%" + errorMsg + "%"));
        }
        if (from >= 0L && to >= 0L) {
            if (where.length() > 0) {
                where.append(" ").append(SqlUtil.Connectives.toString((boolean)true)).append(" ");
            }
            SqlUtil.appendInclusiveExclusiveBetween((StringBuffer)where, (String)REPORTED_TIME);
            parameterList.add(new RdbmsDateColumnParameter(REPORTED_TIME, parameterList.size() + 1, new Timestamp(from)));
            parameterList.add(new RdbmsDateColumnParameter(REPORTED_TIME, parameterList.size() + 1, new Timestamp(to)));
        }
        if (where.length() > 0) {
            where.insert(0, " where ");
        }
        where.append(' ');
        WP wp = new WP(where, parameterList);
        return wp;
    }

    private WP conditioning(String[] servers, int[] levels, String errorMsg, long from, long to) {
        int i;
        StringBuffer where = new StringBuffer();
        ArrayList<Object> parameterList = new ArrayList<Object>();
        if (servers != null && servers.length > 0) {
            SqlUtil.appendStringEquals((StringBuffer)where, (String)SERVER_NAME, (int)servers.length, (boolean)false);
            i = 0;
            while (i < servers.length) {
                parameterList.add(new RdbmsStringColumnParameter(SERVER_NAME, parameterList.size() + 1, servers[i]));
                ++i;
            }
        }
        if (levels != null && levels.length > 0) {
            if (where.length() > 0) {
                where.append(" ").append(SqlUtil.Connectives.toString((boolean)true)).append(" ");
            }
            SqlUtil.appendStringEquals((StringBuffer)where, (String)ERROR_LEVEL, (int)levels.length, (boolean)false);
            i = 0;
            while (i < levels.length) {
                parameterList.add(new RdbmsIntColumnParameter(ERROR_LEVEL, parameterList.size() + 1, levels[i]));
                ++i;
            }
        }
        if (errorMsg != null && errorMsg.length() > 0) {
            if (where.length() > 0) {
                where.append(" ").append(SqlUtil.Connectives.toString((boolean)true)).append(" ");
            }
            SqlUtil.appendStringLike((StringBuffer)where, (String)ERROR_MESSAGE);
            parameterList.add(new RdbmsStringColumnParameter(ERROR_MESSAGE, parameterList.size() + 1, "%" + errorMsg + "%"));
        }
        if (from >= 0L && to >= 0L) {
            if (where.length() > 0) {
                where.append(" ").append(SqlUtil.Connectives.toString((boolean)true)).append(" ");
            }
            SqlUtil.appendInclusiveExclusiveBetween((StringBuffer)where, (String)REPORTED_TIME);
            parameterList.add(new RdbmsDateColumnParameter(REPORTED_TIME, parameterList.size() + 1, new Timestamp(from)));
            parameterList.add(new RdbmsDateColumnParameter(REPORTED_TIME, parameterList.size() + 1, new Timestamp(to)));
        }
        if (where.length() > 0) {
            where.insert(0, " where ");
        }
        where.append(' ');
        WP wp = new WP(where, parameterList);
        return wp;
    }

    private int getNextID(Connection conn) throws SQLException {
        RdbmsGeneralQuery query;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnValue[] item = supporter.fetchItem(conn, query = new RdbmsGeneralQuery(SQL_GET_NEXT_ID));
        return "".equals(item[0].toString()) ? 0 : Integer.parseInt(item[0].toString());
    }

    private String getOrderBy() {
        if (!StringUtil.isEmpty((String)this.orderColumn)) {
            StringBuilder buf = new StringBuilder(32);
            buf.append(" ORDER BY ");
            buf.append(this.orderColumn);
            buf.append(" ");
            buf.append(!this.orderDirection ? "DESC" : "ASC");
            if (!this.orderColumn.equalsIgnoreCase(ERROR_ID)) {
                buf.append(", ").append(ERROR_ID).append(" DESC ");
            }
            return buf.toString();
        }
        return "";
    }

    class WP {
        StringBuffer where;
        List parameterList;

        public WP(StringBuffer where, List parameterList) {
            this.where = where;
            this.parameterList = parameterList;
        }

        public final List getParameterList() {
            return this.parameterList;
        }

        public final StringBuffer getWhere() {
            return this.where;
        }
    }
}

