/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.db.SqlUtil;
import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.FullQueryLog;
import com.diquest.ir.common.database.entity.factory.FullQueryLogFactory;
import com.diquest.ir.common.database.handler.AbstractQueryLogDB;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsLongColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.List;

public class FullQueryLogDB
extends AbstractQueryLogDB {
    private static final String TABLE_NAME = String.valueOf(PROPERTIES.getPrefix()) + "_QUERY_LOG_FULL";
    public static final String COLLECTION = "COLLECTION_ID";
    public static final String PROFILE = "PROFILE";
    public static final String KEYWORDS = "KEYWORDS";
    public static final String ANALYZED_RESULTS = "ANALYZED_RESULTS";
    public static final String USER_NAME = "USER_NAME";
    public static final String EXTRA_DATA = "EXTRA_DATA";
    public static final String CACHE = "CACHED";
    public static final String TOTAL_RESULT_SIZE = "TOTAL_RESULT_SIZE";
    public static final String ERROR_CODE = "ERROR_CODE";
    public static final String RESPONSE_TIME = "RESPONSE_TIME";
    public static final String REGISTERED = "REGISTERED";
    public static final String NANO_TIME = "NANO_TIME";
    public static final String REGISTERED_NANO_TIME = "REGISTERED_NANO_TIME";
    private static final String PRIMARY_EXPRESSION = "CONVERT(varchar(23), REGISTERED, 126)+CONVERT(varchar(19), NANO_TIME) AS REGISTERED_NANO_TIME";
    private static final String[] ALL_COLUMNS = new String[]{"COLLECTION_ID", "PROFILE", "KEYWORDS", "ANALYZED_RESULTS", "USER_NAME", "EXTRA_DATA", "CACHED", "TOTAL_RESULT_SIZE", "ERROR_CODE", "RESPONSE_TIME", "REGISTERED", "NANO_TIME"};
    private static final String[] ALL_COLUMNS_SQLSERVER = new String[]{"COLLECTION_ID", "PROFILE", "KEYWORDS", "ANALYZED_RESULTS", "USER_NAME", "EXTRA_DATA", "CACHED", "TOTAL_RESULT_SIZE", "ERROR_CODE", "RESPONSE_TIME", "REGISTERED", "NANO_TIME", "CONVERT(varchar(23), REGISTERED, 126)+CONVERT(varchar(19), NANO_TIME) AS REGISTERED_NANO_TIME"};
    private static final String SELECT_ALL_COLUMNS = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])ALL_COLUMNS);
    private static final String INSERT = SqlUtil.generateInsertSql((String)TABLE_NAME, (String[])ALL_COLUMNS);
    private String orderColumn = "REGISTERED";
    private boolean orderDirection = false;

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isSupportServer() {
        return false;
    }

    public final String getOrderColumn() {
        return this.orderColumn;
    }

    public final void setOrderColumn(String orderColumn) {
        if (NANO_TIME.equalsIgnoreCase(orderColumn)) {
            throw new IllegalArgumentException();
        }
        this.orderColumn = orderColumn;
    }

    private String getOrderBy() {
        if (!StringUtil.isEmpty((String)this.orderColumn)) {
            StringBuilder buf = new StringBuilder(32);
            buf.append("ORDER BY ");
            buf.append(this.orderColumn);
            buf.append(" ");
            buf.append(!this.orderDirection ? "DESC" : "ASC");
            if (!this.orderColumn.equalsIgnoreCase(REGISTERED)) {
                buf.append(", ").append(REGISTERED).append(" ASC, ").append(NANO_TIME).append(" ASC");
            } else {
                buf.append(", ");
                buf.append(NANO_TIME);
                buf.append(" ");
                buf.append(!this.orderDirection ? "DESC" : "ASC");
            }
            return buf.toString();
        }
        return "";
    }

    private String getOrderBySQLServer() throws SQLException {
        if (!StringUtil.isEmpty((String)this.orderColumn)) {
            StringBuilder buf = new StringBuilder(32);
            buf.append("ORDER BY ");
            buf.append(this.orderColumn);
            buf.append(" ");
            buf.append(!this.orderDirection ? "ASC" : "DESC");
            return buf.toString();
        }
        return "";
    }

    public final boolean isOrderDirection() {
        return this.orderDirection;
    }

    public final void setOrderDirection(boolean orderDirection) {
        this.orderDirection = orderDirection;
    }

    public int count(Connection conn, String keyword, String[] collections, String[][] profiles, long from, long to) throws SQLException {
        StringBuffer psql = new StringBuffer(this.getCountSql());
        psql.append(" WHERE ");
        ArrayList paramList = new ArrayList();
        this.conditioning(psql, paramList, keyword, collections, profiles, from, to);
        RdbmsColumnParameter[] parameters = this.paramList2Array(paramList);
        return this.getCount(conn, psql.toString(), parameters);
    }

    public int insert(Enumeration logs) throws SQLException {
        return this.insert(logs, false);
    }

    public int insert(Enumeration logs, boolean retry) throws SQLException {
        Connection conn = ConnectionFactory.getConnection();
        try {
            int n = this.insert(conn, logs, retry);
            return n;
        }
        finally {
            conn.close();
        }
    }

    public int[] insert(Connection conn, FullQueryLog[] logs) throws SQLException {
        BitSet failed = new BitSet(logs.length);
        FullQueryLog log = null;
        int count = 0;
        PreparedStatement pstmt = conn.prepareStatement(INSERT);
        try {
            int index = 0;
            while (index < logs.length) {
                log = logs[index];
                int idx = 0;
                pstmt.setString(++idx, log.getCollection());
                pstmt.setString(++idx, log.getProfile());
                pstmt.setString(++idx, PROPERTIES.encode(log.getKeywords()));
                pstmt.setString(++idx, PROPERTIES.encode(log.getAnalyzedResults()));
                pstmt.setString(++idx, PROPERTIES.encode(new String(log.getUserName())));
                pstmt.setString(++idx, PROPERTIES.encode(new String(log.getExtraData())));
                pstmt.setString(++idx, String.valueOf(log.getCache()));
                pstmt.setInt(++idx, log.getTotalResultSize());
                pstmt.setInt(++idx, log.getErrorCode());
                pstmt.setInt(++idx, log.getResponseTime());
                pstmt.setTimestamp(++idx, new Timestamp(log.getRegistered()));
                pstmt.setLong(++idx, log.getNanoTime());
                try {
                    count += pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    failed.set(index);
                }
                ++index;
            }
        }
        finally {
            ConnectionFactory.release((PreparedStatement)pstmt);
        }
        int[] f = new int[failed.cardinality()];
        int i = 0;
        while (i < f.length) {
            f[i] = failed.nextSetBit(i == 0 ? 0 : f[i - 1]);
            ++i;
        }
        return f;
    }

    public int insert(Connection conn, Enumeration logs, boolean lazy) throws SQLException {
        int count;
        SQLException head;
        block14: {
            head = null;
            SQLException last = null;
            FullQueryLog log = null;
            count = 0;
            PreparedStatement pstmt = conn.prepareStatement(INSERT);
            while (true) {
                try {
                    while (logs.hasMoreElements()) {
                        log = (FullQueryLog)logs.nextElement();
                        int idx = 0;
                        pstmt.setString(++idx, log.getCollection());
                        pstmt.setString(++idx, log.getProfile());
                        pstmt.setString(++idx, PROPERTIES.encode(log.getKeywords()));
                        pstmt.setString(++idx, PROPERTIES.encode(log.getAnalyzedResults()));
                        pstmt.setString(++idx, PROPERTIES.encode(log.getUserName()));
                        pstmt.setString(++idx, PROPERTIES.encode(log.getExtraData()));
                        pstmt.setString(++idx, String.valueOf(log.getCache()));
                        pstmt.setInt(++idx, log.getTotalResultSize());
                        pstmt.setInt(++idx, log.getErrorCode());
                        pstmt.setInt(++idx, log.getResponseTime());
                        pstmt.setTimestamp(++idx, new Timestamp(log.getRegistered()));
                        pstmt.setLong(++idx, log.getNanoTime());
                        count += pstmt.executeUpdate();
                    }
                    if (head != null) continue;
                    int n = count;
                    return n;
                }
                catch (SQLException e) {
                    if (lazy) {
                        if (head == null) {
                            last = head = e;
                            while (last.getNextException() != null) {
                                last = last.getNextException();
                            }
                        } else {
                            last.setNextException(e);
                            while (last.getNextException() != null) {
                                last = last.getNextException();
                            }
                        }
                    } else {
                        throw e;
                    }
                    if (lazy) continue;
                    break block14;
                }
                break;
            }
            finally {
                ConnectionFactory.release((PreparedStatement)pstmt);
            }
        }
        if (head != null) {
            throw head;
        }
        return count;
    }

    public int delete(Connection conn, Enumeration logs) throws SQLException {
        FullQueryLog log = null;
        int count = 0;
        StringBuffer psql = this.getDeleteSqlWithWhere();
        SqlUtil.appendStringEquals((StringBuffer)psql, (String)REGISTERED);
        psql.append(" AND ");
        SqlUtil.appendStringEquals((StringBuffer)psql, (String)NANO_TIME);
        PreparedStatement pstmt = conn.prepareStatement(psql.toString());
        try {
            while (logs.hasMoreElements()) {
                log = (FullQueryLog)logs.nextElement();
                int idx = 0;
                pstmt.setTimestamp(++idx, new Timestamp(log.getRegistered()));
                pstmt.setLong(++idx, log.getNanoTime());
                count += pstmt.executeUpdate();
            }
        }
        finally {
            ConnectionFactory.release((PreparedStatement)pstmt);
        }
        return count;
    }

    public List select(Connection conn, String keyword, String[] collections, String[][] profiles, long from, long to) throws SQLException {
        List list = null;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        if (this.isPageable()) {
            ArrayList paramList = new ArrayList();
            StringBuffer where = new StringBuffer();
            this.conditioning(where, paramList, keyword, collections, profiles, from, to);
            if (!paramList.isEmpty()) {
                where.insert(0, "WHERE ");
            }
            RdbmsColumnParameter[] parameters = this.paramList2Array(paramList);
            RdbmsPagingQuery pagingQuery = null;
            if (supporter.isSqlServer()) {
                pagingQuery = new RdbmsPagingQuery(REGISTERED_NANO_TIME, this.getOffset(), this.getLimit(), ALL_COLUMNS_SQLSERVER, "FROM " + TABLE_NAME, where.toString(), null, this.getOrderBySQLServer(), parameters);
                pagingQuery.setPrimaryColumnExpression(PRIMARY_EXPRESSION);
            } else {
                pagingQuery = new RdbmsPagingQuery("", this.getOffset(), this.getLimit(), ALL_COLUMNS, "FROM " + TABLE_NAME, where.toString(), null, this.getOrderBy(), parameters);
            }
            list = supporter.fetchCriteria(conn, pagingQuery);
        } else {
            StringBuffer psql = new StringBuffer(SELECT_ALL_COLUMNS);
            int position = psql.length();
            ArrayList paramList = new ArrayList();
            this.conditioning(psql, paramList, keyword, collections, profiles, from, to);
            if (!paramList.isEmpty()) {
                psql.insert(position, " WHERE ");
            }
            psql.append(this.getOrderBy());
            RdbmsColumnParameter[] parameters = this.paramList2Array(paramList);
            list = supporter.fetchItems(conn, new RdbmsGeneralQuery(psql.toString(), parameters));
        }
        return FullQueryLogFactory.create(list);
    }

    public int delete(Connection conn, String keyword, String[] collections, String[][] profiles, long from, long to) throws SQLException {
        ArrayList paramList = new ArrayList();
        StringBuffer psql = this.getDeleteSqlWithWhere();
        this.conditioning(psql, paramList, keyword, collections, profiles, from, to);
        RdbmsColumnParameter[] parameters = this.paramList2Array(paramList);
        return FullQueryLogDB.executeUpdate(conn, psql.toString(), parameters);
    }

    private void conditioning(StringBuffer psql, List paramList, String keyword, String[] collections, String[][] profiles, long from, long to) {
        boolean collectionWithProfile;
        int parameterIndex = paramList.size() + 1;
        boolean used = parameterIndex > 1;
        boolean bl = collectionWithProfile = collections != null && collections.length > 0 && profiles != null && profiles.length > 0;
        if (collectionWithProfile) {
            used = this.ensureAnd(psql, used);
            psql.append(" ( ");
            this.addCollectionCondition(psql, collections.length);
            int i = 0;
            while (i < collections.length) {
                paramList.add(new RdbmsStringColumnParameter(COLLECTION, parameterIndex++, collections[i]));
                ++i;
            }
            psql.append(" or ");
            this.addCollectionAndProfileCondition(psql, profiles);
            i = 0;
            while (i < profiles.length) {
                if (profiles[i].length == 1) {
                    paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                } else if (profiles[i].length == 2) {
                    paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                    paramList.add(new RdbmsStringColumnParameter(this.getProfileColumnName(), parameterIndex++, profiles[i][1]));
                } else {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            psql.append(" ) ");
        } else {
            int i;
            if (collections != null && collections.length > 0) {
                used = this.ensureAnd(psql, used);
                this.addCollectionCondition(psql, collections.length);
                i = 0;
                while (i < collections.length) {
                    paramList.add(new RdbmsStringColumnParameter(COLLECTION, parameterIndex++, collections[i]));
                    ++i;
                }
            }
            if (profiles != null && profiles.length > 0) {
                used = this.ensureAnd(psql, used);
                this.addCollectionAndProfileCondition(psql, profiles);
                i = 0;
                while (i < profiles.length) {
                    if (profiles[i].length == 1) {
                        paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                    } else if (profiles[i].length == 2) {
                        paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                        paramList.add(new RdbmsStringColumnParameter(this.getProfileColumnName(), parameterIndex++, profiles[i][1]));
                    } else {
                        throw new IllegalArgumentException();
                    }
                    ++i;
                }
            }
        }
        if (keyword != null && keyword.length() > 0) {
            used = this.ensureAnd(psql, used);
            SqlUtil.appendStringLike((StringBuffer)psql, (String)KEYWORDS);
            paramList.add(new RdbmsStringColumnParameter(KEYWORDS, parameterIndex++, "%" + keyword + "%"));
        }
        if (from >= 0L && to >= 0L) {
            used = this.ensureAnd(psql, used);
            this.addBoundCondition(psql);
            paramList.add(new RdbmsDateColumnParameter(REGISTERED, parameterIndex++, from));
            paramList.add(new RdbmsDateColumnParameter(REGISTERED, parameterIndex++, to));
        }
    }

    public FullQueryLog select(Connection conn, long registered, long nanoTime) throws SQLException {
        StringBuffer psql = new StringBuffer(SELECT_ALL_COLUMNS);
        psql.append(" WHERE ");
        SqlUtil.appendStringEquals((StringBuffer)psql, (String)REGISTERED);
        psql.append(" AND ");
        SqlUtil.appendStringEquals((StringBuffer)psql, (String)NANO_TIME);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsDateColumnParameter(REGISTERED, 1, registered), new RdbmsLongColumnParameter(NANO_TIME, 2, nanoTime)};
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(psql.toString(), parameters);
        RdbmsColumnValue[] columns = supporter.fetchItem(conn, query);
        return FullQueryLogFactory.create(columns);
    }

    public int delete(Connection conn, long registered, long nanoTime) throws SQLException {
        StringBuffer psql = this.getDeleteSqlWithWhere();
        SqlUtil.appendStringEquals((StringBuffer)psql, (String)REGISTERED);
        psql.append(" AND ");
        SqlUtil.appendStringEquals((StringBuffer)psql, (String)NANO_TIME);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsDateColumnParameter(REGISTERED, 1, registered), new RdbmsLongColumnParameter(NANO_TIME, 2, nanoTime)};
        return FullQueryLogDB.executeUpdate(conn, psql.toString(), parameters);
    }

    public Transmitable getInstance() {
        return new FullQueryLogDB();
    }

    public Inserter getInserter() {
        return new Inserter();
    }

    public void onRemove(final String collection) throws IRException {
        Thread t = new Thread("FullQueryLogDB+onRemove+" + collection){

            public void run() {
                Connection conn = null;
                try {
                    try {
                        conn = ConnectionFactory.getConnection();
                        FullQueryLogDB.this.deleteCollection(conn, collection);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        ConnectionFactory.release((Connection)conn);
                    }
                }
                finally {
                    ConnectionFactory.release((Connection)conn);
                }
            }
        };
        t.start();
    }

    public void deserialize(InputStream in) throws IOException {
        super.deserialize(in);
        this.orderColumn = ByteUtil.readString((InputStream)in);
        this.orderDirection = ByteUtil.readBoolean((InputStream)in);
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        ByteUtil.writeString((OutputStream)out, (String)this.orderColumn);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.orderDirection);
    }

    public static class Cache {
        public static final char HIT = 'H';
        public static final char MISS = 'M';
        public static final char UNUSED = '-';

        public static final char get(Boolean c) {
            return (char)(c == null ? 45 : (c != false ? 72 : 77));
        }
    }

    public class Inserter {
        PreparedStatement pstmt;

        Inserter() {
        }

        public void open(Connection conn) throws SQLException {
            this.close();
            this.pstmt = conn.prepareStatement(INSERT);
        }

        public synchronized void push(FullQueryLog log) throws SQLException {
            int idx = 0;
            this.pstmt.setString(++idx, log.getCollection());
            this.pstmt.setString(++idx, log.getProfile());
            this.pstmt.setString(++idx, PROPERTIES.encode(log.getKeywords()));
            this.pstmt.setString(++idx, PROPERTIES.encode(log.getAnalyzedResults()));
            this.pstmt.setString(++idx, PROPERTIES.encode(log.getUserName()));
            this.pstmt.setString(++idx, PROPERTIES.encode(log.getExtraData()));
            this.pstmt.setString(++idx, String.valueOf(log.getCache()));
            this.pstmt.setInt(++idx, log.getTotalResultSize());
            this.pstmt.setInt(++idx, log.getErrorCode());
            this.pstmt.setInt(++idx, log.getResponseTime());
            this.pstmt.setTimestamp(++idx, new Timestamp(log.getRegistered()));
            this.pstmt.setLong(++idx, log.getNanoTime());
            this.pstmt.executeUpdate();
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        public void close() {
            ConnectionFactory.release((PreparedStatement)this.pstmt);
            this.pstmt = null;
        }
    }
}

