/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.ir.common.database.entity.HotKeyword;
import com.diquest.ir.common.database.entity.factory.HotKeywordFactory;
import com.diquest.ir.common.database.entity.hotkeyword.HotKeywordFormatter;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class HotKeywordDB {
    static RdbmsProperties properties = RdbmsPropertiesFactory.load();
    static final String INSERT_SQL = "INSERT INTO " + properties.getPrefix() + "_HOT_KEYWORD " + " ( CATEGORY, KEYWORD, RANK, BEFORE_RANK, COUNT, FIX_YN, CREATED, UPDATED ) " + " VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    static final String SINGLE_SELECT_SQL = " SELECT CATEGORY, KEYWORD, RANK, BEFORE_RANK, COUNT, FIX_YN, CREATED, UPDATED  FROM " + properties.getPrefix() + "_HOT_KEYWORD " + " WHERE CATEGORY = ? AND KEYWORD = ? ORDER BY RANK";
    static final String DELETE_SQL = " DELETE FROM " + properties.getPrefix() + "_HOT_KEYWORD " + " WHERE CATEGORY = ? AND KEYWORD = ? ";
    static final String DELETE_ALL_SQL = " DELETE FROM " + properties.getPrefix() + "_HOT_KEYWORD " + " WHERE CATEGORY = ?";
    static final String DELETE_ALL_SQL_BETWEEN_RANK = " DELETE FROM " + properties.getPrefix() + "_HOT_KEYWORD " + " WHERE CATEGORY = ? AND ? <= RANK AND RANK < ?";
    static final String UPDATE_RANK_SQL = " UPDATE " + properties.getPrefix() + "_HOT_KEYWORD " + " SET RANK=? WHERE CATEGORY = ? AND KEYWORD = ? ";

    public static int insert(Connection conn, HotKeyword hotKeyword) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, hotKeyword.getCategory()), new RdbmsStringColumnParameter("KEYWORD", 2, hotKeyword.getKeyword()), new RdbmsStringColumnParameter("RANK", 3, String.valueOf(hotKeyword.getRank())), new RdbmsStringColumnParameter("BEFORE_RANK", 4, String.valueOf(hotKeyword.getBeforeRank())), new RdbmsStringColumnParameter("COUNT", 5, String.valueOf(hotKeyword.getCount())), new RdbmsStringColumnParameter("FIX_YN", 6, String.valueOf(hotKeyword.getFixYN())), new RdbmsStringColumnParameter("CREATED", 7, String.valueOf(hotKeyword.getCreated())), new RdbmsStringColumnParameter("UPDATED", 8, String.valueOf(hotKeyword.getUpdated()))};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(INSERT_SQL, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public static int count(Connection conn, String category) throws SQLException {
        RdbmsColumnParameter[] parameters;
        String countSql;
        RdbmsGeneralQuery query;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        List list = supporter.fetchItems(conn, query = new RdbmsGeneralQuery(countSql = " SELECT COUNT(*) FROM " + properties.getPrefix() + "_HOT_KEYWORD WHERE CATEGORY = ?", parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category)}));
        if (list == null || list.size() == 0) {
            return 0;
        }
        RdbmsColumnValue[] columns = (RdbmsColumnValue[])list.get(0);
        return Integer.parseInt(columns[0].toString().trim());
    }

    public static List select(Connection conn, String category) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String LIST_SELECT_SQL = " SELECT CATEGORY, KEYWORD, RANK, BEFORE_RANK, COUNT, FIX_YN, CREATED, UPDATED  FROM " + properties.getPrefix() + "_HOT_KEYWORD " + " WHERE CATEGORY = ? ORDER BY RANK";
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(LIST_SELECT_SQL, parameters);
        List list = supporter.fetchItems(conn, query);
        return HotKeywordFactory.create(list);
    }

    public static List select(Connection conn, String category, int startRank, int endRank) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String LIST_SELECT_SQL = " SELECT CATEGORY, KEYWORD, RANK, BEFORE_RANK, COUNT, FIX_YN, CREATED, UPDATED  FROM " + properties.getPrefix() + "_HOT_KEYWORD " + " WHERE CATEGORY = ? AND RANK >= ? AND RANK < ? ORDER BY RANK ASC";
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category), new RdbmsIntColumnParameter("RANK", 2, startRank), new RdbmsIntColumnParameter("RANK", 3, endRank)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(LIST_SELECT_SQL, parameters);
        List list = supporter.fetchItems(conn, query);
        return HotKeywordFactory.create(list);
    }

    public static HotKeyword select(Connection conn, String category, String keyword) throws SQLException {
        keyword = HotKeywordFormatter.format(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category), new RdbmsStringColumnParameter("KEYWORD", 2, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SINGLE_SELECT_SQL, parameters);
        RdbmsColumnValue[] item = supporter.fetchItem(conn, query);
        return HotKeywordFactory.create(item);
    }

    public static int delete(Connection conn, String category, String keyword) throws SQLException {
        keyword = HotKeywordFormatter.format(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category), new RdbmsStringColumnParameter("KEYWORD", 2, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(DELETE_SQL, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public static int delete(Connection conn, String category) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(DELETE_ALL_SQL, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public static int delete(Connection conn, String category, int startRank, int endRank) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category), new RdbmsIntColumnParameter("RANK", 2, startRank), new RdbmsIntColumnParameter("RANK", 3, endRank)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(DELETE_ALL_SQL_BETWEEN_RANK, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public static int updateRank(Connection conn, String category, String keyword, int rank) throws SQLException {
        keyword = HotKeywordFormatter.format(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("RANK", 1, String.valueOf(rank)), new RdbmsStringColumnParameter("CATEGORY", 2, category), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(UPDATE_RANK_SQL, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public static List selectAsZeitgeist(Connection conn, String category, int topNRank, boolean trim) throws SQLException {
        final int max = HotKeywordDB.count(conn, category);
        List entries = HotKeywordDB.select(conn, category, 0, topNRank + 1);
        Collections.sort(entries, new Comparator(){

            public int compare(Object o1, Object o2) {
                int change2;
                int change1;
                int diff;
                int before2;
                HotKeyword c1 = (HotKeyword)o1;
                HotKeyword c2 = (HotKeyword)o2;
                int before1 = c1.getBeforeRank();
                if (before1 == -1) {
                    before1 = max + 1;
                }
                if ((before2 = c2.getBeforeRank()) == -1) {
                    before2 = max + 1;
                }
                if ((diff = (change1 = before1 - c1.getRank()) - (change2 = before2 - c2.getRank())) != 0) {
                    return -diff;
                }
                diff = c1.getRank() - c2.getRank();
                return diff;
            }
        });
        if (trim) {
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                HotKeyword entry = (HotKeyword)iter.next();
                if (entry.getBeforeRank() == -1 || entry.getRank() <= entry.getBeforeRank()) continue;
                iter.remove();
            }
        }
        return entries;
    }
}

