/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.ir.common.database.entity.HotKeywordDel;
import com.diquest.ir.common.database.entity.factory.HotKeywordDelFactory;
import com.diquest.ir.common.database.entity.hotkeyword.HotKeywordFormatter;
import com.diquest.ir.util.common.PageNavigator;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class HotKeywordDelDB {
    private String columnName;
    private String orderType;
    static RdbmsProperties properties = RdbmsPropertiesFactory.load();
    static final String SQL_PUSH = "INSERT INTO " + properties.getPrefix() + "_HOT_KEYWORD_DEL " + " ( CATEGORY, KEYWORD, CREATED ) " + " VALUES ( ?, ?, ? ) ";
    static final String SQL_SELECT = " SELECT * FROM " + properties.getPrefix() + "_HOT_KEYWORD_DEL " + " WHERE CATEGORY = ? AND KEYWORD = ? ";
    static final String SQL_GET_TOTAL_COUNT = " SELECT COUNT(*) FROM " + properties.getPrefix() + "_HOT_KEYWORD_DEL " + " WHERE CATEGORY=? AND KEYWORD LIKE ? ";
    static final String SQL_DELETE_ALL = " DELETE FROM " + properties.getPrefix() + "_HOT_KEYWORD_DEL" + " WHERE CATEGORY=?";
    static final String SQL_DELETE = " DELETE FROM " + properties.getPrefix() + "_HOT_KEYWORD_DEL " + " WHERE CATEGORY = ? AND KEYWORD = ? ";

    public HotKeywordDelDB() {
        this.setOrder("KEYWORD", "ASC");
    }

    public void setOrder(String columnName, String orderType) {
        this.columnName = columnName;
        this.orderType = orderType;
    }

    public HotKeywordDel push(Connection conn, String category, String keyword) throws SQLException {
        keyword = HotKeywordFormatter.format(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category), new RdbmsStringColumnParameter("KEYWORD", 2, keyword), new RdbmsStringColumnParameter("CREATED", 3, String.valueOf(System.currentTimeMillis()))};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_PUSH, parameters);
        supporter.executeUpdate(conn, query);
        return this.select(conn, category, keyword);
    }

    public List getPage(Connection conn, String category, String keyword, PageNavigator navigator) throws SQLException {
        return this.getPage(conn, category, keyword, navigator.getStartRowNumber());
    }

    public List getPage(Connection conn, String category, String keyword, int startNum) throws SQLException {
        keyword = HotKeywordFormatter.format(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category), new RdbmsStringColumnParameter("KEYWORD LIKE", 2, "%" + keyword + "%")};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", startNum, 10, new String[]{"CATEGORY", "KEYWORD", "CREATED"}, new String[]{String.valueOf(properties.getPrefix()) + "_HOT_KEYWORD_DEL"}, new String[]{String.valueOf(this.columnName) + " " + this.orderType}, null, parameters);
        List native_rows = supporter.fetchCriteria(conn, query);
        return HotKeywordDelFactory.create(native_rows);
    }

    public List select(Connection conn) throws SQLException {
        String sql = "\tSELECT * FROM " + properties.getPrefix() + "_HOT_KEYWORD_DEL " + " \tORDER BY " + this.columnName + " " + this.orderType;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql);
        List native_rows = supporter.fetchItems(conn, query);
        return HotKeywordDelFactory.create(native_rows);
    }

    public List select(Connection conn, String category) throws SQLException {
        String sql = "\tSELECT * FROM " + properties.getPrefix() + "_HOT_KEYWORD_DEL " + "   WHERE CATEGORY = ? " + " \tORDER BY " + this.columnName + " " + this.orderType;
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category)};
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        return HotKeywordDelFactory.create(native_rows);
    }

    public HotKeywordDel select(Connection conn, String category, String keyword) throws SQLException {
        keyword = HotKeywordFormatter.format(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category), new RdbmsStringColumnParameter("KEYWORD", 2, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT, parameters);
        RdbmsColumnValue[] native_row = supporter.fetchItem(conn, query);
        return HotKeywordDelFactory.create(native_row);
    }

    public int getTotalCount(Connection conn, String category) throws SQLException {
        return this.getTotalCount(conn, category, "");
    }

    public int getTotalCount(Connection conn, String category, String keyword) throws SQLException {
        keyword = HotKeywordFormatter.format(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category), new RdbmsStringColumnParameter("KEYWORD LIKE", 2, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET_TOTAL_COUNT, parameters);
        RdbmsColumnValue[] native_row = supporter.fetchItem(conn, query);
        return Integer.parseInt(native_row[0].toString());
    }

    public void delete(Connection conn, String category) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL, parameters);
        supporter.executeUpdate(conn, query);
    }

    public void delete(Connection conn, String category, String keyword) throws SQLException {
        keyword = HotKeywordFormatter.format(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category), new RdbmsStringColumnParameter("KEYWORD", 2, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE, parameters);
        supporter.executeUpdate(conn, query);
    }
}

