/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.ir.common.database.entity.HotKeywordProps;
import com.diquest.ir.common.database.entity.factory.HotKeywordPropsFactory;
import com.diquest.ir.common.database.handler.HotKeywordDB;
import com.diquest.ir.common.database.handler.HotKeywordDelDB;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class HotKeywordPropsDB {
    public static final char USE_YN_Y = 'Y';
    public static final char USE_YN_N = 'N';
    static RdbmsProperties properties = RdbmsPropertiesFactory.load();
    String orderField = " CREATED ";
    String orderType = " DESC ";
    static final String INSERT_SQL = " INSERT INTO " + properties.getPrefix() + "_HOT_KEYWORD_PROPS" + " ( CATEGORY, COUNT, TERM, START_DATE, PERIOD, USE_YN, CREATED, UPDATED ) " + " VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    static final String UPDATE_SQL = " UPDATE " + properties.getPrefix() + "_HOT_KEYWORD_PROPS " + " SET " + " COUNT = ?, " + " TERM = ?, " + " START_DATE = ?, " + " PERIOD = ?, " + " USE_YN = ?, " + " UPDATED = ? " + " WHERE CATEGORY = ? ";
    static final String updateUseYN = " UPDATE " + properties.getPrefix() + "_HOT_KEYWORD_PROPS" + " SET USE_YN=?, UPDATED=? WHERE CATEGORY = ?";
    static final String DELETE_SQL = " DELETE FROM " + properties.getPrefix() + "_HOT_KEYWORD_PROPS " + " WHERE CATEGORY = ?";

    public int insert(Connection conn, HotKeywordProps hkp) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, hkp.getCategory()), new RdbmsStringColumnParameter("COUNT", 2, String.valueOf(hkp.getCount())), new RdbmsStringColumnParameter("TERM", 3, String.valueOf(hkp.getTerm())), new RdbmsStringColumnParameter("START_DATE", 4, String.valueOf(hkp.getStartDate())), new RdbmsStringColumnParameter("PERIOD", 5, String.valueOf(hkp.getPeriod())), new RdbmsStringColumnParameter("USE_YN", 6, String.valueOf('N')), new RdbmsStringColumnParameter("CREATED", 7, String.valueOf(hkp.getCreated())), new RdbmsStringColumnParameter("UPDATED", 8, String.valueOf(hkp.getUpdated()))};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(INSERT_SQL, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public HotKeywordProps select(Connection conn, String category) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String SELECT_SQL = " SELECT * FROM " + properties.getPrefix() + "_HOT_KEYWORD_PROPS " + " WHERE CATEGORY = ? ORDER BY " + this.orderField + " " + this.orderType;
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SELECT_SQL, parameters);
        RdbmsColumnValue[] item = supporter.fetchItem(conn, query);
        return HotKeywordPropsFactory.create(item);
    }

    public List select(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String SELECT_ALL_SQL = " SELECT * FROM " + properties.getPrefix() + "_HOT_KEYWORD_PROPS ORDER BY " + this.orderField + " " + this.orderType;
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SELECT_ALL_SQL);
        List list = supporter.fetchItems(conn, query);
        return HotKeywordPropsFactory.create(list);
    }

    public int update(Connection conn, HotKeywordProps hkp) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COUNT", 1, String.valueOf(hkp.getCount())), new RdbmsStringColumnParameter("TERM", 2, String.valueOf(hkp.getTerm())), new RdbmsStringColumnParameter("START_DATE", 3, String.valueOf(hkp.getStartDate())), new RdbmsStringColumnParameter("PERIOD", 4, String.valueOf(hkp.getPeriod())), new RdbmsStringColumnParameter("USE_YN", 5, String.valueOf(hkp.getUseYN())), new RdbmsStringColumnParameter("UPDATED", 6, String.valueOf(System.currentTimeMillis())), new RdbmsStringColumnParameter("CATEGORY", 7, hkp.getCategory())};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(UPDATE_SQL, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public int updateUseYN(Connection conn, String category, char useYN) throws SQLException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("USE_YN", 1, String.valueOf(useYN)), new RdbmsStringColumnParameter("UPDATED", 2, String.valueOf(System.currentTimeMillis())), new RdbmsStringColumnParameter("CATEGORY", 3, category)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(updateUseYN, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, query);
    }

    public int delete(Connection conn, String category) throws SQLException {
        HotKeywordDelDB hkd = new HotKeywordDelDB();
        hkd.delete(conn, category);
        HotKeywordDB.delete(conn, category);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("CATEGORY", 1, category)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(DELETE_SQL, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public String getOrderField() {
        return this.orderField;
    }

    public void setOrderField(String orderField) {
        this.orderField = orderField;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }
}

