/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.db.SqlUtil;
import com.diquest.commons.develop.NamingConvention;
import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.IndexLog;
import com.diquest.ir.common.database.entity.factory.IndexLogFactory;
import com.diquest.ir.common.database.handler.AbstractLogDB;
import com.diquest.ir.common.database.report.cache.IndexLogDbConstraint;
import com.diquest.ir.common.database.report.cache.IndexLogDbObservable;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.common.DateUtil;
import com.diquest.ir.util.common.IrProperties;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.ConnectionPool;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsLongColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsOffsetDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;

public class IndexLogDB
extends AbstractLogDB
implements CollectionObservable {
    private static final IndexLogDbObservable OBSERVABLE = IndexLogDbObservable.getInstance();
    private static final char DFLT_STATUS_TYPE = 'N';
    private static final char DFLT_EXECUTION_TYPE = 'N';
    private static final char DFLT_INDEXING_TYPE = 'N';
    private static final char DFLT_DATE_RANGE_TYPE = 'e';
    private static final String TABLE_NAME = String.valueOf(PROPERTIES.getPrefix()) + "_INDEX_LOG";
    public static final String COLLECTION = "COLLECTION_ID";
    public static final String INDEXING_TYPE = "INDEXING_TYPE";
    public static final String EXECUTION_TYPE = "EXECUTION_TYPE";
    public static final String STATUS = "STATUS";
    public static final String INSERT_COLLECTED = "INSERT_COLLECTED";
    public static final String UPDATE_COLLECTED = "UPDATE_COLLECTED";
    public static final String DELETE_COLLECTED = "DELETE_COLLECTED";
    public static final String INSERTED = "INSERTED";
    public static final String UPDATED = "UPDATED";
    public static final String DELETED = "DELETED";
    public static final String SERVICEABLE = "SERVICEABLE";
    public static final String TOTAL_INDEXED = "TOTAL_INDEXED";
    public static final String STARTED = "STARTED";
    public static final String ENDED = "ENDED";
    public static final String COLLECTION_STARTED = "COLLECTION_STARTED";
    public static final String COLLECTION_ENDED = "COLLECTION_ENDED";
    public static final String REPOSITORY_STARTED = "REPOSITORY_STARTED";
    public static final String REPOSITORY_ENDED = "REPOSITORY_ENDED";
    public static final String INDEXING_STARTED = "INDEXING_STARTED";
    public static final String INDEXING_ENDED = "INDEXING_ENDED";
    public static final String NANO_TIME = "NANO_TIME";
    public static final String SUM_INSERTED = "sum(INSERTED)";
    public static final String PRIMARY_KEY = "C_IT_S";
    private static final String PRIMARY_EXPRESSION = "COLLECTION_ID + INDEXING_TYPE +  CONVERT(varchar(23), STARTED, 126)+CONVERT(varchar(19), NANO_TIME) AS C_IT_S";
    public static final String[] NONE_PRIMARY_COLUMNS = new String[]{"EXECUTION_TYPE", "STATUS", "INSERT_COLLECTED", "UPDATE_COLLECTED", "DELETE_COLLECTED", "INSERTED", "UPDATED", "DELETED", "SERVICEABLE", "TOTAL_INDEXED", "ENDED", "COLLECTION_STARTED", "COLLECTION_ENDED", "REPOSITORY_STARTED", "REPOSITORY_ENDED", "INDEXING_STARTED", "INDEXING_ENDED"};
    public static final String[] PRIMARY_COLUMNS = new String[]{"COLLECTION_ID", "INDEXING_TYPE", "STARTED", "NANO_TIME"};
    public static final String[] ALL_COLUMNS = new String[]{"COLLECTION_ID", "INDEXING_TYPE", "EXECUTION_TYPE", "STATUS", "INSERT_COLLECTED", "UPDATE_COLLECTED", "DELETE_COLLECTED", "INSERTED", "UPDATED", "DELETED", "SERVICEABLE", "TOTAL_INDEXED", "STARTED", "ENDED", "COLLECTION_STARTED", "COLLECTION_ENDED", "REPOSITORY_STARTED", "REPOSITORY_ENDED", "INDEXING_STARTED", "INDEXING_ENDED", "NANO_TIME"};
    public static final String[] ALL_COLUMNS_SQLSERVER = new String[]{"COLLECTION_ID", "INDEXING_TYPE", "EXECUTION_TYPE", "STATUS", "INSERT_COLLECTED", "UPDATE_COLLECTED", "DELETE_COLLECTED", "INSERTED", "UPDATED", "DELETED", "SERVICEABLE", "TOTAL_INDEXED", "STARTED", "ENDED", "COLLECTION_STARTED", "COLLECTION_ENDED", "REPOSITORY_STARTED", "REPOSITORY_ENDED", "INDEXING_STARTED", "INDEXING_ENDED", "NANO_TIME", "COLLECTION_ID + INDEXING_TYPE +  CONVERT(varchar(23), STARTED, 126)+CONVERT(varchar(19), NANO_TIME) AS C_IT_S"};
    private static final String SELECT_ALL_COLUMNS = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])ALL_COLUMNS);
    private static final String SELECT_SUM_INSERTED = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])new String[]{"sum(INSERTED)"});
    private static final String SELECT_SINGLE_SQL;
    private static final String INSERT_SQL;
    private static final String UPDATE_SQL;
    private static final String DELETE_BETWEEN_SQL;
    private static final String UPDATE_INCOMPLETED;
    private static final long LOOK_UP_LIMIT = 2592000000L;
    private int offset = -1;
    private int limit = -1;
    private String orderColumn = "STARTED";
    private boolean orderDirection = false;

    static {
        INSERT_SQL = SqlUtil.generateInsertSql((String)TABLE_NAME, (String[])ALL_COLUMNS);
        UPDATE_SQL = SqlUtil.generateUpdateSql((String)TABLE_NAME, (String[])NONE_PRIMARY_COLUMNS, (String[])PRIMARY_COLUMNS);
        StringBuilder sb = new StringBuilder();
        sb.append("update ");
        sb.append(TABLE_NAME);
        sb.append(" set ");
        sb.append(STATUS);
        sb.append("=");
        sb.append("'").append('F').append("'");
        sb.append(" where ");
        sb.append(STATUS);
        sb.append("<>");
        sb.append("'").append('S').append("'");
        sb.append(" and ");
        sb.append(STATUS);
        sb.append("<>");
        sb.append("'").append('F').append("'");
        sb.append(" and ");
        sb.append(STATUS);
        sb.append("<>");
        sb.append("'").append('E').append("'");
        sb.append(" and ");
        sb.append(STATUS);
        sb.append("<>");
        sb.append("'").append('D').append("'");
        UPDATE_INCOMPLETED = sb.toString();
        StringBuffer ds = new StringBuffer(" DELETE FROM " + TABLE_NAME + " WHERE ");
        ds.append('(');
        ds.append(STATUS);
        ds.append("=");
        ds.append("'").append('S').append("'");
        ds.append(" or ");
        ds.append(STATUS);
        ds.append("=");
        ds.append("'").append('F').append("'");
        ds.append(" or ");
        ds.append(STATUS);
        ds.append("=");
        ds.append("'").append('E').append("'");
        ds.append(')');
        ds.append(" AND ");
        SqlUtil.appendInclusiveExclusiveBetween((StringBuffer)ds, (String)ENDED);
        DELETE_BETWEEN_SQL = ds.toString();
        StringBuffer sql = new StringBuffer(SELECT_ALL_COLUMNS);
        sql.append(" where ");
        SqlUtil.appendStringEquals((StringBuffer)sql, (String[])PRIMARY_COLUMNS, (boolean)true);
        SELECT_SINGLE_SQL = sql.toString();
    }

    public static void updateSilently(IndexLog log) {
        if (IrProperties.USE_DB) {
            try {
                new IndexLogDB().update(log);
            }
            catch (SQLException e) {
                System.err.println("Update index log to database is failed.");
            }
        }
    }

    public static void validate(IndexLog log) {
        log.validate();
        log.getCollection().length();
    }

    private void conditioning(StringBuffer psql, List paramList, String[] collections, char indexingType, char executionType, char status, long from, long to, char rangeType) {
        boolean used;
        int parameterIndex = paramList.size() + 1;
        boolean bl = used = parameterIndex > 1;
        if (collections != null && collections.length > 0) {
            used = this.ensureAnd(psql, used);
            this.addCollectionCondition(psql, collections.length);
            int i = 0;
            while (i < collections.length) {
                paramList.add(new RdbmsStringColumnParameter(COLLECTION, parameterIndex++, collections[i]));
                ++i;
            }
        }
        if (indexingType != 'N') {
            used = this.ensureAnd(psql, used);
            SqlUtil.appendStringEquals((StringBuffer)psql, (String)String.valueOf(INDEXING_TYPE));
            paramList.add(new RdbmsStringColumnParameter(INDEXING_TYPE, parameterIndex++, String.valueOf(indexingType)));
        }
        if (executionType != 'N') {
            used = this.ensureAnd(psql, used);
            SqlUtil.appendStringEquals((StringBuffer)psql, (String)String.valueOf(EXECUTION_TYPE));
            paramList.add(new RdbmsStringColumnParameter(EXECUTION_TYPE, parameterIndex++, String.valueOf(executionType)));
        }
        if (status != 'N') {
            used = this.ensureAnd(psql, used);
            SqlUtil.appendStringEquals((StringBuffer)psql, (String)String.valueOf(STATUS));
            paramList.add(new RdbmsStringColumnParameter(STATUS, parameterIndex++, String.valueOf(status)));
        }
        if (from >= 0L && to >= 0L) {
            used = this.ensureAnd(psql, used);
            psql.append(" (");
            switch (rangeType) {
                case 'n': 
                case 's': 
                case 'w': {
                    SqlUtil.appendInclusiveExclusiveBetween((StringBuffer)psql, (String)STARTED);
                    paramList.add(new RdbmsOffsetDateColumnParameter(STARTED, parameterIndex++, from));
                    paramList.add(new RdbmsOffsetDateColumnParameter(STARTED, parameterIndex++, to));
                    if ('s' == rangeType) break;
                    psql.append(rangeType == 'n' ? " AND " : " OR ");
                }
                case 'e': {
                    SqlUtil.appendInclusiveExclusiveBetween((StringBuffer)psql, (String)ENDED);
                    paramList.add(new RdbmsDateColumnParameter(ENDED, parameterIndex++, from));
                    paramList.add(new RdbmsDateColumnParameter(ENDED, parameterIndex++, to));
                }
            }
            psql.append(") ");
        }
    }

    public final void disablePaging() {
        this.setOffset(-1);
        this.setLimit(-1);
    }

    public final int getLimit() {
        return this.limit;
    }

    public final int getOffset() {
        return this.offset;
    }

    private String getOrderBy() {
        StringBuilder buf = new StringBuilder(32);
        buf.append(" ORDER BY ");
        if (!StringUtil.isEmpty((String)this.orderColumn)) {
            buf.append(this.orderColumn);
            buf.append(" ");
            buf.append(!this.orderDirection ? "DESC" : "ASC");
        }
        if (!StringUtil.isEmpty((String)this.orderColumn)) {
            buf.append(", ");
        }
        if (this.orderColumn.equalsIgnoreCase(STARTED)) {
            buf.append(ENDED).append(" DESC ");
        } else if (this.orderColumn.equalsIgnoreCase(ENDED)) {
            buf.append(STARTED).append(" DESC ");
        } else {
            buf.append(STARTED).append(" DESC, ").append(ENDED).append(" DESC ");
        }
        return buf.toString();
    }

    private String getLatestOrderBy() {
        StringBuilder buf = new StringBuilder(32);
        buf.append(" ORDER BY ");
        buf.append(STARTED).append(" DESC, ").append(ENDED).append(" DESC ");
        return buf.toString();
    }

    public final String getOrderColumn() {
        return this.orderColumn;
    }

    public final String getTableName() {
        return TABLE_NAME;
    }

    public String getTimeColumnName() {
        return STARTED;
    }

    public final boolean isOrderDirection() {
        return this.orderDirection;
    }

    public final boolean isPageable() {
        return this.offset >= 0 && this.limit >= 0;
    }

    public final boolean isSupportCollection() {
        return true;
    }

    public boolean isSupportProfile() {
        return false;
    }

    public boolean isSupportServer() {
        return false;
    }

    public int insertSafely(Connection conn, IndexLog log) throws SQLException {
        IndexLog select = this.select(conn, log.getCollection(), log.getIndexingType(), log.getStarted().getTime(), log.getNanoTime());
        if (select == null) {
            return this.insert(conn, log);
        }
        return this.update(conn, log);
    }

    public int insert(IndexLog log) throws SQLException {
        Connection conn = ConnectionPool.getInstance().acquire();
        try {
            int n = this.insert(conn, log);
            return n;
        }
        finally {
            ConnectionPool.getInstance().release(conn);
        }
    }

    public int update(IndexLog log) throws SQLException {
        Connection conn = ConnectionPool.getInstance().acquire();
        try {
            int n = this.update(conn, log);
            return n;
        }
        finally {
            ConnectionPool.getInstance().release(conn);
        }
    }

    public int success(IndexLog log) throws SQLException {
        Connection conn = ConnectionFactory.getConnection();
        try {
            int n = this.success(conn, log);
            return n;
        }
        finally {
            conn.close();
        }
    }

    public int fail(IndexLog log) throws SQLException {
        Connection conn = ConnectionFactory.getConnection();
        try {
            int n = this.fail(conn, log);
            return n;
        }
        finally {
            conn.close();
        }
    }

    public int insert(Connection conn, IndexLog log) throws SQLException {
        int n;
        try {
            RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
            int index = 1;
            RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(COLLECTION, index++, log.getCollection()), new RdbmsStringColumnParameter(INDEXING_TYPE, index++, String.valueOf(log.getIndexingType())), new RdbmsStringColumnParameter(EXECUTION_TYPE, index++, String.valueOf(log.getExecutionType())), new RdbmsStringColumnParameter(STATUS, index++, String.valueOf(log.getStatus())), new RdbmsIntColumnParameter(INSERT_COLLECTED, index++, log.getInsertCollected()), new RdbmsIntColumnParameter(UPDATE_COLLECTED, index++, log.getUpdateCollected()), new RdbmsIntColumnParameter(DELETE_COLLECTED, index++, log.getDeleteCollected()), new RdbmsIntColumnParameter(INSERTED, index++, log.getInserted()), new RdbmsIntColumnParameter(UPDATED, index++, log.getUpdated()), new RdbmsIntColumnParameter(DELETED, index++, log.getDeleted()), new RdbmsIntColumnParameter(SERVICEABLE, index++, log.getServiceable()), new RdbmsIntColumnParameter(TOTAL_INDEXED, index++, log.getTotalIndexed()), new RdbmsOffsetDateColumnParameter(STARTED, index++, log.getStarted()), new RdbmsDateColumnParameter(ENDED, index++, log.getEnded()), new RdbmsDateColumnParameter(COLLECTION_STARTED, index++, log.getCollectionStarted()), new RdbmsDateColumnParameter(COLLECTION_ENDED, index++, log.getCollectionEnded()), new RdbmsDateColumnParameter(REPOSITORY_STARTED, index++, log.getRepositoryStarted()), new RdbmsDateColumnParameter(REPOSITORY_ENDED, index++, log.getRepositoryEnded()), new RdbmsDateColumnParameter(INDEXING_STARTED, index++, log.getIndexingStarted()), new RdbmsDateColumnParameter(INDEXING_ENDED, index++, log.getIndexingEnded()), new RdbmsLongColumnParameter(NANO_TIME, index++, log.getNanoTime())};
            RdbmsGeneralQuery query = new RdbmsGeneralQuery(INSERT_SQL, parameters);
            n = supporter.executeUpdate(conn, query);
            OBSERVABLE.setChanged();
        }
        catch (Throwable throwable) {
            OBSERVABLE.setChanged();
            OBSERVABLE.notifyObservers(IndexLogDbConstraint.of(new String[]{log.getCollection()}, log.getStarted().getTime(), Math.max(log.getStarted().getTime(), log.getEnded().getTime())));
            throw throwable;
        }
        OBSERVABLE.notifyObservers(IndexLogDbConstraint.of(new String[]{log.getCollection()}, log.getStarted().getTime(), Math.max(log.getStarted().getTime(), log.getEnded().getTime())));
        return n;
    }

    private int finish(Connection conn, IndexLog log, boolean success) throws SQLException {
        log.setStatus(success ? (char)'S' : 'F');
        log.setEnded(new Date(System.currentTimeMillis()));
        return this.update(conn, log);
    }

    public int success(Connection conn, IndexLog log) throws SQLException {
        return this.finish(conn, log, true);
    }

    public int fail(Connection conn, IndexLog log) throws SQLException {
        return this.finish(conn, log, false);
    }

    public int update(Connection conn, IndexLog log) throws SQLException {
        int updated = -1;
        IndexLog exist = this.select(conn, log.getCollection(), log.getIndexingType(), log.getStarted().getTime(), log.getNanoTime());
        if (exist == null) {
            this.insert(conn, log);
        } else {
            updated = this.update0(conn, log);
        }
        return updated;
    }

    private int update0(Connection conn, IndexLog log) throws SQLException {
        int n;
        try {
            RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
            int index = 1;
            RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(EXECUTION_TYPE, index++, String.valueOf(log.getExecutionType())), new RdbmsStringColumnParameter(STATUS, index++, String.valueOf(log.getStatus())), new RdbmsIntColumnParameter(INSERT_COLLECTED, index++, log.getInsertCollected()), new RdbmsIntColumnParameter(UPDATE_COLLECTED, index++, log.getUpdateCollected()), new RdbmsIntColumnParameter(DELETE_COLLECTED, index++, log.getDeleteCollected()), new RdbmsIntColumnParameter(INSERTED, index++, log.getInserted()), new RdbmsIntColumnParameter(UPDATED, index++, log.getUpdated()), new RdbmsIntColumnParameter(DELETED, index++, log.getDeleted()), new RdbmsIntColumnParameter(SERVICEABLE, index++, log.getServiceable()), new RdbmsIntColumnParameter(TOTAL_INDEXED, index++, log.getTotalIndexed()), new RdbmsDateColumnParameter(ENDED, index++, log.getEnded()), new RdbmsDateColumnParameter(COLLECTION_STARTED, index++, log.getCollectionStarted()), new RdbmsDateColumnParameter(COLLECTION_ENDED, index++, log.getCollectionEnded()), new RdbmsDateColumnParameter(REPOSITORY_STARTED, index++, log.getRepositoryStarted()), new RdbmsDateColumnParameter(REPOSITORY_ENDED, index++, log.getRepositoryEnded()), new RdbmsDateColumnParameter(INDEXING_STARTED, index++, log.getIndexingStarted()), new RdbmsDateColumnParameter(INDEXING_ENDED, index++, log.getIndexingEnded()), new RdbmsStringColumnParameter(COLLECTION, index++, log.getCollection()), new RdbmsStringColumnParameter(INDEXING_TYPE, index++, String.valueOf(log.getIndexingType())), new RdbmsOffsetDateColumnParameter(STARTED, index++, log.getStarted()), new RdbmsLongColumnParameter(NANO_TIME, index++, log.getNanoTime())};
            RdbmsGeneralQuery query = new RdbmsGeneralQuery(UPDATE_SQL, parameters);
            n = supporter.executeUpdate(conn, query);
            OBSERVABLE.setChanged();
        }
        catch (Throwable throwable) {
            OBSERVABLE.setChanged();
            OBSERVABLE.notifyObservers(IndexLogDbConstraint.of(new String[]{log.getCollection()}, log.getStarted().getTime(), Math.max(log.getStarted().getTime(), log.getEnded().getTime())));
            throw throwable;
        }
        OBSERVABLE.notifyObservers(IndexLogDbConstraint.of(new String[]{log.getCollection()}, log.getStarted().getTime(), Math.max(log.getStarted().getTime(), log.getEnded().getTime())));
        return n;
    }

    public int updateIncompleted(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, UPDATE_INCOMPLETED);
    }

    public IndexLog select(Connection conn, String collection, char indexingType, long at, long nanoTime) throws SQLException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(COLLECTION, 1, collection), new RdbmsStringColumnParameter(INDEXING_TYPE, 2, String.valueOf(indexingType)), new RdbmsOffsetDateColumnParameter(STARTED, 3, at), new RdbmsLongColumnParameter(NANO_TIME, 4, nanoTime)};
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SELECT_SINGLE_SQL, parameters);
        RdbmsColumnValue[] columns = supporter.fetchItem(conn, query);
        return IndexLogFactory.create(columns);
    }

    public List select() throws SQLException {
        Connection conn = ConnectionFactory.getConnection();
        try {
            List list = this.select(conn, null);
            return list;
        }
        finally {
            conn.close();
        }
    }

    public List select(Connection conn) throws SQLException {
        return this.select(conn, null);
    }

    public List select(Connection conn, String[] collections) throws SQLException {
        return this.select(conn, collections, 'N', 'N', 'N');
    }

    public List select(Connection conn, String[] collections, char indexingType, char executionType, char status) throws SQLException {
        return this.select(conn, collections, indexingType, executionType, status, -1L, -1L);
    }

    public List select(Connection conn, String[] collections, char indexingType, char executionType, char status, long from, long to) throws SQLException {
        return this.select(conn, collections, indexingType, executionType, status, from, to, 'e');
    }

    public List select(Connection conn, String[] collections, char indexingType, char executionType, char status, long from, long to, char rangeType) throws SQLException {
        List list = null;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        if (this.isPageable()) {
            ArrayList paramList = new ArrayList();
            StringBuffer where = new StringBuffer();
            this.conditioning(where, paramList, collections, indexingType, executionType, status, from, to, rangeType);
            if (paramList.size() > 0) {
                where.insert(0, "where ");
            }
            RdbmsPagingQuery pagingQuery = null;
            if (supporter.isSqlServer()) {
                pagingQuery = new RdbmsPagingQuery(PRIMARY_KEY, this.getOffset(), this.getLimit(), ALL_COLUMNS_SQLSERVER, "from " + TABLE_NAME, where.toString(), null, this.getOrderBy(), this.paramList2Array(paramList));
                pagingQuery.setPrimaryColumnExpression(PRIMARY_EXPRESSION);
            } else {
                pagingQuery = new RdbmsPagingQuery("", this.getOffset(), this.getLimit(), ALL_COLUMNS, "from " + TABLE_NAME, where.toString(), null, this.getOrderBy(), this.paramList2Array(paramList));
            }
            list = supporter.fetchCriteria(conn, pagingQuery);
        } else {
            StringBuffer psql = new StringBuffer(SELECT_ALL_COLUMNS);
            int position = psql.length();
            ArrayList paramList = new ArrayList();
            this.conditioning(psql, paramList, collections, indexingType, executionType, status, from, to, rangeType);
            if (paramList.size() > 0) {
                psql.insert(position, " where ");
            }
            psql.append(this.getOrderBy());
            list = supporter.fetchItems(conn, new RdbmsGeneralQuery(psql.toString(), this.paramList2Array(paramList)));
        }
        return IndexLogFactory.create(list);
    }

    public List selectLatest(Connection conn, String[] collections, char indexingType, char executionType, char status, long before, char rangeType) throws SQLException {
        return this.selectLatest(conn, collections, indexingType, executionType, status, Math.max(0L, before - 2592000000L), before, rangeType);
    }

    public List selectLatest(Connection conn, String[] collections, char indexingType, char executionType, char status, long from, long before, char rangeType) throws SQLException {
        StringBuffer psql = new StringBuffer(SELECT_ALL_COLUMNS);
        int position = psql.length();
        ArrayList paramList = new ArrayList();
        this.conditioning(psql, paramList, collections, indexingType, executionType, status, from, before, rangeType);
        if (paramList.size() > 0) {
            psql.insert(position, " where ");
        }
        psql.append(this.getLatestOrderBy());
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        Enumeration enumeration = supporter.fetchItemsRealTime(conn, new RdbmsGeneralQuery(psql.toString(), this.paramList2Array(paramList)));
        HashSet<String> collected = new HashSet<String>();
        ArrayList<IndexLog> latestLogs = new ArrayList<IndexLog>();
        int skip = 0;
        int size = Integer.MAX_VALUE;
        if (this.isPageable()) {
            skip = this.getOffset() - 1;
            size = this.getLimit();
        }
        while ((collections == null || collected.size() < collections.length) && enumeration.hasMoreElements()) {
            RdbmsColumnValue[] row = (RdbmsColumnValue[])enumeration.nextElement();
            IndexLog log = IndexLogFactory.create(row);
            if (!collected.add(log.getCollection())) continue;
            latestLogs.add(log);
        }
        final boolean od = this.orderDirection;
        final IdentityHashMap map = new IdentityHashMap(latestLogs.size() << 1);
        Collections.sort(latestLogs, new Comparator(){

            public int compare(Object o1, Object o2) {
                IndexLog i2;
                Object c2;
                IndexLog i1 = (IndexLog)((Object)o1);
                Object c1 = map.get((Object)i1);
                if (c1 == null) {
                    c1 = IndexLogDB.get(IndexLogDB.this.orderColumn, (Object)i1);
                    map.put(i1, c1);
                }
                if ((c2 = map.get((Object)(i2 = (IndexLog)((Object)o2)))) == null) {
                    c2 = IndexLogDB.get(IndexLogDB.this.orderColumn, (Object)i2);
                    map.put(i2, c2);
                }
                return (od ? 1 : -1) * ((Comparable)c1).compareTo(c2);
            }
        });
        map.clear();
        int total = latestLogs.size();
        if (skip > total) {
            return new ArrayList(0);
        }
        return new ArrayList(latestLogs.subList(skip, Math.min(skip + size, total)));
    }

    private static Object get(String column, Object obj) {
        try {
            String field = NamingConvention.db2Java((String)column);
            Method method = obj.getClass().getDeclaredMethod(NamingConvention.getGetMethodName((String)field), null);
            Object ret = method.invoke(obj, null);
            return ret;
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public long count(Connection conn, String[] collections, char indexingType, char executionType, char status, long from, long to, char rangeType) throws SQLException {
        RdbmsColumnValue[] list;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        StringBuffer psql = new StringBuffer(SELECT_SUM_INSERTED);
        int position = psql.length();
        ArrayList paramList = new ArrayList();
        this.conditioning(psql, paramList, collections, indexingType, executionType, status, from, to, rangeType);
        if (paramList.size() > 0) {
            psql.insert(position, " where ");
        }
        if ((list = supporter.fetchItem(conn, new RdbmsGeneralQuery(psql.toString(), this.paramList2Array(paramList)))) != null && list[0] != null) {
            return list[0].getLong();
        }
        return 0L;
    }

    public final void setLimit(int limit) {
        this.limit = limit;
    }

    public final void setOffset(int offset) {
        this.offset = offset;
    }

    public final void setOrderColumn(String orderColumn) {
        this.orderColumn = orderColumn;
    }

    public final void setOrderDirection(boolean orderDirection) {
        this.orderDirection = orderDirection;
    }

    public String getRegisteredColumnName() {
        return STARTED;
    }

    public void deserialize(InputStream in) throws IOException {
        this.offset = ByteUtil.readInt((InputStream)in);
        this.limit = ByteUtil.readInt((InputStream)in);
        this.orderColumn = ByteUtil.readString((InputStream)in);
        this.orderDirection = ByteUtil.readBoolean((InputStream)in);
    }

    public Transmitable getInstance() {
        return new IndexLogDB();
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeInt((OutputStream)out, (int)this.offset);
        ByteUtil.writeInt((OutputStream)out, (int)this.limit);
        ByteUtil.writeString((OutputStream)out, (String)this.orderColumn);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.orderDirection);
    }

    public boolean equals(Object o) {
        if (super.equals(o) && o instanceof IndexLogDB) {
            IndexLogDB db = (IndexLogDB)o;
            return this.offset == db.offset && this.limit == db.limit && StringUtil.equals((String)this.orderColumn, (String)db.orderColumn) && this.orderDirection == db.orderDirection;
        }
        return false;
    }

    public int hashCode() {
        return this.offset ^ this.limit ^ (this.orderColumn == null ? 0 : this.orderColumn.hashCode()) ^ (this.orderDirection ? -1 : 0);
    }

    public String toString() {
        return "[offset=" + this.offset + ", limit=" + this.limit + ", orderColumn=" + this.orderColumn + ", orderDirection=" + this.orderDirection + "]";
    }

    public int deleteCompletedBetween(Connection conn, long from, long to) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsDateColumnParameter(ENDED, 1, from), new RdbmsDateColumnParameter(ENDED, 2, to)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(DELETE_BETWEEN_SQL, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public static void main(String[] args) throws SQLException {
        IndexLogDB indexLogDB = new IndexLogDB();
        Connection conn = ConnectionFactory.getConnection();
        try {
            indexLogDB.disablePaging();
            indexLogDB.setOrderColumn(COLLECTION);
            indexLogDB.setOrderDirection(true);
            List selectLatest = indexLogDB.selectLatest(conn, null, '\u0000', '\u0000', '\u0000', System.currentTimeMillis(), 'w');
            Iterator it = selectLatest.iterator();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
        }
        finally {
            conn.close();
        }
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionPool.getInstance().acquire();
                this.insertBasic(collection, conn);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionPool.getInstance().release(conn);
            }
        }
        finally {
            ConnectionPool.getInstance().release(conn);
        }
    }

    private void insertBasic(String collection, Connection conn) throws SQLException {
        IndexLog log = new IndexLog();
        log.setCollection(collection);
        Date current = new Date(System.currentTimeMillis());
        Date base = DateUtil.getDefaultDate();
        log.setDeleteCollected(0);
        log.setDeleted(0);
        log.setInsertCollected(0);
        log.setInserted(0);
        log.setServiceable(0);
        log.setTotalIndexed(0);
        log.setUpdateCollected(0);
        log.setUpdated(0);
        log.setStatus('D');
        log.setExecutionType('A');
        log.setIndexingType('F');
        log.setStarted(current);
        log.setEnded(current);
        log.setCollectionStarted(base);
        log.setCollectionEnded(base);
        log.setIndexingStarted(base);
        log.setIndexingEnded(base);
        log.setRepositoryStarted(base);
        log.setRepositoryEnded(base);
        this.insert(conn, log);
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionPool.getInstance().acquire();
                this.setLimit(1);
                this.setOffset(1);
                List select = this.select(conn, new String[]{collection});
                if (select == null || select.isEmpty()) {
                    this.insertBasic(collection, conn);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionPool.getInstance().release(conn);
            }
        }
        finally {
            ConnectionPool.getInstance().release(conn);
        }
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionPool.getInstance().acquire();
                this.deleteCollection(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionPool.getInstance().release(conn);
            }
        }
        finally {
            ConnectionPool.getInstance().release(conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }

    public int delete(Connection conn, String[] collections, String[][] profiles, String[] servers, long from, long to) throws SQLException {
        try {
            int n = super.delete(conn, collections, profiles, servers, from, to);
            return n;
        }
        finally {
            OBSERVABLE.setChanged();
            OBSERVABLE.notifyObservers(IndexLogDbConstraint.of(collections, from, to));
        }
    }

    public static final class DateRangeType {
        public static final char WIDE = 'w';
        public static final char NARROW = 'n';
        public static final char START = 's';
        public static final char END = 'e';

        public static void validate(char c) {
            switch (c) {
                case 'e': 
                case 'n': 
                case 's': 
                case 'w': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown date range type.");
                }
            }
        }
    }

    public static final class ExecutionType {
        public static final char NOTHING = 'N';
        public static final char AUTO = 'A';
        public static final char MANUAL = 'M';

        public static void validate(char c) {
            switch (c) {
                case 'A': 
                case 'M': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown execution type");
                }
            }
        }
    }

    public static final class IndexingType {
        public static final char NOTHING = 'N';
        public static final char FULL = 'F';
        public static final char CHANGE = 'C';
        public static final char INCREMENTAL = 'I';
        public static final char FIELD_UPDATE = 'U';
        public static final char DOCUMENT_ADD = 'A';
        public static final char DOCUMENT_DEL = 'D';
        public static final char REBUILD = 'R';

        public static void validate(char c) {
            switch (c) {
                case 'A': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'R': 
                case 'U': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown indexing type");
                }
            }
        }
    }

    public static final class Status {
        public static final char NOTHING = 'N';
        public static final char PROCESSING = 'P';
        public static final char COLLECT = 'C';
        public static final char REPOSITORY = 'R';
        public static final char INDEXING = 'I';
        public static final char CANCEL = 'E';
        public static final char SUCCESS = 'S';
        public static final char FAIL = 'F';
        public static final char DEFAULT = 'D';

        public static boolean isSuccess(char c) {
            return c == 'S';
        }

        public static boolean isFinished(char c) {
            return c == 'S' || c == 'F' || c == 'E';
        }

        public static void validate(char c) {
            switch (c) {
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'I': 
                case 'P': 
                case 'R': 
                case 'S': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown status: " + c);
                }
            }
        }
    }
}

