/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.ir.common.database.entity.IndexingJob;
import com.diquest.ir.common.database.entity.factory.IndexingJobFactory;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsLongColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class IndexingJobDB
implements CollectionObservable {
    public static final IndexingJobDB instance = new IndexingJobDB();
    public static final char ENABLE = 'A';
    public static final char DISABLE = 'B';
    public static final char JOB_TYPE_INDEX_ALL = 'A';
    public static final char JOB_TYPE_INDEX_ADD = 'B';
    public static final char JOB_TYPE_INDEX_UPDATE = 'C';
    public static final char JOB_TYPE_INDEX_REBUILD = 'R';
    public static final char START_DATE_TYPE_AFTER = 'A';
    public static final char START_DATE_TYPE_FROM = 'B';
    public static final char START_DATE_TYPE_NONE = 'C';
    public static final char LIMIT_ENABLE = 'A';
    public static final char LIMIT_DISABLE = 'B';
    static final RdbmsProperties properties = RdbmsPropertiesFactory.load();
    public static final String TABLE_NAME = String.valueOf(properties.getPrefix()) + "_INDEX_JOB";
    static final String SQL_DISABLE = " UPDATE " + TABLE_NAME + " SET ENABLE=?, LAST_UPDATED=?, EXECUTOR=? " + " WHERE COLLECTION_ID = ? AND JOB_TYPE = ? ";
    static final String SQL_ENABLE = " UPDATE " + TABLE_NAME + " " + " SET ENABLE=?, INDEX_CYCLE=?, START_DATE=?, LAST_UPDATED=?, EXECUTOR=?, LIMIT_ENABLE=?, LIMIT_START=?, LIMIT_END=? " + " WHERE COLLECTION_ID = ? AND JOB_TYPE = ? ";
    static final String GET_ALL_ENABLED_INDEXING_JOB = " SELECT * FROM " + TABLE_NAME + " WHERE ENABLE = ? ";
    static final String GET_ALL_INDEXING_JOB = " SELECT * FROM " + TABLE_NAME + " ";
    static final String SQL_GET = " SELECT JOB_ID, ENABLE, JOB_TYPE, COLLECTION_ID, INDEX_CYCLE,  START_DATE, CREATED, LAST_UPDATED, EXECUTOR,  LIMIT_ENABLE, LIMIT_START, LIMIT_END  FROM " + TABLE_NAME + " " + " WHERE JOB_ID = ? ";
    static final String SQL_INSERT = " INSERT INTO " + TABLE_NAME + " " + " (JOB_ID, ENABLE, JOB_TYPE, COLLECTION_ID, INDEX_CYCLE, START_DATE, CREATED, LAST_UPDATED, EXECUTOR, LIMIT_ENABLE, LIMIT_START, LIMIT_END)" + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    static final String SQL_GET_NEXT_ID = "SELECT MAX(JOB_ID)+1 as JOB_ID from " + TABLE_NAME;
    static final String SQL_GET_BY_COLLECTION_ID_AND_JOB_TYPE = " SELECT JOB_ID, ENABLE, JOB_TYPE, COLLECTION_ID, INDEX_CYCLE, START_DATE, CREATED, LAST_UPDATED, EXECUTOR, LIMIT_ENABLE, LIMIT_START, LIMIT_END  FROM " + TABLE_NAME + " " + " WHERE COLLECTION_ID = ? AND JOB_TYPE = ? ";

    public static String getTableName() {
        return TABLE_NAME;
    }

    public IndexingJob disable(Connection conn, String collectionID, char job_type, String executor) throws Exception {
        IndexingJob exist_index_job = this.get(conn, collectionID, job_type);
        if (exist_index_job == null) {
            int job_id = this.getNextID(conn);
            IndexingJob insertTarget = new IndexingJob(job_id, 'B', job_type, collectionID, 0L, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), executor, 'B', 0L, 0L);
            this.insert(conn, insertTarget);
        } else {
            RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("ENABLE", 1, 'B'), new RdbmsDateColumnParameter("LAST_UPDATED", 2, new Timestamp(System.currentTimeMillis())), new RdbmsStringColumnParameter("EXECUTOR", 3, executor), new RdbmsStringColumnParameter("COLLECTION_ID", 4, collectionID), new RdbmsStringColumnParameter("JOB_TYPE", 5, job_type)};
            RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DISABLE, parameters);
            RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
            supporter.executeUpdate(conn, query);
        }
        return this.get(conn, collectionID, job_type);
    }

    public IndexingJob enable(Connection conn, String collection_id, char job_type, long index_cycle, char start_date_type, long start_date, String executor, char limit_enable, long limit_start, long limit_end) throws Exception {
        return this.enable(conn, collection_id, job_type, index_cycle, start_date, executor, limit_enable, limit_start, limit_end);
    }

    public IndexingJob enable(Connection conn, String collection_id, char job_type, long index_cycle, long start_date, String executor, char limit_enable, long limit_start, long limit_end) throws Exception {
        IndexingJob pre = this.get(conn, collection_id, job_type);
        long current = System.currentTimeMillis();
        if (pre == null) {
            int job_id = this.getNextID(conn);
            IndexingJob insertTarget = new IndexingJob(job_id, 'A', job_type, collection_id, index_cycle, new Date(start_date), new Date(current), new Date(current), executor, limit_enable, limit_start, limit_end);
            this.insert(conn, insertTarget);
        } else {
            IndexingJob check = new IndexingJob(pre.getJobID(), 'A', job_type, collection_id, index_cycle, new Date(start_date), pre.getCreated(), pre.getLastUpdated(), pre.getExecutor(), limit_enable, limit_start, limit_end);
            if (check.equals(pre)) {
                return pre;
            }
            RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("ENABLE", 1, 'A'), new RdbmsLongColumnParameter("INDEX_CYCLE", 2, index_cycle), new RdbmsDateColumnParameter("START_DATE", 3, start_date), new RdbmsDateColumnParameter("LAST_UPDATED", 4, new Timestamp(current)), new RdbmsStringColumnParameter("EXECUTOR", 5, executor), new RdbmsStringColumnParameter("LIMIT_ENABLE", 6, limit_enable), new RdbmsLongColumnParameter("LIMIT_START", 7, limit_start), new RdbmsLongColumnParameter("LIMIT_END", 8, limit_end), new RdbmsStringColumnParameter("COLLECTION_ID", 9, collection_id), new RdbmsStringColumnParameter("JOB_TYPE", 10, job_type)};
            RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_ENABLE, parameters);
            RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
            supporter.executeUpdate(conn, query);
        }
        return this.get(conn, collection_id, job_type);
    }

    public List getAllIndexingJob(Connection conn, char enable) throws SQLException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("ENABLE", 1, enable)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(GET_ALL_ENABLED_INDEXING_JOB, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.fetchItems(conn, query);
    }

    public List getAllIndexingJob(Connection conn) throws SQLException {
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(GET_ALL_INDEXING_JOB, null);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return IndexingJobFactory.create(supporter.fetchItems(conn, query));
    }

    public IndexingJob get(Connection conn, int job_id) throws Exception {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter("JOB_ID", 1, job_id)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET, parameters);
        RdbmsColumnValue[] item = supporter.fetchItem(conn, query);
        return IndexingJobFactory.create(item);
    }

    public int insert(Connection conn, IndexingJob expected) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        int next_id = this.getNextID(conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter("JOB_ID", 1, next_id), new RdbmsStringColumnParameter("ENABLE", 2, expected.getEnable()), new RdbmsStringColumnParameter("JOB_TYPE", 3, expected.getJobType()), new RdbmsStringColumnParameter("COLLECTION_ID", 4, expected.getCollectionID()), new RdbmsLongColumnParameter("INDEX_CYCLE", 5, expected.getIndexCycle()), new RdbmsDateColumnParameter("START_DATE", 6, expected.getStartDate()), new RdbmsDateColumnParameter("CREATED", 7, expected.getCreated()), new RdbmsDateColumnParameter("LAST_UPDATED", 8, expected.getLastUpdated()), new RdbmsStringColumnParameter("EXECUTOR", 9, expected.getExecutor()), new RdbmsStringColumnParameter("LIMIT_ENABLE", 10, expected.getLimitEnable()), new RdbmsLongColumnParameter("LIMIT_START", 11, expected.getLimitStart()), new RdbmsLongColumnParameter("LIMIT_END", 12, expected.getLimitEnd())};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public int removeCollection(Connection conn, String collection) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collection)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery("DELETE FROM " + TABLE_NAME + " WHERE COLLECTION_ID=?", parameters);
        return supporter.executeUpdate(conn, query);
    }

    private int getNextID(Connection conn) throws SQLException {
        RdbmsGeneralQuery query;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnValue[] item = supporter.fetchItem(conn, query = new RdbmsGeneralQuery(SQL_GET_NEXT_ID, null));
        if (item == null || item.length > 0 && item[0] == null) {
            return 0;
        }
        return "".equals(item[0].toString()) ? 0 : Integer.parseInt(item[0].toString());
    }

    public IndexingJob get(Connection conn, String collection_id, char job_type) throws Exception {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collection_id), new RdbmsStringColumnParameter("JOB_TYPE", 2, job_type)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET_BY_COLLECTION_ID_AND_JOB_TYPE, parameters);
        RdbmsColumnValue[] item = supporter.fetchItem(conn, query);
        return IndexingJobFactory.create(item);
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                this.removeCollection(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }
}

