/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.db.SqlUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.JobLog;
import com.diquest.ir.common.database.entity.factory.JobLogFactory;
import com.diquest.ir.common.database.handler.AbstractLogDB;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsBinaryStreamColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsCharStreamColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsLongColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class JobLogDB
extends AbstractLogDB
implements Serializable {
    private static final long serialVersionUID = -3775311141878906769L;
    public static final char STATUS_NOTHING = 'N';
    public static final char STATUS_WAIT = 'A';
    public static final char STATUS_EXECUTE = 'C';
    public static final char STATUS_COMPLETE = 'D';
    public static final char STATUS_QUEUEING = 'E';
    public static final char RESPONSE_NOTHING = 'N';
    public static final char RESPONSE_INIT = 'I';
    public static final char RESPONSE_OK = 'A';
    public static final char RESPONSE_WARN = 'B';
    public static final char RESPONSE_FATAL = 'C';
    public static final char RESPONSE_ERROR = 'D';
    public static final char RESPONSE_FAIL = 'E';
    public static final char RESPONSE_NEVER_EXECUTED = 'F';
    public static final char ENABLE = 'E';
    public static final char DISABLE = 'D';
    private static final RdbmsProperties properties = RdbmsPropertiesFactory.load();
    static final boolean USE_CLOB;
    private static final String SQL_GET_NEXT_ID;
    private static final String SQL_PUSH;
    private static final String SQL_GET;
    private static final String SQL_SET_RESPONSE;
    private static final String SQL_GET_MIN_LAST_UPDATED;
    private static String SQL_GET_WAITING_JOB_BY_LASTUPDATED;
    private static final String SQL_GET_ALL_JOB_LIST;
    private static final String SQL_MODIFY_STATUS;
    private static final String SQL_SET_ENABLE;
    private static final String SQL_DELETE_JOB;
    private static final String SQL_DELETE_BY_STATUS;
    private static final String SQL_DELETE_ALL;
    private static final String SQL_FAIL_ALL_STATUS;
    private static final String SQL_HIDE;
    private static final String TABLE_NAME;
    public static final String JOB_ID = "JOB_ID";
    public static final String JOB_DESCRIPTION = "JOB_DESCRIPTION";
    public static final String JOB_STATUS = "JOB_STATUS";
    public static final String JOB_ENABLE = "JOB_ENABLE";
    public static final String REQUEST_MESSAGE = "REQUEST_MESSAGE";
    public static final String RESPONSE_CODE = "RESPONSE_CODE";
    public static final String RESPONSE_MESSAGE = "RESPONSE_MESSAGE";
    public static final String CREATED = "CREATED";
    public static final String LAST_UPDATED = "LAST_UPDATED";
    public static final String EXECUTOR = "EXECUTOR";
    private static final String[] ALL_COLUMNS;
    private static final String[] LIST_COLUMNS;
    private static final String SELECT_ALL_COLUMNS;
    private static final String SELECT_LIST_COLUMNS;
    private static final String SQL_DELETE_BETWEEN;
    private static final int DISABLED = -1;
    private int offset = -1;
    private int limit = -1;
    private String orderColumn = "JOB_ID";
    private boolean orderDirection = false;

    static {
        String property = properties.getProperty("ir.db.useclob");
        USE_CLOB = property == null ? false : Boolean.valueOf(property);
        SQL_GET_NEXT_ID = "SELECT MAX(JOB_ID)+1 AS JOB_ID FROM " + properties.getPrefix() + "_JOB_LOG";
        SQL_PUSH = " INSERT INTO " + properties.getPrefix() + "_JOB_LOG ( " + " JOB_ID, JOB_DESCRIPTION, JOB_STATUS, JOB_ENABLE, " + " REQUEST_MESSAGE, RESPONSE_CODE, CREATED, " + " LAST_UPDATED, EXECUTOR ) " + " VALUES ( ?,?,?,?,?,?,?,?,? )";
        SQL_GET = " SELECT * FROM " + properties.getPrefix() + "_JOB_LOG WHERE JOB_ID = ? ";
        SQL_SET_RESPONSE = " UPDATE " + properties.getPrefix() + "_JOB_LOG SET JOB_STATUS=? , RESPONSE_CODE=?, RESPONSE_MESSAGE=?, LAST_UPDATED=? " + " WHERE JOB_ID=? ";
        SQL_GET_MIN_LAST_UPDATED = " SELECT MIN(LAST_UPDATED) AS LAST_UPDATED FROM " + properties.getPrefix() + "_JOB_LOG " + " WHERE " + " JOB_STATUS   = 'A' " + " AND JOB_ENABLE = 'E' ";
        SQL_GET_WAITING_JOB_BY_LASTUPDATED = " SELECT *  FROM " + properties.getPrefix() + "_JOB_LOG " + " WHERE " + " LAST_UPDATED = ? " + " AND JOB_STATUS = ? " + " AND JOB_ENABLE = ? ";
        SQL_GET_ALL_JOB_LIST = "SELECT * FROM " + properties.getPrefix() + "_JOB_LOG WHERE JOB_ENABLE = ? " + "ORDER BY LAST_UPDATED DESC ";
        SQL_MODIFY_STATUS = " UPDATE " + properties.getPrefix() + "_JOB_LOG " + " SET JOB_STATUS = ?, LAST_UPDATED=? " + " WHERE JOB_ID=? ";
        SQL_SET_ENABLE = " UPDATE " + properties.getPrefix() + "_JOB_LOG " + " SET JOB_ENABLE = ?, LAST_UPDATED=? " + " WHERE JOB_ID=? ";
        SQL_DELETE_JOB = " DELETE FROM " + properties.getPrefix() + "_JOB_LOG " + " WHERE JOB_ID=? ";
        SQL_DELETE_BY_STATUS = " DELETE FROM " + properties.getPrefix() + "_JOB_LOG" + " WHERE JOB_STATUS = ?";
        SQL_DELETE_ALL = " DELETE FROM " + properties.getPrefix() + "_JOB_LOG";
        SQL_FAIL_ALL_STATUS = " UPDATE  " + properties.getPrefix() + "_JOB_LOG " + "  SET " + " JOB_STATUS= '" + 'D' + "' " + " ,JOB_ENABLE= '" + 'D' + "' " + " ,RESPONSE_CODE= '" + 'F' + "' " + " ,RESPONSE_MESSAGE = 'Failed, Server restarted.' " + " ,LAST_UPDATED = ? " + " WHERE " + " JOB_STATUS!='" + 'D' + "'";
        SQL_HIDE = " UPDATE " + properties.getPrefix() + "_JOB_LOG " + " SET " + " JOB_ENABLE=?" + " ,LAST_UPDATED=?" + " WHERE " + " JOB_ID=? ";
        TABLE_NAME = String.valueOf(PROPERTIES.getPrefix()) + "_JOB_LOG";
        ALL_COLUMNS = new String[]{JOB_ID, JOB_DESCRIPTION, JOB_STATUS, JOB_ENABLE, REQUEST_MESSAGE, RESPONSE_CODE, RESPONSE_MESSAGE, CREATED, LAST_UPDATED, EXECUTOR};
        LIST_COLUMNS = new String[]{JOB_ID, JOB_DESCRIPTION, JOB_STATUS, JOB_ENABLE, RESPONSE_CODE, CREATED, LAST_UPDATED, EXECUTOR};
        SELECT_ALL_COLUMNS = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])ALL_COLUMNS);
        SELECT_LIST_COLUMNS = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])LIST_COLUMNS);
        SQL_DELETE_BETWEEN = " DELETE FROM " + TABLE_NAME + " WHERE " + JOB_STATUS + "='" + 'D' + "' and " + LAST_UPDATED + " >= ? and " + LAST_UPDATED + " < ? ";
    }

    public boolean assertJobStatus(Connection conn, int job_id, char job_status) throws Exception {
        JobLog job = this.get(conn, job_id);
        char status = job.getJobStatus();
        return status == job_status;
    }

    public int delete(Connection conn, int job_id) throws Exception {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter(JOB_ID, 1, job_id)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_JOB, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public int deleteAll(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL);
        return supporter.executeUpdate(conn, query);
    }

    public int deleteByStatus(Connection conn, char job_status) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(JOB_STATUS, 1, job_status)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_BY_STATUS, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public int failAllStatus(Connection conn, long last_updated) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsLongColumnParameter(LAST_UPDATED, 1, last_updated)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_FAIL_ALL_STATUS, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public JobLog get(Connection conn, int jobID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter(JOB_ID, 1, jobID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET, parameters);
        return JobLogFactory.create(supporter.fetchItem(conn, query));
    }

    public List getAllJobList(Connection conn) throws Exception {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(JOB_ENABLE, 1, 'E')};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET_ALL_JOB_LIST, parameters);
        return supporter.fetchItems(conn, query);
    }

    public JobLog getLatestJob(Connection conn) throws Exception {
        long min_last_updated = this.getMinLastUpdated(conn);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsLongColumnParameter(LAST_UPDATED, 1, min_last_updated), new RdbmsStringColumnParameter(JOB_STATUS, 2, 'A'), new RdbmsStringColumnParameter(JOB_ENABLE, 3, 'E')};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET_WAITING_JOB_BY_LASTUPDATED, parameters);
        return JobLogFactory.create(supporter.fetchItem(conn, query));
    }

    public long getMinLastUpdated(Connection conn) throws Exception {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET_MIN_LAST_UPDATED);
        RdbmsColumnValue[] item = supporter.fetchItem(conn, query);
        return item[0].getLong();
    }

    public int getNextID(Connection conn) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(SQL_GET_NEXT_ID);
            rs = pstmt.executeQuery();
            int max = -1;
            if (rs.next()) {
                max = rs.getInt("job_id");
            }
            int n = max;
            return n;
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
    }

    public List getUsersJobList(Connection conn, String username) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(JOB_STATUS, 1, 'E')};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_GET_ALL_JOB_LIST, parameters);
        return supporter.fetchItems(conn, query);
    }

    public int hide(Connection conn, int jobID, long last_updated) throws Exception {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(JOB_ENABLE, 1, 'D'), new RdbmsLongColumnParameter(LAST_UPDATED, 2, last_updated), new RdbmsIntColumnParameter(JOB_ID, 3, jobID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_HIDE, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public int modifyStatus(Connection conn, int job_id, char status, long last_updated) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(JOB_STATUS, 1, status), new RdbmsLongColumnParameter(LAST_UPDATED, 2, last_updated), new RdbmsIntColumnParameter(JOB_ID, 3, job_id)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_MODIFY_STATUS, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public JobLog push(Connection conn, ExtRequest ext_request, String description, String executor, long created, long last_updated) throws IOException, SQLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ext_request.serialize((OutputStream)baos);
        int job_id = this.getNextID(conn);
        RdbmsColumnParameter[] parameters = null;
        if (!USE_CLOB) {
            parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter(JOB_ID, 1, job_id), new RdbmsStringColumnParameter(JOB_DESCRIPTION, 2, description), new RdbmsStringColumnParameter(JOB_STATUS, 3, 'A'), new RdbmsStringColumnParameter(JOB_ENABLE, 4, 'E'), new RdbmsBinaryStreamColumnParameter(REQUEST_MESSAGE, 5, baos.toByteArray()), new RdbmsStringColumnParameter(RESPONSE_CODE, 6, 'I'), new RdbmsLongColumnParameter(CREATED, 7, created), new RdbmsLongColumnParameter(LAST_UPDATED, 8, last_updated), new RdbmsStringColumnParameter(EXECUTOR, 9, executor)};
        } else {
            byte[] b = baos.toByteArray();
            String sJobLog = ByteUtil.byteArrayToHex((byte[])b);
            parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter(JOB_ID, 1, job_id), new RdbmsStringColumnParameter(JOB_DESCRIPTION, 2, description), new RdbmsStringColumnParameter(JOB_STATUS, 3, 'A'), new RdbmsStringColumnParameter(JOB_ENABLE, 4, 'E'), new RdbmsCharStreamColumnParameter(REQUEST_MESSAGE, 5, sJobLog.toCharArray()), new RdbmsStringColumnParameter(RESPONSE_CODE, 6, 'I'), new RdbmsLongColumnParameter(CREATED, 7, created), new RdbmsLongColumnParameter(LAST_UPDATED, 8, last_updated), new RdbmsStringColumnParameter(EXECUTOR, 9, executor)};
        }
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_PUSH, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        supporter.executeUpdate(conn, query);
        return this.get(conn, job_id);
    }

    public int setEnable(Connection conn, int job_id, char enable, long last_updated) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(JOB_ENABLE, 1, enable), new RdbmsLongColumnParameter(LAST_UPDATED, 2, last_updated), new RdbmsIntColumnParameter(JOB_ID, 3, job_id)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SET_ENABLE, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public int setResponse(Connection conn, int job_id, char status, char response_code, String response_message, long last_updated) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(JOB_STATUS, 1, status), new RdbmsStringColumnParameter(RESPONSE_CODE, 2, response_code), new RdbmsStringColumnParameter(RESPONSE_MESSAGE, 3, response_message), new RdbmsLongColumnParameter(LAST_UPDATED, 4, last_updated), new RdbmsIntColumnParameter(JOB_ID, 5, job_id)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SET_RESPONSE, parameters);
        return supporter.executeUpdate(conn, query);
    }

    public Transmitable getInstance() {
        return new JobLogDB();
    }

    public String getTableName() {
        return String.valueOf(properties.getPrefix()) + "_JOB_LOG";
    }

    public String getTimeColumnName() {
        return LAST_UPDATED;
    }

    public boolean isSupportCollection() {
        return false;
    }

    public boolean isSupportProfile() {
        return false;
    }

    public boolean isSupportServer() {
        return false;
    }

    public final String getOrderColumn() {
        return this.orderColumn;
    }

    public final void setOrderColumn(String orderColumn) {
        this.orderColumn = orderColumn;
    }

    public final void setOrderDirection(boolean orderDirection) {
        this.orderDirection = orderDirection;
    }

    public void deserialize(InputStream in) throws IOException {
        this.offset = ByteUtil.readInt((InputStream)in);
        this.limit = ByteUtil.readInt((InputStream)in);
        this.orderColumn = ByteUtil.readString((InputStream)in);
        this.orderDirection = ByteUtil.readBoolean((InputStream)in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof JobLogDB) {
            return this.offset == ((JobLogDB)o).offset && this.limit == ((JobLogDB)o).limit && StringUtil.equals((String)this.orderColumn, (String)((JobLogDB)o).orderColumn) && this.orderDirection == ((JobLogDB)o).orderDirection;
        }
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeInt((OutputStream)out, (int)this.offset);
        ByteUtil.writeInt((OutputStream)out, (int)this.limit);
        ByteUtil.writeString((OutputStream)out, (String)this.orderColumn);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.orderDirection);
    }

    public int hashCode() {
        return this.offset ^ this.limit ^ StringUtil.hashCode((String)this.orderColumn) ^ (this.orderDirection ? 0 : -1);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[offset=");
        b.append(this.offset);
        b.append(", limit=");
        b.append(this.limit);
        b.append(", orderColumn=");
        b.append(this.orderColumn);
        b.append(", orderDirection=");
        b.append(this.orderDirection);
        b.append("]");
        return b.toString();
    }

    public final void disablePaging() {
        this.setOffset(-1);
        this.setLimit(-1);
    }

    public final int getLimit() {
        return this.limit;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final boolean isPageable() {
        return this.offset >= 0 && this.limit >= 0;
    }

    public final void setLimit(int limit) {
        this.limit = limit;
    }

    public final void setOffset(int offset) {
        this.offset = offset;
    }

    public JobLog getJobLog(Connection conn, int jobId) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter(JOB_ID, 1, jobId)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SELECT_ALL_COLUMNS) + " where " + JOB_ID + "=?", parameters);
        RdbmsColumnValue[] item = supporter.fetchItem(conn, query);
        return JobLogFactory.create(item);
    }

    public List getJobLogs(Connection conn, String executor, char status, char response, long from, long to) throws SQLException {
        if (conn == null) {
            throw new NullPointerException();
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        StringBuffer where = new StringBuffer();
        ArrayList<Object> parameterList = new ArrayList<Object>();
        if (executor != null && executor.length() > 0) {
            SqlUtil.appendStringEquals((StringBuffer)where, (String)EXECUTOR);
            parameterList.add(new RdbmsStringColumnParameter(EXECUTOR, parameterList.size() + 1, executor));
        }
        if (status != 'N') {
            if (where.length() > 0) {
                where.append(" ").append(SqlUtil.Connectives.toString((boolean)true)).append(" ");
            }
            SqlUtil.appendStringEquals((StringBuffer)where, (String)JOB_STATUS);
            parameterList.add(new RdbmsStringColumnParameter(JOB_STATUS, parameterList.size() + 1, status));
        }
        if (response != 'N') {
            if (where.length() > 0) {
                where.append(" ").append(SqlUtil.Connectives.toString((boolean)true)).append(" ");
            }
            SqlUtil.appendStringEquals((StringBuffer)where, (String)RESPONSE_CODE);
            parameterList.add(new RdbmsStringColumnParameter(RESPONSE_CODE, parameterList.size() + 1, response));
        }
        if (from >= 0L && to >= 0L) {
            if (where.length() > 0) {
                where.append(" ").append(SqlUtil.Connectives.toString((boolean)true)).append(" ");
            }
            SqlUtil.appendInclusiveExclusiveBetween((StringBuffer)where, (String)LAST_UPDATED);
            parameterList.add(new RdbmsLongColumnParameter(LAST_UPDATED, parameterList.size() + 1, from));
            parameterList.add(new RdbmsLongColumnParameter(LAST_UPDATED, parameterList.size() + 1, to));
        }
        if (where.length() > 0) {
            where.insert(0, " where ");
        }
        RdbmsColumnParameter[] parameters = this.paramList2Array(parameterList);
        if (this.isPageable()) {
            RdbmsPagingQuery query = new RdbmsPagingQuery(JOB_ID, this.getOffset(), this.getLimit(), LIST_COLUMNS, "FROM " + TABLE_NAME, where.toString(), null, this.getOrderBy(), parameters);
            return JobLogFactory.create(supporter.fetchCriteria(conn, query));
        }
        String sql = String.valueOf(SELECT_LIST_COLUMNS) + where.toString() + this.getOrderBy();
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, parameters);
        return JobLogFactory.create(supporter.fetchItems(conn, query));
    }

    public int getCount(Connection conn, String executor, char status, char response, long from, long to) throws SQLException {
        if (conn == null) {
            throw new NullPointerException();
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        StringBuffer where = new StringBuffer();
        ArrayList<Object> parameterList = new ArrayList<Object>();
        if (executor != null && executor.length() > 0) {
            SqlUtil.appendStringEquals((StringBuffer)where, (String)EXECUTOR);
            parameterList.add(new RdbmsStringColumnParameter(EXECUTOR, parameterList.size() + 1, executor));
        }
        if (status != 'N') {
            if (where.length() > 0) {
                where.append(" ").append(SqlUtil.Connectives.toString((boolean)true)).append(" ");
            }
            SqlUtil.appendStringEquals((StringBuffer)where, (String)JOB_STATUS);
            parameterList.add(new RdbmsStringColumnParameter(JOB_STATUS, parameterList.size() + 1, status));
        }
        if (response != 'N') {
            if (where.length() > 0) {
                where.append(" ").append(SqlUtil.Connectives.toString((boolean)true)).append(" ");
            }
            SqlUtil.appendStringEquals((StringBuffer)where, (String)RESPONSE_CODE);
            parameterList.add(new RdbmsStringColumnParameter(RESPONSE_CODE, parameterList.size() + 1, response));
        }
        if (from >= 0L && to >= 0L) {
            if (where.length() > 0) {
                where.append(" ").append(SqlUtil.Connectives.toString((boolean)true)).append(" ");
            }
            SqlUtil.appendInclusiveExclusiveBetween((StringBuffer)where, (String)LAST_UPDATED);
            parameterList.add(new RdbmsLongColumnParameter(LAST_UPDATED, parameterList.size() + 1, from));
            parameterList.add(new RdbmsLongColumnParameter(LAST_UPDATED, parameterList.size() + 1, to));
        }
        if (where.length() > 0) {
            where.insert(0, " where ");
        }
        RdbmsColumnParameter[] parameters = this.paramList2Array(parameterList);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery("SELECT count(*) from " + TABLE_NAME + " " + where.toString(), parameters);
        RdbmsColumnValue[] fetchItem = supporter.fetchItem(conn, query);
        if (fetchItem == null || fetchItem.length == 0 || fetchItem[0] == null) {
            return 0;
        }
        return fetchItem[0].getInt();
    }

    public int deleteCompletedBetween(Connection conn, long from, long to) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsLongColumnParameter(LAST_UPDATED, 1, from), new RdbmsLongColumnParameter(LAST_UPDATED, 2, to)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_BETWEEN, parameters);
        return supporter.executeUpdate(conn, query);
    }

    private String getOrderBy() {
        if (!StringUtil.isEmpty((String)this.orderColumn)) {
            StringBuilder buf = new StringBuilder(32);
            buf.append(" ORDER BY ");
            buf.append(this.orderColumn);
            buf.append(" ");
            buf.append(!this.orderDirection ? "DESC" : "ASC");
            if (!this.orderColumn.equalsIgnoreCase(JOB_ID)) {
                buf.append(", ").append(JOB_ID).append(" DESC ");
            }
            return buf.toString();
        }
        return "";
    }

    public String getRegisteredColumnName() {
        return LAST_UPDATED;
    }

    public static class Enable {
        public static final char ENABLE = 'E';
        public static final char DISABLE = 'D';
    }

    public static class Response {
        public static final char INIT = 'I';
        public static final char OK = 'A';
        public static final char WARN = 'B';
        public static final char FATAL = 'C';
        public static final char ERROR = 'D';
        public static final char FAIL = 'E';
        public static final char NEVER_EXECUTED = 'F';
    }

    public static class Status {
        public static final char WAIT = 'A';
        public static final char EXECUTE = 'C';
        public static final char COMPLETE = 'D';
        public static final char QUEUEING = 'E';
    }
}

