/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import java.sql.Connection;
import java.sql.SQLException;

public class LogDBQuery {
    public static final int DEFAULT_SCALE = 10;
    static RdbmsProperties properties = RdbmsPropertiesFactory.load();
    private final int DBTYPE_DB2 = 1;
    private final int DBTYPE_MSSQL = 2;
    private final int DBTYPE_MYSQL = 3;
    private final int DBTYPE_POSTGRES = 4;
    private final int DBTYPE_ORACLE = 5;
    private final int DBTYPE_INFORMIX = 6;
    private final int DBTYPE_TIBERO = 7;
    private int dbType;
    protected String timeSliceQuery;
    protected String timeSliceIntervalQuery;
    protected String popularInterval;
    protected String failTermQuery;
    protected String timeSliceIntervalQueryMinute;
    private String dbDriver;
    protected String collection = "";
    private final String MSSQL_GET_TIME_SLICED_QUERY_DATA = "select sum(search_count) as querysum,  timeslice, avg(RESPONSE_AVERAGE_TIME) as average  from \t( select collection_name, search_count, RESPONSE_AVERAGE_TIME, REPLACE(REPLACE(CONVERT(varchar(13), reg_date, 120), '-', ''), ' ', '') as timeslice  from " + properties.getPrefix() + "_LOG_TIMESLICE where REG_DATE between ? and ? " + ") temp " + " where collection_name = ? " + " group by timeslice order by timeslice asc ";
    private final String DB2_GET_TIME_SLICED_QUERY_DATA = " select sum(search_count) as querysum,  timeslice, avg(RESPONSE_AVERAGE_TIME) as average   from (  select collection_name, search_count, RESPONSE_AVERAGE_TIME, CHAR(REPLACE(REPLACE ( to_char(REG_DATE, 'YYYY-MM-DD HH24:MI:SS'), '-', '' ),' ', ''),10) as timeslice  from " + properties.getPrefix() + "_LOG_TIMESLICE " + " where reg_date between ? and ? " + " order by reg_date " + ") temp " + " where collection_name = ? " + " group by timeslice order by timeslice asc ";
    private final String MYSQL_GET_TIME_SLICED_QUERY_DATA = " SELECT sum(search_count) as querysum,  timeslice, avg(RESPONSE_AVERAGE_TIME) as average   FROM (  SELECT collection_name, search_count, RESPONSE_AVERAGE_TIME, DATE_FORMAT(reg_date,'%Y%m%d%H') as timeslice  FROM " + properties.getPrefix() + "_LOG_TIMESLICE WHERE reg_date between ? and ? " + " ) temp " + " where collection_name = ? " + " GROUP BY timeslice ORDER BY timeslice asc ";
    private final String ORACLE_GET_TIME_SLICED_QUERY_DATA = " select sum(search_count) as querysum, timeslice, avg(RESPONSE_AVERAGE_TIME) as average  from (  select collection_name, search_count, RESPONSE_AVERAGE_TIME, to_char(reg_date,'yyyymmddhh24') as timeslice  from " + properties.getPrefix() + "_LOG_TIMESLICE where reg_date between ? and ? " + " ) temp " + " where collection_name = ? " + " group by timeslice " + " order by timeslice asc ";
    private final String POSTGRES_GET_TIME_SLICED_QUERY_DATA = " SELECT sum(search_count) as querysum, timeslice, avg(RESPONSE_AVERAGE_TIME) as average   FROM (  SELECT collection_name, search_count, RESPONSE_AVERAGE_TIME, to_char(reg_date,'YYYYMMDDHH24') as timeslice  FROM " + properties.getPrefix() + "_LOG_TIMESLICE WHERE reg_date between  ? AND ?" + " ) temp " + " where collection_name = ? " + " GROUP BY timeslice ORDER BY timeslice asc ";
    private final String INFORMIX_GET_TIME_SLICED_QUERY_DATA = " SELECT collection_name, sum(search_count) as querysum, RESPONSE_AVERAGE_TIME as average, to_char(reg_date, '%Y%m%d%H') as timeslice  FROM " + properties.getPrefix() + "_LOG_TIMESLICE " + " WHERE reg_date between  " + " ?  AND ? " + " AND collection_name = ? " + " GROUP BY timeslice, collection_name" + " ORDER BY timeslice asc ";
    private final String TIBERO_GET_TIME_SLICED_QUERY_DATA = this.ORACLE_GET_TIME_SLICED_QUERY_DATA;
    private final String MSSQL_INTERVAL_QUERY_DATA = "select sum(search_count) as querysum,  timeslice , avg(RESPONSE_AVERAGE_TIME) as average from   ( select collection_name, search_count, RESPONSE_AVERAGE_TIME, REPLACE(REPLACE(CONVERT(varchar(13), reg_date, 120), '-', ''), ' ', '') as timeslice  from " + properties.getPrefix() + "_LOG_TIMESLICE where REG_DATE between ? AND ? " + ") temp " + " where collection_name = ? " + "group by timeslice order by timeslice asc";
    private final String DB2_INTERVAL_QUERY_DATA = " select sum(search_count) as querysum,  timeslice , avg(RESPONSE_AVERAGE_TIME) as average  from (  select collection_name, search_count, RESPONSE_AVERAGE_TIME, CHAR(REPLACE(REPLACE ( to_char(REG_DATE, 'YYYY-MM-DD HH24:MI:SS'), '-', '' ),' ', ''),10) as timeslice  from " + properties.getPrefix() + "_LOG_TIMESLICE where reg_date between ? and ? order by reg_date " + ") temp " + " where collection_name = ? " + " group by timeslice order by timeslice asc ";
    private final String MYSQL_INTERVAL_QUERY_DATA = " SELECT sum(search_count) as querysum,  timeslice , avg(RESPONSE_AVERAGE_TIME) as average  FROM (  SELECT collection_name, search_count, RESPONSE_AVERAGE_TIME, DATE_FORMAT(reg_date,'%Y%m%d%H') as timeslice  FROM " + properties.getPrefix() + "_LOG_TIMESLICE WHERE reg_date between ? and ? " + " ) temp " + " where collection_name = ? " + " GROUP BY timeslice ORDER BY timeslice asc ";
    private final String ORACLE_INTERVAL_QUERY_DATA = " select sum(search_count) as querysum, timeslice , avg(RESPONSE_AVERAGE_TIME) as average  from (  select collection_name, search_count, RESPONSE_AVERAGE_TIME, to_char(reg_date,'yyyymmddhh24') as timeslice  from " + properties.getPrefix() + "_LOG_TIMESLICE where reg_date between ? and ? " + " ) temp " + " where collection_name = ? " + " group by timeslice " + " order by timeslice asc ";
    private final String POSTGRES_INTERVAL_QUERY_DATA = " SELECT sum(search_count) as querysum,  timeslice , avg(RESPONSE_AVERAGE_TIME) as average  FROM (  SELECT collection_name, search_count, RESPONSE_AVERAGE_TIME, to_char(reg_date,'YYYYMMDDHH24') as timeslice  FROM " + properties.getPrefix() + "_LOG_TIMESLICE WHERE reg_date between  ? AND ? " + " ) temp " + " where collection_name = ? " + " GROUP BY timeslice ORDER BY timeslice asc ";
    private final String INFORMIX_INTERVAL_QUERY_DATA = " SELECT sum(search_count) as querysum, to_char(reg_date, '%Y%m%d%H') as timeslice, avg(RESPONSE_AVERAGE_TIME) as average  FROM   " + properties.getPrefix() + "_LOG_TIMESLICE " + " WHERE  REG_DATE BETWEEN ? AND ? AND collection_name = ?" + " GROUP  BY  2";
    private final String TIBERO_INTERVAL_QUERY_DATA = this.ORACLE_INTERVAL_QUERY_DATA;
    private final String MSSQL_MINUTE_INTERVAL_QUERY_DATA = "select sum(search_count) as querysum,  timeslice , avg(RESPONSE_AVERAGE_TIME) as average from   ( select collection_name, search_count, RESPONSE_AVERAGE_TIME, REPLACE(REPLACE(REPLACE(CONVERT(varchar(16), reg_date, 120), '-', ''), ' ', ''), ':','') as timeslice  from " + properties.getPrefix() + "_LOG_TIMESLICE where REG_DATE between ? AND ? " + ") temp " + " where collection_name = ? " + "group by timeslice order by timeslice asc";
    private final String DB2_MINUTE_INTERVAL_QUERY_DATA = " select sum(search_count) as querysum,  timeslice , avg(RESPONSE_AVERAGE_TIME) as average  from (  select collection_name, search_count, RESPONSE_AVERAGE_TIME, CHAR(REPLACE(REPLACE(REPLACE ( to_char(REG_DATE, 'YYYY-MM-DD HH24:MI:SS'), '-', '' ),' ', ''),':',''),12) as timeslice  from " + properties.getPrefix() + "_LOG_TIMESLICE where reg_date between ? and ? order by reg_date " + ") temp " + " where collection_name = ? " + " group by timeslice order by timeslice asc ";
    private final String MYSQL_MINUTE_INTERVAL_QUERY_DATA = " SELECT sum(search_count) as querysum,  timeslice , avg(RESPONSE_AVERAGE_TIME) as average  FROM (  SELECT collection_name, search_count, RESPONSE_AVERAGE_TIME, DATE_FORMAT(reg_date,'%Y%m%d%H%i') as timeslice  FROM " + properties.getPrefix() + "_LOG_TIMESLICE WHERE reg_date between ? and ? " + " ) temp " + " where collection_name = ? " + " GROUP BY timeslice ORDER BY timeslice asc ";
    private final String ORACLE_MINUTE_INTERVAL_QUERY_DATA = " select sum(search_count) as querysum, timeslice , avg(RESPONSE_AVERAGE_TIME) as average  from (  select collection_name, search_count, RESPONSE_AVERAGE_TIME, to_char(reg_date,'yyyymmddhh24MI') as timeslice  from " + properties.getPrefix() + "_LOG_TIMESLICE where reg_date between ? and ? " + " ) temp " + " where collection_name = ? " + " group by timeslice " + " order by timeslice asc ";
    private final String POSTGRES_MINUTE_INTERVAL_QUERY_DATA = " SELECT sum(search_count) as querysum,  timeslice , avg(RESPONSE_AVERAGE_TIME) as average  FROM (  SELECT collection_name, search_count, RESPONSE_AVERAGE_TIME, to_char(reg_date,'YYYYMMDDHH24MI') as timeslice  FROM " + properties.getPrefix() + "_LOG_TIMESLICE WHERE reg_date between  ? AND ? " + " ) temp " + " where collection_name = ? " + " GROUP BY timeslice ORDER BY timeslice asc ";
    private final String INFORMIX_MINUTE_INTERVAL_QUERY_DATA = " SELECT sum(search_count) as querysum, to_char(reg_date, '%Y%m%d%H%M') as timeslice, avg(RESPONSE_AVERAGE_TIME) as average  FROM   " + properties.getPrefix() + "_LOG_TIMESLICE " + " WHERE  REG_DATE BETWEEN ? AND ? AND collection_name = ?" + " GROUP  BY  2";
    private final String TIBERO_MINUTE_INTERVAL_QUERY_DATA = this.ORACLE_MINUTE_INTERVAL_QUERY_DATA;
    private final String MSSQL_INTERVAL_POPULAR_SEARCH_TERM = " select Top 10 search_term, sum(search_count) as sum_sc  from " + properties.getPrefix() + "_LOG_SEARCH_TERM_POPULAR " + " where reg_date between ? and ? and collection_name = ? " + " group by search_term " + " order by sum_sc desc, search_term asc ";
    private final String DB2_INTERVAL_POPULAR_SEARCH_TERM = " select search_term, sum(search_count) as sum_sc  from " + properties.getPrefix() + "_LOG_SEARCH_TERM_POPULAR " + " where reg_date between ? and ? and collection_name = ? " + " group by search_term " + " order by sum_sc desc " + " fetch first " + 10 + " rows only ";
    private final String POSTGRES_INTERVAL_POPULAR_SEARCH_TERM = " select search_term, sum(search_count) as sum_sc  from " + properties.getPrefix() + "_LOG_SEARCH_TERM_POPULAR " + " where reg_date between ? and ? and collection_name = ? " + " group by search_term " + " order by sum_sc desc " + " limit " + 10 + " ";
    private final String MYSQL_INTERVAL_POPULAR_SEARCH_TERM = " select search_term, sum(search_count) as sum_sc  from " + properties.getPrefix() + "_LOG_SEARCH_TERM_POPULAR " + " where reg_date between ? and ? and collection_name = ? " + " group by search_term " + " order by sum_sc desc " + " limit " + 10 + " ";
    private final String ORACLE_INTERVAL_POPULAR_SEARCH_TERM = " select search_term, sum_sc  from (  select search_term, sum(search_count) as sum_sc   from " + properties.getPrefix() + "_LOG_SEARCH_TERM_POPULAR " + " where reg_date between ? and ? and collection_name = ? " + " group by search_term " + " order by sum_sc desc" + " ) " + " where rownum <= " + 10;
    private final String INFORMIX_INTERVAL_POPULAR_SEARCH_TERM = " select first 10 search_term, sum(search_count) as sum_sc   from " + properties.getPrefix() + "_LOG_SEARCH_TERM_POPULAR " + " where reg_date between ? and ? and collection_name = ? " + " group by search_term " + " order by sum_sc desc";
    private final String TIBERO_INTERVAL_POPULAR_SEARCH_TERM = this.ORACLE_INTERVAL_POPULAR_SEARCH_TERM;
    private final String MSSQL_SEARCH_TERM_FAIL = " select Top 10 fail_search_term, sum(fail_search_count) as fail_sum_sc  from " + properties.getPrefix() + "_LOG_SEARCH_TERM_FAIL " + " where reg_date between ? and ? and collection_name = ? " + " group by fail_search_term " + " order by fail_sum_sc desc, fail_search_term asc";
    private final String DB2_SEARCH_TERM_FAIL = " select fail_search_term, sum(fail_search_count) as fail_sum_sc  from " + properties.getPrefix() + "_LOG_SEARCH_TERM_FAIL " + " where reg_date between ? and ? and collection_name = ? " + " group by fail_search_term " + " order by fail_sum_sc desc " + " fetch first " + 10 + " rows only ";
    private final String POSTGRES_SEARCH_TERM_FAIL = " select fail_search_term, sum(fail_search_count) as fail_sum_sc  from " + properties.getPrefix() + "_LOG_SEARCH_TERM_FAIL " + " where reg_date between ? and ? and collection_name = ? " + " group by fail_search_term " + " order by fail_sum_sc desc " + " limit " + 10 + " ";
    private final String MYSQL_SEARCH_TERM_FAIL = " select fail_search_term, sum(fail_search_count) as fail_sum_sc  from " + properties.getPrefix() + "_LOG_SEARCH_TERM_FAIL " + " where reg_date between ? and ? and collection_name = ? " + " group by fail_search_term " + " order by fail_sum_sc desc " + " limit " + 10 + " ";
    private final String ORACLE_SEARCH_TERM_FAIL = " select fail_search_term, fail_sum_sc  from (  select fail_search_term, sum(fail_search_count) as fail_sum_sc   from " + properties.getPrefix() + "_LOG_SEARCH_TERM_FAIL " + " where reg_date between ? and ? and collection_name = ? " + " group by fail_search_term " + " order by fail_sum_sc desc" + " ) " + " where rownum <= " + 10;
    private final String INFORMIX_SEARCH_TERM_FAIL = " select first 10 fail_search_term, sum(fail_search_count) as fail_sum_sc  from " + properties.getPrefix() + "_LOG_SEARCH_TERM_FAIL " + " where " + " reg_date between ? and ? " + " and collection_name = ? " + " group by fail_search_term " + " order by fail_sum_sc desc";
    private final String TIBERO_SEARCH_TERM_FAIL = this.ORACLE_SEARCH_TERM_FAIL;

    public LogDBQuery() throws SQLException {
        this.setDBQuery();
    }

    public LogDBQuery(String collection) throws SQLException {
        this.setDBQuery();
        this.collection = collection;
    }

    private void setDBQuery() throws SQLException {
        Connection conn = null;
        try {
            conn = ConnectionFactory.getConnection();
            this.dbDriver = conn.getMetaData().getDriverName().toUpperCase();
            if (this.dbDriver.indexOf("POSTGRESQL") != -1) {
                this.dbType = 4;
            } else if (this.dbDriver.indexOf("ORACLE") != -1) {
                this.dbType = 5;
            } else if (this.dbDriver.indexOf("MYSQL") != -1) {
                this.dbType = 3;
            } else if (this.dbDriver.indexOf("DB2") != -1) {
                this.dbType = 1;
            } else if (this.dbDriver.indexOf("SQLSERVER") != -1) {
                this.dbType = 2;
            } else if (this.dbDriver.indexOf("JTDS") != -1) {
                this.dbType = 2;
            } else if (this.dbDriver.indexOf("INFORMIX") != -1) {
                this.dbType = 6;
            } else if (this.dbDriver.indexOf("TIBERO") != -1) {
                this.dbType = 7;
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
        switch (this.dbType) {
            case 1: {
                this.timeSliceQuery = this.DB2_GET_TIME_SLICED_QUERY_DATA;
                this.timeSliceIntervalQuery = this.DB2_INTERVAL_QUERY_DATA;
                this.popularInterval = this.DB2_INTERVAL_POPULAR_SEARCH_TERM;
                this.failTermQuery = this.DB2_SEARCH_TERM_FAIL;
                this.timeSliceIntervalQueryMinute = this.DB2_MINUTE_INTERVAL_QUERY_DATA;
                break;
            }
            case 2: {
                this.timeSliceQuery = this.MSSQL_GET_TIME_SLICED_QUERY_DATA;
                this.timeSliceIntervalQuery = this.MSSQL_INTERVAL_QUERY_DATA;
                this.popularInterval = this.MSSQL_INTERVAL_POPULAR_SEARCH_TERM;
                this.failTermQuery = this.MSSQL_SEARCH_TERM_FAIL;
                this.timeSliceIntervalQueryMinute = this.MSSQL_MINUTE_INTERVAL_QUERY_DATA;
                break;
            }
            case 3: {
                this.timeSliceQuery = this.MYSQL_GET_TIME_SLICED_QUERY_DATA;
                this.timeSliceIntervalQuery = this.MYSQL_INTERVAL_QUERY_DATA;
                this.popularInterval = this.MYSQL_INTERVAL_POPULAR_SEARCH_TERM;
                this.failTermQuery = this.MYSQL_SEARCH_TERM_FAIL;
                this.timeSliceIntervalQueryMinute = this.MYSQL_MINUTE_INTERVAL_QUERY_DATA;
                break;
            }
            case 4: {
                this.timeSliceQuery = this.POSTGRES_GET_TIME_SLICED_QUERY_DATA;
                this.timeSliceIntervalQuery = this.POSTGRES_INTERVAL_QUERY_DATA;
                this.popularInterval = this.POSTGRES_INTERVAL_POPULAR_SEARCH_TERM;
                this.failTermQuery = this.POSTGRES_SEARCH_TERM_FAIL;
                this.timeSliceIntervalQueryMinute = this.POSTGRES_MINUTE_INTERVAL_QUERY_DATA;
                break;
            }
            case 5: {
                this.timeSliceQuery = this.ORACLE_GET_TIME_SLICED_QUERY_DATA;
                this.timeSliceIntervalQuery = this.ORACLE_INTERVAL_QUERY_DATA;
                this.popularInterval = this.ORACLE_INTERVAL_POPULAR_SEARCH_TERM;
                this.failTermQuery = this.ORACLE_SEARCH_TERM_FAIL;
                this.timeSliceIntervalQueryMinute = this.ORACLE_MINUTE_INTERVAL_QUERY_DATA;
                break;
            }
            case 6: {
                this.timeSliceQuery = this.INFORMIX_GET_TIME_SLICED_QUERY_DATA;
                this.timeSliceIntervalQuery = this.INFORMIX_INTERVAL_QUERY_DATA;
                this.popularInterval = this.INFORMIX_INTERVAL_POPULAR_SEARCH_TERM;
                this.failTermQuery = this.INFORMIX_SEARCH_TERM_FAIL;
                this.timeSliceIntervalQueryMinute = this.INFORMIX_MINUTE_INTERVAL_QUERY_DATA;
                break;
            }
            case 7: {
                this.timeSliceQuery = this.TIBERO_GET_TIME_SLICED_QUERY_DATA;
                this.timeSliceIntervalQuery = this.TIBERO_INTERVAL_QUERY_DATA;
                this.popularInterval = this.TIBERO_INTERVAL_POPULAR_SEARCH_TERM;
                this.failTermQuery = this.TIBERO_SEARCH_TERM_FAIL;
                this.timeSliceIntervalQueryMinute = this.TIBERO_MINUTE_INTERVAL_QUERY_DATA;
            }
        }
    }

    protected String getPopularInterval(int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Scale cannot be negative.");
        }
        int pos = this.popularInterval.indexOf(String.valueOf(10));
        if (pos != -1) {
            return this.popularInterval.replaceFirst(String.valueOf(10), String.valueOf(scale));
        }
        throw new IllegalArgumentException("Scale cannot be changeable");
    }

    protected String getFailTermInterval(int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("Scale cannot be negative.");
        }
        int pos = this.failTermQuery.indexOf(String.valueOf(10));
        if (pos != -1) {
            return this.failTermQuery.replaceFirst(String.valueOf(10), String.valueOf(scale));
        }
        throw new IllegalArgumentException("Scale cannot be changeable");
    }
}

