/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.ir.common.database.entity.LogFailTerm;
import com.diquest.ir.common.database.handler.LogDBQuery;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LogFailTermDB
extends LogDBQuery {
    private static final int DEFAULT_PAGE = 1;
    private final String GET_LOG_FAIL_TERM = "  SELECT FAIL_SEARCH_TERM, FAIL_SEARCH_COUNT, COLLECTION_NAME, REG_DATE  \t\t\t  FROM " + properties.getPrefix() + "_LOG_SEARCH_TERM_FAIL WHERE FAIL_SEARCH_TERM = ?  ";
    int page = 1;
    int perPage = 10;
    private final String GET_TOTAL_FAIL_SEARCH_COUNT = "SELECT sum(FAIL_SEARCH_COUNT) FROM " + properties.getPrefix() + "_LOG_SEARCH_TERM_FAIL";

    public static void main(String[] args) throws SQLException {
        LogFailTermDB logFailTermDBClient = new LogFailTermDB();
        List failSearchTerm = logFailTermDBClient.getFailSearchTerm(new java.util.Date(0L), new java.util.Date(System.currentTimeMillis()), new String[]{"aha", "yna_article"}, 10, 2);
        Iterator iterator = failSearchTerm.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            String term = (String)map.get("fail_search_term");
            String cnt = (String)map.get("fail_sum");
            System.out.println(String.valueOf(term) + "\t" + cnt);
        }
    }

    public LogFailTermDB() throws SQLException {
    }

    public LogFailTermDB(String collection) throws SQLException {
        super(collection);
    }

    public LogFailTerm get(String failSearchTerm) throws SQLException, ClassNotFoundException {
        Connection conn = null;
        PreparedStatement psmt = null;
        ResultSet rs = null;
        LogFailTerm logFailTerm = null;
        try {
            conn = ConnectionFactory.getConnection();
            psmt = conn.prepareStatement(this.GET_LOG_FAIL_TERM);
            psmt.setString(1, properties.encode(failSearchTerm));
            rs = psmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    int failSearchCount = rs.getInt("FAIL_SEARCH_COUNT");
                    String collectionName = rs.getString("COLLECTION_NAME");
                    Date regDate = rs.getDate("REG_DATE");
                    logFailTerm = new LogFailTerm(failSearchTerm, failSearchCount, collectionName, regDate);
                }
            }
        }
        catch (Throwable throwable) {
            ConnectionFactory.release(rs, psmt, (Connection)conn);
            throw throwable;
        }
        ConnectionFactory.release((ResultSet)rs, (Statement)psmt, (Connection)conn);
        return logFailTerm;
    }

    public List getFailSearchTerm(java.util.Date startDate, java.util.Date endDate) throws SQLException {
        return this.getFailSearchTerm(startDate, endDate, this.collection);
    }

    public List getFailSearchTerm(java.util.Date startDate, java.util.Date endDate, String collection) throws SQLException {
        return this.getFailSearchTerm(startDate, endDate, collection, this.perPage);
    }

    public List getFailSearchTerm(java.util.Date startDate, java.util.Date endDate, String collection, int scale) throws SQLException {
        return this.getFailSearchTerm(startDate, endDate, collection, scale, this.page);
    }

    public List getFailSearchTerm(java.util.Date startDate, java.util.Date endDate, String collection, int scale, int page) throws SQLException {
        return this.getFailSearchTerm(startDate, endDate, new String[]{collection}, scale, page);
    }

    public List getFailSearchTerm(java.util.Date startDate, java.util.Date endDate, String[] collections) throws SQLException {
        return this.getFailSearchTerm(startDate, endDate, collections, this.perPage);
    }

    public List getFailSearchTerm(java.util.Date startDate, java.util.Date endDate, String[] collections, int scale) throws SQLException {
        return this.getFailSearchTerm(startDate, endDate, collections, scale, this.page);
    }

    public final int getTotalFailSearchCount(String collection) throws SQLException {
        return this.getTotalFailSearchCount(new String[]{collection});
    }

    public final int getTotalFailSearchCount(String[] collections) throws SQLException {
        return this.getTotalFailSearchCount(null, null, collections);
    }

    public final int getTotalFailSearchCount(java.util.Date startDate, java.util.Date endDate, String collection) throws SQLException {
        return this.getTotalFailSearchCount(startDate, endDate, new String[]{collection});
    }

    public final int getTotalFailSearchCount(java.util.Date startDate, java.util.Date endDate, String[] collections) throws SQLException {
        int n;
        boolean useDate = startDate != null && endDate != null;
        boolean useCollection = collections.length != 0;
        StringBuffer sql = new StringBuffer(this.GET_TOTAL_FAIL_SEARCH_COUNT);
        if (useDate || useCollection) {
            sql.append(" WHERE ");
            if (useCollection) {
                sql.append(" ( ");
                sql.append(" COLLECTION_NAME = ? ");
                int i = 1;
                while (i < collections.length) {
                    sql.append(" OR COLLECTION_NAME = ? ");
                    ++i;
                }
                sql.append(" ) ");
            }
            if (useDate && useCollection) {
                sql.append(" AND ");
            }
            if (useDate) {
                sql.append(" ( REG_DATE BETWEEN ? AND ? ) ");
            }
        }
        ResultSet resultSet = null;
        PreparedStatement pstmt = null;
        Connection conn = ConnectionFactory.getConnection();
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int paramIndex = 1;
            if (useCollection) {
                int i = 0;
                while (i < collections.length) {
                    String collection = collections[i];
                    pstmt.setString(paramIndex++, collection);
                    ++i;
                }
            }
            if (useDate) {
                pstmt.setTimestamp(paramIndex++, new Timestamp(startDate.getTime()));
                pstmt.setTimestamp(paramIndex++, new Timestamp(endDate.getTime()));
            }
            int count = 0;
            resultSet = pstmt.executeQuery();
            if (resultSet.next()) {
                count = resultSet.getInt(1);
            }
            n = count;
        }
        catch (Throwable throwable) {
            ConnectionFactory.release(resultSet, (Statement)pstmt, (Connection)conn);
            throw throwable;
        }
        ConnectionFactory.release((ResultSet)resultSet, (Statement)pstmt, (Connection)conn);
        return n;
    }

    public static final List getTotalFailSearchCounts(java.util.Date startDate, java.util.Date endDate, String[] collections) throws SQLException {
        ArrayList<Object[]> arrayList;
        boolean useCollection = collections.length != 0;
        StringBuffer sql = new StringBuffer("select reg_date, sum(fail_search_count) from " + properties.getPrefix() + "_log_search_term_fail ");
        sql.append(" WHERE ");
        if (useCollection) {
            sql.append(" ( ");
            sql.append(" COLLECTION_NAME = ? ");
            int i = 1;
            while (i < collections.length) {
                sql.append(" OR COLLECTION_NAME = ? ");
                ++i;
            }
            sql.append(" ) ");
        }
        if (useCollection) {
            sql.append(" AND ");
        }
        sql.append(" ( REG_DATE BETWEEN ? AND ? ) ");
        sql.append(" group by reg_date order by reg_date asc ");
        ResultSet resultSet = null;
        PreparedStatement pstmt = null;
        Connection conn = ConnectionFactory.getConnection();
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int paramIndex = 1;
            if (useCollection) {
                int i = 0;
                while (i < collections.length) {
                    String collection = collections[i];
                    pstmt.setString(paramIndex++, collection);
                    ++i;
                }
            }
            pstmt.setTimestamp(paramIndex++, new Timestamp(startDate.getTime()));
            pstmt.setTimestamp(paramIndex++, new Timestamp(endDate.getTime()));
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            resultSet = pstmt.executeQuery();
            while (resultSet.next()) {
                Timestamp time = resultSet.getTimestamp(1);
                int count = resultSet.getInt(2);
                Object[] slot = new Object[]{time, new Integer(count)};
                result.add(slot);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            ConnectionFactory.release(resultSet, (Statement)pstmt, (Connection)conn);
            throw throwable;
        }
        ConnectionFactory.release((ResultSet)resultSet, (Statement)pstmt, (Connection)conn);
        return arrayList;
    }

    public List getFailSearchTerm(java.util.Date startDate, java.util.Date endDate, String[] collections, int scale, int page) throws SQLException {
        int total = scale * page;
        int skip = total - scale;
        String failTermQuery = this.getFailTermInterval(total);
        if (collections == null || collections.length == 0) {
            return new ArrayList(0);
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList result = new ArrayList();
        Connection conn = ConnectionFactory.getConnection();
        try {
            String sql = "";
            String whereCaluse = "collection_name = ?";
            int index = failTermQuery.indexOf(whereCaluse);
            if (index == -1) {
                throw new SQLException("Cannot create where statement.");
            }
            String prev = failTermQuery.substring(0, index);
            String post = failTermQuery.substring(index + whereCaluse.length());
            String where = " ( ";
            int i = 0;
            while (i < collections.length) {
                if (i != 0) {
                    where = String.valueOf(where) + " OR ";
                }
                where = String.valueOf(where) + " " + whereCaluse + " ";
                ++i;
            }
            where = String.valueOf(where) + " ) ";
            sql = String.valueOf(prev) + where + post;
            pstmt = conn.prepareStatement(sql);
            pstmt.setTimestamp(1, new Timestamp(startDate.getTime()));
            pstmt.setTimestamp(2, new Timestamp(endDate.getTime()));
            int i2 = 0;
            while (i2 < collections.length) {
                pstmt.setString(3 + i2, collections[i2]);
                ++i2;
            }
            rs = pstmt.executeQuery();
            this.resultSet2List(rs, result, skip, total);
        }
        catch (Throwable throwable) {
            ConnectionFactory.release(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        ConnectionFactory.release((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return result;
    }

    public List getFailSearchTerm(int day) throws SQLException {
        return this.getFailSearchTerm(day, 0, 0);
    }

    public List getFailSearchTerm(int day, int hour, int min) throws SQLException {
        long currentTimeMillis = System.currentTimeMillis();
        long interval = 60000L * (long)min + 3600000L * (long)hour + 86400000L * (long)day;
        java.util.Date end = new java.util.Date(currentTimeMillis);
        java.util.Date start = new java.util.Date(currentTimeMillis - interval);
        return this.getFailSearchTerm(start, end);
    }

    public List getFailSearchTerm(int day, int hour, int min, String[] collections) throws SQLException {
        long currentTimeMillis = System.currentTimeMillis();
        long interval = 60000L * (long)min + 3600000L * (long)hour + 86400000L * (long)day;
        java.util.Date end = new java.util.Date(currentTimeMillis);
        java.util.Date start = new java.util.Date(currentTimeMillis - interval);
        return this.getFailSearchTerm(start, end, collections);
    }

    public List getFailSearchTerm(int day, String[] collections) throws SQLException {
        return this.getFailSearchTerm(day, 0, 0, collections);
    }

    public void setPagingInfo(int page, int perPage) {
        this.page = page;
        this.perPage = perPage;
    }

    private void resultSet2List(ResultSet rs, List result, int from, int to) throws SQLException {
        if (from >= to || from < 0 || to < 0) {
            return;
        }
        int index = 0;
        while (index++ < from) {
            boolean next = rs.next();
            if (next) continue;
            return;
        }
        int remain = to - from;
        while (remain-- > 0 && rs.next()) {
            HashMap<String, String> map = new HashMap<String, String>(2, 1.0f);
            map.put("fail_search_term", properties.decode(rs.getString("FAIL_SEARCH_TERM")));
            map.put("fail_sum", rs.getString("fail_sum_sc"));
            result.add(map);
        }
    }

    public static List getTimeSlicedFailData(java.util.Date from, java.util.Date to, int unit, int knownGap, String[] collections) throws SQLException {
        List naiveData = LogFailTermDB.getTotalFailSearchCounts(from, to, collections);
        if (unit <= 0) {
            unit = 60;
        }
        long interval = (long)unit * 1000L * 60L;
        int naiveSize = naiveData.size();
        long fromTime = LogFailTermDB.correct(from, unit, true).getTime();
        long toTime = LogFailTermDB.correct(to, unit, false).getTime();
        ArrayList<Object[]> slots = new ArrayList<Object[]>((int)(1L + (toTime - fromTime) / interval));
        int naiveIndex = 0;
        long time = fromTime;
        while (time <= toTime) {
            double sum = 0.0;
            long logGap = 0L;
            while (naiveIndex < naiveSize) {
                Object[] log = (Object[])naiveData.get(naiveIndex);
                long logTime = ((java.util.Date)log[0]).getTime();
                if (naiveIndex + 1 < naiveSize) {
                    long nextLogTime = ((java.util.Date)((Object[])naiveData.get(naiveIndex + 1))[0]).getTime();
                    logGap = nextLogTime - logTime;
                } else if (knownGap == 0) {
                    if (logGap == 0L) {
                        logGap = time + interval - logTime;
                    }
                } else {
                    logGap = knownGap;
                }
                if (logTime >= time + interval) break;
                int failCount = (Integer)log[1];
                double portion = LogFailTermDB.portionOfOverlap(time, interval, logTime, logGap);
                sum += (double)failCount * portion;
                if (logTime + logGap >= time + interval) break;
                ++naiveIndex;
            }
            Object[] slot = new Object[3];
            slot[0] = new java.util.Date(time);
            slot[1] = new Integer((int)Math.round(sum));
            slots.add(slot);
            time += interval;
        }
        return slots;
    }

    private static double portionOfOverlap(long srcFrom, long srcLength, long destFrom, long destLength) {
        if (srcLength <= 0L || destLength <= 0L) {
            return 0.0;
        }
        long srcEnd = srcFrom + srcLength;
        long destEnd = destFrom + destLength;
        if (destEnd <= srcFrom) {
            return 0.0;
        }
        if (srcEnd <= destFrom) {
            return 0.0;
        }
        if (destEnd <= srcEnd) {
            srcEnd = destEnd;
        }
        if (srcFrom <= destFrom) {
            srcFrom = destFrom;
        }
        return (double)(srcEnd - srcFrom) / (double)(destEnd - destFrom);
    }

    public static java.util.Date correct(java.util.Date date, int minute, boolean before) {
        long MINUTE = 60000L;
        long shift = 32400000L;
        if (before) {
            long time = date.getTime();
            long overed = (time + shift) % ((long)minute * MINUTE);
            return new java.util.Date(time - overed);
        }
        long time = date.getTime();
        long overed = (time + shift) % ((long)minute * MINUTE);
        if (overed != 0L) {
            time = time - overed + (long)minute * MINUTE;
        }
        return new java.util.Date(time);
    }
}

