/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.ir.common.database.entity.LogFull;
import com.diquest.ir.common.database.handler.LogDBQuery;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import com.diquest.ir.util.rdbms.supporter.SqlServerSupporter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class LogFullDB
extends LogDBQuery {
    private static final String TABLE = String.valueOf(properties.getPrefix()) + "_LOG_FULL";
    private static final String SQL_GET_TOTAL_LOG_FULL = " SELECT COUNT(*) FROM " + TABLE;
    private static final String LOG_FULL_DELETE_ALL = "delete from " + TABLE;
    private static final String LOG_FULL_GET_ALL = "select * from " + TABLE;
    private static final String DATE_RANGE = " reg_date between ? and ? ";
    private static final String ORDER_DATE = " order by reg_date ";
    private boolean useDateRange = false;
    private Date dateRangeFrom;
    private Date dateRangeTo;
    private boolean ordering = false;
    private boolean descending = true;

    public LogFullDB() throws SQLException {
    }

    public LogFullDB(String collection) throws SQLException {
        super(collection);
    }

    public void deleteAll() throws ClassNotFoundException, SQLException {
        Connection conn = null;
        PreparedStatement psmt = null;
        try {
            conn = ConnectionFactory.getConnection();
            psmt = conn.prepareStatement(LOG_FULL_DELETE_ALL);
            psmt.executeUpdate();
        }
        catch (Throwable throwable) {
            ConnectionFactory.release(psmt, (Connection)conn);
            throw throwable;
        }
        ConnectionFactory.release((PreparedStatement)psmt, (Connection)conn);
    }

    public void disableDateRange() {
        this.useDateRange = false;
    }

    public int getLogFullCount(Connection conn, String collection) throws Exception {
        return this.getLogFullCount(conn, new String[]{collection});
    }

    public int getLogFullCount(Connection conn, String[] collections) throws Exception {
        String sql = String.valueOf(SQL_GET_TOTAL_LOG_FULL) + this.createWhereWith(collections);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[collections.length + (this.useDateRange ? 2 : 0)];
        int i = 0;
        while (i < collections.length) {
            parameters[i] = new RdbmsStringColumnParameter("COLLECTION", i + 1, collections[i]);
            ++i;
        }
        if (this.useDateRange) {
            parameters[i] = new RdbmsDateColumnParameter("REG_DATE", i + 1, this.dateRangeFrom.getTime());
            parameters[++i] = new RdbmsDateColumnParameter("REG_DATE", i + 1, this.dateRangeTo.getTime());
            ++i;
        }
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, parameters);
        RdbmsColumnValue[] item = supporter.fetchItem(conn, query);
        return Integer.parseInt(item[0].toString());
    }

    public List getLogFullList(Connection conn, int start, int scale) throws Exception {
        return this.getLogFullList(conn, start, scale, new String[]{this.collection});
    }

    public List getLogFullList(Connection conn, int start, int scale, String[] collections) throws Exception {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        if (supporter instanceof SqlServerSupporter) {
            ArrayList<LogFull> arrayList;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String sql = String.valueOf(LOG_FULL_GET_ALL) + this.createWhereWith(collections) + this.createOrderBy();
                pstmt = conn.prepareStatement(sql);
                int i = 0;
                while (i < collections.length) {
                    pstmt.setString(i + 1, collections[i]);
                    ++i;
                }
                if (this.useDateRange) {
                    pstmt.setTimestamp(i + 1, new Timestamp(this.dateRangeFrom.getTime()));
                    pstmt.setTimestamp(++i + 1, new Timestamp(this.dateRangeTo.getTime()));
                    ++i;
                }
                rs = pstmt.executeQuery();
                int skip = 1;
                while (skip++ < start && rs.next()) {
                }
                int left = scale;
                ArrayList<LogFull> list = new ArrayList<LogFull>(scale);
                while (left-- >= 0 && rs.next()) {
                    list.add(this.createLogFull(rs));
                }
                arrayList = list;
            }
            catch (Throwable throwable) {
                ConnectionFactory.release(rs, pstmt);
                throw throwable;
            }
            ConnectionFactory.release((ResultSet)rs, (PreparedStatement)pstmt);
            return arrayList;
        }
        String[] columns = new String[]{"KEYWORDS", "COLLECTION", "RESULT_SIZE", "USER_NAME", "EXT_DATA", "RESPONSE_TIME", "REG_DATE"};
        String from = " FROM " + TABLE;
        String whereStmt = this.createWhereWith(collections);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[collections.length + (this.useDateRange ? 2 : 0)];
        int i = 0;
        while (i < collections.length) {
            parameters[i] = new RdbmsStringColumnParameter("COLLECTION_NAME", i + 1, collections[i]);
            ++i;
        }
        if (this.useDateRange) {
            parameters[i] = new RdbmsDateColumnParameter("REG_DATE", i + 1, new Timestamp(this.dateRangeFrom.getTime()));
            parameters[++i] = new RdbmsDateColumnParameter("REG_DATE", i + 1, new Timestamp(this.dateRangeTo.getTime()));
            ++i;
        }
        RdbmsPagingQuery query = new RdbmsPagingQuery(null, start, scale, columns, from, whereStmt, null, this.createOrderBy(), parameters);
        List naiveList = supporter.fetchCriteria(conn, query);
        ArrayList<LogFull> list = new ArrayList<LogFull>(naiveList.size());
        Iterator iterator = naiveList.iterator();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        while (iterator.hasNext()) {
            RdbmsColumnValue[] row = (RdbmsColumnValue[])iterator.next();
            LogFull logFull = this.createLogFull(row, format);
            list.add(logFull);
            iterator.remove();
        }
        return list;
    }

    public boolean setOrder(boolean desc) {
        this.descending = desc;
        return this.descending;
    }

    public void useDateRange(Date dateFrom, Date dateTo) {
        this.dateRangeFrom = new Date(dateFrom.getTime());
        this.dateRangeTo = new Date(dateTo.getTime());
        this.useDateRange = true;
    }

    public boolean useOrdering(boolean use) {
        this.ordering = use;
        return this.ordering;
    }

    private LogFull createLogFull(RdbmsColumnValue[] row, SimpleDateFormat format) throws ParseException {
        LogFull logFull = new LogFull();
        logFull.setKeywords(row[0].toString());
        logFull.setCollection(row[1].toString());
        logFull.setResultSize(Integer.parseInt(row[2].toString()));
        logFull.setUserName(row[3].toString());
        logFull.setExtDate(row[4].toString());
        logFull.setResponseTime(Integer.parseInt(row[5].toString()));
        logFull.setRegDate(format.parse(row[6].toString()));
        return logFull;
    }

    private LogFull createLogFull(ResultSet rs) throws SQLException {
        LogFull logFull = new LogFull();
        logFull.setKeywords(properties.decode(rs.getString("KEYWORDS")));
        logFull.setCollection(rs.getString("COLLECTION"));
        logFull.setResultSize(rs.getInt("RESULT_SIZE"));
        logFull.setUserName(properties.decode(rs.getString("USER_NAME")));
        logFull.setExtDate(properties.decode(rs.getString("EXT_DATA")));
        logFull.setResponseTime(rs.getInt("RESPONSE_TIME"));
        logFull.setRegDate(rs.getTimestamp("REG_DATE"));
        return logFull;
    }

    private String createOrderBy() {
        if (this.ordering) {
            return ORDER_DATE + (this.descending ? " desc " : " asc ");
        }
        return "";
    }

    private String createWhereWith(String[] collections) {
        if (collections.length == 0 || !this.useDateRange) {
            return "";
        }
        String whereStmt = " WHERE ";
        if (collections.length != 0) {
            whereStmt = String.valueOf(whereStmt) + " ( ";
            int i = 0;
            while (i < collections.length) {
                if (i != 0) {
                    whereStmt = String.valueOf(whereStmt) + " OR ";
                }
                whereStmt = String.valueOf(whereStmt) + " COLLECTION = ? ";
                ++i;
            }
            whereStmt = String.valueOf(whereStmt) + " ) ";
        }
        if (collections.length != 0 && this.useDateRange) {
            whereStmt = String.valueOf(whereStmt) + " and ";
        }
        if (this.useDateRange) {
            whereStmt = String.valueOf(whereStmt) + " ( ";
            whereStmt = String.valueOf(whereStmt) + DATE_RANGE;
            whereStmt = String.valueOf(whereStmt) + " ) ";
        }
        return whereStmt;
    }
}

