/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.ir.common.database.entity.LogPopular;
import com.diquest.ir.common.database.handler.LogDBQuery;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogPopularDB
extends LogDBQuery {
    private static final int DEFAULT_PAGE = 1;
    int page = 1;
    int perPage = 10;
    private final String GET_LOG_POPULAR_TERM = " SELECT COLLECTION_NAME, SEARCH_TERM, SEARCH_COUNT, REG_DATE  FROM " + properties.getPrefix() + "_LOG_SEARCH_TERM_POPULAR " + " WHERE COLLECTION_NAME = ? AND SEARCH_TERM LIKE ? ";

    public void setPagingInfo(int page, int perPage) {
        this.page = page;
        this.perPage = perPage;
    }

    public LogPopularDB() throws SQLException {
    }

    public LogPopularDB(String collection) throws SQLException {
        super(collection);
    }

    public List getLogPoupularList(String collection, String term) throws SQLException {
        ArrayList<LogPopular> arrayList;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<LogPopular> result = new ArrayList<LogPopular>();
        try {
            conn = ConnectionFactory.getConnection();
            pstmt = conn.prepareStatement(this.GET_LOG_POPULAR_TERM);
            pstmt.setString(1, collection);
            pstmt.setString(2, properties.encode("%" + term + "%"));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                LogPopular entity = new LogPopular(rs.getString("COLLECTION_NAME"), properties.decode(rs.getString("SEARCH_TERM")), rs.getInt("SEARCH_COUNT"), rs.getTimestamp("REG_DATE"));
                result.add(entity);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            ConnectionFactory.release(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        ConnectionFactory.release((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return arrayList;
    }

    public List getPopularSearchTerm(Date startDate, Date endDate) throws SQLException {
        return this.getPopularSearchTerm(startDate, endDate, this.collection);
    }

    public List getPopularSearchTerm(Date startDate, Date endDate, String collection) throws SQLException {
        return this.getPopularSearchTerm(startDate, endDate, collection, this.perPage);
    }

    public List getPopularSearchTerm(Date startDate, Date endDate, String[] collections) throws SQLException {
        return this.getPopularSearchTerm(startDate, endDate, collections, this.perPage);
    }

    public List getPopularSearchTerm(Date startDate, Date endDate, String collection, int scale) throws SQLException {
        return this.getPopularSearchTerm(startDate, endDate, new String[]{collection}, scale);
    }

    public List getPopularSearchTerm(Date startDate, Date endDate, String[] collections, int scale) throws SQLException {
        return this.getPopularSearchTerm(startDate, endDate, collections, scale, this.page);
    }

    public List getPopularSearchTerm(Date startDate, Date endDate, String[] collections, int scale, int page) throws SQLException {
        int total = scale * page;
        int skip = total - scale;
        String popularTermQuery = this.getPopularInterval(total);
        if (collections == null || collections.length == 0) {
            return new ArrayList(0);
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList result = new ArrayList();
        Connection conn = ConnectionFactory.getConnection();
        try {
            String sql = "";
            String whereCaluse = "collection_name = ?";
            int index = popularTermQuery.indexOf(whereCaluse);
            if (index == -1) {
                throw new SQLException("Cannot create where statement.");
            }
            String prev = popularTermQuery.substring(0, index);
            String post = popularTermQuery.substring(index + whereCaluse.length());
            String where = " ( ";
            int i = 0;
            while (i < collections.length) {
                if (i != 0) {
                    where = String.valueOf(where) + " OR ";
                }
                where = String.valueOf(where) + " " + whereCaluse + " ";
                ++i;
            }
            where = String.valueOf(where) + " ) ";
            sql = String.valueOf(prev) + where + post;
            pstmt = conn.prepareStatement(sql);
            pstmt.setTimestamp(1, new Timestamp(startDate.getTime()));
            pstmt.setTimestamp(2, new Timestamp(endDate.getTime()));
            int i2 = 0;
            while (i2 < collections.length) {
                pstmt.setString(3 + i2, collections[i2]);
                ++i2;
            }
            rs = pstmt.executeQuery();
            this.resultSet2List(rs, result, skip, total);
        }
        catch (Throwable throwable) {
            ConnectionFactory.release(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        ConnectionFactory.release((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return result;
    }

    private void resultSet2List(ResultSet rs, List result, int from, int to) throws SQLException {
        if (from >= to || from < 0 || to < 0) {
            return;
        }
        int index = 0;
        while (index++ < from) {
            boolean next = rs.next();
            if (next) continue;
            return;
        }
        int remain = to - from;
        while (remain-- > 0 && rs.next()) {
            HashMap<String, String> map = new HashMap<String, String>(2, 1.0f);
            map.put("search_term", properties.decode(rs.getString("search_term")));
            map.put("sum_sc", rs.getString("sum_sc"));
            result.add(map);
        }
    }

    public List getPopularSearchTerm(int day) throws SQLException {
        return this.getPopularSearchTerm(day, new String[]{this.collection});
    }

    public List getPopularSearchTerm(int day, int hour, int min) throws SQLException {
        return this.getPopularSearchTerm(day, hour, min, new String[]{this.collection});
    }

    public List getPopularSearchTerm(int day, int hour, int min, String[] collections) throws SQLException {
        long currentTimeMillis = System.currentTimeMillis();
        long interval = 60000L * (long)min + 3600000L * (long)hour + 86400000L * (long)day;
        Date end = new Date(currentTimeMillis);
        Date start = new Date(currentTimeMillis - interval);
        return this.getPopularSearchTerm(start, end, collections);
    }

    public List getPopularSearchTerm(int day, String[] collections) throws SQLException {
        return this.getPopularSearchTerm(day, 0, 0, collections);
    }

    static class MapEntityFactory {
        MapEntityFactory() {
        }

        static List create(List native_rows) {
            int size = native_rows.size();
            ArrayList<Map> result = new ArrayList<Map>(size);
            int i = 0;
            while (i < size) {
                result.add(MapEntityFactory.create((RdbmsColumnValue[])native_rows.get(i)));
                ++i;
            }
            return result;
        }

        static Map create(RdbmsColumnValue[] native_row) {
            String search_term = native_row[0].toString();
            String sum_sc = native_row[1].toString();
            HashMap<String, String> entity = new HashMap<String, String>(2, 1.0f);
            entity.put("search_term", search_term);
            entity.put("sum_sc", sum_sc);
            return entity;
        }
    }
}

