/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.ir.common.database.entity.LogTimeSlice;
import com.diquest.ir.common.database.handler.LogDBQuery;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogTimeSliceDB
extends LogDBQuery {
    private final String GET_LOG_TIME_SLICE = " SELECT SEARCH_COUNT, COLLECTION_NAME, REG_DATE FROM " + properties.getPrefix() + "_LOG_TIMESLICE WHERE LOG_ID = ? ";
    private static final int TIMESLICE_INDEX = 0;
    private static final int QUERYSUM_INDEX = 1;
    private static final int AVERAGE_INDEX = 2;

    public LogTimeSliceDB(String collection) throws SQLException {
        super(collection);
    }

    public LogTimeSliceDB() throws SQLException {
    }

    public LogTimeSlice get(int logFailID) throws SQLException, ClassNotFoundException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        LogTimeSlice lts = new LogTimeSlice();
        try {
            conn = ConnectionFactory.getConnection();
            pstmt = conn.prepareStatement(this.GET_LOG_TIME_SLICE);
            pstmt.setInt(1, logFailID);
            rs = pstmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    lts.setOid(logFailID);
                    lts.setResponseAverageTime(rs.getLong("RESPONSE_AVERAGE_TIME"));
                    lts.setSearchCount(rs.getInt("SEARCH_COUNT"));
                    lts.setCollection(rs.getString("COLLECTION_NAME"));
                    lts.setRegDate(rs.getDate("REG_DATE"));
                }
            }
        }
        catch (Throwable throwable) {
            ConnectionFactory.release(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        ConnectionFactory.release((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return lts;
    }

    public List getTimeSlicedQueryData(Date date) throws ClassNotFoundException, SQLException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        GregorianCalendar temp = new GregorianCalendar(cal.get(1), cal.get(2), cal.get(5), 0, 0);
        Date startOfDate = temp.getTime();
        ((Calendar)temp).add(11, 24);
        Date endOfDate = temp.getTime();
        List native_results = this.getTimeSlicedQueryData(startOfDate, endOfDate);
        ArrayList resorted_results = new ArrayList();
        if (native_results.size() > 0) {
            int i = 0;
            while (i < 24) {
                HashMap<String, String> row = FindRowMap.find(native_results, "timeslice", String.valueOf(i));
                if (row == null) {
                    row = new HashMap<String, String>(3, 1.0f);
                    row.put("timeslice", String.valueOf(i));
                    row.put("querysum", String.valueOf(0));
                    row.put("average", String.valueOf(0));
                }
                resorted_results.add(row);
                ++i;
            }
        }
        return resorted_results;
    }

    public List getTimeSlicedQueryData(Date start_date, Date end_date) throws ClassNotFoundException, SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList result = new ArrayList();
        try {
            conn = ConnectionFactory.getConnection();
            pstmt = conn.prepareStatement(this.timeSliceIntervalQuery);
            pstmt.setTimestamp(1, new Timestamp(start_date.getTime()));
            pstmt.setTimestamp(2, new Timestamp(end_date.getTime()));
            pstmt.setString(3, this.collection);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int timeslice = Integer.parseInt(rs.getString("timeslice").substring("yyyyddmm".length()));
                int querysum = Integer.parseInt(rs.getString("querysum"));
                String average_str = rs.getString("average");
                Double average = Double.valueOf(average_str);
                HashMap<String, String> row = new HashMap<String, String>(3, 1.0f);
                row.put("timeslice", String.valueOf(timeslice));
                row.put("querysum", String.valueOf(querysum));
                row.put("average", String.valueOf(average.intValue()));
                result.add(row);
            }
        }
        catch (Throwable throwable) {
            ConnectionFactory.release(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        ConnectionFactory.release((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return result;
    }

    public List getTimeSlicedQueryData() throws SQLException, ClassNotFoundException {
        Calendar cal = Calendar.getInstance();
        Date end = cal.getTime();
        cal.add(11, -23);
        int hour_start = cal.get(11);
        Date start = cal.getTime();
        List result = this.getTimeSlicedQueryData(start, end);
        ArrayList resorted_result = new ArrayList();
        int offset = hour_start;
        if (result.size() > 0) {
            int i = 0;
            while (i < 24) {
                HashMap<String, String> row = FindRowMap.find(result, "timeslice", String.valueOf(offset));
                if (row == null) {
                    row = new HashMap<String, String>(3, 1.0f);
                    row.put("timeslice", String.valueOf(offset));
                    row.put("querysum", String.valueOf(0));
                    row.put("average", String.valueOf(0));
                }
                resorted_result.add(row);
                offset = offset < 23 ? ++offset : 0;
                ++i;
            }
        }
        return resorted_result;
    }

    public List[] getTimeSlicedQueryData(Date from, Date to, String[] collections) throws SQLException {
        if (collections.length == 0) {
            return new List[0];
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        List[] result = new ArrayList[collections.length];
        try {
            conn = ConnectionFactory.getConnection();
            pstmt = conn.prepareStatement(this.timeSliceIntervalQueryMinute);
            pstmt.setTimestamp(1, new Timestamp(from.getTime()));
            pstmt.setTimestamp(2, new Timestamp(to.getTime()));
            int i = 0;
            while (i < collections.length) {
                ArrayList<Object[]> curResult = result[i] = new ArrayList<Object[]>();
                pstmt.setString(3, collections[i]);
                resultSet = pstmt.executeQuery();
                try {
                    while (resultSet.next()) {
                        Date timeSlice = this.fastTransfer(resultSet.getString("timeslice"));
                        Double querySum = Double.valueOf(resultSet.getString("querysum"));
                        Double average = Double.valueOf(resultSet.getString("average"));
                        curResult.add(new Object[]{timeSlice, querySum, average});
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            ConnectionFactory.release(pstmt, (Connection)conn);
            throw throwable;
        }
        ConnectionFactory.release((PreparedStatement)pstmt, (Connection)conn);
        return result;
    }

    public static List merge(List[] lists, long threshold) {
        if (lists == null) {
            return null;
        }
        if (lists.length == 0) {
            return new ArrayList();
        }
        if (lists.length == 1) {
            return new ArrayList(lists[0]);
        }
        ArrayList appended = new ArrayList();
        int i = 0;
        while (i < lists.length) {
            appended.addAll(lists[i]);
            ++i;
        }
        Object[][] appendedArr = (Object[][])appended.toArray((T[])new Object[appended.size()][3]);
        Arrays.sort(appendedArr, new Comparator(){

            public int compare(Object o1, Object o2) {
                Object[] c1 = (Object[])o1;
                Object[] c2 = (Object[])o2;
                return ((Date)c1[0]).compareTo((Date)c2[0]);
            }
        });
        ArrayList<Object[]> merged = new ArrayList<Object[]>();
        Object[] last = null;
        if (appendedArr.length > 0) {
            last = appendedArr[0];
            merged.add(last);
        }
        int i2 = 1;
        while (i2 < appendedArr.length) {
            Object[] current = appendedArr[i2];
            Date lastDate = (Date)last[0];
            Date currentDate = (Date)current[0];
            if (Math.abs(lastDate.getTime() - currentDate.getTime()) < threshold) {
                double qs = (Double)current[1];
                double avg = (Double)current[2];
                double pQs = (Double)last[1];
                double qAvg = (Double)last[2];
                double newQs = qs + pQs;
                double newAvg = newQs == 0.0 ? 0.0 : (qs * avg + pQs * qAvg) / newQs;
                last[1] = new Double(newQs);
                last[2] = new Double(newAvg);
            } else {
                last = current;
                merged.add(current);
            }
            ++i2;
        }
        return merged;
    }

    Date fastTransfer(String date) {
        Calendar cal = GregorianCalendar.getInstance();
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(4, 6));
        int day = Integer.parseInt(date.substring(6, 8));
        int hour = Integer.parseInt(date.substring(8, 10));
        int minute = Integer.parseInt(date.substring(10, 12));
        cal.set(year, month - 1, day, hour, minute);
        return cal.getTime();
    }

    static class FindRowMap {
        FindRowMap() {
        }

        static Map find(List target, String key, String value) {
            int i = 0;
            while (i < target.size()) {
                Map row = (Map)target.get(i);
                String row_value = (String)row.get(key);
                if (row_value != null && row_value.equals(value)) {
                    return row;
                }
                ++i;
            }
            return null;
        }
    }
}

