/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.ir.common.database.entity.ScheduleTask;
import com.diquest.ir.common.database.entity.factory.ScheduleTaskFactory;
import com.diquest.ir.util.common.DateUtil;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsLongColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class ScheduleTaskDB {
    public static final char TASK_TYPE_CMD = 'C';
    public static final char TASK_TYPE_INTERNAL = 'I';
    public static final char TASK_TYPE_INTERNAL_NXTASK = 'T';
    public static final char USE_YN_Y = 'Y';
    public static final char USE_YN_N = 'N';
    public static final char TASK_STATUS_SUCCESS = 'S';
    public static final char TASK_STATUS_FAIL = 'F';
    public static final char TASK_STATUS_NONE = 'N';
    public static final long SCHEDULE_END_LIMIT = 1000L;
    public static final String HOTKEYWORD_RESERVED = "hotkeyword_";
    public static final String TRENDS_RESERVED = "TRENDS_";
    public static final String CATEGORY_UPDATE_RESERVED = "CATEGORY_UPDATE_";
    static final RdbmsProperties properties = RdbmsPropertiesFactory.load();
    static final String GET_ALL_SCHEDULE_TASK = " SELECT * FROM " + properties.getPrefix() + "_SCHEDULE_TASK";
    static final String GET_SCHEDULE_TASK = " SELECT * FROM " + properties.getPrefix() + "_SCHEDULE_TASK WHERE TASK_NAME=?";
    static final String INSERT = " INSERT INTO " + properties.getPrefix() + "_SCHEDULE_TASK" + " (TASK_NAME, TASK_TYPE, TASK_CMD, TASK_PARAM, TASK_STATUS, SCHEDULE_START_DATE, SCHEDULE_END_DATE, SCHEDULE_PERIOD, RESPONSE_CODE, USE_YN, RUN_START_TIME, RUN_END_TIME, CREATED, UPDATED)" + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    static final String UPDATE = " UPDATE " + properties.getPrefix() + "_SCHEDULE_TASK" + " SET TASK_TYPE=?, TASK_CMD=?, TASK_PARAM=?, SCHEDULE_START_DATE=?, SCHEDULE_END_DATE=?, SCHEDULE_PERIOD=?, USE_YN=?, UPDATED=?" + " WHERE TASK_NAME = ?";
    static final String updateUseYN = " UPDATE " + properties.getPrefix() + "_SCHEDULE_TASK" + " SET USE_YN=?, UPDATED=?" + " WHERE TASK_NAME = ?";
    static final String UPDATE_TASK_RESULT = " UPDATE " + properties.getPrefix() + "_SCHEDULE_TASK" + " SET TASK_STATUS=?, RESPONSE_CODE=?, RUN_START_TIME=?, RUN_END_TIME=?" + " WHERE TASK_NAME = ?";
    static final String DELETE = " DELETE FROM " + properties.getPrefix() + "_SCHEDULE_TASK " + " WHERE TASK_NAME = ? ";

    public List getAllScheduleTask(Connection conn) throws SQLException {
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(GET_ALL_SCHEDULE_TASK);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return ScheduleTaskFactory.create(supporter.fetchItems(conn, query));
    }

    public ScheduleTask getScheduleTask(Connection conn, String taskName) throws SQLException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("TASK_NAME", 1, taskName)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(GET_SCHEDULE_TASK, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnValue[] item = supporter.fetchItem(conn, query);
        return ScheduleTaskFactory.create(item);
    }

    public int insert(Connection conn, String taskName, char taskType, String taskCmd, String taskParam, long scheduleStartDate, long scheduleEndDate, long schedulePeriod, char useYN) throws SQLException {
        long currentTime = System.currentTimeMillis();
        if (scheduleEndDate < 0L) {
            scheduleEndDate = 0L;
        }
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("TASK_NAME", 1, taskName), new RdbmsStringColumnParameter("TASK_TYPE", 2, taskType), new RdbmsStringColumnParameter("TASK_CMD", 3, taskCmd), new RdbmsStringColumnParameter("TASK_PARAM", 4, taskParam), new RdbmsStringColumnParameter("TASK_STATUS", 5, 'N'), new RdbmsDateColumnParameter("SCHEDULE_START_DATE", 6, new Timestamp(scheduleStartDate)), new RdbmsDateColumnParameter("SCHEDULE_END_DATE", 7, new Timestamp(scheduleEndDate)), new RdbmsLongColumnParameter("SCHEDULE_PERIOD", 8, schedulePeriod), new RdbmsStringColumnParameter("RESPONSE_CODE", 9, ""), new RdbmsStringColumnParameter("USE_YN", 10, useYN), new RdbmsDateColumnParameter("RUN_START_TIME", 11, DateUtil.getDefaultTimestamp()), new RdbmsDateColumnParameter("RUN_END_TIME", 12, DateUtil.getDefaultTimestamp()), new RdbmsDateColumnParameter("CREATED", 13, new Timestamp(currentTime)), new RdbmsDateColumnParameter("UPDATED", 14, new Timestamp(currentTime))};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(INSERT, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, query);
    }

    public int update(Connection conn, String taskName, char taskType, String taskCmd, String taskParam, long scheduleStartDate, long scheduleEndDate, long schedulePeriod, char useYN) throws SQLException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("TASK_TYPE", 1, taskType), new RdbmsStringColumnParameter("TASK_CMD", 2, taskCmd), new RdbmsStringColumnParameter("TASK_PARAM", 3, taskParam), new RdbmsDateColumnParameter("SCHEDULE_START_DATE", 4, new Timestamp(scheduleStartDate)), new RdbmsDateColumnParameter("SCHEDULE_END_DATE", 5, new Timestamp(scheduleEndDate)), new RdbmsLongColumnParameter("SCHEDULE_PERIOD", 6, schedulePeriod), new RdbmsStringColumnParameter("USE_YN", 7, useYN), new RdbmsDateColumnParameter("UPDATED", 8, new Timestamp(System.currentTimeMillis())), new RdbmsStringColumnParameter("TASK_NAME", 9, taskName)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(UPDATE, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, query);
    }

    public int updateUseYN(Connection conn, String taskName, char useYN) throws SQLException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("USE_YN", 1, useYN), new RdbmsDateColumnParameter("UPDATED", 2, new Timestamp(System.currentTimeMillis())), new RdbmsStringColumnParameter("TASK_NAME", 3, taskName)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(updateUseYN, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, query);
    }

    public int updateTaskResult(Connection conn, String taskName, String taskStatus, int responseCode, long runStartTime, long runEndTime) throws SQLException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("TASK_STATUS", 1, taskStatus), new RdbmsStringColumnParameter("RESPONSE_CODE", 2, String.valueOf(responseCode)), new RdbmsDateColumnParameter("RUN_START_TIME", 3, new Timestamp(runStartTime)), new RdbmsDateColumnParameter("RUN_END_TIME", 4, new Timestamp(runEndTime)), new RdbmsStringColumnParameter("TASK_NAME", 5, taskName)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(UPDATE_TASK_RESULT, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, query);
    }

    public int delete(Connection conn, String taskName) throws SQLException {
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("TASK_NAME", 1, taskName)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(DELETE, parameters);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        return supporter.executeUpdate(conn, query);
    }
}

