/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.db.SqlUtil;
import com.diquest.commons.type.ByteUtil;
import com.diquest.commons.type.DateUtil;
import com.diquest.commons.type.EnumerationUtil;
import com.diquest.commons.type.IteratorUtil;
import com.diquest.commons.type.StringArrayUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.commons.type.TimeUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.ServerLog;
import com.diquest.ir.common.database.entity.factory.ServerLogFactory;
import com.diquest.ir.common.database.handler.AbstractLogDB;
import com.diquest.ir.common.database.report.cache.ServerLogDbConstraint;
import com.diquest.ir.common.database.report.cache.ServerLogDbObservable;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class ServerLogDB
extends AbstractLogDB {
    private static final ServerLogDbObservable OBSERVABLE = ServerLogDbObservable.getInstance();
    public static final ServerLogDB instance = new ServerLogDB();
    public static final String SERVER = "SERVER";
    public static final String DENIAL = "DENIAL";
    public static final String ERRORS = "ERRORS";
    public static final String SPACE_USED = "SPACE_USED";
    public static final String SPACE_REMAIN = "SPACE_REMAIN";
    public static final String CPU_USAGE = "CPU_USAGE";
    public static final String MEMORY_USED = "MEMORY_USED";
    public static final String SPACE_USED_BY_IR = "SPACE_USED_BY_IR";
    public static final String CPU_USAGE_BY_IR = "CPU_USAGE_BY_IR";
    public static final String MEMORY_MAX_BY_IR = "MEMORY_MAX_BY_IR";
    public static final String MEMORY_TOTAL_BY_IR = "MEMORY_TOTAL_BY_IR";
    public static final String MEMORY_USED_BY_IR = "MEMORY_USED_BY_IR";
    public static final String CONNECTION = "CONNECTIONS";
    public static final String DAY = "DAYZ";
    public static final String HOUR = "HOURZ";
    public static final String MINUTE = "MINUTEZ";
    public static final String REGISTERED = "REGISTERED";
    private static final String[] NULL_SERVERS = null;
    protected static final String TABLE_NAME = String.valueOf(PROPERTIES.getPrefix()) + "_SERVER_LOG";
    protected static final String AVG_SPACE_USED = "avg(SPACE_USED) as SPACE_USED";
    protected static final String AVG_SPACE_REMAIN = "avg(SPACE_REMAIN) as SPACE_REMAIN";
    protected static final String AVG_CPU_USAGE = "avg(CPU_USAGE) as CPU_USAGE";
    protected static final String AVG_MEMORY_USED = "avg(MEMORY_USED) as MEMORY_USED";
    protected static final String AVG_SPACE_USED_BY_IR = "avg(SPACE_USED_BY_IR) as SPACE_USED_BY_IR";
    protected static final String AVG_CPU_USAGE_BY_IR = "avg(CPU_USAGE_BY_IR) as CPU_USAGE_BY_IR";
    protected static final String AVG_MEMORY_TOTAL_BY_IR = "avg(MEMORY_TOTAL_BY_IR) as MEMORY_TOTAL_BY_IR";
    protected static final String AVG_MEMORY_USED_BY_IR = "avg(MEMORY_USED_BY_IR) as MEMORY_USED_BY_IR";
    protected static final String AVG_CONNECTION = "avg(CONNECTIONS) as CONNECTIONS";
    protected static final String MAX_DENIAL = "max(DENIAL) as DENIAL";
    protected static final String MAX_ERRORS = "max(ERRORS) as ERRORS";
    protected static final String MAX_SPACE_USED = "max(SPACE_USED) as SPACE_USED";
    protected static final String MAX_SPACE_REMAIN = "max(SPACE_REMAIN) as SPACE_REMAIN";
    protected static final String MAX_CPU_USAGE = "max(CPU_USAGE) as CPU_USAGE";
    protected static final String MAX_MEMORY_USED = "max(MEMORY_USED) as MEMORY_USED";
    protected static final String MAX_SPACE_USED_BY_IR = "max(SPACE_USED_BY_IR) as SPACE_USED_BY_IR";
    protected static final String MAX_CPU_USAGE_BY_IR = "max(CPU_USAGE_BY_IR) as CPU_USAGE_BY_IR";
    protected static final String MAX_MEMORY_MAX_BY_IR = "max(MEMORY_MAX_BY_IR) as MEMORY_MAX_BY_IR";
    protected static final String MAX_MEMORY_TOTAL_BY_IR = "max(MEMORY_TOTAL_BY_IR) as MEMORY_TOTAL_BY_IR";
    protected static final String MAX_MEMORY_USED_BY_IR = "max(MEMORY_USED_BY_IR) as MEMORY_USED_BY_IR";
    protected static final String MAX_CONNECTION = "max(CONNECTIONS) as CONNECTIONS";
    protected static final String MIN_DENIAL = "min(DENIAL) as DENIAL";
    protected static final String MIN_ERRORS = "min(ERRORS) as ERRORS";
    protected static final String MIN_SPACE_USED = "min(SPACE_USED) as SPACE_USED";
    protected static final String MIN_SPACE_REMAIN = "min(SPACE_REMAIN) as SPACE_REMAIN";
    protected static final String MIN_CPU_USAGE = "min(CPU_USAGE) as CPU_USAGE";
    protected static final String MIN_MEMORY_USED = "min(MEMORY_USED) as MEMORY_USED";
    protected static final String MIN_SPACE_USED_BY_IR = "min(SPACE_USED_BY_IR) as SPACE_USED_BY_IR";
    protected static final String MIN_CPU_USAGE_BY_IR = "min(CPU_USAGE_BY_IR) as CPU_USAGE_BY_IR";
    protected static final String MIN_MEMORY_MAX_BY_IR = "min(MEMORY_MAX_BY_IR) as MEMORY_MAX_BY_IR";
    protected static final String MIN_MEMORY_TOTAL_BY_IR = "min(MEMORY_TOTAL_BY_IR) as MEMORY_TOTAL_BY_IR";
    protected static final String MIN_MEMORY_USED_BY_IR = "min(MEMORY_USED_BY_IR) as MEMORY_USED_BY_IR";
    protected static final String MIN_CONNECTION = "min(CONNECTIONS) as CONNECTIONS";
    protected static final String MIN_MINUTE = "min(MINUTEZ) as MINUTEZ";
    protected static final String MIN_HOUR = "min(HOURZ) as HOURZ";
    protected static final String MIN_DAY = "min(DAYZ) as DAYZ";
    protected static final String MIN_REGISTERED = "min(REGISTERED) as REGISTERED";
    protected static final String SUM_DENIAL = "sum(DENIAL) as DENIAL";
    protected static final String SUM_ERRORS = "sum(ERRORS) as ERRORS";
    protected static final String SUM_SPACE_USED = "sum(SPACE_USED) as SPACE_USED";
    protected static final String SUM_SPACE_REMAIN = "sum(SPACE_REMAIN) as SPACE_REMAIN";
    protected static final String SUM_MEMORY_USED = "sum(MEMORY_USED) as MEMORY_USED";
    protected static final String SUM_SPACE_USED_BY_IR = "sum(SPACE_USED_BY_IR) as SPACE_USED_BY_IR";
    protected static final String SUM_MEMORY_MAX_BY_IR = "sum(MEMORY_MAX_BY_IR) as MEMORY_MAX_BY_IR";
    protected static final String SUM_MEMORY_TOTAL_BY_IR = "sum(MEMORY_TOTAL_BY_IR) as MEMORY_TOTAL_BY_IR";
    protected static final String SUM_MEMORY_USED_BY_IR = "sum(MEMORY_USED_BY_IR) as MEMORY_USED_BY_IR";
    protected static final String SUM_CONNECTION = "sum(CONNECTIONS) as CONNECTIONS";
    protected static final String[] ALL_COLUMNS = new String[]{"SERVER", "DENIAL", "ERRORS", "SPACE_USED", "SPACE_REMAIN", "CPU_USAGE", "MEMORY_USED", "SPACE_USED_BY_IR", "CPU_USAGE_BY_IR", "MEMORY_MAX_BY_IR", "MEMORY_TOTAL_BY_IR", "MEMORY_USED_BY_IR", "CONNECTIONS", "DAYZ", "HOURZ", "MINUTEZ", "REGISTERED"};
    protected static final String[] STATS_COLUMNS = new String[]{"sum(DENIAL) as DENIAL", "sum(ERRORS) as ERRORS", "avg(SPACE_USED) as SPACE_USED", "avg(SPACE_REMAIN) as SPACE_REMAIN", "avg(CPU_USAGE) as CPU_USAGE", "avg(MEMORY_USED) as MEMORY_USED", "avg(SPACE_USED_BY_IR) as SPACE_USED_BY_IR", "avg(CPU_USAGE_BY_IR) as CPU_USAGE_BY_IR", "max(MEMORY_MAX_BY_IR) as MEMORY_MAX_BY_IR", "avg(MEMORY_TOTAL_BY_IR) as MEMORY_TOTAL_BY_IR", "avg(MEMORY_USED_BY_IR) as MEMORY_USED_BY_IR", "avg(CONNECTIONS) as CONNECTIONS", "min(REGISTERED) as REGISTERED"};
    protected static final String[] MIN_COLUMNS = new String[]{"min(DENIAL) as DENIAL", "min(ERRORS) as ERRORS", "min(SPACE_USED) as SPACE_USED", "min(SPACE_REMAIN) as SPACE_REMAIN", "min(CPU_USAGE) as CPU_USAGE", "min(MEMORY_USED) as MEMORY_USED", "min(SPACE_USED_BY_IR) as SPACE_USED_BY_IR", "min(CPU_USAGE_BY_IR) as CPU_USAGE_BY_IR", "min(MEMORY_MAX_BY_IR) as MEMORY_MAX_BY_IR", "min(MEMORY_TOTAL_BY_IR) as MEMORY_TOTAL_BY_IR", "min(MEMORY_USED_BY_IR) as MEMORY_USED_BY_IR", "min(CONNECTIONS) as CONNECTIONS", "min(REGISTERED) as REGISTERED"};
    protected static final String[] MAX_COLUMNS = new String[]{"max(DENIAL) as DENIAL", "max(ERRORS) as ERRORS", "max(SPACE_USED) as SPACE_USED", "max(SPACE_REMAIN) as SPACE_REMAIN", "max(CPU_USAGE) as CPU_USAGE", "max(MEMORY_USED) as MEMORY_USED", "max(SPACE_USED_BY_IR) as SPACE_USED_BY_IR", "max(CPU_USAGE_BY_IR) as CPU_USAGE_BY_IR", "max(MEMORY_MAX_BY_IR) as MEMORY_MAX_BY_IR", "max(MEMORY_TOTAL_BY_IR) as MEMORY_TOTAL_BY_IR", "max(MEMORY_USED_BY_IR) as MEMORY_USED_BY_IR", "max(CONNECTIONS) as CONNECTIONS", "min(REGISTERED) as REGISTERED"};
    protected static final String[] INTEGRATE_SERVERS = new String[]{"sum(DENIAL) as DENIAL", "sum(ERRORS) as ERRORS", "sum(SPACE_USED) as SPACE_USED", "sum(SPACE_REMAIN) as SPACE_REMAIN", "avg(CPU_USAGE) as CPU_USAGE", "sum(MEMORY_USED) as MEMORY_USED", "sum(SPACE_USED_BY_IR) as SPACE_USED_BY_IR", "avg(CPU_USAGE_BY_IR) as CPU_USAGE_BY_IR", "sum(MEMORY_MAX_BY_IR) as MEMORY_MAX_BY_IR", "sum(MEMORY_TOTAL_BY_IR) as MEMORY_TOTAL_BY_IR", "sum(MEMORY_USED_BY_IR) as MEMORY_USED_BY_IR", "sum(CONNECTIONS) as CONNECTIONS", "REGISTERED"};
    protected static final String[] INTEGRATE_SERVERS_TIME = new String[]{"sum(DENIAL) as DENIAL", "sum(ERRORS) as ERRORS", "sum(SPACE_USED) as SPACE_USED", "sum(SPACE_REMAIN) as SPACE_REMAIN", "avg(CPU_USAGE) as CPU_USAGE", "sum(MEMORY_USED) as MEMORY_USED", "sum(SPACE_USED_BY_IR) as SPACE_USED_BY_IR", "avg(CPU_USAGE_BY_IR) as CPU_USAGE_BY_IR", "sum(MEMORY_MAX_BY_IR) as MEMORY_MAX_BY_IR", "sum(MEMORY_TOTAL_BY_IR) as MEMORY_TOTAL_BY_IR", "sum(MEMORY_USED_BY_IR) as MEMORY_USED_BY_IR", "sum(CONNECTIONS) as CONNECTIONS", "min(DAYZ) as DAYZ", "min(HOURZ) as HOURZ", "min(MINUTEZ) as MINUTEZ", "REGISTERED"};
    protected static final String INSERT = SqlUtil.generateInsertSql((String)TABLE_NAME, (String[])ALL_COLUMNS);
    protected static final String SELECT_ALL = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])ALL_COLUMNS);
    protected static final String SELECT_INTEGRATE = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])INTEGRATE_SERVERS_TIME);
    protected static final String SELECT_INTEGRATE_WITHOUT_TIME = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])INTEGRATE_SERVERS);
    protected static final String SELECT_MIN = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])MIN_COLUMNS);
    protected static final String SELECT_MAX = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])MAX_COLUMNS);
    protected static final String SELECT_STATS = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])STATS_COLUMNS);
    protected static final String DELETE_SINGLE = "DELETE FROM " + TABLE_NAME + " WHERE " + "REGISTERED" + "=? AND " + "SERVER" + "=?";
    private String orderColumn = "REGISTERED";
    private boolean orderDirection = true;

    private static String getBasicUnitColumn(long from, long to, long unit) {
        if (TimeUtil.isDayBased((long)unit) && DateUtil.isDayBased((long)from) && DateUtil.isDayBased((long)to)) {
            return DAY;
        }
        if (TimeUtil.isHourBased((long)unit) && DateUtil.isHourBased((long)from) && DateUtil.isHourBased((long)to)) {
            return HOUR;
        }
        return MINUTE;
    }

    protected static String[] arrayrize(String server) {
        String[] stringArray;
        if (server == null) {
            stringArray = NULL_SERVERS;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = server;
        }
        return stringArray;
    }

    public final String getOrderColumn() {
        return this.orderColumn;
    }

    public final String getTableName() {
        return TABLE_NAME;
    }

    public final String getTimeColumnName() {
        return REGISTERED;
    }

    public final int insert(Enumeration logs) throws SQLException {
        Connection conn = ConnectionFactory.getConnection();
        try {
            int n = this.insert(conn, logs);
            return n;
        }
        finally {
            conn.close();
        }
    }

    public int insert(Connection conn, Enumeration logs) throws SQLException {
        ServerLogDbConstraint cons = null;
        try {
            int n;
            PreparedStatement pstmt = conn.prepareStatement(INSERT);
            try {
                int count = 0;
                while (logs.hasMoreElements()) {
                    ServerLog log = (ServerLog)((Object)logs.nextElement());
                    this.setup(log, pstmt);
                    count += pstmt.executeUpdate();
                    if (cons == null) {
                        cons = ServerLogDbConstraint.of(new String[]{log.getServer()}, log.getRegistered().getTime(), log.getRegistered().getTime() + 60000L);
                        continue;
                    }
                    cons.merge(ServerLogDbConstraint.of(new String[]{log.getServer()}, log.getRegistered().getTime(), log.getRegistered().getTime() + 60000L));
                }
                n = count;
            }
            catch (Throwable throwable) {
                pstmt.close();
                throw throwable;
            }
            pstmt.close();
            return n;
        }
        finally {
            if (cons != null) {
                OBSERVABLE.setChanged();
                OBSERVABLE.notifyObservers(cons);
            }
        }
    }

    public int ensureDelete(Connection conn, Enumeration logs) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement(DELETE_SINGLE);
        try {
            int count = 0;
            while (logs.hasMoreElements()) {
                ServerLog log = (ServerLog)((Object)logs.nextElement());
                pstmt.setTimestamp(1, new Timestamp(log.getRegistered().getTime()));
                pstmt.setString(2, log.getServer());
                count += pstmt.executeUpdate();
            }
            int n = count;
            return n;
        }
        finally {
            pstmt.close();
        }
    }

    public final int insert(ServerLog log) throws SQLException {
        return this.insert(EnumerationUtil.singleton((Object)((Object)log)));
    }

    public final boolean isOrderDirection() {
        return this.orderDirection;
    }

    public final boolean isSupportCollection() {
        return false;
    }

    public final boolean isSupportProfile() {
        return false;
    }

    public final boolean isSupportServer() {
        return true;
    }

    public final List select(Connection conn, String server, long from, long to, long unit) throws SQLException {
        return this.select(conn, ServerLogDB.arrayrize(server), from, to, unit);
    }

    public final List select(Connection conn, String[] servers, long from, long to) throws SQLException {
        List list = null;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        StringBuffer psql = new StringBuffer(SELECT_ALL);
        int position = psql.length();
        ArrayList paramList = new ArrayList();
        this.conditioning(psql, paramList, servers, from, to);
        if (paramList.size() > 0) {
            psql.insert(position, " where ");
        }
        psql.append(this.getOrderBy());
        list = supporter.fetchItems(conn, new RdbmsGeneralQuery(psql.toString(), this.paramList2Array(paramList)));
        return ServerLogFactory.create(list);
    }

    public final List select(Connection conn, String[] servers, long from, long to, long unit) throws SQLException {
        return this.selectType(conn, servers, from, to, unit, 3);
    }

    public final List selectLatest(Connection conn, long from, long before) throws SQLException {
        return this.selectLatest(conn, NULL_SERVERS, from, before);
    }

    public final ServerLog selectLatest(Connection conn, String server, long before) throws SQLException {
        List selectLatest = this.selectLatest(conn, ServerLogDB.arrayrize(server), 0L, before);
        if (selectLatest.isEmpty()) {
            return null;
        }
        return (ServerLog)((Object)selectLatest.get(0));
    }

    public final List selectLatest(Connection conn, String[] serverNames, long from, long before) throws SQLException {
        String[] servers = serverNames;
        if (servers == null || servers.length == 0) {
            servers = ServerLogDB.getServersLoggedBefore(conn, from, before);
        }
        ArrayList<ServerLog> list = new ArrayList<ServerLog>();
        int i = 0;
        while (i < servers.length) {
            ServerLog latest = this.selectLatest1(conn, servers[i], from, before);
            list.add(latest);
            ++i;
        }
        return list;
    }

    public final List selectMax(Connection conn, String server, long from, long to, long unit) throws SQLException {
        return this.selectType(conn, ServerLogDB.arrayrize(server), from, to, unit, 1);
    }

    public final List selectMax(Connection conn, String[] servers, long from, long to, long unit) throws SQLException {
        return this.selectType(conn, servers, from, to, unit, 1);
    }

    public final List selectMin(Connection conn, String server, long from, long to, long unit) throws SQLException {
        return this.selectType(conn, ServerLogDB.arrayrize(server), from, to, unit, 0);
    }

    public final List selectMin(Connection conn, String[] servers, long from, long to, long unit) throws SQLException {
        return this.selectType(conn, servers, from, to, unit, 0);
    }

    public final void setOrderColumn(String orderColumn) {
        this.orderColumn = orderColumn;
    }

    public final void setOrderDirection(boolean orderDirection) {
        this.orderDirection = orderDirection;
    }

    private void checkRange(long from, long to, long unit) {
        if (from < 0L || to < 0L || from > to || unit <= 0L) {
            throw new IllegalArgumentException();
        }
        if (!TimeUtil.isMinuteBased((long)unit)) {
            throw new IllegalArgumentException("Not minutes.");
        }
        if (DateUtil.isMinuteBased((long)to) && DateUtil.isMinuteBased((long)from) && (to - from) % unit != 0L) {
            throw new IllegalArgumentException("Not a dividable unit.");
        }
    }

    private static String[] getServersLoggedBefore(Connection conn, long from, long before) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String sql = "select SERVER from " + TABLE_NAME + " where " + REGISTERED + " >= ? and " + REGISTERED + " < ? " + " group by " + SERVER;
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, new RdbmsColumnParameter[]{new RdbmsDateColumnParameter(REGISTERED, 1, from), new RdbmsDateColumnParameter(REGISTERED, 2, before)});
        List items = supporter.fetchItems(conn, query);
        String[] servers = new String[items.size()];
        int index = 0;
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            RdbmsColumnValue[] values = (RdbmsColumnValue[])iter.next();
            servers[index++] = values[0].getString();
        }
        return servers;
    }

    private final ServerLog selectLatest1(Connection conn, String server, long from, long before) throws SQLException {
        List fetchCriteria;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        StringBuffer psql = new StringBuffer();
        int position = psql.length();
        ArrayList paramList = new ArrayList();
        this.conditioning(psql, paramList, ServerLogDB.arrayrize(server), from, before);
        if (paramList.size() > 0) {
            psql.insert(position, " where ");
        }
        if ((fetchCriteria = supporter.fetchCriteria(conn, new RdbmsPagingQuery(REGISTERED, 1, 1, ALL_COLUMNS, "from " + TABLE_NAME, psql.toString(), null, "order by REGISTERED " + SqlUtil.Order.toString((boolean)false), this.paramList2Array(paramList)))) != null && !fetchCriteria.isEmpty()) {
            return ServerLogFactory.create((RdbmsColumnValue[])fetchCriteria.get(0));
        }
        return null;
    }

    private final List selectType(Connection conn, String[] servers, long from, long to, long unit, int type) throws SQLException {
        StringBuffer ql;
        Object select;
        this.checkRange(from, to, unit);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        boolean isSingleServer = servers != null && servers.length == 1;
        StringBuffer where = new StringBuffer();
        ArrayList paramList = new ArrayList();
        int position = where.length();
        this.conditioning(where, paramList, servers, from, to);
        if (paramList.size() > 0) {
            where.insert(position, " where ");
        }
        String psql = null;
        if (isSingleServer) {
            select = type == 0 ? SELECT_MIN : (type == 1 ? SELECT_MAX : SELECT_STATS);
            ql = new StringBuffer((String)select);
            ql.append(where);
            ql.append(" group by " + ServerLogDB.getBasicUnitColumn(from, to, unit));
            ql.append(this.getOrderBy(REGISTERED, true));
            psql = ql.toString();
        } else if (supporter.isSubquerySupported()) {
            StringBuffer subql = new StringBuffer(SELECT_INTEGRATE);
            subql.append(where);
            subql.append(" group by REGISTERED");
            String sub = " ( " + subql.toString() + " ) " + supporter.getSubqueryAliasIndicator() + " TEMP_INNER ";
            String[] columns = type == 0 ? MIN_COLUMNS : (type == 1 ? MAX_COLUMNS : STATS_COLUMNS);
            String select2 = SqlUtil.generateSelectSql((String)sub, (String[])columns);
            ql = new StringBuffer(select2);
            ql.append(" group by " + ServerLogDB.getBasicUnitColumn(from, to, unit));
            ql.append(this.getOrderBy(REGISTERED, true));
            psql = ql.toString();
        } else {
            StringBuffer subql = new StringBuffer(SELECT_INTEGRATE_WITHOUT_TIME);
            subql.append(where);
            subql.append(" group by REGISTERED");
            subql.append(this.getOrderBy(REGISTERED, true));
            psql = subql.toString();
        }
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(psql, this.paramList2Array(paramList));
        select = ServerLogFactory.createCalculatedTime(IteratorUtil.wrap((Enumeration)supporter.fetchItemsRealTime(conn, query)));
        switch (type) {
            case 0: {
                return ServerLogFactory.min((Iterator)select, this.naming(servers), from, to, unit);
            }
            case 1: {
                return ServerLogFactory.max((Iterator)select, this.naming(servers), from, to, unit);
            }
        }
        return ServerLogFactory.mergeAuto((Iterator)select, this.naming(servers), from, to, unit);
    }

    protected final void conditioning(StringBuffer psql, List paramList, String[] servers, long from, long to) {
        boolean used;
        int parameterIndex = paramList.size() + 1;
        boolean bl = used = parameterIndex > 1;
        if (servers != null && servers.length > 0) {
            used = this.ensureAnd(psql, used);
            this.addServerCondition(psql, servers.length);
            int i = 0;
            while (i < servers.length) {
                paramList.add(new RdbmsStringColumnParameter(SERVER, parameterIndex++, servers[i]));
                ++i;
            }
        }
        if (from >= 0L && to >= 0L) {
            used = this.ensureAnd(psql, used);
            psql.append(" (");
            SqlUtil.appendInclusiveExclusiveBetween((StringBuffer)psql, (String)REGISTERED);
            paramList.add(new RdbmsDateColumnParameter(REGISTERED, parameterIndex++, from));
            paramList.add(new RdbmsDateColumnParameter(REGISTERED, parameterIndex++, to));
            psql.append(") ");
        }
    }

    protected final String getOrderBy() {
        return this.getOrderBy(this.orderColumn, this.orderDirection);
    }

    protected final String getOrderBy(String oc, boolean od) {
        if (oc != null) {
            StringBuilder b = new StringBuilder();
            b.append(" order by ");
            b.append(oc);
            b.append(" ");
            b.append(SqlUtil.Order.toString((boolean)od));
            b.append(" ");
            return b.toString();
        }
        return " ";
    }

    protected String naming(String[] servers) {
        String serverName = servers == null || servers.length == 0 ? "all servers" : (servers.length == 1 ? servers[0] : StringArrayUtil.format((String[])servers, (String)", "));
        return serverName;
    }

    protected final void setup(ServerLog log, PreparedStatement pstmt) throws SQLException {
        int idx = 0;
        pstmt.setString(++idx, log.getServer());
        pstmt.setInt(++idx, (int)log.getDenial());
        pstmt.setInt(++idx, (int)log.getErrors());
        pstmt.setInt(++idx, (int)log.getSpaceUsed());
        pstmt.setInt(++idx, (int)log.getSpaceRemain());
        pstmt.setInt(++idx, (int)log.getCpuUsage());
        pstmt.setInt(++idx, (int)log.getMemoryUsed());
        pstmt.setInt(++idx, (int)log.getSpaceUsedByIr());
        pstmt.setInt(++idx, (int)log.getCpuUsageByIr());
        pstmt.setInt(++idx, (int)log.getMemoryMaxByIr());
        pstmt.setInt(++idx, (int)log.getMemoryTotalByIr());
        pstmt.setInt(++idx, (int)log.getMemoryUsedByIr());
        pstmt.setInt(++idx, (int)log.getConnection());
        pstmt.setInt(++idx, log.getDay());
        pstmt.setInt(++idx, log.getHour());
        pstmt.setInt(++idx, log.getMinute());
        pstmt.setTimestamp(++idx, new Timestamp(log.getRegistered().getTime()));
    }

    public void deserialize(InputStream in) throws IOException {
        this.orderColumn = ByteUtil.readString((InputStream)in);
        this.orderDirection = ByteUtil.readBoolean((InputStream)in);
    }

    public Transmitable getInstance() {
        return instance;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString((OutputStream)out, (String)this.orderColumn);
        ByteUtil.writeBoolean((OutputStream)out, (boolean)this.orderDirection);
    }

    public boolean equals(Object o) {
        if (super.equals(o) && o instanceof ServerLogDB) {
            return StringUtil.equals((String)this.orderColumn, (String)((ServerLogDB)o).orderColumn) && this.orderDirection == ((ServerLogDB)o).orderDirection;
        }
        return false;
    }

    public int hashCode() {
        return (this.orderColumn == null ? 0 : this.orderColumn.hashCode()) ^ (this.orderDirection ? -1 : 0);
    }

    public String toString() {
        return "[orderColumn=" + this.orderColumn + ", orderDirection=" + this.orderDirection + "]";
    }

    public int delete(Connection conn, String[] collections, String[][] profiles, String[] servers, long from, long to) throws SQLException {
        try {
            int n = super.delete(conn, collections, profiles, servers, from, to);
            return n;
        }
        finally {
            OBSERVABLE.setChanged();
            OBSERVABLE.notifyObservers(ServerLogDbConstraint.of(servers, from, to));
        }
    }

    public static final class TYPE {
        public static final int MIN = 0;
        public static final int MAX = 1;
        public static final int AUTO = 3;
    }
}

