/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.db.SqlUtil;
import com.diquest.commons.type.DateUtil;
import com.diquest.commons.type.TimeUtil;
import com.diquest.ir.common.database.entity.StatisticalQueryLog;
import com.diquest.ir.common.database.entity.factory.StatisticalQueryLogFactory;
import com.diquest.ir.common.database.handler.AbstractQueryLogDB;
import com.diquest.ir.common.database.report.cache.CollectionConstraint;
import com.diquest.ir.common.database.report.cache.DateRangeConstraint;
import com.diquest.ir.common.database.report.cache.ProfileConstraint;
import com.diquest.ir.common.database.report.cache.ServerConstraint;
import com.diquest.ir.common.database.report.cache.StatisticalQueryLogDbConstraint;
import com.diquest.ir.common.database.report.cache.StatisticalQueryLogDbObservable;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class StatisticalQueryLogDB
extends AbstractQueryLogDB {
    private static final StatisticalQueryLogDbObservable OBSERVABLE = StatisticalQueryLogDbObservable.getInstance();
    public static final int NUM_RESPONSE_TIME_SLOT = 11;
    private static final String TABLE_NAME = String.valueOf(PROPERTIES.getPrefix()) + "_QUERY_LOG_STATS";
    public static final String COLLECTION = "COLLECTION_ID";
    public static final String PROFILE = "PROFILE";
    public static final String SERVER = "SERVER";
    public static final String REQUESTED = "REQUESTED";
    public static final String RESPONSE_TIME = "RESPONSE_TIME";
    public static final String RESPONSE_TIME_0 = "RESPONSE_TIME_0";
    public static final String RESPONSE_TIME_1 = "RESPONSE_TIME_1";
    public static final String RESPONSE_TIME_2 = "RESPONSE_TIME_2";
    public static final String RESPONSE_TIME_3 = "RESPONSE_TIME_3";
    public static final String RESPONSE_TIME_4 = "RESPONSE_TIME_4";
    public static final String RESPONSE_TIME_5 = "RESPONSE_TIME_5";
    public static final String RESPONSE_TIME_6 = "RESPONSE_TIME_6";
    public static final String RESPONSE_TIME_7 = "RESPONSE_TIME_7";
    public static final String RESPONSE_TIME_8 = "RESPONSE_TIME_8";
    public static final String RESPONSE_TIME_9 = "RESPONSE_TIME_9";
    public static final String RESPONSE_TIME_10 = "RESPONSE_TIME_10";
    public static final String CACHE_HIT = "CACHE_HIT";
    public static final String CACHE_REQUESTED = "CACHE_REQUESTED";
    public static final String REGISTERED = "REGISTERED";
    public static final String DAY = "DAYZ";
    public static final String HOUR = "HOURZ";
    public static final String MINUTE = "MINUTEZ";
    public static final String DURATION = "DURATION";
    private static final String[] ALL_COLUMNS = new String[]{"COLLECTION_ID", "PROFILE", "SERVER", "REQUESTED", "RESPONSE_TIME", "RESPONSE_TIME_0", "RESPONSE_TIME_1", "RESPONSE_TIME_2", "RESPONSE_TIME_3", "RESPONSE_TIME_4", "RESPONSE_TIME_5", "RESPONSE_TIME_6", "RESPONSE_TIME_7", "RESPONSE_TIME_8", "RESPONSE_TIME_9", "RESPONSE_TIME_10", "CACHE_HIT", "CACHE_REQUESTED", "REGISTERED", "DAYZ", "HOURZ", "MINUTEZ", "DURATION"};
    private static final String INSERT = SqlUtil.generateInsertSql((String)TABLE_NAME, (String[])ALL_COLUMNS);
    public static final String SUM_REQUESTED = "SUM_REQUESTED";
    public static final String MIN_REQUESTED = "MIN_REQUESTED";
    public static final String MAX_REQUESTED = "MAX_REQUESTED";
    public static final String SUM_RESPONSE_TIME_0 = "SUM_RT_0";
    public static final String SUM_RESPONSE_TIME_1 = "SUM_RT_1";
    public static final String SUM_RESPONSE_TIME_2 = "SUM_RT_2";
    public static final String SUM_RESPONSE_TIME_3 = "SUM_RT_3";
    public static final String SUM_RESPONSE_TIME_4 = "SUM_RT_4";
    public static final String SUM_RESPONSE_TIME_5 = "SUM_RT_5";
    public static final String SUM_RESPONSE_TIME_6 = "SUM_RT_6";
    public static final String SUM_RESPONSE_TIME_7 = "SUM_RT_7";
    public static final String SUM_RESPONSE_TIME_8 = "SUM_RT_8";
    public static final String SUM_RESPONSE_TIME_9 = "SUM_RT_9";
    public static final String SUM_RESPONSE_TIME_10 = "SUM_RT_10";
    public static final String SUM_CACHE_HIT = "SUM_CACHE_HIT";
    public static final String SUM_CACHE_REQUESTED = "SUM_CACHE_REQUESTED";
    public static final String MIN_REGISTERED = "MIN_REGISTERED";
    public static final String[] MIN_MAX_REQUESTED_COLUMNS = new String[]{"min(REQUESTED) as MIN_REQUESTED", "max(REQUESTED) as MAX_REQUESTED", "DURATION"};
    public static final String[] SUMMED_COLUMNS = new String[]{"sum(REQUESTED) as SUM_REQUESTED", "min(REQUESTED) as MIN_REQUESTED", "max(REQUESTED) as MAX_REQUESTED", "sum(RESPONSE_TIME_0) as SUM_RT_0", "sum(RESPONSE_TIME_1) as SUM_RT_1", "sum(RESPONSE_TIME_2) as SUM_RT_2", "sum(RESPONSE_TIME_3) as SUM_RT_3", "sum(RESPONSE_TIME_4) as SUM_RT_4", "sum(RESPONSE_TIME_5) as SUM_RT_5", "sum(RESPONSE_TIME_6) as SUM_RT_6", "sum(RESPONSE_TIME_7) as SUM_RT_7", "sum(RESPONSE_TIME_8) as SUM_RT_8", "sum(RESPONSE_TIME_9) as SUM_RT_9", "sum(RESPONSE_TIME_10) as SUM_RT_10", "sum(CACHE_HIT) as SUM_CACHE_HIT", "sum(CACHE_REQUESTED) as SUM_CACHE_REQUESTED", "REGISTERED"};
    public static final String[] WEIGHTED_AVERAGE_COLUMNS = new String[]{"REQUESTED", "RESPONSE_TIME", "RESPONSE_TIME_0", "RESPONSE_TIME_1", "RESPONSE_TIME_2", "RESPONSE_TIME_3", "RESPONSE_TIME_4", "RESPONSE_TIME_5", "RESPONSE_TIME_6", "RESPONSE_TIME_7", "RESPONSE_TIME_8", "RESPONSE_TIME_9", "RESPONSE_TIME_10", "CACHE_HIT", "CACHE_REQUESTED", "REGISTERED", "DURATION"};
    public static final String[] APPROX_COLUMNS = new String[]{"sum(REQUESTED) as SUM_REQUESTED", "sum(REQUESTED*RESPONSE_TIME) as RESPONSE_TIME", "sum(RESPONSE_TIME_0) as SUM_RT_0", "sum(RESPONSE_TIME_1) as SUM_RT_1", "sum(RESPONSE_TIME_2) as SUM_RT_2", "sum(RESPONSE_TIME_3) as SUM_RT_3", "sum(RESPONSE_TIME_4) as SUM_RT_4", "sum(RESPONSE_TIME_5) as SUM_RT_5", "sum(RESPONSE_TIME_6) as SUM_RT_6", "sum(RESPONSE_TIME_7) as SUM_RT_7", "sum(RESPONSE_TIME_8) as SUM_RT_8", "sum(RESPONSE_TIME_9) as SUM_RT_9", "sum(RESPONSE_TIME_10) as SUM_RT_10", "sum(CACHE_HIT) as SUM_CACHE_HIT", "sum(CACHE_REQUESTED) as SUM_CACHE_REQUESTED", "min(REGISTERED) as REGISTERED", "avg(DURATION) as DURATION"};
    private static final String MIN_MAX_REQUESTED_SELECT = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])MIN_MAX_REQUESTED_COLUMNS);
    private static final String WEIGHTED_AVERAGE_SELECT = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])WEIGHTED_AVERAGE_COLUMNS);
    private static final String APPROX_SELECT = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])APPROX_COLUMNS);
    private static final String TOTAL_REQUESTED_SELECT = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])new String[]{"sum(REQUESTED) as SUM_REQUESTED"});
    private static final String AVERAGE_RESPONSE_TIME_SELECT = SqlUtil.generateSelectSql((String)TABLE_NAME, (String[])new String[]{"sum(REQUESTED)", "sum(RESPONSE_TIME*REQUESTED)"});

    public final String getTableName() {
        return TABLE_NAME;
    }

    public final boolean isSupportServer() {
        return true;
    }

    public int insert(Connection conn, Enumeration logs) throws SQLException {
        StatisticalQueryLogDbConstraint constraint = null;
        PreparedStatement pstmt = conn.prepareStatement(INSERT);
        try {
            int cnt = 0;
            while (logs.hasMoreElements()) {
                StatisticalQueryLog log = (StatisticalQueryLog)logs.nextElement();
                int idx = 0;
                pstmt.setString(++idx, log.getCollection());
                pstmt.setString(++idx, log.getProfile());
                pstmt.setString(++idx, log.getServer());
                pstmt.setInt(++idx, (int)log.getRequested());
                pstmt.setInt(++idx, (int)log.getResponseTime());
                pstmt.setInt(++idx, (int)log.getResponseTime0());
                pstmt.setInt(++idx, (int)log.getResponseTime1());
                pstmt.setInt(++idx, (int)log.getResponseTime2());
                pstmt.setInt(++idx, (int)log.getResponseTime3());
                pstmt.setInt(++idx, (int)log.getResponseTime4());
                pstmt.setInt(++idx, (int)log.getResponseTime5());
                pstmt.setInt(++idx, (int)log.getResponseTime6());
                pstmt.setInt(++idx, (int)log.getResponseTime7());
                pstmt.setInt(++idx, (int)log.getResponseTime8());
                pstmt.setInt(++idx, (int)log.getResponseTime9());
                pstmt.setInt(++idx, (int)log.getResponseTime10());
                pstmt.setInt(++idx, (int)log.getCacheHit());
                pstmt.setInt(++idx, (int)log.getCacheRequested());
                pstmt.setTimestamp(++idx, new Timestamp(log.getRegistered()));
                pstmt.setInt(++idx, log.getDay());
                pstmt.setInt(++idx, log.getHour());
                pstmt.setInt(++idx, log.getMinute());
                pstmt.setLong(++idx, log.getDuration());
                cnt += pstmt.executeUpdate();
                StatisticalQueryLogDbConstraint cons = new StatisticalQueryLogDbConstraint();
                cons.put("collection", new CollectionConstraint(log.getCollection()));
                cons.put("server", new ServerConstraint(log.getServer()));
                cons.put("profile", new ProfileConstraint(String.valueOf(log.getCollection()) + "." + log.getProfile()));
                cons.put("date", new DateRangeConstraint(log.getRegistered(), log.getRegistered() + log.getDuration()));
                if (constraint == null) {
                    constraint = cons;
                    continue;
                }
                constraint.merge(cons);
            }
            int n = cnt;
            return n;
        }
        finally {
            pstmt.close();
            if (constraint != null) {
                OBSERVABLE.setChanged();
                OBSERVABLE.notifyObservers(constraint);
            }
        }
    }

    public double[] getMinMaxRequestedPerSecond(Connection conn, String[] collections, String[][] profiles, String[] servers, long from, long to) throws SQLException {
        double[] minMax = new double[2];
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        StringBuffer psql = new StringBuffer(MIN_MAX_REQUESTED_SELECT);
        int position = psql.length();
        ArrayList paramList = new ArrayList();
        this.conditioning(psql, paramList, collections, profiles, servers, from, to);
        if (!paramList.isEmpty()) {
            psql.insert(position, " where ");
        }
        psql.append(" group by DURATION");
        List fetchItems = supporter.fetchItems(conn, new RdbmsGeneralQuery(psql.toString(), this.paramList2Array(paramList)));
        Iterator iter = fetchItems.iterator();
        while (iter.hasNext()) {
            RdbmsColumnValue[] item = (RdbmsColumnValue[])iter.next();
            double duration = item[2].getDouble();
            double min = item[0].getDouble() / (duration / 1000.0);
            double max = item[1].getDouble() / (duration / 1000.0);
            if (min < minMax[0]) {
                minMax[0] = min;
            }
            if (!(max > minMax[0])) continue;
            minMax[1] = max;
        }
        return minMax;
    }

    public List select(Connection conn, String[] collections, String[][] profiles, String[] servers, long from, long to, long units) throws SQLException {
        if (units % 60000L != 0L) {
            throw new IllegalArgumentException();
        }
        Iterator logs = this.select(conn, collections, profiles, servers, from, to);
        return StatisticalQueryLogFactory.merge(logs, from, to, units);
    }

    public long getRequested(Connection conn, String[] collections, String[][] profiles, String[] servers, long from, long to) throws SQLException {
        RdbmsColumnValue[] fetchItem;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        StringBuffer psql = new StringBuffer(TOTAL_REQUESTED_SELECT);
        int position = psql.length();
        ArrayList paramList = new ArrayList();
        this.conditioning(psql, paramList, collections, profiles, servers, from, to);
        if (!paramList.isEmpty()) {
            psql.insert(position, " where ");
        }
        if ((fetchItem = supporter.fetchItem(conn, new RdbmsGeneralQuery(psql.toString(), this.paramList2Array(paramList)))) != null && fetchItem.length > 0 && fetchItem[0] != null) {
            return fetchItem[0].getLong();
        }
        return 0L;
    }

    public double getAverageResponseTime(Connection conn, String[] collections, String[][] profiles, String[] servers, long from, long to) throws SQLException {
        RdbmsColumnValue[] fetchItem;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        StringBuffer psql = new StringBuffer(AVERAGE_RESPONSE_TIME_SELECT);
        int position = psql.length();
        ArrayList paramList = new ArrayList();
        this.conditioning(psql, paramList, collections, profiles, servers, from, to);
        if (!paramList.isEmpty()) {
            psql.insert(position, " where ");
        }
        if ((fetchItem = supporter.fetchItem(conn, new RdbmsGeneralQuery(psql.toString(), this.paramList2Array(paramList)))) != null && fetchItem.length == 2 && fetchItem[0] != null && fetchItem[1] != null) {
            double requested = fetchItem[0].getDouble();
            double weightedResponseTime = fetchItem[1].getDouble();
            if (requested == 0.0) {
                return weightedResponseTime;
            }
            return weightedResponseTime / requested;
        }
        return 0.0;
    }

    protected double[] getMinMaxRequested(Connection conn, String[] collections, String[][] profiles, String[] servers, long from, long to) throws SQLException {
        StringBuffer where = new StringBuffer();
        int position = where.length();
        ArrayList<RdbmsIntColumnParameter> paramList = new ArrayList<RdbmsIntColumnParameter>();
        where.insert(position, " where REQUESTED<>? ");
        paramList.add(new RdbmsIntColumnParameter(REQUESTED, 1, 0));
        this.conditioning(where, paramList, collections, profiles, servers, from, to);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String inner = "select sum(REQUESTED)/(avg(DURATION)/1000) as REQUESTED from " + TABLE_NAME + where.toString() + " group by " + REGISTERED;
        String query = "select min(REQUESTED), max(REQUESTED) from (" + inner + ") " + supporter.getSubqueryAliasIndicator() + " TEMP_INNER";
        if (supporter.isSubquerySupported()) {
            RdbmsColumnValue[] fetchItem = supporter.fetchItem(conn, new RdbmsGeneralQuery(query, this.paramList2Array(paramList)));
            if (fetchItem != null && fetchItem.length == 2 && fetchItem[0] != null) {
                return new double[]{fetchItem[0].getDouble(), fetchItem[1].getDouble()};
            }
            return new double[]{0.0, 0.0};
        }
        Enumeration items = supporter.fetchItemsRealTime(conn, new RdbmsGeneralQuery(inner, this.paramList2Array(paramList)));
        return this.getMinMaxFromEnumeration(items);
    }

    protected double[] getMinMaxResponseTime(Connection conn, String[] collections, String[][] profiles, String[] servers, long from, long to) throws SQLException {
        StringBuffer where = new StringBuffer();
        int position = where.length();
        ArrayList<RdbmsIntColumnParameter> paramList = new ArrayList<RdbmsIntColumnParameter>();
        SqlUtil.appendOperation((StringBuffer)where, (String)REQUESTED, (String)" > ");
        paramList.add(new RdbmsIntColumnParameter(REQUESTED, 1, 0));
        this.conditioning(where, paramList, collections, profiles, servers, from, to);
        if (!paramList.isEmpty()) {
            where.insert(position, " where ");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String inner = "select sum(REQUESTED)/(avg(DURATION)/1000) as REQUESTED, sum(REQUESTED*RESPONSE_TIME)/sum(REQUESTED) as RESPONSE_TIME  from " + TABLE_NAME + where.toString() + " group by " + REGISTERED;
        String query = "select min(RESPONSE_TIME), max(RESPONSE_TIME) from (" + inner + ") " + supporter.getSubqueryAliasIndicator() + " TEMP_INNER";
        if (supporter.isSubquerySupported()) {
            RdbmsColumnValue[] fetchItem = supporter.fetchItem(conn, new RdbmsGeneralQuery(query, this.paramList2Array(paramList)));
            if (fetchItem != null && fetchItem.length == 2 && fetchItem[0] != null) {
                return new double[]{fetchItem[0].getDouble(), fetchItem[1].getDouble()};
            }
            return new double[]{0.0, 0.0};
        }
        Enumeration items = supporter.fetchItemsRealTime(conn, new RdbmsGeneralQuery(inner, this.paramList2Array(paramList)));
        return this.getMinMaxFromEnumeration(items);
    }

    private double[] getMinMaxFromEnumeration(Enumeration items) {
        RdbmsColumnValue[] item;
        double max = 0.0;
        double min = 0.0;
        if (items.hasMoreElements()) {
            item = (RdbmsColumnValue[])items.nextElement();
            min = max = item[0].getDouble();
        }
        while (items.hasMoreElements()) {
            item = (RdbmsColumnValue[])items.nextElement();
            double value = item[0].getDouble();
            if (max < value) {
                max = value;
                continue;
            }
            if (!(min > value)) continue;
            min = value;
        }
        return new double[]{min, max};
    }

    private static String getBasicUnitColumn(long from, long to, long unit) {
        if (TimeUtil.isDayBased((long)unit) && DateUtil.isDayBased((long)from) && DateUtil.isDayBased((long)to)) {
            return DAY;
        }
        if (TimeUtil.isHourBased((long)unit) && DateUtil.isHourBased((long)from) && DateUtil.isHourBased((long)to)) {
            return HOUR;
        }
        return MINUTE;
    }

    protected final Iterator selectApprox(Connection conn, String[] collections, String[][] profiles, String[] servers, long from, long to, long unit) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        StringBuffer psql = new StringBuffer(APPROX_SELECT);
        int position = psql.length();
        ArrayList paramList = new ArrayList();
        this.conditioning(psql, paramList, collections, profiles, servers, from, to);
        if (!paramList.isEmpty()) {
            psql.insert(position, " where ");
        }
        psql.append(" group by ").append(StatisticalQueryLogDB.getBasicUnitColumn(from, to, unit));
        psql.append(" order by ").append(REGISTERED).append(" asc");
        final Enumeration realTimeItems = supporter.fetchItemsRealTime(conn, new RdbmsGeneralQuery(psql.toString(), this.paramList2Array(paramList)));
        return new Iterator(){

            public boolean hasNext() {
                return realTimeItems.hasMoreElements();
            }

            public Object next() {
                StatisticalQueryLog media = StatisticalQueryLogFactory.create((RdbmsColumnValue[])realTimeItems.nextElement());
                if (media.getRequested() != 0.0) {
                    media.setResponseTime(media.getResponseTime() / media.getRequested());
                }
                return media;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected final Iterator select(Connection conn, String[] collections, String[][] profiles, String[] servers, long from, long to) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        StringBuffer psql = new StringBuffer(WEIGHTED_AVERAGE_SELECT);
        int position = psql.length();
        ArrayList paramList = new ArrayList();
        this.conditioning(psql, paramList, collections, profiles, servers, from, to);
        if (!paramList.isEmpty()) {
            psql.insert(position, " where ");
        }
        psql.append(" order by ").append(REGISTERED).append(" asc");
        final Enumeration realTimeItems = supporter.fetchItemsRealTime(conn, new RdbmsGeneralQuery(psql.toString(), this.paramList2Array(paramList)));
        return new Iterator(){

            public boolean hasNext() {
                return realTimeItems.hasMoreElements();
            }

            public Object next() {
                return StatisticalQueryLogFactory.create((RdbmsColumnValue[])realTimeItems.nextElement());
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected final void conditioning(StringBuffer psql, List paramList, String[] collections, String[][] profiles, String[] servers, long from, long to) {
        int i;
        boolean collectionWithProfile;
        int parameterIndex = paramList.size() + 1;
        boolean used = parameterIndex > 1;
        boolean bl = collectionWithProfile = collections != null && collections.length > 0 && profiles != null && profiles.length > 0;
        if (collectionWithProfile) {
            used = this.ensureAnd(psql, used);
            psql.append(" ( ");
            this.addCollectionCondition(psql, collections.length);
            i = 0;
            while (i < collections.length) {
                paramList.add(new RdbmsStringColumnParameter(COLLECTION, parameterIndex++, collections[i]));
                ++i;
            }
            psql.append(" or ");
            this.addCollectionAndProfileCondition(psql, profiles);
            i = 0;
            while (i < profiles.length) {
                if (profiles[i].length == 1) {
                    paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                } else if (profiles[i].length == 2) {
                    paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                    paramList.add(new RdbmsStringColumnParameter(this.getProfileColumnName(), parameterIndex++, profiles[i][1]));
                } else {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            psql.append(" ) ");
        } else {
            if (collections != null && collections.length > 0) {
                used = this.ensureAnd(psql, used);
                this.addCollectionCondition(psql, collections.length);
                i = 0;
                while (i < collections.length) {
                    paramList.add(new RdbmsStringColumnParameter(COLLECTION, parameterIndex++, collections[i]));
                    ++i;
                }
            }
            if (profiles != null && profiles.length > 0) {
                used = this.ensureAnd(psql, used);
                this.addCollectionAndProfileCondition(psql, profiles);
                i = 0;
                while (i < profiles.length) {
                    if (profiles[i].length == 1) {
                        paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                    } else if (profiles[i].length == 2) {
                        paramList.add(new RdbmsStringColumnParameter(this.getCollectionColumnName(), parameterIndex++, profiles[i][0]));
                        paramList.add(new RdbmsStringColumnParameter(this.getProfileColumnName(), parameterIndex++, profiles[i][1]));
                    } else {
                        throw new IllegalArgumentException();
                    }
                    ++i;
                }
            }
        }
        if (servers != null && servers.length > 0) {
            used = this.ensureAnd(psql, used);
            this.addServerCondition(psql, servers.length);
            i = 0;
            while (i < servers.length) {
                paramList.add(new RdbmsStringColumnParameter(SERVER, parameterIndex++, servers[i]));
                ++i;
            }
        }
        if (from >= 0L && to >= 0L) {
            used = this.ensureAnd(psql, used);
            this.addBoundCondition(psql);
            paramList.add(new RdbmsDateColumnParameter(REGISTERED, parameterIndex++, from));
            paramList.add(new RdbmsDateColumnParameter(REGISTERED, parameterIndex++, to));
        }
    }

    public static double getAverageResponseTime(List logs) {
        return StatisticalQueryLogDB.getAverageResponseTime(logs.iterator());
    }

    public static double getAverageResponseTime(Iterator logs) {
        StatisticalQueryLog dummy = new StatisticalQueryLog();
        dummy.merge(logs);
        return dummy.getResponseTime();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof StatisticalQueryLogDB) {
            return super.equals(o);
        }
        return false;
    }

    public Transmitable getInstance() {
        return new StatisticalQueryLogDB();
    }

    public Inserter getInserter() {
        return new Inserter();
    }

    public void onRemove(String collection) throws IRException {
        try {
            super.onRemove(collection);
        }
        finally {
            OBSERVABLE.setChanged();
            StatisticalQueryLogDbConstraint cons = new StatisticalQueryLogDbConstraint();
            cons.put("collection", new CollectionConstraint(collection));
            OBSERVABLE.notifyObservers(cons);
        }
    }

    public int delete(Connection conn, String[] collections, String[][] profiles, String[] servers, long from, long to) throws SQLException {
        try {
            int n = super.delete(conn, collections, profiles, servers, from, to);
            return n;
        }
        finally {
            OBSERVABLE.setChanged();
            OBSERVABLE.notifyObservers(StatisticalQueryLogDbConstraint.of(collections, profiles, servers, from, to));
        }
    }

    public class Inserter {
        PreparedStatement pstmt;
        StatisticalQueryLogDbConstraint constraint = null;

        Inserter() {
        }

        public void open(Connection conn) throws SQLException {
            this.close();
            this.pstmt = conn.prepareStatement(INSERT);
        }

        public synchronized void push(StatisticalQueryLog log) throws SQLException {
            int idx = 0;
            this.pstmt.setString(++idx, log.getCollection());
            this.pstmt.setString(++idx, log.getProfile());
            this.pstmt.setString(++idx, log.getServer());
            this.pstmt.setInt(++idx, (int)log.getRequested());
            this.pstmt.setInt(++idx, (int)log.getResponseTime());
            this.pstmt.setInt(++idx, (int)log.getResponseTime0());
            this.pstmt.setInt(++idx, (int)log.getResponseTime1());
            this.pstmt.setInt(++idx, (int)log.getResponseTime2());
            this.pstmt.setInt(++idx, (int)log.getResponseTime3());
            this.pstmt.setInt(++idx, (int)log.getResponseTime4());
            this.pstmt.setInt(++idx, (int)log.getResponseTime5());
            this.pstmt.setInt(++idx, (int)log.getResponseTime6());
            this.pstmt.setInt(++idx, (int)log.getResponseTime7());
            this.pstmt.setInt(++idx, (int)log.getResponseTime8());
            this.pstmt.setInt(++idx, (int)log.getResponseTime9());
            this.pstmt.setInt(++idx, (int)log.getResponseTime10());
            this.pstmt.setInt(++idx, (int)log.getCacheHit());
            this.pstmt.setInt(++idx, (int)log.getCacheRequested());
            this.pstmt.setTimestamp(++idx, new Timestamp(log.getRegistered()));
            this.pstmt.setInt(++idx, log.getDay());
            this.pstmt.setInt(++idx, log.getHour());
            this.pstmt.setInt(++idx, log.getMinute());
            this.pstmt.setLong(++idx, log.getDuration());
            this.pstmt.executeUpdate();
            StatisticalQueryLogDbConstraint cons = new StatisticalQueryLogDbConstraint();
            cons.put("collection", new CollectionConstraint(log.getCollection()));
            cons.put("server", new ServerConstraint(log.getServer()));
            cons.put("profile", new ProfileConstraint(String.valueOf(log.getCollection()) + "." + log.getProfile()));
            cons.put("date", new DateRangeConstraint(log.getRegistered(), log.getRegistered() + log.getDuration()));
            if (this.constraint == null) {
                this.constraint = cons;
            } else {
                this.constraint.merge(cons);
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        public void close() {
            try {
                if (this.constraint != null) {
                    OBSERVABLE.setChanged();
                    OBSERVABLE.notifyObservers(this.constraint);
                    this.constraint = null;
                }
            }
            finally {
                ConnectionFactory.release((PreparedStatement)this.pstmt);
                this.pstmt = null;
            }
        }
    }
}

