/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.profile.TestQuery;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.protocol.query.Query;
import com.diquest.ir.common.msg.protocol.query.QueryParser;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsBinaryStreamColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsCharStreamColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class TestQueryDB
implements CollectionObservable {
    public static final TestQueryDB instance = new TestQueryDB();
    protected static RdbmsProperties properties = RdbmsPropertiesFactory.load();
    protected static final String PREFIX = properties.getPrefix();
    public static final String EMPTY = "*";
    private static final String EMPTY_STRING = "";
    public static final String ORDER_QUERY_ID_ASC = " ORDER BY QUERY_ID ASC";
    public static final String ORDER_QUERY_ID_DESC = " ORDER BY QUERY_ID DESC";
    public static final String ORDER_COLLECTION_ID_ASC = " ORDER BY COLLECTION_ID ASC";
    public static final String ORDER_COLLECTION_ID_DESC = " ORDER BY COLLECTION_ID DESC";
    public static final String ORDER_REGDATE_ASC = " ORDER BY REG_DATE ASC";
    public static final String ORDER_REGDATE_DESC = " ORDER BY REG_DATE DESC";
    static final String TABLE = String.valueOf(PREFIX) + "_TEST_QUERY";
    static final String SQL_INSERT_QUERY = " INSERT INTO " + TABLE + " (COLLECTION_ID, QUERY_ID, TITLE, SUMMARY, THUMBNAIL, DISPLAY_REMOVED, QUERY, REG_DATE) " + "VALUES ( ?, ?, ?, ?, ?, ?, ?, ?  ) ";
    static final String SQL_UPDATE_QUERY = " UPDATE " + TABLE + " SET TITLE=?, SUMMARY=?, THUMBNAIL=?, DISPLAY_REMOVED=?, QUERY=?, REG_DATE=? " + " WHERE COLLECTION_ID = ? AND QUERY_ID = ? ";
    static final String SQL_SELECT_QUERY = " SELECT COLLECTION_ID, QUERY_ID, TITLE, SUMMARY, THUMBNAIL, DISPLAY_REMOVED, QUERY, REG_DATE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND QUERY_ID = ?";
    static final String SQL_SELECT_QUERY_COLLECTION = " SELECT COLLECTION_ID, QUERY_ID, TITLE, SUMMARY, THUMBNAIL, DISPLAY_REMOVED, QUERY, REG_DATE FROM " + TABLE + " WHERE COLLECTION_ID = ?";
    static final String SQL_SELECT_QUERY_ALL = " SELECT COLLECTION_ID, QUERY_ID, TITLE, SUMMARY, THUMBNAIL, DISPLAY_REMOVED, QUERY, REG_DATE FROM " + TABLE;
    static final String SQL_SELECT_QUERY_ID_COLLECTION = " SELECT QUERY_ID FROM " + TABLE + " WHERE COLLECTION_ID = ?";
    static final String SQL_SELECT_QUERY_ID_ALL = " SELECT COLLECTION_ID, QUERY_ID FROM " + TABLE;
    static final String SQL_DELETE = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND QUERY_ID = ? ";
    static final String SQL_DELETE_COLLECTION = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? ";
    static final String SQL_DELETE_ALL = " DELETE FROM " + TABLE;
    static final boolean USE_CLOB;

    static {
        String property = properties.getProperty("ir.db.useclob");
        USE_CLOB = property == null ? false : Boolean.valueOf(property);
    }

    public static void put(Connection conn, String collectionID, String queryID, String title, String summary, String thumbNail, boolean displayRemoved, Query query) throws SQLException, IOException {
        if (StringUtil.isEmpty((String)title)) {
            title = EMPTY_STRING;
        }
        if (StringUtil.isEmpty((String)summary)) {
            summary = EMPTY_STRING;
        }
        if (StringUtil.isEmpty((String)thumbNail)) {
            thumbNail = EMPTY_STRING;
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        query.serialize(baos);
        Timestamp regDate = new Timestamp(System.currentTimeMillis());
        RdbmsColumnParameter[] parameters = null;
        if (!USE_CLOB) {
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("QUERY_ID", 2, queryID), new RdbmsStringColumnParameter("TITLE", 3, title), new RdbmsStringColumnParameter("SUMMARY", 4, summary), new RdbmsStringColumnParameter("THUMBNAIL", 5, thumbNail), new RdbmsIntColumnParameter("DISPLAY_REMOVED", 6, displayRemoved ? 1 : 0), new RdbmsBinaryStreamColumnParameter("QUERY", 7, baos.toByteArray()), new RdbmsDateColumnParameter("REG_DATE", 8, regDate)};
        } else {
            byte[] b = baos.toByteArray();
            String sQuery = ByteUtil.byteArrayToHex((byte[])b);
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("QUERY_ID", 2, queryID), new RdbmsStringColumnParameter("TITLE", 3, title), new RdbmsStringColumnParameter("SUMMARY", 4, summary), new RdbmsStringColumnParameter("THUMBNAIL", 5, thumbNail), new RdbmsIntColumnParameter("DISPLAY_REMOVED", 6, displayRemoved ? 1 : 0), new RdbmsCharStreamColumnParameter("QUERY", 7, sQuery.toCharArray()), new RdbmsDateColumnParameter("REG_DATE", 8, regDate)};
        }
        RdbmsGeneralQuery q = new RdbmsGeneralQuery(SQL_INSERT_QUERY, parameters);
        supporter.executeUpdate(conn, q);
    }

    public static void put(Connection conn, String collectionID, String title, String summary, String thumbNail, boolean displayRemoved, String queryID, String queryString) throws IRException, SQLException, IOException {
        QueryParser queryParser = new QueryParser();
        Query query = queryParser.parseQuery(queryString);
        TestQueryDB.put(conn, collectionID, queryID, title, summary, thumbNail, displayRemoved, query);
    }

    public static void put(Connection conn, TestQuery query) throws SQLException, IOException {
        TestQueryDB.put(conn, query.getCollectionID(), query.getQueryID(), query.getTitle(), query.getSummary(), query.getThumbNail(), query.isDisplayRemoved(), query.getQuery());
    }

    public static void update(Connection conn, String collectionID, String queryID, String title, String summary, String thumbNail, boolean displayRemoved, Query query) throws SQLException, IOException {
        if (StringUtil.isEmpty((String)title)) {
            title = EMPTY_STRING;
        }
        if (StringUtil.isEmpty((String)summary)) {
            summary = EMPTY_STRING;
        }
        if (StringUtil.isEmpty((String)thumbNail)) {
            thumbNail = EMPTY_STRING;
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        query.serialize(baos);
        Timestamp regDate = new Timestamp(System.currentTimeMillis());
        RdbmsColumnParameter[] parameters = null;
        if (!USE_CLOB) {
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("TITLE", 1, title), new RdbmsStringColumnParameter("SUMMARY", 2, summary), new RdbmsStringColumnParameter("THUMBNAIL", 3, thumbNail), new RdbmsIntColumnParameter("DISPLAY_REMOVED", 4, displayRemoved ? 1 : 0), new RdbmsBinaryStreamColumnParameter("QUERY", 5, baos.toByteArray()), new RdbmsDateColumnParameter("REG_DATE", 6, regDate), new RdbmsStringColumnParameter("COLLECTION_ID", 7, collectionID), new RdbmsStringColumnParameter("QUERY_ID", 8, queryID)};
        } else {
            byte[] b = baos.toByteArray();
            String sQuery = ByteUtil.byteArrayToHex((byte[])b);
            parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("TITLE", 1, title), new RdbmsStringColumnParameter("SUMMARY", 2, summary), new RdbmsStringColumnParameter("THUMBNAIL", 3, thumbNail), new RdbmsIntColumnParameter("DISPLAY_REMOVED", 4, displayRemoved ? 1 : 0), new RdbmsCharStreamColumnParameter("QUERY", 5, sQuery.toCharArray()), new RdbmsDateColumnParameter("REG_DATE", 6, regDate), new RdbmsStringColumnParameter("COLLECTION_ID", 7, collectionID), new RdbmsStringColumnParameter("QUERY_ID", 8, queryID)};
        }
        RdbmsGeneralQuery q = new RdbmsGeneralQuery(SQL_UPDATE_QUERY, parameters);
        supporter.executeUpdate(conn, q);
    }

    public static void update(Connection conn, String collectionID, String queryID, String title, String summary, String thumbNail, boolean displayRemoved, String queryString) throws IRException, SQLException, IOException {
        QueryParser queryParser = new QueryParser();
        Query query = queryParser.parseQuery(queryString);
        TestQueryDB.update(conn, collectionID, queryID, title, summary, thumbNail, displayRemoved, query);
    }

    public static void update(Connection conn, TestQuery query) throws SQLException, IOException {
        TestQueryDB.update(conn, query.getCollectionID(), query.getQueryID(), query.getTitle(), query.getSummary(), query.getThumbNail(), query.isDisplayRemoved(), query.getQuery());
    }

    public static TestQuery get(Connection conn, String collectionID, String queryID) throws IOException, SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = EMPTY;
        }
        if (StringUtil.isEmpty((String)queryID)) {
            throw new SQLException("queryID is null.");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("QUERY_ID", 2, queryID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_QUERY, parameters);
        RdbmsColumnValue[] native_row = supporter.fetchItem(conn, query);
        return TestQuery.create(native_row);
    }

    public static TestQuery[] getList(Connection conn, String collectionID, String order) throws SQLException, IOException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = EMPTY;
        }
        if (StringUtil.isEmpty((String)order)) {
            order = EMPTY_STRING;
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_QUERY_COLLECTION) + order, parameters);
        List native_row = supporter.fetchItems(conn, query);
        return TestQuery.create(native_row);
    }

    public static TestQuery[] getList(Connection conn, String order) throws SQLException, IOException {
        if (StringUtil.isEmpty((String)order)) {
            order = EMPTY_STRING;
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_QUERY_ALL) + order);
        List native_row = supporter.fetchItems(conn, query);
        return TestQuery.create(native_row);
    }

    public static String[] getListQueryID(Connection conn, String collectionID, String order) throws SQLException, IOException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = EMPTY;
        }
        if (StringUtil.isEmpty((String)order)) {
            order = EMPTY_STRING;
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_QUERY_ID_COLLECTION) + order, parameters);
        List native_row = supporter.fetchItems(conn, query);
        String[] queryIDs = new String[native_row.size()];
        int i = 0;
        while (i < native_row.size()) {
            queryIDs[i] = ((RdbmsColumnValue[])native_row.get(i))[0].toString();
            ++i;
        }
        return queryIDs;
    }

    public static String[] getListQueryID(Connection conn, String order) throws SQLException, IOException {
        if (StringUtil.isEmpty((String)order)) {
            order = EMPTY_STRING;
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_QUERY_ID_ALL) + order);
        List native_row = supporter.fetchItems(conn, query);
        String[] queryIDs = new String[native_row.size()];
        int i = 0;
        while (i < native_row.size()) {
            queryIDs[i] = ((RdbmsColumnValue[])native_row.get(i))[0].toString();
            ++i;
        }
        return queryIDs;
    }

    public static void delete(Connection conn, String collectionID, String queryID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("QUERY_ID", 2, queryID)};
        RdbmsGeneralQuery q = new RdbmsGeneralQuery(SQL_DELETE, parameters);
        supporter.executeUpdate(conn, q);
    }

    public static void delete(Connection conn, String collectionID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
        RdbmsGeneralQuery q = new RdbmsGeneralQuery(SQL_DELETE_COLLECTION, parameters);
        supporter.executeUpdate(conn, q);
    }

    public static void deleteAll(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery q = new RdbmsGeneralQuery(SQL_DELETE_ALL);
        supporter.executeUpdate(conn, q);
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                TestQueryDB.delete(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }
}

