/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.db.SqlUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.TrendsDelete;
import com.diquest.ir.common.database.entity.factory.TrendsDeleteFactory;
import com.diquest.ir.common.database.handler.AbstractGeneralDB;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class TrendsDeleteDB
extends AbstractGeneralDB {
    private static final String TRENDS_DELETE = "TRENDS_DELETE";
    private static final RdbmsProperties PROPERTIES = RdbmsPropertiesFactory.load();
    private static final String TABLE = String.valueOf(PROPERTIES.getPrefix()) + "_" + "TRENDS_DELETE";
    private static final String NAME = "TRENDS_ID";
    private static final String KEYWORD = "KEYWORD";
    private static final String[] ALL = new String[]{"TRENDS_ID", "KEYWORD"};
    private static final String INSERT_SQL = SqlUtil.generateInsertSql((String)TABLE, (String[])ALL);
    private static final String SELECT_NAME_SQL = String.valueOf(SqlUtil.generateSelectSql((String)TABLE, (String[])ALL)) + " WHERE " + "TRENDS_ID" + "=? ";
    private static final String SELECT_SINGLE_SQL = String.valueOf(SELECT_NAME_SQL) + " and " + "KEYWORD" + "=? ";
    private static final String SELECT_NAME_KEYWORD_SQL = String.valueOf(SELECT_NAME_SQL) + " and " + "KEYWORD" + " like ? ";
    private static final String DELETE_NAME_SQL = "DELETE FROM " + TABLE + " where " + "TRENDS_ID" + "=? ";
    private static final String DELETE_SINGLE_SQL = String.valueOf(DELETE_NAME_SQL) + " and " + "KEYWORD" + "=? ";

    public TrendsDeleteDB() {
        this.setOrderColumn(KEYWORD);
        this.setOrderDirection(true);
    }

    public int insert(Connection conn, TrendsDelete row) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = TrendsDeleteDB.parameterize(row);
        String sql = INSERT_SQL;
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, parameters);
        int count = supporter.executeUpdate(conn, rdbmsGeneralQuery);
        return count;
    }

    public TrendsDelete select(Connection conn, TrendsDelete row) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = TrendsDeleteDB.parameterize(row);
        String sql = SELECT_SINGLE_SQL;
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, parameters);
        return TrendsDeleteFactory.create(supporter.fetchItem(conn, rdbmsGeneralQuery));
    }

    public List selectGlobal(Connection conn) throws SQLException {
        return this.select(conn, "*");
    }

    public List select(Connection conn, String name) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        if (this.isPageable()) {
            RdbmsPagingQuery query = new RdbmsPagingQuery(KEYWORD, this.getOffset(), this.getLimit(), ALL, new String[]{TABLE}, new String[]{this.getOrderBy()}, null, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)});
            return TrendsDeleteFactory.create(supporter.fetchCriteria(conn, query));
        }
        String sql = String.valueOf(SELECT_NAME_SQL) + this.getOrderBy();
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)};
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, parameters);
        return TrendsDeleteFactory.create(supporter.fetchItems(conn, rdbmsGeneralQuery));
    }

    public List select(Connection conn, String name, String keyword) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        if (this.isPageable()) {
            RdbmsPagingQuery query = new RdbmsPagingQuery(KEYWORD, this.getOffset(), this.getLimit(), ALL, new String[]{TABLE}, new String[]{this.getOrderBy()}, null, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name), new RdbmsStringColumnParameter("KEYWORD LIKE", 2, "%" + keyword + "%")});
            return TrendsDeleteFactory.create(supporter.fetchCriteria(conn, query));
        }
        String sql = String.valueOf(SELECT_NAME_KEYWORD_SQL) + this.getOrderBy();
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name), new RdbmsStringColumnParameter(KEYWORD, 2, "%" + keyword + "%")};
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, parameters);
        return TrendsDeleteFactory.create(supporter.fetchItems(conn, rdbmsGeneralQuery));
    }

    public int delete(Connection conn, TrendsDelete row) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = TrendsDeleteDB.parameterize(row);
        String sql = DELETE_SINGLE_SQL;
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, parameters);
        return supporter.executeUpdate(conn, rdbmsGeneralQuery);
    }

    public int delete(Connection conn, String name) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String sql = DELETE_NAME_SQL;
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)};
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, parameters);
        return supporter.executeUpdate(conn, rdbmsGeneralQuery);
    }

    private static RdbmsColumnParameter[] parameterize(TrendsDelete row) {
        int index = 1;
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, index++, row.getName()), new RdbmsStringColumnParameter(KEYWORD, index++, row.getKeyword())};
        return parameters;
    }

    public Transmitable getInstance() {
        return new TrendsDeleteDB();
    }

    public boolean isNull() {
        return false;
    }

    private String getOrderBy() {
        if (!StringUtil.isEmpty((String)this.getOrderColumn())) {
            StringBuilder buf = new StringBuilder(32);
            buf.append(" ORDER BY ");
            buf.append(this.getOrderColumn());
            buf.append(!this.getOrderDirection() ? " DESC " : " ASC ");
            return buf.toString();
        }
        return "";
    }
}

