/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.db.SqlUtil;
import com.diquest.ir.common.database.entity.TrendsKeyword;
import com.diquest.ir.common.database.entity.factory.TrendsKeywordFactory;
import com.diquest.ir.common.database.entity.trends.TrendsKeywordList;
import com.diquest.ir.common.database.handler.AbstractGeneralDB;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TrendsKeywordDB
extends AbstractGeneralDB {
    private static final Map MODS = new HashMap();
    private static final String TRENDS_KEYWORD = "TRENDS_KEYWORD";
    private static final RdbmsProperties PROPERTIES = RdbmsPropertiesFactory.load();
    private static final String TABLE = String.valueOf(PROPERTIES.getPrefix()) + "_" + "TRENDS_KEYWORD";
    private static final String NAME = "TRENDS_ID";
    private static final String KEYWORD = "KEYWORD";
    private static final String RANK = "RANKING";
    private static final String PREV_RANK = "PREV_RANK";
    private static final String REQUESTED = "REQUESTED";
    private static final String FIXED = "FIXED_YN";
    private static final String DIFF = "DIFF";
    private static final String[] ALL = new String[]{"TRENDS_ID", "KEYWORD", "RANKING", "PREV_RANK", "REQUESTED", "FIXED_YN"};
    private static final String[] ALL_DIFF = new String[]{"TRENDS_ID", "KEYWORD", "RANKING", "PREV_RANK", "REQUESTED", "FIXED_YN", "RANKING - PREV_RANK AS DIFF"};
    private static final String[] ALL_BUT_PRIMARY = new String[]{"RANKING", "PREV_RANK", "REQUESTED", "FIXED_YN"};
    private static final String[] PRIMARY = new String[]{"TRENDS_ID", "KEYWORD"};
    private static final String INSERT_SQL = SqlUtil.generateInsertSql((String)TABLE, (String[])ALL);
    private static final String SELECT_NAME_SQL = String.valueOf(SqlUtil.generateSelectSql((String)TABLE, (String[])ALL)) + " WHERE " + "TRENDS_ID" + "=? ";
    private static final String SELECT_NAME_DIFF_SQL = String.valueOf(SqlUtil.generateSelectSql((String)TABLE, (String[])ALL_DIFF)) + " WHERE " + "TRENDS_ID" + "=? ";
    private static final String DELETE_NAME_SQL = "DELETE FROM " + TABLE + " where " + "TRENDS_ID" + "=? ";
    private static final String DELETE_SINGLE_SQL = String.valueOf(DELETE_NAME_SQL) + " and " + "KEYWORD" + "=? ";
    private static final String UPDATE_SQL = SqlUtil.generateUpdateSql((String)TABLE, (String[])ALL_BUT_PRIMARY, (String[])PRIMARY);

    public synchronized List diff(Connection conn, String name) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        if (this.isPageable()) {
            RdbmsPagingQuery query = new RdbmsPagingQuery(KEYWORD, this.getOffset(), this.getLimit(), ALL_DIFF, new String[]{TABLE}, new String[]{this.getDiffOrderBy()}, null, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)});
            return TrendsKeywordFactory.create(supporter.fetchCriteria(conn, query));
        }
        String sql = String.valueOf(SELECT_NAME_DIFF_SQL) + this.getDiffOrderBy();
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)};
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, parameters);
        return TrendsKeywordFactory.create(supporter.fetchItems(conn, rdbmsGeneralQuery));
    }

    public synchronized Transmitable getInstance() {
        return new TrendsKeywordDB();
    }

    public boolean isNull() {
        return false;
    }

    public synchronized List list(Connection conn, String name) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        if (this.isPageable()) {
            RdbmsPagingQuery query = new RdbmsPagingQuery(KEYWORD, this.getOffset(), this.getLimit(), ALL, new String[]{TABLE}, new String[]{this.getOrderBy()}, null, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)});
            return TrendsKeywordFactory.create(supporter.fetchCriteria(conn, query));
        }
        String sql = String.valueOf(SELECT_NAME_SQL) + this.getOrderBy();
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)};
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, parameters);
        return TrendsKeywordFactory.create(supporter.fetchItems(conn, rdbmsGeneralQuery));
    }

    public synchronized TrendsKeywordList listWith(Connection conn, String name) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        long modCount = TrendsKeywordDB.getModCount(name);
        if (modCount == -1L) {
            TrendsKeywordDB.onDbChange(name);
            modCount = TrendsKeywordDB.getModCount(name);
        }
        if (this.isPageable()) {
            RdbmsPagingQuery query = new RdbmsPagingQuery(KEYWORD, this.getOffset(), this.getLimit(), ALL, new String[]{TABLE}, new String[]{this.getOrderBy()}, null, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)});
            return new TrendsKeywordList(name, modCount, TrendsKeywordFactory.create(supporter.fetchCriteria(conn, query)));
        }
        String sql = String.valueOf(SELECT_NAME_SQL) + this.getOrderBy();
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)};
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, parameters);
        return new TrendsKeywordList(name, modCount, TrendsKeywordFactory.create(supporter.fetchItems(conn, rdbmsGeneralQuery)));
    }

    public synchronized int delete(Connection conn, TrendsKeyword row) throws SQLException {
        RdbmsColumnParameter[] parameters;
        RdbmsGeneralQuery rdbmsGeneralQuery;
        int changed;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        int index = 1;
        String sql = DELETE_SINGLE_SQL;
        if ((changed = supporter.executeUpdate(conn, rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, index++, row.getName()), new RdbmsStringColumnParameter(KEYWORD, index++, row.getKeyword())}))) != 0) {
            TrendsKeywordDB.onDbChange(row.getName());
        }
        return changed;
    }

    public synchronized int delete(Connection conn, String name) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String sql = DELETE_NAME_SQL;
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)};
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, parameters);
        int changed = supporter.executeUpdate(conn, rdbmsGeneralQuery);
        if (changed != 0) {
            MODS.remove(name);
        }
        return changed;
    }

    private static RdbmsColumnParameter[] parameterize(TrendsKeyword row) {
        int index = 1;
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, index++, row.getName()), new RdbmsStringColumnParameter(KEYWORD, index++, row.getKeyword()), new RdbmsIntColumnParameter(RANK, index++, row.getRank()), new RdbmsIntColumnParameter(PREV_RANK, index++, row.getPrevRank()), new RdbmsIntColumnParameter(REQUESTED, index++, row.getRequested()), new RdbmsStringColumnParameter(FIXED, index++, row.isFixed() ? (char)'Y' : 'N')};
        return parameters;
    }

    public synchronized int update(Connection conn, TrendsKeyword row) throws SQLException {
        RdbmsColumnParameter[] parameters;
        RdbmsGeneralQuery rdbmsGeneralQuery;
        int count;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        int index = 1;
        String sql = UPDATE_SQL;
        if ((count = supporter.executeUpdate(conn, rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter(RANK, index++, row.getRank()), new RdbmsIntColumnParameter(PREV_RANK, index++, row.getPrevRank()), new RdbmsIntColumnParameter(REQUESTED, index++, row.getRequested()), new RdbmsStringColumnParameter(FIXED, index++, row.isFixed() ? (char)'Y' : 'N'), new RdbmsStringColumnParameter(NAME, index++, row.getName()), new RdbmsStringColumnParameter(KEYWORD, index++, row.getKeyword())}))) != 0) {
            TrendsKeywordDB.onDbChange(row.getName());
        }
        return count;
    }

    public synchronized int delete(Connection conn, Collection rows) throws SQLException {
        int count = 0;
        String name = null;
        PreparedStatement statement = conn.prepareStatement(DELETE_SINGLE_SQL);
        try {
            Iterator it = rows.iterator();
            while (it.hasNext()) {
                TrendsKeyword row = (TrendsKeyword)it.next();
                int index = 1;
                int n = index++;
                name = row.getName();
                statement.setString(n, PROPERTIES.encode(name));
                statement.setString(index++, PROPERTIES.encode(row.getKeyword()));
                count += statement.executeUpdate();
            }
        }
        finally {
            statement.close();
        }
        if (count != 0) {
            TrendsKeywordDB.onDbChange(name);
        }
        return count;
    }

    public synchronized int update(Connection conn, Collection rows) throws SQLException {
        int count = 0;
        String name = null;
        PreparedStatement statement = conn.prepareStatement(UPDATE_SQL);
        try {
            Iterator it = rows.iterator();
            while (it.hasNext()) {
                TrendsKeyword row = (TrendsKeyword)it.next();
                int index = 1;
                statement.setInt(index++, row.getRank());
                statement.setInt(index++, row.getPrevRank());
                statement.setInt(index++, row.getRequested());
                statement.setString(index++, PROPERTIES.encode(row.isFixed() ? "Y" : "N"));
                int n = index++;
                name = row.getName();
                statement.setString(n, PROPERTIES.encode(name));
                statement.setString(index++, PROPERTIES.encode(row.getKeyword()));
                count += statement.executeUpdate();
            }
        }
        finally {
            statement.close();
        }
        if (count != 0) {
            TrendsKeywordDB.onDbChange(name);
        }
        return count;
    }

    public synchronized int insert(Connection conn, TrendsKeyword row) throws SQLException {
        RdbmsColumnParameter[] parameters;
        String sql;
        RdbmsGeneralQuery rdbmsGeneralQuery;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        int count = supporter.executeUpdate(conn, rdbmsGeneralQuery = new RdbmsGeneralQuery(sql = INSERT_SQL, parameters = TrendsKeywordDB.parameterize(row)));
        if (count != 0) {
            TrendsKeywordDB.onDbChange(row.getName());
        }
        return count;
    }

    public synchronized int insert(Connection conn, Collection rows) throws SQLException {
        int count = 0;
        String name = null;
        PreparedStatement statement = conn.prepareStatement(INSERT_SQL);
        try {
            Iterator it = rows.iterator();
            while (it.hasNext()) {
                TrendsKeyword row = (TrendsKeyword)it.next();
                int index = 1;
                int n = index++;
                name = row.getName();
                statement.setString(n, PROPERTIES.encode(name));
                statement.setString(index++, PROPERTIES.encode(row.getKeyword()));
                statement.setInt(index++, row.getRank());
                statement.setInt(index++, row.getPrevRank());
                statement.setInt(index++, row.getRequested());
                statement.setString(index++, PROPERTIES.encode(row.isFixed() ? "Y" : "N"));
                try {
                    count += statement.executeUpdate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            statement.close();
        }
        if (count != 0) {
            TrendsKeywordDB.onDbChange(name);
        }
        return count;
    }

    public void setOrderColumn(String orderColumn) {
    }

    public void setOrderDirection(boolean orderDirection) {
    }

    private String getOrderBy() {
        return " ORDER BY RANKING ASC ";
    }

    private String getDiffOrderBy() {
        return " ORDER BY DIFF ASC, RANKING ASC, KEYWORD ASC ";
    }

    private static synchronized void onDbChange(String name) {
        Long modCount = null;
        modCount = (Long)MODS.get(name);
        long longValue = modCount == null ? System.currentTimeMillis() : modCount;
        MODS.put(name, new Long(--longValue));
    }

    public static synchronized long getModCount(String name) {
        Long modCount = (Long)MODS.get(name);
        if (modCount == null) {
            return -1L;
        }
        return modCount;
    }
}

