/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.db.SqlUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.commons.typebuffer.StringBuilder;
import com.diquest.ir.common.database.entity.TrendsSetting;
import com.diquest.ir.common.database.entity.factory.TrendsSettingFactory;
import com.diquest.ir.common.database.handler.AbstractGeneralDB;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsLongColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class TrendsSettingDB
extends AbstractGeneralDB {
    private static final RdbmsProperties PROPERTIES = RdbmsPropertiesFactory.load();
    private static final String TRENDS_SETTING = "TRENDS_SETTING";
    private static final String TABLE = String.valueOf(PROPERTIES.getPrefix()) + "_" + "TRENDS_SETTING";
    private static final String NAME = "TRENDS_ID";
    private static final String TARGET = "TARGET";
    private static final String CAPACITY = "CAPACITY";
    private static final String TERM = "TERM";
    private static final String START_DATE = "START_DATE";
    private static final String PERIOD = "PERIOD";
    private static final String USAGE = "ENABLE";
    private static final String USE_GLOBAL_DEL = "USE_GLOBAL_DEL";
    private static final String[] ALL = new String[]{"TRENDS_ID", "TARGET", "CAPACITY", "TERM", "START_DATE", "PERIOD", "ENABLE", "USE_GLOBAL_DEL"};
    private static final String[] ALL_BUT_PRIMARY = new String[]{"TARGET", "CAPACITY", "TERM", "START_DATE", "PERIOD", "ENABLE", "USE_GLOBAL_DEL"};
    private static final String[] PRIMARY = new String[]{"TRENDS_ID"};
    private static final String SELECT_NAME_SQL = String.valueOf(SqlUtil.generateSelectSql((String)TABLE, (String[])ALL)) + " WHERE " + "TRENDS_ID" + " like ? ";
    private static final String SELECT_SQL = String.valueOf(SqlUtil.generateSelectSql((String)TABLE, (String[])ALL)) + " WHERE " + "TRENDS_ID" + " = ? ";
    private static final String DELETE_SQL = "DELETE FROM " + TABLE + " WHERE " + "TRENDS_ID" + "=? ";
    private static final String INSERT_SQL = SqlUtil.generateInsertSql((String)TABLE, (String[])ALL);
    private static final String UPDATE_SQL = SqlUtil.generateUpdateSql((String)TABLE, (String[])ALL_BUT_PRIMARY, (String[])PRIMARY);

    public Transmitable getInstance() {
        return new TrendsSettingDB();
    }

    public boolean isNull() {
        return false;
    }

    public List list(Connection conn, String name) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        if (this.isPageable()) {
            RdbmsPagingQuery query = new RdbmsPagingQuery(NAME, this.getOffset(), this.getLimit(), ALL, new String[]{TABLE}, new String[]{this.getOrderBy()}, null, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("TRENDS_ID LIKE", 1, "%" + name + "%")});
            return TrendsSettingFactory.create(supporter.fetchCriteria(conn, query));
        }
        String sql = String.valueOf(SELECT_NAME_SQL) + this.getOrderBy();
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, "%" + name + "%")});
        return TrendsSettingFactory.create(supporter.fetchItems(conn, rdbmsGeneralQuery));
    }

    public TrendsSetting select(Connection conn, String name) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String sql = SELECT_SQL;
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(sql, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)});
        return TrendsSettingFactory.create(supporter.fetchItem(conn, rdbmsGeneralQuery));
    }

    public int delete(Connection conn, String name) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(DELETE_SQL, new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, 1, name)});
        return supporter.executeUpdate(conn, rdbmsGeneralQuery);
    }

    public int insert(Connection conn, TrendsSetting setting) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        int index = 1;
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(NAME, index++, setting.getName()), new RdbmsStringColumnParameter(TARGET, index++, setting.getTarget().encode()), new RdbmsIntColumnParameter(CAPACITY, index++, setting.getCapacity()), new RdbmsLongColumnParameter(TERM, index++, setting.getTerm()), new RdbmsDateColumnParameter(START_DATE, index++, new Timestamp(setting.getStartDate().getTime())), new RdbmsLongColumnParameter(PERIOD, index++, setting.getPeriod()), new RdbmsStringColumnParameter(USAGE, index++, setting.isUsage() ? "Y" : "N"), new RdbmsStringColumnParameter(USE_GLOBAL_DEL, index++, setting.isUseGlobalDel() ? "Y" : "N")};
        RdbmsGeneralQuery rdbmsGeneralQuery = new RdbmsGeneralQuery(INSERT_SQL, parameters);
        return supporter.executeUpdate(conn, rdbmsGeneralQuery);
    }

    public int update(Connection conn, TrendsSetting setting) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        int index = 1;
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter(TARGET, index++, setting.getTarget().encode()), new RdbmsIntColumnParameter(CAPACITY, index++, setting.getCapacity()), new RdbmsLongColumnParameter(TERM, index++, setting.getTerm()), new RdbmsDateColumnParameter(START_DATE, index++, new Timestamp(setting.getStartDate().getTime())), new RdbmsLongColumnParameter(PERIOD, index++, setting.getPeriod()), new RdbmsStringColumnParameter(USAGE, index++, setting.isUsage() ? "Y" : "N"), new RdbmsStringColumnParameter(USE_GLOBAL_DEL, index++, setting.isUseGlobalDel() ? "Y" : "N"), new RdbmsStringColumnParameter(NAME, index++, setting.getName())};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(UPDATE_SQL, parameters);
        return supporter.executeUpdate(conn, query);
    }

    private String getOrderBy() {
        if (!StringUtil.isEmpty((String)this.getOrderColumn())) {
            StringBuilder buf = new StringBuilder(32);
            buf.append(" ORDER BY ");
            buf.append(this.getOrderColumn());
            buf.append(!this.getOrderDirection() ? " DESC " : " ASC ");
            return buf.toString();
        }
        return "";
    }
}

