/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler;

import com.diquest.commons.type.ArrayUtil;
import com.diquest.commons.type.StringUtil;
import com.diquest.commons.typebuffer.MyIntBuffer;
import com.diquest.ir.common.database.entity.AbstractKeywordCountQueryLog;
import com.diquest.ir.common.database.entity.PopularQueryLog;
import com.diquest.ir.common.database.entity.ZeitgeistQueryLog;
import com.diquest.ir.common.database.handler.PopularQueryLogDB;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ZeitgeistQueryLogDB {
    private static final int DISABLED = -1;
    private int offset = -1;
    private int limit = -1;
    PopularQueryLog[] logs;
    int[] difference;

    public static int[] difference(List target, List control) {
        HashMap<String, Integer> keywordRank = new HashMap<String, Integer>(control.size() << 1);
        Iterator iter = control.iterator();
        while (iter.hasNext()) {
            AbstractKeywordCountQueryLog log = (AbstractKeywordCountQueryLog)iter.next();
            if (log.getRank() == -1) continue;
            keywordRank.put(log.getKeywords(), new Integer(log.getRank()));
        }
        int[] diff = new int[target.size()];
        Arrays.fill(diff, Integer.MIN_VALUE);
        int currentRank = 0;
        Iterator iter2 = target.iterator();
        while (iter2.hasNext()) {
            AbstractKeywordCountQueryLog log = (AbstractKeywordCountQueryLog)iter2.next();
            Integer r = (Integer)keywordRank.get(log.getKeywords());
            if (r != null && log.getRank() != -1) {
                diff[currentRank] = r - log.getRank();
            }
            ++currentRank;
        }
        return diff;
    }

    public static void main(String[] args) {
        int[] nArray = new int[24];
        nArray[0] = 9;
        nArray[1] = 4;
        nArray[2] = 8;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 1;
        nArray[6] = 9;
        nArray[7] = 8;
        nArray[8] = 4;
        nArray[10] = 2;
        nArray[11] = 3;
        nArray[12] = 6;
        nArray[13] = 7;
        nArray[14] = 2;
        nArray[15] = 9;
        nArray[17] = 3;
        nArray[18] = 8;
        nArray[19] = 4;
        nArray[20] = 7;
        nArray[21] = 9;
        nArray[23] = 3;
        int[] values = nArray;
        int[][] ir = new int[values.length][2];
        int i = 0;
        while (i < values.length) {
            ir[i][0] = i;
            ir[i][1] = values[i];
            ++i;
        }
        int[] metaSort = ArrayUtil.metaSort((Object[])ir, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                int[] i2 = (int[])o2;
                int[] i1 = (int[])o1;
                if (i2[1] != i1[1]) {
                    return i1[1] < i2[1] ? 1 : (i1[1] > i2[1] ? -1 : 0);
                }
                return i1[0] < i2[0] ? -1 : (i1[0] > i2[0] ? 1 : 0);
            }
        });
        System.out.println(ArrayUtil.toString((int[])metaSort));
        int[] select = ArrayUtil.select((int[])values, (int[])metaSort);
        System.out.println(ArrayUtil.toString((int[])select));
    }

    private static int[] purifyDifference(int[] difference, int referenceSize) {
        int[] newScore = new int[difference.length];
        int i = 0;
        while (i < difference.length) {
            newScore[i] = difference[i] == Integer.MIN_VALUE ? referenceSize - i : difference[i];
            ++i;
        }
        return newScore;
    }

    public ZeitgeistQueryLogDB() {
    }

    public ZeitgeistQueryLogDB(List current, List past) {
        this.create(current, past);
    }

    public final void disablePaging() {
        this.setOffset(-1);
        this.setLimit(-1);
    }

    public final int[] getDifference() {
        return this.difference;
    }

    public final int[] getDifference(int[] ranks) {
        return ArrayUtil.select((int[])this.difference, (int[])ranks);
    }

    public final int getLimit() {
        return this.limit;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final PopularQueryLog[] getZeitgeist() {
        return this.logs;
    }

    public final PopularQueryLog[] getZeitgeist(int[] ranks) {
        return (PopularQueryLog[])ArrayUtil.select((Object[])this.logs, (int[])ranks);
    }

    public final boolean isPageable() {
        return this.offset >= 0 && this.limit >= 0;
    }

    public int[] search(String keyword) {
        MyIntBuffer ranks = new MyIntBuffer(32);
        int i = 0;
        while (i < this.logs.length) {
            if (this.logs[i].getKeywords().indexOf(keyword) != -1) {
                ranks.append(i);
            }
            ++i;
        }
        return ranks.toArray();
    }

    public List select(Connection conn, String keyword, String[] collections, String[][] profiles, long from, long to, int referenceLimit) throws SQLException {
        return this.select(conn, keyword, collections, profiles, from - (to - from), from, from, to, referenceLimit, referenceLimit);
    }

    public List select(Connection conn, String keyword, String[] collections, String[][] profiles, long previousFrom, long previousTo, long currentFrom, long currentTo, int previousLimit, int currentLimit) throws SQLException {
        PopularQueryLogDB previousDb = new PopularQueryLogDB();
        previousDb.setLimit(previousLimit);
        previousDb.setOffset(previousLimit == -1 ? -1 : 1);
        PopularQueryLogDB currentDb = new PopularQueryLogDB();
        currentDb.setLimit(currentLimit);
        currentDb.setOffset(currentLimit == -1 ? -1 : 1);
        List previous = previousDb.select(conn, null, collections, profiles, previousFrom, previousTo);
        List current = currentDb.select(conn, null, collections, profiles, currentFrom, currentTo);
        int[] difference = ZeitgeistQueryLogDB.difference(current, previous);
        int[] correctedDifference = ZeitgeistQueryLogDB.purifyDifference(difference, previous.size());
        int[] order = this.ordering(correctedDifference);
        difference = ArrayUtil.select((int[])difference, (int[])order);
        Object[] currentArr = current.toArray(new PopularQueryLog[current.size()]);
        PopularQueryLog[] logs = (PopularQueryLog[])ArrayUtil.select((Object[])currentArr, (int[])order);
        ZeitgeistQueryLog[] zLogs = new ZeitgeistQueryLog[logs.length];
        int i = 0;
        while (i < logs.length) {
            zLogs[i] = new ZeitgeistQueryLog(logs[i]);
            zLogs[i].setRank(i + 1);
            ++i;
        }
        List<ZeitgeistQueryLog> zeitgeist = new LinkedList<ZeitgeistQueryLog>(Arrays.asList(zLogs));
        int index = 0;
        Iterator it = zeitgeist.iterator();
        while (it.hasNext()) {
            ((AbstractKeywordCountQueryLog)it.next()).setDifference(difference[index++]);
        }
        if (!StringUtil.isEmpty((String)keyword)) {
            Iterator iterator = zeitgeist.iterator();
            while (iterator.hasNext()) {
                AbstractKeywordCountQueryLog log = (AbstractKeywordCountQueryLog)iterator.next();
                if (log.getKeywords().indexOf(keyword) != -1) continue;
                iterator.remove();
            }
        }
        if (this.isPageable()) {
            zeitgeist = zeitgeist.size() > this.getOffset() - 1 ? zeitgeist.subList(this.getOffset() - 1, Math.min(zeitgeist.size(), this.getOffset() - 1 + this.getLimit())) : Collections.EMPTY_LIST;
        }
        return zeitgeist;
    }

    public final void setLimit(int limit) {
        this.limit = limit;
    }

    public final void setOffset(int offset) {
        this.offset = offset;
    }

    private void create(List current, List past) {
        int[] difference = ZeitgeistQueryLogDB.difference(current, past);
        int[] correctedDifference = ZeitgeistQueryLogDB.purifyDifference(difference, past.size());
        int[] order = this.ordering(correctedDifference);
        ArrayUtil.reverse((int[])order);
        this.difference = ArrayUtil.select((int[])correctedDifference, (int[])order);
        Object[] currentArr = current.toArray(new PopularQueryLog[current.size()]);
        this.logs = (PopularQueryLog[])ArrayUtil.select((Object[])currentArr, (int[])order);
    }

    private int[] ordering(int[] correctedDifference) {
        int[][] indexAndRank = new int[correctedDifference.length][2];
        int i = 0;
        while (i < correctedDifference.length) {
            indexAndRank[i][0] = i;
            indexAndRank[i][1] = correctedDifference[i];
            ++i;
        }
        int[] order = ArrayUtil.metaSort((Object[])indexAndRank, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                int[] i1 = (int[])o1;
                int[] i2 = (int[])o2;
                int diff = i1[1] - i2[1];
                if (diff != 0) {
                    return -diff;
                }
                return i1[0] - i2[0];
            }
        });
        return order;
    }
}

