/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.dictionary;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.profile.bannedword.BannedWord;
import com.diquest.ir.common.database.handler.dictionary.DBHandler;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class BannedWordDB
extends DBHandler
implements CollectionObservable {
    static final String TABLE = String.valueOf(PREFIX) + "_BANNEDWORD";
    static final String SQL_INSERT_BANNEDWORD = " INSERT INTO " + TABLE + " (COLLECTION_ID, PROFILE_ID, KEYWORD, REG_DATE, APPLY) VALUES ( ?, ?, ?, ?, ? )";
    static final String SQL_UPDATE_APPLY = "UPDATE " + TABLE + " SET APPLY = '1' " + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_SELECT_BANNEDWORD = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ?";
    static final String SQL_SELECT_PROFILE_BANNEDWORD = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_ALL_BANNEDWORD = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, REG_DATE, APPLY FROM " + TABLE;
    static final String SQL_SEARCH_BANNEDWORD = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, REG_DATE, APPLY FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD LIKE ?";
    static final String SQL_SELECT_ALL_BANNEDWORD_COUNT = " SELECT COUNT(*) FROM " + TABLE;
    static final String SQL_SELECT_BANNEDWORD_COUNT = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_COUNT_SEARCH = " SELECT COUNT(*) FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD LIKE ?";
    static final String SQL_DELETE_ALL_BANNEDWORD = "DELETE FROM " + TABLE;
    static final String SQL_DELETE_BANNEDWORD_PROFILE = "DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_DELETE_BANNEDWORD_COLLECTION = "DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ?";
    static final String SQL_DELETE_BANNEDWORD = " DELETE FROM " + TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ?";

    public static void put(Connection conn, String keyword) throws SQLException {
        BannedWordDB.put(conn, "*", "*", keyword);
    }

    public static void put(Connection conn, String collectionID, String keyword) throws SQLException {
        BannedWordDB.put(conn, collectionID, "*", keyword);
    }

    public static void put(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = BannedWordDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                Timestamp regDate = new Timestamp(System.currentTimeMillis());
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsDateColumnParameter("REG_DATE", 4, regDate), new RdbmsIntColumnParameter("APPLY", 5, 0)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_BANNEDWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void updateApply(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_APPLY, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static BannedWord[] getListSearchPage(Connection conn, String collectionID, String profileID, String keyword, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = BannedWordDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD LIKE", 3, "%" + keyword + "%")};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return BannedWord.create(list);
    }

    public static BannedWord[] getListPage(Connection conn, String collectionID, String profileID, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return BannedWord.create(list);
    }

    public static BannedWord[] getListPageOrderKeyword(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return BannedWordDB.getListPage(conn, collectionID, profileID, start, scale, "KEYWORD ASC");
    }

    public static BannedWord[] getListPageOrderDate(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return BannedWordDB.getListPage(conn, collectionID, profileID, start, scale, "REG_DATE DESC");
    }

    public static BannedWord[] getListPageOrderApply(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return BannedWordDB.getListPage(conn, collectionID, profileID, start, scale, "APPLY ASC");
    }

    public static BannedWord[] getListSystemPage(Connection conn, int start, int scale, String order) throws SQLException {
        return BannedWordDB.getListPage(conn, "*", "*", start, scale, order);
    }

    public static BannedWord[] getListSystemPageOrderKeyword(Connection conn, int start, int scale) throws SQLException {
        return BannedWordDB.getListPage(conn, "*", "*", start, scale, "KEYWORD ASC");
    }

    public static BannedWord[] getListSystemPageOrderDate(Connection conn, int start, int scale) throws SQLException {
        return BannedWordDB.getListPage(conn, "*", "*", start, scale, "REG_DATE DESC");
    }

    public static BannedWord[] getListSystemPageOrderApply(Connection conn, int start, int scale) throws SQLException {
        return BannedWordDB.getListPage(conn, "*", "*", start, scale, "APPLY ASC");
    }

    public static BannedWord[] getListDefaultProfilePage(Connection conn, String collectionID, int start, int scale, String order) throws SQLException {
        return BannedWordDB.getListPage(conn, collectionID, "*", start, scale, order);
    }

    public static BannedWord[] getListDefaultProfilePageOrderKeyword(Connection conn, String collectionID, int start, int scale, String order) throws SQLException {
        return BannedWordDB.getListPage(conn, collectionID, "*", start, scale, "KEYWORD ASC");
    }

    public static BannedWord[] getListDefaultProfilePageOrderDate(Connection conn, String collectionID, int start, int scale, String order) throws SQLException {
        return BannedWordDB.getListPage(conn, collectionID, "*", start, scale, "REG_DATE DESC");
    }

    public static BannedWord[] getListDefaultProfilePageOrderApply(Connection conn, String collectionID, int start, int scale, String order) throws SQLException {
        return BannedWordDB.getListPage(conn, collectionID, "*", start, scale, "APPLY ASC");
    }

    public static BannedWord get(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = BannedWordDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_BANNEDWORD, parameters);
        RdbmsColumnValue[] native_rows = supporter.fetchItem(conn, query);
        return BannedWord.create(native_rows);
    }

    public static BannedWord[] getListSystem(Connection conn, String order) throws SQLException {
        return BannedWordDB.getList(conn, "*", "*", order);
    }

    public static BannedWord[] getListDefaultProfile(Connection conn, String collectionID, String order) throws SQLException {
        return BannedWordDB.getList(conn, collectionID, "*", order);
    }

    public static BannedWord[] getList(Connection conn, String collectionID, String profileID, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        order = BannedWordDB.getOrderby(order);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_PROFILE_BANNEDWORD) + order, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        return BannedWord.create(native_rows);
    }

    public static void copy(Connection conn, String fromCollectionID, String fromProfileID, String toCollectionID, String toProfileID) throws SQLException {
        int count = BannedWordDB.getCount(conn, fromCollectionID, fromProfileID);
        int iterNum = count / 200 + 1;
        int i = 0;
        while (i < iterNum) {
            int start = i * 200 + 1;
            BannedWord[] list = BannedWordDB.getListPage(conn, fromCollectionID, fromProfileID, start, 200, null);
            int j = 0;
            while (j < list.length) {
                BannedWordDB.put(conn, toCollectionID, toProfileID, list[j].getKeyword());
                ++j;
            }
            ++i;
        }
    }

    public static BannedWord[] getListAll(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_PROFILE_BANNEDWORD, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        return BannedWord.create(native_rows);
    }

    public static int getListAllCount(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_ALL_BANNEDWORD_COUNT, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCount(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_BANNEDWORD_COUNT, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountSystem(Connection conn) throws SQLException {
        return BannedWordDB.getCount(conn, "*", "*");
    }

    public static int getCountDefaultProfile(Connection conn, String collectionID) throws SQLException {
        return BannedWordDB.getCount(conn, collectionID, "*");
    }

    public static int getCountSearch(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = BannedWordDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_SEARCH, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static void deleteAll(Connection conn) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL_BANNEDWORD);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteCollection(Connection conn, String collectionID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("collectionID cannot be null.");
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_BANNEDWORD_COLLECTION, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteSystem(Connection conn) throws SQLException {
        BannedWordDB.deleteProfile(conn, "*", "*");
    }

    public static void deleteDefaultProfile(Connection conn, String collectionID) throws SQLException {
        BannedWordDB.deleteProfile(conn, collectionID, "*");
    }

    public static void deleteProfile(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_BANNEDWORD_PROFILE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void delete(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        keyword = BannedWordDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_BANNEDWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                BannedWordDB.deleteCollection(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }
}

