/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.dictionary;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.profile.categoryranking.CategoryRanking;
import com.diquest.ir.common.database.entity.profile.categoryranking.CategoryRankingKeyword;
import com.diquest.ir.common.database.handler.dictionary.DBHandler;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class CategoryRankingDB
extends DBHandler
implements CollectionObservable {
    static final String CATEGORY_KEYWORD_TABLE = String.valueOf(PREFIX) + "_CATEGORY_RANKING_KEYWORD";
    static final String CATEGORY_TABLE = String.valueOf(PREFIX) + "_CATEGORY_RANKING";
    static final String SQL_INSERT_CATEGORY_KEYWORD = " INSERT INTO " + CATEGORY_KEYWORD_TABLE + " (COLLECTION_ID, PROFILE_ID, KEYWORD, CATEGORIES, REG_DATE, APPLY) VALUES " + " (?, ?, ?, ?, ?, ? )";
    static final String SQL_UPDATE_CATEGORY_KEYWORD = " UPDATE " + CATEGORY_KEYWORD_TABLE + " SET CATEGORIES=?, REG_DATE=?, APPLY=? " + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? ";
    static final String SQL_UPDATE_APPLY_CATEGORY = "UPDATE " + CATEGORY_TABLE + " SET APPLY = '1' " + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_UPDATE_APPLY_KEYWORD = "UPDATE " + CATEGORY_KEYWORD_TABLE + " SET APPLY = '1' " + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_SELECT_KEYWORD = "SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, CATEGORIES, REG_DATE, APPLY FROM " + CATEGORY_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? ";
    static final String SQL_SELECT_KEYWORDS = "SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, CATEGORIES, REG_DATE, APPLY FROM " + CATEGORY_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_COUNT_KEYWORDS = "SELECT COUNT(*) FROM " + CATEGORY_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_COUNT_SEARCH_KEYWORDS = "SELECT COUNT(*) FROM " + CATEGORY_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD LIKE ? ";
    static final String SQL_SEARCH_KEYWORDS = "SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, CATEGORIES, REG_DATE, APPLY FROM " + CATEGORY_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD LIKE ? ";
    static final String SQL_DELETE_CATEGORY_KEYWORD = " DELETE FROM " + CATEGORY_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? ";
    static final String SQL_DELETE_ALL_CATEGORY_KEYWORD = " DELETE FROM " + CATEGORY_KEYWORD_TABLE;
    static final String SQL_DELETE_CATEGORY_KEYWORD_COLLECTION = " DELETE FROM " + CATEGORY_KEYWORD_TABLE + " WHERE COLLECTION_ID = ?";
    static final String SQL_DELETE_CATEGORY_KEYWORD_PROFILE = " DELETE FROM " + CATEGORY_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_INSERT_CATEGORY = " INSERT INTO " + CATEGORY_TABLE + " (COLLECTION_ID, PROFILE_ID, KEYWORD, FIELD, CATEGORY, TYPE, RANK, START_DATE, END_DATE, REG_DATE, APPLY, USE_YN, CREATOR) " + "VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) ";
    static final String SQL_UPDATE_CATEGORY = " UPDATE " + CATEGORY_TABLE + " SET TYPE=?, RANK=?, START_DATE=?, END_DATE=?, REG_DATE=?, APPLY=?, USE_YN=? " + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? AND FIELD = ? AND CATEGORY = ? AND CREATOR = ?";
    static final String SQL_SELECT_CATEGORY = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, FIELD, CATEGORY, TYPE, RANK, START_DATE, END_DATE, REG_DATE, APPLY, USE_YN, CREATOR FROM " + CATEGORY_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? AND FIELD = ? AND CATEGORY = ? ";
    static final String SQL_SELECT_CATEGORY_KEYWORD = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, FIELD, CATEGORY, TYPE, RANK, START_DATE, END_DATE, REG_DATE, APPLY, USE_YN, CREATOR FROM " + CATEGORY_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? ";
    static final String SQL_SELECT_CATEGORY_USABLE_KEYWORD = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, FIELD, CATEGORY, TYPE, RANK, START_DATE, END_DATE, REG_DATE, APPLY, USE_YN, CREATOR FROM " + CATEGORY_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? AND USE_YN = ?";
    static final String SQL_SELECT_CATEGORY_USABLE_ALL_KEYWORD = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, FIELD, CATEGORY, TYPE, RANK, START_DATE, END_DATE, REG_DATE, APPLY, USE_YN, CREATOR FROM " + CATEGORY_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND USE_YN = ?";
    static final String SQL_SELECT_CATEGORY_KEYWORD_COUNT = " SELECT COUNT(*) FROM " + CATEGORY_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ?";
    static final String SQL_SELECT_CATEGORY_PROFILE = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, FIELD, CATEGORY, TYPE, RANK, START_DATE, END_DATE, REG_DATE, APPLY, USE_YN, CREATOR FROM " + CATEGORY_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_CATEGORY_PROFILE_COUNT = " SELECT COUNT(*) FROM " + CATEGORY_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_DELETE_CATEGORY = " DELETE FROM " + CATEGORY_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? AND FIELD = ? AND CATEGORY = ? AND CREATOR = ?";
    static final String SQL_DELETE_ALL_CATEGORY = "DELETE FROM " + CATEGORY_TABLE;
    static final String SQL_DELETE_CATEGORY_COLLECTION = "DELETE FROM " + CATEGORY_TABLE + " WHERE COLLECTION_ID = ?";
    static final String SQL_DELETE_CATEGORY_PROFILE = "DELETE FROM " + CATEGORY_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_DELETE_CATEGORY_PROFILE_CREATOR = "DELETE FROM " + CATEGORY_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND CREATOR = ?";
    static final String SQL_DELETE_CATEGORIES_KEYWORD = "DELETE FROM " + CATEGORY_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? AND CREATOR = ?";
    static final String SQL_SELECT_COUNT_SEARCH_CATEGORY_KEYWORDS = "SELECT COUNT(*) FROM " + CATEGORY_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD LIKE ? ";

    public static void putKeyword(Connection conn, String collectionID, String profileID, String keyword, int categories) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                Timestamp updated = new Timestamp(System.currentTimeMillis());
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsIntColumnParameter("CATEGORIES", 4, categories), new RdbmsDateColumnParameter("REG_DATE", 5, updated), new RdbmsIntColumnParameter("APPLY", 6, 0)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_CATEGORY_KEYWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void updateApply(Connection conn, String collectionID, String profileID) throws SQLException {
        CategoryRankingDB.updateApplyCategory(conn, collectionID, profileID);
        CategoryRankingDB.updateApplyKeyword(conn, collectionID, profileID);
    }

    private static void updateApplyCategory(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_APPLY_CATEGORY, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    private static void updateApplyKeyword(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_APPLY_KEYWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void updateKeyword(Connection conn, String collectionID, String profileID, String keyword, int categories) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                Timestamp updated = new Timestamp(System.currentTimeMillis());
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter("CATEGORIES", 1, categories), new RdbmsDateColumnParameter("REG_DATE", 2, updated), new RdbmsIntColumnParameter("APPLY", 3, 0), new RdbmsStringColumnParameter("COLLECTION_ID", 4, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 5, profileID), new RdbmsStringColumnParameter("KEYWORD", 6, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_CATEGORY_KEYWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static CategoryRankingKeyword getKeyword(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_KEYWORD, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return CategoryRankingKeyword.create(value);
    }

    public static void deleteKeyword(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                CategoryRankingDB.deleteCategoryKeyword(conn, collectionID, profileID, keyword);
                int numRemainCategories = CategoryRankingDB.getCountCategorySearchKeyword(conn, collectionID, profileID, keyword);
                if (numRemainCategories > 0) {
                    CategoryRankingDB.updateKeyword(conn, collectionID, profileID, keyword, numRemainCategories);
                } else {
                    RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                    RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
                    RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_CATEGORY_KEYWORD, parameters);
                    supporter.executeUpdate(conn, query);
                }
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteCategoryKeywordByKeyword(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_CATEGORY_KEYWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static int getCountKeyword(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_KEYWORDS, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountSearchKeyword(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_SEARCH_KEYWORDS, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountCategorySearchKeyword(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_SEARCH_CATEGORY_KEYWORDS, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static CategoryRankingKeyword[] getListKeyword(Connection conn, String collectionID, String profileID, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        order = CategoryRankingDB.getOrderby(order);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_KEYWORDS) + order, parameters);
        List list = supporter.fetchItems(conn, query);
        return CategoryRankingKeyword.create(list);
    }

    public static CategoryRankingKeyword[] getListPageKeyword(Connection conn, String collectionID, String profileID, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "CATEGORIES", "REG_DATE", "APPLY"};
        String[] froms = new String[]{CATEGORY_KEYWORD_TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return CategoryRankingKeyword.create(list);
    }

    public static CategoryRankingKeyword[] getListPageKeywordOrderKeyword(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return CategoryRankingDB.getListPageKeyword(conn, collectionID, profileID, start, scale, "KEYWORD ASC");
    }

    public static CategoryRankingKeyword[] getListPageKeywordOrderDate(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return CategoryRankingDB.getListPageKeyword(conn, collectionID, profileID, start, scale, "REG_DATE DESC");
    }

    public static CategoryRankingKeyword[] getListPageKeywordOrderApply(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return CategoryRankingDB.getListPageKeyword(conn, collectionID, profileID, start, scale, "APPLY ASC");
    }

    public static CategoryRankingKeyword[] getListSearchPageKeyword(Connection conn, String collectionID, String profileID, String keyword, int start, int scale, String order) throws SQLException {
        if (order == null) {
            order = "";
        }
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "CATEGORIES", "REG_DATE", "APPLY"};
        String[] froms = new String[]{CATEGORY_KEYWORD_TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD LIKE", 3, "%" + keyword + "%")};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return CategoryRankingKeyword.create(list);
    }

    public static CategoryRankingKeyword[] searchProfileKeyword(Connection conn, String collectionID, String profileID, String keyword, String order) throws SQLException {
        order = CategoryRankingDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SEARCH_KEYWORDS) + order, parameters);
        List list = supporter.fetchItems(conn, query);
        return CategoryRankingKeyword.create(list);
    }

    public static CategoryRankingKeyword[] searchProfileKeywordOrderKeyword(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        return CategoryRankingDB.searchProfileKeyword(conn, collectionID, profileID, keyword, "KEYWORD ASC");
    }

    public static CategoryRankingKeyword[] searchProfileKeywordOrderDate(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        return CategoryRankingDB.searchProfileKeyword(conn, collectionID, profileID, keyword, "REG_DATE DESC");
    }

    public static CategoryRankingKeyword[] searchProfileKeywordOrderApply(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        return CategoryRankingDB.searchProfileKeyword(conn, collectionID, profileID, keyword, "APPLY ASC");
    }

    public static void putCategory(Connection conn, CategoryRanking category) throws SQLException {
        String collectionID = category.getCollectionID();
        String profileID = category.getProfileID();
        String keyword = category.getKeyword();
        String field = category.getField();
        String categoryValue = category.getCategory();
        byte type = category.getType();
        int rank = category.getRank();
        long start = category.getStart();
        long end = category.getEnd();
        Timestamp updated = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        boolean use = category.isUse();
        char creator = category.getCreator();
        CategoryRankingDB.putCategory(conn, collectionID, profileID, keyword, field, categoryValue, type, rank, start, end, updated, apply, use, creator);
    }

    public static void putCategory(Connection conn, String collectionID, String profileID, String keyword, String field, String category, byte type, int rank, long start, long end) throws SQLException {
        Timestamp updated = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        boolean use = true;
        char creator = 'U';
        CategoryRankingDB.putCategory(conn, collectionID, profileID, keyword, field, category, type, rank, start, end, updated, apply, use, creator);
    }

    public static void putCategory(Connection conn, String collectionID, String profileID, String keyword, String field, String category, byte type, int rank, long start, long end, char creator) throws SQLException {
        Timestamp updated = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        boolean use = true;
        CategoryRankingDB.putCategory(conn, collectionID, profileID, keyword, field, category, type, rank, start, end, updated, apply, use, creator);
    }

    private static void putCategory(Connection conn, String collectionID, String profileID, String keyword, String field, String category, byte type, int rank, long start, long end, Timestamp updated, boolean apply, boolean use, char creator) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsStringColumnParameter("FIELD", 4, field), new RdbmsStringColumnParameter("CATEGORY", 5, category), new RdbmsIntColumnParameter("TYPE", 6, (int)type), new RdbmsIntColumnParameter("RANK", 7, rank), new RdbmsDateColumnParameter("START_DATE", 8, start), new RdbmsDateColumnParameter("END_DATE", 9, end), new RdbmsDateColumnParameter("REG_DATE", 10, updated), new RdbmsIntColumnParameter("APPLY", 11, apply ? 1 : 0), new RdbmsStringColumnParameter("USE_YN", 12, use ? (char)'1' : '0'), new RdbmsStringColumnParameter("CREATOR", 13, String.valueOf(creator))};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_CATEGORY, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void updateCategory(Connection conn, CategoryRanking category) throws SQLException {
        String collectionID = category.getCollectionID();
        String profileID = category.getProfileID();
        String keyword = category.getKeyword();
        String field = category.getField();
        String category2 = category.getCategory();
        byte type = category.getType();
        int rank = category.getRank();
        long start = category.getStart();
        long end = category.getEnd();
        Timestamp updated = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        boolean use = category.isUse();
        char creator = category.getCreator();
        CategoryRankingDB.updateCategory(conn, collectionID, profileID, keyword, field, category2, type, rank, start, end, updated, apply, use, creator);
    }

    public static void updateCategory(Connection conn, String collectionID, String profileID, String keyword, String field, String category, byte type, int rank, long start, long end) throws SQLException {
        Timestamp updated = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        boolean use = true;
        char creator = 'U';
        CategoryRankingDB.updateCategory(conn, collectionID, profileID, keyword, field, category, type, rank, start, end, updated, apply, use, creator);
    }

    private static void updateCategory(Connection conn, String collectionID, String profileID, String keyword, String field, String category, byte type, int rank, long start, long end, Timestamp updated, boolean apply, boolean use, char creator) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter("TYPE", 1, (int)type), new RdbmsIntColumnParameter("RANK", 2, rank), new RdbmsDateColumnParameter("START_DATE", 3, start), new RdbmsDateColumnParameter("END_DATE", 4, end), new RdbmsDateColumnParameter("REG_DATE", 5, updated), new RdbmsIntColumnParameter("APPLY", 6, apply ? 1 : 0), new RdbmsStringColumnParameter("USE_YN", 7, use ? (char)'1' : '0'), new RdbmsStringColumnParameter("COLLECTION_ID", 8, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 9, profileID), new RdbmsStringColumnParameter("KEYWORD", 10, keyword), new RdbmsStringColumnParameter("FIELD", 11, field), new RdbmsStringColumnParameter("CATEGORY", 12, category), new RdbmsStringColumnParameter("CREATOR", 13, String.valueOf(creator))};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_CATEGORY, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static CategoryRanking getCategory(Connection conn, String collectionID, String profileID, String keyword, String field, String category) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsStringColumnParameter("FIELD", 4, field), new RdbmsStringColumnParameter("CATEGORY", 5, category)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_CATEGORY, parameters);
        RdbmsColumnValue[] native_row = supporter.fetchItem(conn, query);
        return CategoryRanking.create(native_row);
    }

    public static CategoryRanking[] getListPageCategoryProfile(Connection conn, String collectionID, String profileID, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "FIELD", "CATEGORY", "TYPE", "RANK", "START_DATE", "END_DATE", "REG_DATE", "APPLY", "USE_YN", "CREATOR"};
        String[] froms = new String[]{CATEGORY_TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return CategoryRanking.create(list);
    }

    public static CategoryRanking[] getListCategory(Connection conn, String collectionID, String profileID, String keyword, String order) throws SQLException {
        order = CategoryRankingDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_CATEGORY_KEYWORD) + order, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        return CategoryRanking.create(native_rows);
    }

    public static CategoryRanking[] getListUsableCategory(Connection conn, String collectionID, String profileID, String keyword, String order, boolean use) throws SQLException {
        order = CategoryRankingDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsStringColumnParameter("USE_YN", 4, use ? (char)'1' : '0')};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_CATEGORY_USABLE_KEYWORD) + order, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        return CategoryRanking.create(native_rows);
    }

    public static CategoryRanking[] getListUsableAllCategory(Connection conn, String collectionID, String profileID, String order, boolean use) throws SQLException {
        order = CategoryRankingDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("USE_YN", 3, use ? (char)'1' : '0')};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_CATEGORY_USABLE_ALL_KEYWORD) + order, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        return CategoryRanking.create(native_rows);
    }

    public static void copy(Connection conn, String fromCollectionID, String fromProfileID, String toCollectionID, String toProfileID) throws SQLException {
        int j;
        int start;
        int countKeyword = CategoryRankingDB.getCountKeyword(conn, fromCollectionID, fromProfileID);
        int keywordIterNum = countKeyword / 200 + 1;
        int countCategory = CategoryRankingDB.getListCategoryProfileCount(conn, fromCollectionID, fromProfileID);
        int categoryIterNum = countCategory / 200 + 1;
        int i = 0;
        while (i < keywordIterNum) {
            start = i * 200 + 1;
            CategoryRankingKeyword[] list = CategoryRankingDB.getListPageKeyword(conn, fromCollectionID, fromProfileID, start, 200, null);
            j = 0;
            while (j < list.length) {
                CategoryRankingDB.putKeyword(conn, toCollectionID, toProfileID, list[j].getKeyword(), list[j].getCategories());
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < categoryIterNum) {
            start = i * 200 + 1;
            CategoryRanking[] categoryList = CategoryRankingDB.getListPageCategoryProfile(conn, fromCollectionID, fromProfileID, start, 200, null);
            j = 0;
            while (j < categoryList.length) {
                CategoryRankingDB.putCategory(conn, toCollectionID, toProfileID, categoryList[j].getKeyword(), categoryList[j].getField(), categoryList[j].getCategory(), categoryList[j].getType(), categoryList[j].getRank(), categoryList[j].getStart(), categoryList[j].getEnd(), categoryList[j].getCreator());
                ++j;
            }
            ++i;
        }
    }

    public static int getCountCategory(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_CATEGORY_KEYWORD_COUNT, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static CategoryRanking[] getListCategoryProfile(Connection conn, String collectionID, String profileID, String order) throws SQLException {
        order = CategoryRankingDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_CATEGORY_PROFILE) + order, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        return CategoryRanking.create(native_rows);
    }

    public static int getListCategoryProfileCount(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_CATEGORY_PROFILE_COUNT, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static CategoryRanking[] getListCategoryCollection(Connection conn, String collectionID, String order) throws SQLException {
        order = order == null ? "" : " ORDER BY " + order;
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, "*")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_CATEGORY_PROFILE) + order, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        return CategoryRanking.create(native_rows);
    }

    public static int getListCategoryCollectionCount(Connection conn, String collectionID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, "*")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_CATEGORY_PROFILE_COUNT, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static void deleteAll(Connection conn) throws SQLException {
        CategoryRankingDB.deleteAllCategory(conn);
        CategoryRankingDB.deleteAllCategoryKeyword(conn);
    }

    public static void deleteAllCategory(Connection conn) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL_CATEGORY);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteAllCategoryKeyword(Connection conn) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL_CATEGORY_KEYWORD);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteCollection(Connection conn, String collectionID) throws SQLException {
        CategoryRankingDB.deleteCollectionCategory(conn, collectionID);
        CategoryRankingDB.deleteCollectionCategoryKeyword(conn, collectionID);
    }

    public static void deleteCollectionCategory(Connection conn, String collectionID) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_CATEGORY_COLLECTION, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteCollectionCategoryKeyword(Connection conn, String collectionID) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_CATEGORY_KEYWORD_COLLECTION, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteProfile(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        CategoryRankingDB.deleteProfileCategory(conn, collectionID, profileID);
        CategoryRankingDB.deleteProfileCategoryKeyword(conn, collectionID, profileID);
    }

    public static void deleteProfileCategory(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_CATEGORY_PROFILE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteProfileCategory(Connection conn, String collectionID, String profileID, char creator) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("CREATOR", 3, String.valueOf(creator))};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_CATEGORY_PROFILE_CREATOR, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteProfileCategoryKeyword(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_CATEGORY_KEYWORD_PROFILE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteDefaultProfile(Connection conn, String collectionID) throws SQLException {
        CategoryRankingDB.deleteProfileCategory(conn, collectionID, "*");
        CategoryRankingDB.deleteProfileCategoryKeyword(conn, collectionID, "*");
    }

    public static void deleteCategoryKeyword(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsStringColumnParameter("CREATOR", 4, 'U')};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_CATEGORIES_KEYWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteCategory(Connection conn, String collectionID, String profileID, String keyword, String field, String category, char creator) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : CategoryRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsStringColumnParameter("FIELD", 4, field), new RdbmsStringColumnParameter("CATEGORY", 5, category), new RdbmsStringColumnParameter("CREATOR", 6, String.valueOf(creator))};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_CATEGORY, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteCategory(Connection conn, CategoryRanking category) throws SQLException {
        CategoryRankingDB.deleteCategory(conn, category.getCollectionID(), category.getProfileID(), category.getKeyword(), category.getField(), category.getCategory(), category.getCreator());
    }

    public static void deleteExpired(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        long currentTime = System.currentTimeMillis();
        CategoryRankingKeyword[] keywords = CategoryRankingDB.getListKeyword(conn, collectionID, profileID, null);
        int i = 0;
        while (i < keywords.length) {
            String keyword = keywords[i].getKeyword();
            CategoryRanking[] categories = CategoryRankingDB.getListCategory(conn, collectionID, profileID, keyword, null);
            int cSize = categories.length;
            int c = 0;
            while (c < categories.length) {
                CategoryRanking cat = categories[c];
                if (cat.getEnd() != 0L && cat.getEnd() < currentTime) {
                    CategoryRankingDB.deleteCategory(conn, collectionID, profileID, keyword, cat.getField(), cat.getCategory(), 'U');
                    --cSize;
                }
                ++c;
            }
            if (cSize == 0) {
                CategoryRankingDB.deleteKeyword(conn, collectionID, profileID, keyword);
            } else if (cSize != categories.length) {
                CategoryRankingDB.updateKeyword(conn, collectionID, profileID, keyword, cSize);
            }
            ++i;
        }
    }

    public static void deleteExpiredDefaultProfile(Connection conn, String collectionID) throws SQLException {
        CategoryRankingDB.deleteExpired(conn, collectionID, "*");
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                CategoryRankingDB.deleteCollection(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }
}

