/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.dictionary;

import com.diquest.ir.common.database.handler.dictionary.BannedWordDB;
import com.diquest.ir.common.database.handler.dictionary.CategoryRankingDB;
import com.diquest.ir.common.database.handler.dictionary.DocumentRankingDB;
import com.diquest.ir.common.database.handler.dictionary.RankingModelDB;
import com.diquest.ir.common.database.handler.dictionary.RecommendDB;
import com.diquest.ir.common.database.handler.dictionary.RedirectDB;
import com.diquest.ir.common.database.handler.dictionary.StopwordDB;
import com.diquest.ir.common.database.handler.dictionary.ThesaurusDB;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class DBHandler {
    public static final String TEMP_PROFILE = "TEMPORARY_PROFILE";
    public static final String ORDERBY = " ORDER BY ";
    public static final String ORDER_KEYWORD = "KEYWORD ASC";
    public static final String ORDER_REG_DATE = "REG_DATE DESC";
    public static final String ORDER_APPLY = "APPLY ASC";
    public static final String ORDER_THEME_TITLE = "THEME_TITLE ASC";
    protected static RdbmsProperties properties = RdbmsPropertiesFactory.load();
    protected static final String PREFIX = properties.getPrefix();
    protected static final int scale = 200;
    public static final String EMPTY = "*";
    private static final String EMPTY_STRING = "";

    protected static final String getOrderby(String order) {
        if (order == null) {
            return EMPTY_STRING;
        }
        return ORDERBY + order;
    }

    protected static final String toUpperTrim(String keyword) {
        if (keyword != null) {
            return keyword.toUpperCase().trim();
        }
        return null;
    }

    public static final void deleteAll(Connection conn, String collectionID, String profileID) throws SQLException {
        BannedWordDB.deleteProfile(conn, collectionID, profileID);
        CategoryRankingDB.deleteProfile(conn, collectionID, profileID);
        DocumentRankingDB.deleteProfile(conn, collectionID, profileID);
        RankingModelDB.deleteRankingModelProfile(conn, collectionID, profileID);
        RecommendDB.deleteProfile(conn, collectionID, profileID);
        RedirectDB.deleteProfile(conn, collectionID, profileID);
        StopwordDB.deleteProfile(conn, collectionID, profileID);
        ThesaurusDB.deleteProfile(conn, collectionID, profileID);
    }

    public static final void copyAll(Connection conn, String collectionID, String sourceProfile, String destProfile) throws SQLException {
        BannedWordDB.copy(conn, collectionID, sourceProfile, collectionID, destProfile);
        CategoryRankingDB.copy(conn, collectionID, sourceProfile, collectionID, destProfile);
        DocumentRankingDB.copy(conn, collectionID, sourceProfile, collectionID, destProfile);
        RankingModelDB.copy(conn, collectionID, sourceProfile, collectionID, destProfile);
        RecommendDB.copy(conn, collectionID, sourceProfile, collectionID, destProfile);
        RedirectDB.copy(conn, collectionID, sourceProfile, collectionID, destProfile);
        StopwordDB.copy(conn, collectionID, sourceProfile, collectionID, destProfile);
        ThesaurusDB.copy(conn, collectionID, sourceProfile, collectionID, destProfile);
    }

    public static final void deleteAllTemp(Connection conn, String collectionID) throws SQLException {
        DBHandler.deleteAll(conn, collectionID, TEMP_PROFILE);
    }

    public static final void copyAlltoTemp(Connection conn, String collectionID, String sourceProfile) throws SQLException {
        DBHandler.copyAll(conn, collectionID, sourceProfile, TEMP_PROFILE);
    }

    public static final void initializeTemp(Connection conn, String collectionID, String sourceProfile) throws SQLException {
        DBHandler.deleteAll(conn, collectionID, TEMP_PROFILE);
        DBHandler.copyAll(conn, collectionID, sourceProfile, TEMP_PROFILE);
    }

    public static final void initializeProfile(Connection conn, String collectionID, String destProfile) throws SQLException {
        DBHandler.deleteAll(conn, collectionID, destProfile);
        DBHandler.copyAll(conn, collectionID, TEMP_PROFILE, destProfile);
    }
}

