/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.dictionary;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.profile.documentranking.DocumentRanking;
import com.diquest.ir.common.database.entity.profile.documentranking.DocumentRankingKeyword;
import com.diquest.ir.common.database.handler.dictionary.DBHandler;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.setting.CollectionObservable;
import com.diquest.ir.util.common.StringTokenizer;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class DocumentRankingDB
extends DBHandler
implements CollectionObservable {
    static final char DELIMETER = ',';
    static final String DOCUMENT_KEYWORD_TABLE = String.valueOf(PREFIX) + "_DOCUMENT_RANKING_KEYWORD";
    static final String DOCUMENT_TABLE = String.valueOf(PREFIX) + "_DOCUMENT_RANKING";
    static final String SQL_INSERT_DOCUMENT_KEYWORD = " INSERT INTO " + DOCUMENT_KEYWORD_TABLE + " (COLLECTION_ID, PROFILE_ID, KEYWORD, DOCUMENTS, REG_DATE, APPLY) VALUES " + " (?, ?, ?, ?, ?, ? )";
    static final String SQL_UPDATE_DOCUMENT_KEYWORD = " UPDATE " + DOCUMENT_KEYWORD_TABLE + " SET DOCUMENTS=?, REG_DATE=?, APPLY=? " + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? ";
    static final String SQL_UPDATE_APPLY_DOCUMENT = "UPDATE " + DOCUMENT_TABLE + " SET APPLY = '1' " + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_UPDATE_APPLY_KEYWORD = "UPDATE " + DOCUMENT_KEYWORD_TABLE + " SET APPLY = '1' " + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_SELECT_KEYWORD = "SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, DOCUMENTS, REG_DATE, APPLY FROM " + DOCUMENT_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ?";
    static final String SQL_SELECT_KEYWORDS = "SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, DOCUMENTS, REG_DATE, APPLY FROM " + DOCUMENT_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_COUNT_KEYWORDS = "SELECT COUNT(*) FROM " + DOCUMENT_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_COUNT_SEARCH_KEYWORDS = "SELECT COUNT(*) FROM " + DOCUMENT_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD LIKE ?";
    static final String SQL_SEARCH_KEYWORDS = "SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, DOCUMENTS, REG_DATE, APPLY FROM " + DOCUMENT_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD LIKE ?";
    static final String SQL_DELETE_KEYWORD = " DELETE FROM " + DOCUMENT_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? ";
    static final String SQL_DELETE_ALL_KEYWORD = " DELETE FROM " + DOCUMENT_KEYWORD_TABLE;
    static final String SQL_DELETE_KEYWORD_COLLECTION = " DELETE FROM " + DOCUMENT_KEYWORD_TABLE + " WHERE COLLECTION_ID = ?";
    static final String SQL_DELETE_KEYWORD_PROFILE = " DELETE FROM " + DOCUMENT_KEYWORD_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_INSERT_DOCUMENT = " INSERT INTO " + DOCUMENT_TABLE + " (COLLECTION_ID, PROFILE_ID, KEYWORD, DOC_ID, TYPE, RANK, START_DATE, END_DATE, REG_DATE, APPLY) " + " VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) ";
    static final String SQL_UPDATE_DOCUMENT = " UPDATE " + DOCUMENT_TABLE + " SET TYPE=?, RANK=?, START_DATE=?, END_DATE=?, REG_DATE=?, APPLY=? " + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? AND DOC_ID = ? ";
    static final String SQL_SELECT_DOCUMENT = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, DOC_ID, TYPE, RANK, START_DATE, END_DATE, REG_DATE, APPLY FROM " + DOCUMENT_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? AND DOC_ID = ? ";
    static final String SQL_SELECT_DOCUMENT_EXIST = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, DOC_ID, TYPE, RANK, START_DATE, END_DATE, REG_DATE, APPLY FROM " + DOCUMENT_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? AND TYPE = ? AND RANK = ?";
    static final String SQL_SELECT_DOCUMENT_KEYWORD = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, DOC_ID, TYPE, RANK, START_DATE, END_DATE, REG_DATE, APPLY FROM " + DOCUMENT_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ?";
    static final String SQL_SELECT_DOCUMENT_KEYWORD_COUNT = " SELECT COUNT(*) FROM " + DOCUMENT_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ?";
    static final String SQL_SELECT_DOCUMENT_PROFILE = " SELECT COLLECTION_ID, PROFILE_ID, KEYWORD, DOC_ID, TYPE, RANK, START_DATE, END_DATE, REG_DATE, APPLY FROM " + DOCUMENT_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ?";
    static final String SQL_SELECT_DOCUMENT_PROFILE_COUNT = " SELECT COUNT(*) FROM " + DOCUMENT_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_DELETE_DOCUMENT = " DELETE FROM " + DOCUMENT_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? AND DOC_ID = ? ";
    static final String SQL_DELETE_DOCUMENT_KEYWORD = " DELETE FROM " + DOCUMENT_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? ";
    static final String SQL_DELETE_ALL_DOCUMENT = "DELETE FROM " + DOCUMENT_TABLE;
    static final String SQL_DELETE_DOCUMENT_COLLECTION = "DELETE FROM " + DOCUMENT_TABLE + " WHERE COLLECTION_ID = ?";
    static final String SQL_DELETE_DOCUMENT_PROFILE = "DELETE FROM " + DOCUMENT_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? ";
    static final String SQL_DELETE_DOCUMENTS_KEYWORD = "DELETE FROM " + DOCUMENT_TABLE + " WHERE COLLECTION_ID = ? AND PROFILE_ID = ? AND KEYWORD = ? ";

    public static String[] makeDocumentRankingList(String keyword) {
        char[][] tokens = StringTokenizer.token((String)keyword, (char)',');
        String[] tokenStrs = new String[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            tokenStrs[i] = new String(tokens[i]);
            ++i;
        }
        return tokenStrs;
    }

    public static void putKeyword(Connection conn, String collectionID, String profileID, String keyword, int documents) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                Timestamp updated = new Timestamp(System.currentTimeMillis());
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsIntColumnParameter("DOCUMENTS", 4, documents), new RdbmsDateColumnParameter("REG_DATE", 5, updated), new RdbmsStringColumnParameter("APPLY", 6, '0')};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_DOCUMENT_KEYWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void putKeyword(Connection conn, DocumentRankingKeyword documentRankingKeyword) throws SQLException {
        DocumentRankingDB.putKeyword(conn, documentRankingKeyword.getCollectionID(), documentRankingKeyword.getProfileID(), documentRankingKeyword.getKeyword(), documentRankingKeyword.getDocuments());
    }

    public static void updateKeyword(Connection conn, String collectionID, String profileID, String keyword, int documents) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                Timestamp updated = new Timestamp(System.currentTimeMillis());
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter("DOCUMENTS", 1, documents), new RdbmsDateColumnParameter("REG_DATE", 2, updated), new RdbmsStringColumnParameter("APPLY", 3, '0'), new RdbmsStringColumnParameter("COLLECTION_ID", 4, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 5, profileID), new RdbmsStringColumnParameter("KEYWORD", 6, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_DOCUMENT_KEYWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void updateKeyword(Connection conn, DocumentRankingKeyword documentRankingKeyword) throws SQLException {
        DocumentRankingDB.updateKeyword(conn, documentRankingKeyword.getCollectionID(), documentRankingKeyword.getProfileID(), documentRankingKeyword.getKeyword(), documentRankingKeyword.getDocuments());
    }

    public static void updateApply(Connection conn, String collectionID, String profileID) throws SQLException {
        DocumentRankingDB.updateApplyCategory(conn, collectionID, profileID);
        DocumentRankingDB.updateApplyKeyword(conn, collectionID, profileID);
    }

    private static void updateApplyCategory(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_APPLY_DOCUMENT, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    private static void updateApplyKeyword(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_APPLY_KEYWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteKeyword(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_KEYWORD, parameters);
                supporter.executeUpdate(conn, query);
                DocumentRankingDB.deleteDocumentKeyword(conn, collectionID, profileID, keyword);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static DocumentRankingKeyword getKeyword(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_KEYWORD, parameters);
        RdbmsColumnValue[] native_row = supporter.fetchItem(conn, query);
        return DocumentRankingKeyword.create(native_row);
    }

    public static int getCountKeyword(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_KEYWORDS, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountSearchKeyword(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_SEARCH_KEYWORDS, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static DocumentRankingKeyword[] getListKeyword(Connection conn, String collectionID, String profileID, String order) throws SQLException {
        order = DocumentRankingDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_KEYWORDS) + order, parameters);
        List list = supporter.fetchItems(conn, query);
        return DocumentRankingKeyword.create(list);
    }

    public static DocumentRankingKeyword[] getListPageKeyword(Connection conn, String collectionID, String profileID, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "DOCUMENTS", "REG_DATE", "APPLY"};
        String[] froms = new String[]{DOCUMENT_KEYWORD_TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return DocumentRankingKeyword.create(list);
    }

    public static DocumentRankingKeyword[] getListPageKeywordOrderKeyword(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return DocumentRankingDB.getListPageKeyword(conn, collectionID, profileID, start, scale, "KEYWORD ASC");
    }

    public static DocumentRankingKeyword[] getListPageKeywordOrderDate(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return DocumentRankingDB.getListPageKeyword(conn, collectionID, profileID, start, scale, "REG_DATE DESC");
    }

    public static DocumentRankingKeyword[] getListPageKeywordOrderApply(Connection conn, String collectionID, String profileID, int start, int scale) throws SQLException {
        return DocumentRankingDB.getListPageKeyword(conn, collectionID, profileID, start, scale, "APPLY ASC");
    }

    public static DocumentRankingKeyword[] getListSearchPageKeyword(Connection conn, String collectionID, String profileID, String keyword, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "DOCUMENTS", "REG_DATE", "APPLY"};
        String[] froms = new String[]{DOCUMENT_KEYWORD_TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD LIKE", 3, "%" + keyword + "%")};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return DocumentRankingKeyword.create(list);
    }

    public static DocumentRankingKeyword[] searchProfileKeyword(Connection conn, String collectionID, String profileID, String keyword, String order) throws SQLException {
        order = DocumentRankingDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SEARCH_KEYWORDS) + order, parameters);
        List list = supporter.fetchItems(conn, query);
        return DocumentRankingKeyword.create(list);
    }

    public static DocumentRankingKeyword[] searchProfileKeywordOrderKeyword(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        return DocumentRankingDB.searchProfileKeyword(conn, collectionID, profileID, keyword, "KEYWORD ASC");
    }

    public static DocumentRankingKeyword[] searchProfileKeywordOrderDate(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        return DocumentRankingDB.searchProfileKeyword(conn, collectionID, profileID, keyword, "REG_DATE DESC");
    }

    public static DocumentRankingKeyword[] searchProfileKeywordOrderApply(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        return DocumentRankingDB.searchProfileKeyword(conn, collectionID, profileID, keyword, "APPLY ASC");
    }

    public static void putDocument(Connection conn, DocumentRanking document) throws SQLException {
        String collectionID = document.getCollectionID();
        String profileID = document.getProfileID();
        String keyword = document.getKeyword();
        String docIDValue = document.getDocID();
        byte type = document.getType();
        int rank = document.getRank();
        long start = document.getStart();
        long end = document.getEnd();
        Timestamp updated = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        DocumentRankingDB.putDocument(conn, collectionID, profileID, keyword, docIDValue, type, rank, start, end, updated, apply);
    }

    public static void putDocument(Connection conn, String collectionID, String profileID, String keyword, String docID, byte type, int rank, long start, long end) throws SQLException {
        Timestamp updated = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        DocumentRankingDB.putDocument(conn, collectionID, profileID, keyword, docID, type, rank, start, end, updated, apply);
    }

    private static void putDocument(Connection conn, String collectionID, String profileID, String keyword, String docID, byte type, int rank, long start, long end, Timestamp updated, boolean apply) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsStringColumnParameter("DOC_ID", 4, docID), new RdbmsIntColumnParameter("TYPE", 5, (int)type), new RdbmsIntColumnParameter("RANK", 6, rank), new RdbmsDateColumnParameter("START_DATE", 7, start), new RdbmsDateColumnParameter("END_DATE", 8, end), new RdbmsDateColumnParameter("REG_DATE", 9, updated), new RdbmsStringColumnParameter("APPLY", 10, apply ? (char)'1' : '0')};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT_DOCUMENT, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void updateDocument(Connection conn, DocumentRanking document) throws SQLException {
        String collectionID = document.getCollectionID();
        String profileID = document.getProfileID();
        String keyword = document.getKeyword();
        String docID = document.getDocID();
        byte type = document.getType();
        int rank = document.getRank();
        long start = document.getStart();
        long end = document.getEnd();
        Timestamp updated = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        DocumentRankingDB.updateDocument(conn, collectionID, profileID, keyword, docID, type, rank, start, end, updated, apply);
    }

    public static void updateDocument(Connection conn, String collectionID, String profileID, String keyword, String docID, byte type, int rank, long start, long end) throws SQLException {
        Timestamp updated = new Timestamp(System.currentTimeMillis());
        boolean apply = false;
        DocumentRankingDB.updateDocument(conn, collectionID, profileID, keyword, docID, type, rank, start, end, updated, apply);
    }

    private static void updateDocument(Connection conn, String collectionID, String profileID, String keyword, String docID, byte type, int rank, long start, long end, Timestamp updated, boolean apply) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsIntColumnParameter("TYPE", 1, (int)type), new RdbmsIntColumnParameter("RANK", 2, rank), new RdbmsDateColumnParameter("START_DATE", 3, start), new RdbmsDateColumnParameter("END_DATE", 4, end), new RdbmsDateColumnParameter("REG_DATE", 5, updated), new RdbmsStringColumnParameter("APPLY", 6, apply ? (char)'1' : '0'), new RdbmsStringColumnParameter("COLLECTION_ID", 7, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 8, profileID), new RdbmsStringColumnParameter("KEYWORD", 9, keyword), new RdbmsStringColumnParameter("DOC_ID", 10, docID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_DOCUMENT, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static DocumentRanking getDocument(Connection conn, String collectionID, String profileID, String keyword, String docID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        if (StringUtil.isEmpty((String)docID)) {
            throw new SQLException("docId cannot be null.");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsStringColumnParameter("DOC_ID", 4, docID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_DOCUMENT, parameters);
        RdbmsColumnValue[] native_row = supporter.fetchItem(conn, query);
        return DocumentRanking.create(native_row);
    }

    public static boolean isExist(Connection conn, String collectionID, String profileID, String keyword, byte type, int rank) throws SQLException {
        RdbmsColumnParameter[] parameters;
        RdbmsGeneralQuery query;
        if (type != 1) {
            return false;
        }
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnValue[] native_row = supporter.fetchItem(conn, query = new RdbmsGeneralQuery(SQL_SELECT_DOCUMENT_EXIST, parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsIntColumnParameter("TYPE", 4, (int)type), new RdbmsIntColumnParameter("RANK", 5, rank)}));
        return DocumentRanking.create(native_row) != null;
    }

    public static DocumentRanking[] getListDocument(Connection conn, String collectionID, String profileID, String keyword, String order) throws SQLException {
        order = DocumentRankingDB.getOrderby(order);
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_DOCUMENT_KEYWORD) + order, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        return DocumentRanking.create(native_rows);
    }

    public static int getCountDocumentRanking(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_DOCUMENT_KEYWORD_COUNT, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static DocumentRanking[] getListDocumentRanking(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_DOCUMENT_PROFILE, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        return DocumentRanking.create(native_rows);
    }

    public static DocumentRanking[] getListPageDocumentRanking(Connection conn, String collectionID, String profileID, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"COLLECTION_ID", "PROFILE_ID", "KEYWORD", "DOC_ID", "TYPE", "RANK", "START_DATE", "END_DATE", "REG_DATE", "APPLY"};
        String[] froms = new String[]{DOCUMENT_TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return DocumentRanking.create(list);
    }

    public static void copy(Connection conn, String fromCollectionID, String fromProfileID, String toCollectionID, String toProfileID) throws SQLException {
        int j;
        int start;
        int keywordCount = DocumentRankingDB.getCountKeyword(conn, fromCollectionID, fromProfileID);
        int keywordIterNum = keywordCount / 200 + 1;
        int documentCount = DocumentRankingDB.getCountDocumentRanking(conn, fromCollectionID, fromProfileID);
        int documentIterNum = documentCount / 200 + 1;
        int i = 0;
        while (i < keywordIterNum) {
            start = i * 200 + 1;
            DocumentRankingKeyword[] list = DocumentRankingDB.getListPageKeyword(conn, fromCollectionID, fromProfileID, start, 200, null);
            j = 0;
            while (j < list.length) {
                DocumentRankingDB.putKeyword(conn, toCollectionID, toProfileID, list[j].getKeyword(), list[j].getDocuments());
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < documentIterNum) {
            start = i * 200 + 1;
            DocumentRanking[] documentList = DocumentRankingDB.getListPageDocumentRanking(conn, fromCollectionID, fromProfileID, start, 200, null);
            j = 0;
            while (j < documentList.length) {
                DocumentRankingDB.putDocument(conn, toCollectionID, toProfileID, documentList[j].getKeyword(), documentList[j].getDocID(), documentList[j].getType(), documentList[j].getRank(), documentList[j].getStart(), documentList[j].getEnd());
                ++j;
            }
            ++i;
        }
    }

    public static int getCountDocumentRanking(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_DOCUMENT_PROFILE_COUNT, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static DocumentRanking[] getListDocumentRanking(Connection conn, String collectionID) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, "*")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_DOCUMENT_PROFILE, parameters);
        List native_rows = supporter.fetchItems(conn, query);
        return DocumentRanking.create(native_rows);
    }

    public static int getCountDocumentRanking(Connection conn, String collectionID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            throw new SQLException("collectionID is null");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, "*")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_DOCUMENT_PROFILE_COUNT, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static void deleteAll(Connection conn) throws SQLException {
        DocumentRankingDB.deleteAllDocumentRanking(conn);
        DocumentRankingDB.deleteAllDocumentRankingKeyword(conn);
    }

    public static void deleteAllDocumentRanking(Connection conn) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL_DOCUMENT);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteAllDocumentRankingKeyword(Connection conn) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL_KEYWORD);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteCollection(Connection conn, String collectionID) throws SQLException {
        DocumentRankingDB.deleteCollectionDocumentRanking(conn, collectionID);
        DocumentRankingDB.deleteCollectionDocumentRankingKeyword(conn, collectionID);
    }

    public static void deleteCollectionDocumentRanking(Connection conn, String collectionID) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_DOCUMENT_COLLECTION, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteCollectionDocumentRankingKeyword(Connection conn, String collectionID) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_KEYWORD_COLLECTION, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteProfile(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        DocumentRankingDB.deleteProfileDocumentRanking(conn, collectionID, profileID);
        DocumentRankingDB.deleteProfileDocumentRankingKeyword(conn, collectionID, profileID);
    }

    public static void deleteProfileDocumentRanking(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_DOCUMENT_PROFILE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteProfileDocumentRankingKeyword(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_KEYWORD_PROFILE, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteDefaultProfile(Connection conn, String collectionID) throws SQLException {
        DocumentRankingDB.deleteProfileDocumentRanking(conn, collectionID, "*");
        DocumentRankingDB.deleteProfileDocumentRankingKeyword(conn, collectionID, "*");
    }

    public static void deleteDocumentKeyword(Connection conn, String collectionID, String profileID, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_DOCUMENT_KEYWORD, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteDocumentRanking(Connection conn, String collectionID, String profileID, String keyword, String docID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        keyword = StringUtil.isEmpty((String)keyword) ? "*" : DocumentRankingDB.toUpperTrim(keyword);
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("COLLECTION_ID", 1, collectionID), new RdbmsStringColumnParameter("PROFILE_ID", 2, profileID), new RdbmsStringColumnParameter("KEYWORD", 3, keyword), new RdbmsStringColumnParameter("DOC_ID", 4, docID)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_DOCUMENT, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void deleteExpired(Connection conn, String collectionID, String profileID) throws SQLException {
        if (StringUtil.isEmpty((String)collectionID)) {
            collectionID = "*";
        }
        if (StringUtil.isEmpty((String)profileID)) {
            profileID = "*";
        }
        long currentTime = System.currentTimeMillis();
        DocumentRankingKeyword[] keywords = DocumentRankingDB.getListKeyword(conn, collectionID, profileID, null);
        int i = 0;
        while (i < keywords.length) {
            String keyword = keywords[i].getKeyword();
            DocumentRanking[] documents = DocumentRankingDB.getListDocument(conn, collectionID, profileID, keyword, null);
            int cSize = documents.length;
            int c = 0;
            while (c < documents.length) {
                DocumentRanking doc = documents[c];
                if (doc.getEnd() != 0L && doc.getEnd() < currentTime) {
                    DocumentRankingDB.deleteDocumentRanking(conn, collectionID, profileID, keyword, doc.getDocID());
                    --cSize;
                }
                ++c;
            }
            if (cSize == 0) {
                DocumentRankingDB.deleteKeyword(conn, collectionID, profileID, keyword);
            } else if (cSize != documents.length) {
                DocumentRankingDB.updateKeyword(conn, collectionID, profileID, keyword, cSize);
            }
            ++i;
        }
    }

    public static void deleteExpiredDefaultProfile(Connection conn, String collectionID) throws SQLException {
        DocumentRankingDB.deleteExpired(conn, collectionID, "*");
    }

    public void onAdd(String collection) throws IRException, InterruptedException {
    }

    public void onAddBefore(String collection) {
    }

    public void onModify(String collection) throws IRException, InterruptedException {
    }

    public void onModifyBefore(String collection) throws IRException, InterruptedException {
    }

    public void onRemove(String collection) throws IRException {
        Connection conn = null;
        try {
            try {
                conn = ConnectionFactory.getConnection();
                DocumentRankingDB.deleteCollection(conn, collection);
            }
            catch (SQLException e) {
                e.printStackTrace();
                ConnectionFactory.release((Connection)conn);
            }
        }
        finally {
            ConnectionFactory.release((Connection)conn);
        }
    }

    public void onRemoveBefore(String collection) throws IRException {
    }
}

