/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.common.database.handler.dictionary;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.common.database.entity.profile.usercndic.UserCnDic;
import com.diquest.ir.common.database.handler.dictionary.DBHandler;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class EnglishUserCnDicDB
extends DBHandler {
    static final String TABLE = String.valueOf(PREFIX) + "_USER_CNDIC_ENGLIGH";
    static final String SQL_INSERT = " INSERT INTO " + TABLE + " (KEYWORD, REG_DATE, APPLY) VALUES (?, ?, ?) ";
    static final String SQL_UPDATE_APPLY = "UPDATE " + TABLE + " SET APPLY = '1' ";
    static final String SQL_SELECT = " SELECT KEYWORD, REG_DATE, APPLY FROM " + TABLE + " WHERE KEYWORD = ? ";
    static final String SQL_SELECT_ALL = " SELECT KEYWORD, REG_DATE, APPLY FROM " + TABLE;
    static final String SQL_SELECT_ALL_KEYWORD = " SELECT KEYWORD FROM " + TABLE;
    static final String SQL_SELECT_COUNT = " SELECT COUNT(*) FROM " + TABLE;
    static final String SQL_SELECT_COUNT_SEARCH = " SELECT COUNT(*) FROM " + TABLE + " WHERE KEYWORD LIKE ? ";
    static final String SQL_DELETE = " DELETE FROM " + TABLE + " WHERE KEYWORD = ? ";
    static final String SQL_DELETE_ALL = " DELETE FROM " + TABLE;

    public static void put(Connection conn, String keyword) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("KEYWORD", 1, keyword), new RdbmsDateColumnParameter("REG_DATE", 2, new Timestamp(System.currentTimeMillis())), new RdbmsIntColumnParameter("APPLY", 3, 0)};
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_INSERT, parameters);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static void updateApply(Connection conn) throws SQLException {
        boolean success = false;
        try {
            try {
                conn.setAutoCommit(false);
                RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
                RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_UPDATE_APPLY);
                supporter.executeUpdate(conn, query);
                success = true;
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static UserCnDic get(Connection conn, String keyword) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("KEYWORD", 1, keyword)};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT, parameters);
        RdbmsColumnValue[] item = supporter.fetchItem(conn, query);
        return UserCnDic.create(item);
    }

    public static UserCnDic[] getList(Connection conn, String order) throws SQLException {
        order = EnglishUserCnDicDB.getOrderby(order);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_ALL) + order);
        List items = supporter.fetchItems(conn, query);
        return UserCnDic.create(items);
    }

    public static String[] getListKeyword(Connection conn, String order) throws SQLException {
        order = EnglishUserCnDicDB.getOrderby(order);
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(String.valueOf(SQL_SELECT_ALL_KEYWORD) + order);
        List items = supporter.fetchItems(conn, query);
        String[] keywords = new String[items.size()];
        int i = 0;
        while (i < items.size()) {
            RdbmsColumnValue[] native_row = (RdbmsColumnValue[])items.get(i);
            if (native_row[0] == null) {
                return null;
            }
            keywords[i] = native_row[0].toString();
            ++i;
        }
        return keywords;
    }

    public static UserCnDic[] getListPage(Connection conn, int start, int scale, String order) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"KEYWORD", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, null);
        List list = supporter.fetchCriteria(conn, query);
        return UserCnDic.create(list);
    }

    public static UserCnDic[] getListPageSearch(Connection conn, String keyword, int start, int scale, String order) throws SQLException {
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        String[] columns = new String[]{"KEYWORD", "REG_DATE", "APPLY"};
        String[] froms = new String[]{TABLE};
        String[] orders = order != null ? new String[]{order} : null;
        RdbmsColumnParameter[] parameter = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("KEYWORD LIKE", 1, "%" + keyword + "%")};
        RdbmsPagingQuery query = new RdbmsPagingQuery("KEYWORD", start, scale, columns, froms, orders, null, parameter);
        List list = supporter.fetchCriteria(conn, query);
        return UserCnDic.create(list);
    }

    public static int getCount(Connection conn) throws SQLException {
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int getCountSearch(Connection conn, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
        RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("KEYWORD", 1, "%" + keyword + "%")};
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_SELECT_COUNT_SEARCH, parameters);
        RdbmsColumnValue[] value = supporter.fetchItem(conn, query);
        return Integer.parseInt(value[0].toString());
    }

    public static int delete(Connection conn, String keyword) throws SQLException {
        if (StringUtil.isEmpty((String)keyword)) {
            throw new SQLException("keyword is null.");
        }
        boolean success = false;
        try {
            conn.setAutoCommit(false);
            RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
            RdbmsColumnParameter[] parameters = new RdbmsColumnParameter[]{new RdbmsStringColumnParameter("KEYWORD", 1, keyword)};
            RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE, parameters);
            int r = supporter.executeUpdate(conn, query);
            success = true;
            int n = r;
            return n;
        }
        catch (SQLException e) {
            conn.rollback();
            throw e;
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }

    public static int deleteAll(Connection conn) throws SQLException {
        boolean success = false;
        try {
            conn.setAutoCommit(false);
            RdbmsSupporter supporter = RdbmsSupporter.createRdbmsSupporter((Connection)conn);
            RdbmsGeneralQuery query = new RdbmsGeneralQuery(SQL_DELETE_ALL);
            int r = supporter.executeUpdate(conn, query);
            success = true;
            int n = r;
            return n;
        }
        catch (SQLException e) {
            conn.rollback();
            throw e;
        }
        finally {
            if (success) {
                conn.commit();
            }
        }
    }
}

